/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.TableView;

public class EHTableView
extends ExportHandler {
    public EHTableView(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TableView_Name").append(",");
        stringBuffer.append("ObjectID").append(",");
        stringBuffer.append("NumOID").append(",");
        stringBuffer.append("ImportID").append(",");
        stringBuffer.append("ModelID").append(",");
        stringBuffer.append("Num_ModelID").append(",");
        stringBuffer.append("Structured_Type_ID").append(",");
        stringBuffer.append("Num_Structured_Type_ID").append(",");
        stringBuffer.append("Structured_Type_Name").append(",");
        stringBuffer.append("User_Defined").append(",");
        stringBuffer.append("Engineer").append(",");
        stringBuffer.append("Allow_Type_Substitution").append(",");
        stringBuffer.append("OID_Columns");
        arrayList.add(stringBuffer.toString());
        Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!this.getCsvExporter().isModelSelected(relationalDesign)) continue;
            Iterator iterator2 = relationalDesign.getTableViewSet().iterator();
            while (iterator2.hasNext()) {
                TableView tableView = (TableView)iterator2.next();
                stringBuffer = new StringBuffer();
                stringBuffer.append(tableView.getName()).append(",");
                stringBuffer.append(tableView.getObjectID()).append(",");
                stringBuffer.append(tableView.getNumID()).append(",");
                stringBuffer.append(tableView.getImportedId() != null ? tableView.getImportedId() : "").append(",");
                stringBuffer.append(relationalDesign.getObjectID()).append(",");
                stringBuffer.append(relationalDesign.getNumID()).append(",");
                if (tableView.isBST()) {
                    stringBuffer.append(tableView.getBasedOnStructuredType().getObjectID()).append(",");
                    stringBuffer.append(tableView.getBasedOnStructuredType().getNumID()).append(",");
                    stringBuffer.append(tableView.getBasedOnStructuredType().getName()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(tableView.getUserDefined() ? "Y" : "N").append(",");
                stringBuffer.append(tableView.getShouldEngineer() ? "Y" : "N").append(",");
                stringBuffer.append(tableView.isAllowTypeSubstitution() ? "Y" : "N").append(",");
                stringBuffer.append(this.replaceAndQuoteString(tableView.getOidText())).append(",");
                arrayList.add(stringBuffer.toString());
                this.getCsvExporter().addNote(tableView.getObjectID(), tableView.getNumID(), "TableView", tableView.getNotes());
                this.getCsvExporter().addComment(tableView.getObjectID(), tableView.getNumID(), "TableView", tableView.getComment());
                this.getCsvExporter().addCommentRDBMS(tableView.getObjectID(), tableView.getNumID(), "TableView", tableView.getCommentInRDBMS());
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_TableViews.csv";
    }
}

