/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;

public class EHTableIncludeScripts
extends ExportHandler {
    public EHTableIncludeScripts(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ObjectID").append(",");
        stringBuffer.append("NumOID").append(",");
        stringBuffer.append("Type").append(",");
        stringBuffer.append("Sequence").append(",");
        stringBuffer.append("Text");
        arrayList.add(stringBuffer.toString());
        Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!this.getCsvExporter().isModelSelected(relationalDesign)) continue;
            Iterator iterator2 = relationalDesign.getTableSet().iterator();
            while (iterator2.hasNext()) {
                Table table = (Table)iterator2.next();
                this.addScript(table, arrayList, "Before Drop/Rename", this.replaceString(table.getBeforeDrop()));
                this.addScript(table, arrayList, "Before Create", this.replaceString(table.getBeforeCreate()));
                this.addScript(table, arrayList, "After Create", this.replaceString(table.getAfterCreate()));
                this.addScript(table, arrayList, "End of Script", this.replaceString(table.getEndOfScript()));
            }
        }
        this.saveToFile(arrayList);
    }

    private void addScript(Table table, List list, String string, String string2) {
        if (!"".equalsIgnoreCase(string2)) {
            CharSequence charSequence;
            int n = 0;
            while (string2.length() > 2000) {
                ++n;
                charSequence = string2.substring(0, 2000);
                string2 = string2.substring(2000);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(table.getObjectID()).append(",");
                stringBuffer.append(table.getNumID()).append(",");
                stringBuffer.append(string).append(",");
                stringBuffer.append(n).append(",");
                stringBuffer.append(this.quotedString((String)charSequence)).append(",");
                list.add(stringBuffer.toString());
            }
            if (string2.length() > 0) {
                ++n;
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append(table.getObjectID()).append(",");
                ((StringBuffer)charSequence).append(table.getNumID()).append(",");
                ((StringBuffer)charSequence).append(string).append(",");
                ((StringBuffer)charSequence).append(n).append(",");
                ((StringBuffer)charSequence).append(this.quotedString(string2));
                list.add(((StringBuffer)charSequence).toString());
            }
        }
    }

    @Override
    public String getFileName() {
        return "DM_Table_Include_Scripts.csv";
    }
}

