/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;

public class EHTable
extends ExportHandler {
    public EHTable(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Table_Name").append(",");
        stringBuffer.append("ObjectID").append(",");
        stringBuffer.append("NumOID").append(",");
        stringBuffer.append("ImportID").append(",");
        stringBuffer.append("ModelID").append(",");
        stringBuffer.append("Num_ModelID").append(",");
        stringBuffer.append("Structured_Type_ID").append(",");
        stringBuffer.append("Num_Structured_Type_ID").append(",");
        stringBuffer.append("Structured_Type_Name").append(",");
        stringBuffer.append("Number_Data_Elements").append(",");
        stringBuffer.append("Classification_Type").append(",");
        stringBuffer.append("Allow_Type_Substitution").append(",");
        stringBuffer.append("Min_Volume").append(",");
        stringBuffer.append("Expected_Volume").append(",");
        stringBuffer.append("Max_Volume").append(",");
        stringBuffer.append("Growth_Rate_Percents").append(",");
        stringBuffer.append("Growth_Rate_Interval").append(",");
        stringBuffer.append("Normal_Form").append(",");
        stringBuffer.append("Temporary_Object_Scope").append(",");
        stringBuffer.append("Adequately_Normalized").append(",");
        stringBuffer.append("Substitution_Parent").append(",");
        stringBuffer.append("Num_Substitution_Parent").append(",");
        stringBuffer.append("Engineer").append(",");
        stringBuffer.append("Spatial_Table").append(",");
        stringBuffer.append("OID_is_PK").append(",");
        stringBuffer.append("OID_is_User_Defined").append(",");
        stringBuffer.append("Include_Scripts_Into_DDL");
        arrayList.add(stringBuffer.toString());
        Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!this.getCsvExporter().isModelSelected(relationalDesign)) continue;
            Iterator iterator2 = relationalDesign.getTableSet().iterator();
            while (iterator2.hasNext()) {
                Table table = (Table)iterator2.next();
                stringBuffer = new StringBuffer();
                stringBuffer.append(table.getName()).append(",");
                stringBuffer.append(table.getObjectID()).append(",");
                stringBuffer.append(table.getNumID()).append(",");
                stringBuffer.append(table.getImportedId() != null ? table.getImportedId() : "").append(",");
                stringBuffer.append(relationalDesign.getObjectID()).append(",");
                stringBuffer.append(relationalDesign.getNumID()).append(",");
                if (table.isBST()) {
                    stringBuffer.append(table.getBasedOnStructuredType().getObjectID()).append(",");
                    stringBuffer.append(table.getBasedOnStructuredType().getNumID()).append(",");
                    stringBuffer.append(table.getBasedOnStructuredType().getName()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(table.getElements().length).append(",");
                stringBuffer.append(table.getTypeID()).append(",");
                stringBuffer.append(table.isAllowTypeSubstitution() ? "Y" : "N").append(",");
                stringBuffer.append(table.getMinVolumes()).append(",");
                stringBuffer.append(table.getExpectedVolumes()).append(",");
                stringBuffer.append(table.getMaxVolumes()).append(",");
                stringBuffer.append(table.getGrowthPercent()).append(",");
                stringBuffer.append(table.getGrowthType()).append(",");
                stringBuffer.append(table.getNormalForm()).append(",");
                stringBuffer.append(table.getScope()).append(",");
                stringBuffer.append(table.getAdequatelyNormalized().charAt(0)).append(",");
                if (table.getTypeSubstitution() != null) {
                    stringBuffer.append(table.getTypeSubstitution().getObjectID()).append(",");
                    stringBuffer.append(table.getTypeSubstitution().getNumID()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(table.getShouldEngineer() ? "Y" : "N").append(",");
                stringBuffer.append(table.isSpatialTable() ? "Y" : "N").append(",");
                stringBuffer.append(table.isOidIsPK() ? "Y" : "N").append(",");
                stringBuffer.append(table.isUserDefinedOid() ? "Y" : "N").append(",");
                stringBuffer.append(table.getShouldGenerateScript() ? "Y" : "N").append(",");
                arrayList.add(stringBuffer.toString());
                this.getCsvExporter().addNote(table.getObjectID(), table.getNumID(), "Table", table.getNotes());
                this.getCsvExporter().addComment(table.getObjectID(), table.getNumID(), "Table", table.getComment());
                this.getCsvExporter().addCommentRDBMS(table.getObjectID(), table.getNumID(), "Table", table.getCommentInRDBMS());
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Tables.csv";
    }
}

