/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;

public class EHSpatialColumnDefinition
extends ExportHandler {
    public EHSpatialColumnDefinition(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Table_ID").append(",");
        stringBuffer.append("Num_Table_ID").append(",");
        stringBuffer.append("Definition_ID").append(",");
        stringBuffer.append("Definition_Name").append(",");
        stringBuffer.append("Table_Name").append(",");
        stringBuffer.append("ColumnID").append(",");
        stringBuffer.append("Num_ColumnID").append(",");
        stringBuffer.append("Column_Name").append(",");
        stringBuffer.append("Use_Function").append(",");
        stringBuffer.append("Function_Expression").append(",");
        stringBuffer.append("Coordinate_System_ID").append(",");
        stringBuffer.append("Has_Spatial_Index").append(",");
        stringBuffer.append("Spatial_Index_ID").append(",");
        stringBuffer.append("Num_Spatial_Index_ID");
        arrayList.add(stringBuffer.toString());
        Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!this.getCsvExporter().isModelSelected(relationalDesign)) continue;
            Iterator iterator2 = relationalDesign.getTableSet().iterator();
            while (iterator2.hasNext()) {
                Table table = (Table)iterator2.next();
                Iterator iterator3 = table.getSpatialDefinitions().iterator();
                int n = 0;
                while (iterator3.hasNext()) {
                    SpatialColumnDefObject spatialColumnDefObject = (SpatialColumnDefObject)iterator3.next();
                    spatialColumnDefObject.setId(++n);
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(table.getObjectID()).append(",");
                    stringBuffer.append(table.getNumID()).append(",");
                    stringBuffer.append(n).append(",");
                    stringBuffer.append(spatialColumnDefObject.getName()).append(",");
                    stringBuffer.append(table.getName()).append(",");
                    if (spatialColumnDefObject.getSpatialColumn() != null) {
                        stringBuffer.append(spatialColumnDefObject.getSpatialColumn().getObjectID()).append(",");
                        stringBuffer.append(spatialColumnDefObject.getSpatialColumn().getNumID()).append(",");
                        stringBuffer.append(spatialColumnDefObject.getSpatialColumn().getName()).append(",");
                    } else {
                        stringBuffer.append("").append(",");
                        stringBuffer.append("").append(",");
                        stringBuffer.append("").append(",");
                    }
                    stringBuffer.append(spatialColumnDefObject.isFunction() ? "Y" : "N").append(",");
                    stringBuffer.append(this.replaceAndQuoteString(spatialColumnDefObject.getFuncExpression())).append(",");
                    stringBuffer.append(spatialColumnDefObject.getSystemID()).append(",");
                    if (spatialColumnDefObject.getSpatialIndex() != null) {
                        stringBuffer.append("Y").append(",");
                        stringBuffer.append(spatialColumnDefObject.getSpatialIndex().getObjectID()).append(",");
                        stringBuffer.append(spatialColumnDefObject.getSpatialIndex().getNumID()).append(",");
                    } else {
                        stringBuffer.append("N").append(",");
                        stringBuffer.append("").append(",");
                        stringBuffer.append("").append(",");
                    }
                    arrayList.add(stringBuffer.toString());
                }
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Spatial_Column_Definition.csv";
    }
}

