/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class EHProcessEntities
extends ExportHandler {
    public EHProcessEntities(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Process_ID").append(",");
        stringBuffer.append("Num_Process_ID").append(",");
        stringBuffer.append("Entity_ID").append(",");
        stringBuffer.append("Num_Entity_ID").append(",");
        stringBuffer.append("Flow_ID").append(",");
        stringBuffer.append("Num_Flow_ID").append(",");
        stringBuffer.append("DFD_ID").append(",");
        stringBuffer.append("Num_DFD_ID").append(",");
        stringBuffer.append("Process_Name").append(",");
        stringBuffer.append("Entity_Name").append(",");
        stringBuffer.append("Flow_Name").append(",");
        stringBuffer.append("DFD_Name").append(",");
        stringBuffer.append("OP_Read").append(",");
        stringBuffer.append("OP_Create").append(",");
        stringBuffer.append("OP_Update").append(",");
        stringBuffer.append("OP_Delete").append(",");
        stringBuffer.append("CRUD_Code").append(",");
        stringBuffer.append("Flow_Direction");
        arrayList.add(stringBuffer.toString());
        ProcessModel processModel = this.getDesign().getProcessModel();
        Iterator iterator = processModel.getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
            String string = dataFlowDesign.getTopLevelDataFlowDesign().getName();
            Iterator iterator2 = dataFlowDesign.getProcessSet().iterator();
            while (iterator2.hasNext()) {
                Process process = (Process)iterator2.next();
                if (process.getType() != 0) continue;
                for (Process.ProcessedObject processedObject : process.getProcessedEntitiesAndFlows(false)) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(process.getObjectID()).append(",");
                    stringBuffer.append(process.getNumID()).append(",");
                    stringBuffer.append(processedObject.getObject().getObjectID()).append(",");
                    stringBuffer.append(processedObject.getObject().getNumID()).append(",");
                    stringBuffer.append(processedObject.getFlow().getObjectID()).append(",");
                    stringBuffer.append(processedObject.getFlow().getNumID()).append(",");
                    stringBuffer.append(dataFlowDesign.getObjectID()).append(",");
                    stringBuffer.append(dataFlowDesign.getNumID()).append(",");
                    stringBuffer.append(process.getName()).append(",");
                    stringBuffer.append(processedObject.getObject().getName()).append(",");
                    stringBuffer.append(processedObject.getFlow().getName()).append(",");
                    stringBuffer.append(string).append(",");
                    stringBuffer.append(processedObject.isOpRead() ? "Y" : "N").append(",");
                    stringBuffer.append(processedObject.isOpCreate() ? "Y" : "N").append(",");
                    stringBuffer.append(processedObject.isOpUpdate() ? "Y" : "N").append(",");
                    stringBuffer.append(processedObject.isOpDelete() ? "Y" : "N").append(",");
                    if (processedObject.isOpRead()) {
                        stringBuffer.append("R").append(",");
                    } else {
                        String string2 = "";
                        if (processedObject.isOpCreate()) {
                            string2 = "C";
                        }
                        if (processedObject.isOpUpdate()) {
                            string2 = string2 + "U";
                        }
                        if (processedObject.isOpDelete()) {
                            string2 = string2 + "D";
                        }
                        stringBuffer.append(string2).append(",");
                    }
                    stringBuffer.append(processedObject.isInbound() ? "In" : "Out").append(",");
                    arrayList.add(stringBuffer.toString());
                }
                this.getCsvExporter().addNote(process.getObjectID(), process.getNumID(), "Process", process.getNotes());
                this.getCsvExporter().addComment(process.getObjectID(), process.getNumID(), "Process", process.getComment());
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Process_Entities.csv";
    }
}

