/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;

public class EHNotes
extends ExportHandler {
    public EHNotes(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ObjectID").append(",");
        stringBuffer.append("NumOID").append(",");
        stringBuffer.append("Type").append(",");
        stringBuffer.append("Sequence").append(",");
        stringBuffer.append("Text");
        arrayList.add(stringBuffer.toString());
        for (CSVExporter.ObjDesc objDesc : this.getCsvExporter().getNotes()) {
            String string = this.replaceString(objDesc.getText());
            if ("".equalsIgnoreCase(string)) continue;
            int n = 0;
            while (string.length() > 2000) {
                ++n;
                String string2 = string.substring(0, 2000);
                int n2 = 2000;
                try {
                    n2 = string2.getBytes("UTF-8").length;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n2 > 2000) {
                    int n3 = n2 - 2000;
                    string2 = string.substring(0, 2000 - n3);
                    string = string.substring(2000 - n3);
                } else {
                    string = string.substring(2000);
                }
                stringBuffer = new StringBuffer();
                stringBuffer.append(objDesc.getObjectID()).append(",");
                stringBuffer.append(objDesc.getNumOID()).append(",");
                stringBuffer.append(objDesc.getType()).append(",");
                stringBuffer.append(n).append(",");
                stringBuffer.append(this.quotedString(string2)).append(",");
                arrayList.add(stringBuffer.toString());
            }
            if (string.length() <= 0) continue;
            ++n;
            stringBuffer = new StringBuffer();
            stringBuffer.append(objDesc.getObjectID()).append(",");
            stringBuffer.append(objDesc.getNumOID()).append(",");
            stringBuffer.append(objDesc.getType()).append(",");
            stringBuffer.append(n).append(",");
            stringBuffer.append(this.quotedString(string)).append(",");
            arrayList.add(stringBuffer.toString());
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Notes.csv";
    }
}

