/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class EHMappings
extends ExportHandler {
    public EHMappings(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Logical_Model_ID").append(",");
        stringBuffer.append("Num_Logical_Model_ID").append(",");
        stringBuffer.append("Logical_Model_Name").append(",");
        stringBuffer.append("Logical_Object_ID").append(",");
        stringBuffer.append("Num_Logical_Object_ID").append(",");
        stringBuffer.append("Logical_Object_Name").append(",");
        stringBuffer.append("Relational_Model_ID").append(",");
        stringBuffer.append("Num_Relational_Model_ID").append(",");
        stringBuffer.append("Relational_Model_Name").append(",");
        stringBuffer.append("Relational_Object_ID").append(",");
        stringBuffer.append("Num_Relational_Object_ID").append(",");
        stringBuffer.append("Relational_Object_Name").append(",");
        stringBuffer.append("Entity_Name").append(",");
        stringBuffer.append("Table_Name");
        arrayList.add(stringBuffer.toString());
        Map map = this.getDesign().getExtendedMap().getMappings();
        for (Object k : map.keySet()) {
            DesignObject designObject;
            DesignObject designObject2;
            XtdMapping xtdMapping = (XtdMapping)map.get(k);
            if (xtdMapping.getOwnerDesignPart() instanceof LogicalDesign) {
                designObject2 = xtdMapping.getOwnerObject();
                designObject = xtdMapping.getTargetObject();
            } else {
                designObject2 = xtdMapping.getTargetObject();
                designObject = xtdMapping.getOwnerObject();
            }
            if (designObject2 == null || designObject == null) continue;
            stringBuffer = new StringBuffer();
            stringBuffer.append(designObject2.getDesignPart().getObjectID()).append(",");
            stringBuffer.append(designObject2.getDesignPart().getNumID()).append(",");
            stringBuffer.append(designObject2.getDesignPart().getName()).append(",");
            stringBuffer.append(designObject2.getObjectID()).append(",");
            stringBuffer.append(designObject2.getNumID()).append(",");
            stringBuffer.append(designObject2.getName()).append(",");
            stringBuffer.append(designObject.getDesignPart().getObjectID()).append(",");
            stringBuffer.append(designObject.getDesignPart().getNumID()).append(",");
            stringBuffer.append(designObject.getDesignPart().getName()).append(",");
            stringBuffer.append(designObject.getObjectID()).append(",");
            stringBuffer.append(designObject.getNumID()).append(",");
            stringBuffer.append(designObject.getName()).append(",");
            if (designObject2 instanceof Entity) {
                stringBuffer.append(designObject2.getName()).append(",");
            } else if (designObject2 instanceof Attribute) {
                try {
                    stringBuffer.append(((Attribute)designObject2).getContainer().getName()).append(",");
                }
                catch (Exception exception) {
                    System.out.println("Wrong Mapping - EHMappings.Attribute: " + designObject2.getName());
                    stringBuffer.append("").append(",");
                }
            } else if (designObject2 instanceof CandidateKey) {
                try {
                    stringBuffer.append(((CandidateKey)designObject2).getContainerObject().getName()).append(",");
                }
                catch (Exception exception) {
                    System.out.println("Wrong Mapping - EHMappings.CandidateKey: " + designObject2.getName());
                    stringBuffer.append("").append(",");
                }
            } else {
                stringBuffer.append("").append(",");
            }
            if (designObject instanceof Table) {
                stringBuffer.append(designObject.getName()).append(",");
            } else if (designObject instanceof Column) {
                stringBuffer.append(((Column)designObject).getContainer().getName()).append(",");
            } else if (designObject instanceof Index) {
                stringBuffer.append(((Index)designObject).getContainerObject().getName()).append(",");
            } else {
                stringBuffer.append("").append(",");
            }
            arrayList.add(stringBuffer.toString());
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Mappings.csv";
    }
}

