/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;

public class EHKey
extends ExportHandler {
    public EHKey(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Key_Name").append(",");
        stringBuffer.append("ObjectID").append(",");
        stringBuffer.append("NumOID").append(",");
        stringBuffer.append("ImportID").append(",");
        stringBuffer.append("ContainerID").append(",");
        stringBuffer.append("Num_ContainerID").append(",");
        stringBuffer.append("State Type").append(",");
        stringBuffer.append("Synonyms").append(",");
        stringBuffer.append("Entity_Name");
        arrayList.add(stringBuffer.toString());
        LogicalDesign logicalDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logicalDesign)) {
            Iterator iterator = logicalDesign.getGlobalCandidateKeySet().iterator();
            while (iterator.hasNext()) {
                CandidateKey candidateKey = (CandidateKey)iterator.next();
                stringBuffer = new StringBuffer();
                stringBuffer.append(candidateKey.getName()).append(",");
                stringBuffer.append(candidateKey.getObjectID()).append(",");
                stringBuffer.append(candidateKey.getNumID()).append(",");
                stringBuffer.append(candidateKey.getImportedId() != null ? candidateKey.getImportedId() : "").append(",");
                stringBuffer.append(candidateKey.getContainerObject().getObjectID()).append(",");
                stringBuffer.append(candidateKey.getContainerObject().getNumID()).append(",");
                stringBuffer.append(candidateKey.getKeyState()).append(",");
                stringBuffer.append(this.quotedString(candidateKey.getSynonym())).append(",");
                stringBuffer.append(candidateKey.getContainerObject().getName()).append(",");
                arrayList.add(stringBuffer.toString());
                this.getCsvExporter().addNote(candidateKey.getObjectID(), candidateKey.getNumID(), "Key", candidateKey.getNotes());
                this.getCsvExporter().addComment(candidateKey.getObjectID(), candidateKey.getNumID(), "Key", candidateKey.getComment());
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Keys.csv";
    }
}

