/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;

public class EHForeignKey
extends ExportHandler {
    public EHForeignKey(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FK_Name").append(",");
        stringBuffer.append("ModelID").append(",");
        stringBuffer.append("Num_ModelID").append(",");
        stringBuffer.append("ObjectID").append(",");
        stringBuffer.append("NumOID").append(",");
        stringBuffer.append("ImportID").append(",");
        stringBuffer.append("Child_Table_Name").append(",");
        stringBuffer.append("Referred_Table_Name").append(",");
        stringBuffer.append("Engineer").append(",");
        stringBuffer.append("Delete_Rule").append(",");
        stringBuffer.append("Child_Table_ID").append(",");
        stringBuffer.append("Num_Child_Table_ID").append(",");
        stringBuffer.append("Referred_Table_ID").append(",");
        stringBuffer.append("Num_Referred_Table_ID").append(",");
        stringBuffer.append("Referred_Key_ID").append(",");
        stringBuffer.append("Num_Referred_Key_ID").append(",");
        stringBuffer.append("Number_Of_Columns");
        arrayList.add(stringBuffer.toString());
        Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!this.getCsvExporter().isModelSelected(relationalDesign)) continue;
            Iterator iterator2 = relationalDesign.getFKIndexAssociationSet().iterator();
            while (iterator2.hasNext()) {
                FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator2.next();
                stringBuffer = new StringBuffer();
                stringBuffer.append(fKIndexAssociation.getName()).append(",");
                stringBuffer.append(relationalDesign.getObjectID()).append(",");
                stringBuffer.append(relationalDesign.getNumID()).append(",");
                stringBuffer.append(fKIndexAssociation.getObjectID()).append(",");
                stringBuffer.append(fKIndexAssociation.getNumID()).append(",");
                stringBuffer.append(fKIndexAssociation.getImportedId() != null ? fKIndexAssociation.getImportedId() : "").append(",");
                stringBuffer.append(fKIndexAssociation.getContainerWithKeyObject().getName()).append(",");
                stringBuffer.append(fKIndexAssociation.getRemoteTable().getName()).append(",");
                stringBuffer.append(fKIndexAssociation.getShouldEngineer() ? "Y" : "N").append(",");
                stringBuffer.append(fKIndexAssociation.getDeleteRule()).append(",");
                stringBuffer.append(fKIndexAssociation.getContainerWithKeyObject().getObjectID()).append(",");
                stringBuffer.append(fKIndexAssociation.getContainerWithKeyObject().getNumID()).append(",");
                stringBuffer.append(fKIndexAssociation.getRemoteTable().getObjectID()).append(",");
                stringBuffer.append(fKIndexAssociation.getRemoteTable().getNumID()).append(",");
                stringBuffer.append(fKIndexAssociation.getRemoteIndex().getObjectID()).append(",");
                stringBuffer.append(fKIndexAssociation.getRemoteIndex().getNumID()).append(",");
                stringBuffer.append(fKIndexAssociation.getRemoteIndex().getElements().length).append(",");
                arrayList.add(stringBuffer.toString());
                this.getCsvExporter().addNote(fKIndexAssociation.getObjectID(), fKIndexAssociation.getNumID(), "ForeignKey", fKIndexAssociation.getNotes());
                this.getCsvExporter().addComment(fKIndexAssociation.getObjectID(), fKIndexAssociation.getNumID(), "ForeignKey", fKIndexAssociation.getComment());
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_ForeignKeys.csv";
    }
}

