/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;

public class EHEntityView
extends ExportHandler {
    public EHEntityView(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EntityView_Name").append(",");
        stringBuffer.append("ObjectID").append(",");
        stringBuffer.append("NumOID").append(",");
        stringBuffer.append("ImportID").append(",");
        stringBuffer.append("ModelID").append(",");
        stringBuffer.append("Num_ModelID").append(",");
        stringBuffer.append("Structured_Type_ID").append(",");
        stringBuffer.append("Num_Structured_Type_ID").append(",");
        stringBuffer.append("Structured_Type_Name").append(",");
        stringBuffer.append("User_Defined").append(",");
        stringBuffer.append("View_Type");
        arrayList.add(stringBuffer.toString());
        LogicalDesign logicalDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logicalDesign)) {
            Iterator iterator = logicalDesign.getEntityViewSet().iterator();
            while (iterator.hasNext()) {
                EntityView entityView = (EntityView)iterator.next();
                stringBuffer = new StringBuffer();
                stringBuffer.append(entityView.getName()).append(",");
                stringBuffer.append(entityView.getObjectID()).append(",");
                stringBuffer.append(entityView.getNumID()).append(",");
                stringBuffer.append(entityView.getImportedId() != null ? entityView.getImportedId() : "").append(",");
                stringBuffer.append(logicalDesign.getObjectID()).append(",");
                stringBuffer.append(logicalDesign.getNumID()).append(",");
                if (entityView.isBST()) {
                    stringBuffer.append(entityView.getBasedOnStructuredType().getObjectID()).append(",");
                    stringBuffer.append(entityView.getBasedOnStructuredType().getNumID()).append(",");
                    stringBuffer.append(entityView.getBasedOnStructuredType().getName()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(entityView.getUserDefined() ? "Y" : "N").append(",");
                stringBuffer.append(entityView.getViewType()).append(",");
                arrayList.add(stringBuffer.toString());
                this.getCsvExporter().addNote(entityView.getObjectID(), entityView.getNumID(), "EntityView", entityView.getNotes());
                this.getCsvExporter().addComment(entityView.getObjectID(), entityView.getNumID(), "EntityView", entityView.getComment());
                this.getCsvExporter().addCommentRDBMS(entityView.getObjectID(), entityView.getNumID(), "EntityView", entityView.getCommentInRDBMS());
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_EntityViews.csv";
    }
}

