/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.storage.RDBMSType;

public class EHDomainCheckConstraint
extends ExportHandler {
    public EHDomainCheckConstraint(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Domain_ID").append(",");
        stringBuffer.append("Num_Domain_ID").append(",");
        stringBuffer.append("Sequence").append(",");
        stringBuffer.append("Constraint_Name").append(",");
        stringBuffer.append("Text").append(",");
        stringBuffer.append("Database_Type").append(",");
        stringBuffer.append("Domain_Name");
        arrayList.add(stringBuffer.toString());
        Iterator iterator = this.getDesign().getDomainSet().iterator();
        while (iterator.hasNext()) {
            Domain domain = (Domain)iterator.next();
            CheckConstraint checkConstraint = domain.getCheck();
            int n = 0;
            if (checkConstraint == null) continue;
            String string = checkConstraint.getGenericConstraint();
            if (string != null && !"".equalsIgnoreCase(string)) {
                ++n;
                stringBuffer = new StringBuffer();
                stringBuffer.append(domain.getObjectID()).append(",");
                stringBuffer.append(domain.getNumID()).append(",");
                stringBuffer.append(n).append(",");
                stringBuffer.append(checkConstraint.getName()).append(",");
                stringBuffer.append(this.replaceAndQuoteString(string)).append(",");
                stringBuffer.append("GENERIC").append(",");
                stringBuffer.append(domain.getName()).append(",");
                arrayList.add(stringBuffer.toString());
            }
            Object[] objectArray = checkConstraint.getTypes();
            for (int i = 0; i < objectArray.length; ++i) {
                RDBMSType rDBMSType = (RDBMSType)objectArray[i];
                String string2 = checkConstraint.getImplementationFor(rDBMSType);
                if (string2 == null || "".equalsIgnoreCase(string2)) continue;
                ++n;
                stringBuffer = new StringBuffer();
                stringBuffer.append(domain.getObjectID()).append(",");
                stringBuffer.append(domain.getNumID()).append(",");
                stringBuffer.append(n).append(",");
                stringBuffer.append(checkConstraint.getName()).append(",");
                stringBuffer.append(this.replaceAndQuoteString(string2)).append(",");
                stringBuffer.append(rDBMSType.getName()).append(",");
                stringBuffer.append(domain.getName()).append(",");
                arrayList.add(stringBuffer.toString());
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Domain_Check_Constraints.csv";
    }
}

