/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.Domain;

public class EHDomain
extends ExportHandler {
    public EHDomain(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Domain_ID").append(",");
        stringBuffer.append("Domain_Name").append(",");
        stringBuffer.append("Num_Domain_ID").append(",");
        stringBuffer.append("Synonyms").append(",");
        stringBuffer.append("Logical_Type_ID").append(",");
        stringBuffer.append("Num_Logical_Type_ID").append(",");
        stringBuffer.append("T_Size").append(",");
        stringBuffer.append("T_Precision").append(",");
        stringBuffer.append("T_Scale").append(",");
        stringBuffer.append("Native_Type").append(",");
        stringBuffer.append("LT_Name");
        arrayList.add(stringBuffer.toString());
        Iterator iterator = this.getDesign().getDomainSet().iterator();
        while (iterator.hasNext()) {
            Domain domain = (Domain)iterator.next();
            stringBuffer = new StringBuffer();
            stringBuffer.append(domain.getObjectID()).append(",");
            stringBuffer.append(domain.getName()).append(",");
            stringBuffer.append(domain.getNumID()).append(",");
            stringBuffer.append(this.quotedString(domain.getSynonym())).append(",");
            stringBuffer.append(domain.getLogicalDatatype().getObjectID()).append(",");
            stringBuffer.append(domain.getLogicalDatatype().getNumID()).append(",");
            stringBuffer.append(domain.getSize()).append(",");
            stringBuffer.append(domain.getPrecision()).append(",");
            stringBuffer.append(domain.getScale()).append(",");
            stringBuffer.append(domain.getDataType().getName()).append(",");
            stringBuffer.append(domain.getLogicalDatatype().getName()).append(",");
            arrayList.add(stringBuffer.toString());
            this.getCsvExporter().addNote(domain.getObjectID(), domain.getNumID(), "Domain", domain.getNotes());
            this.getCsvExporter().addComment(domain.getObjectID(), domain.getNumID(), "Domain", domain.getComment());
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Domains.csv";
    }
}

