/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;

public class EHColumn
extends ExportHandler {
    public EHColumn(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Column_Name").append(",");
        stringBuffer.append("ObjectID").append(",");
        stringBuffer.append("NumOID").append(",");
        stringBuffer.append("ImportID").append(",");
        stringBuffer.append("ContainerID").append(",");
        stringBuffer.append("Num_ContainerID").append(",");
        stringBuffer.append("Mandatory").append(",");
        stringBuffer.append("DataType_Kind").append(",");
        stringBuffer.append("Value_Type").append(",");
        stringBuffer.append("Computed").append(",");
        stringBuffer.append("Formula").append(",");
        stringBuffer.append("ScopeEntityID").append(",");
        stringBuffer.append("Num_ScopeEntityID").append(",");
        stringBuffer.append("Domain_ID").append(",");
        stringBuffer.append("Num_Domain_ID").append(",");
        stringBuffer.append("Logical_Type_ID").append(",");
        stringBuffer.append("Num_Logical_Type_ID").append(",");
        stringBuffer.append("Distinct_Type_ID").append(",");
        stringBuffer.append("Num_Distinct_Type_ID").append(",");
        stringBuffer.append("Structured_Type_ID").append(",");
        stringBuffer.append("Num_Structured_Type_ID").append(",");
        stringBuffer.append("Collection_Type_ID").append(",");
        stringBuffer.append("Num_Collection_Type_ID").append(",");
        stringBuffer.append("Check_Constraint_Name").append(",");
        stringBuffer.append("Default_Value").append(",");
        stringBuffer.append("Use_Domain_Constraint").append(",");
        stringBuffer.append("Domain_Name").append(",");
        stringBuffer.append("Logical_Type_Name").append(",");
        stringBuffer.append("Structured_Type_Name").append(",");
        stringBuffer.append("Distinct_Type_Name").append(",");
        stringBuffer.append("Collection_Type_Name").append(",");
        stringBuffer.append("Uses_Default").append(",");
        stringBuffer.append("Engineer").append(",");
        stringBuffer.append("Table_Name").append(",");
        stringBuffer.append("PK_Flag").append(",");
        stringBuffer.append("FK_Flag").append(",");
        stringBuffer.append("Native_Type").append(",");
        stringBuffer.append("Sequence").append(",");
        stringBuffer.append("ModelID").append(",");
        stringBuffer.append("Num_ModelID").append(",");
        stringBuffer.append("Model_Name").append(",");
        stringBuffer.append("T_Size").append(",");
        stringBuffer.append("T_Precision").append(",");
        stringBuffer.append("T_Scale");
        arrayList.add(stringBuffer.toString());
        Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!this.getCsvExporter().isModelSelected(relationalDesign)) continue;
            Iterator iterator2 = relationalDesign.getColumnSet().iterator();
            while (iterator2.hasNext()) {
                Column column = (Column)iterator2.next();
                stringBuffer = new StringBuffer();
                stringBuffer.append(column.getName()).append(",");
                stringBuffer.append(column.getObjectID()).append(",");
                stringBuffer.append(column.getNumID()).append(",");
                stringBuffer.append(column.getImportedId() != null ? column.getImportedId() : "").append(",");
                stringBuffer.append(column.getContainer().getObjectID()).append(",");
                stringBuffer.append(column.getContainer().getNumID()).append(",");
                stringBuffer.append(column.getNullsAllowed() ? "N" : "Y").append(",");
                switch (column.getUse()) {
                    case 0: {
                        stringBuffer.append("Domain").append(",");
                        break;
                    }
                    case 1: {
                        stringBuffer.append("Logical Type").append(",");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("Distinct Type").append(",");
                        break;
                    }
                    case 3: {
                        if (column.isReference()) {
                            stringBuffer.append("Ref Struct Type").append(",");
                            break;
                        }
                        stringBuffer.append("Structured Type").append(",");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("Collection Type").append(",");
                    }
                }
                stringBuffer.append(column.getSourceType()).append(",");
                stringBuffer.append(column.isComputed() != false ? "Y" : "N").append(",");
                stringBuffer.append(column.getFormulaDesc()).append(",");
                if (column.getScope() != null) {
                    stringBuffer.append(column.getScope().getObjectID()).append(",");
                    stringBuffer.append(column.getScope().getNumID()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(column.getDomain().getObjectID()).append(",");
                stringBuffer.append(column.getDomain().getNumID()).append(",");
                stringBuffer.append(column.getLogicalDatatype().getObjectID()).append(",");
                stringBuffer.append(column.getLogicalDatatype().getNumID()).append(",");
                if (column.getDistinctType() != null) {
                    stringBuffer.append(column.getDistinctType().getObjectID()).append(",");
                    stringBuffer.append(column.getDistinctType().getNumID()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                if (column.getStructuredType() != null) {
                    stringBuffer.append(column.getStructuredType().getObjectID()).append(",");
                    stringBuffer.append(column.getStructuredType().getNumID()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                if (column.getCollectionType() != null) {
                    stringBuffer.append(column.getCollectionType().getObjectID()).append(",");
                    stringBuffer.append(column.getCollectionType().getNumID()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(column.getConstraintName()).append(",");
                stringBuffer.append(column.getDefaultValue()).append(",");
                stringBuffer.append(column.getUseDomainConstraints() ? "Y" : "N").append(",");
                if (column.getUse() == 0) {
                    stringBuffer.append(column.getDomain().getName()).append(",");
                    stringBuffer.append(column.getDomain().getLogicalDatatype().getName()).append(",");
                } else if (column.getUse() == 1) {
                    stringBuffer.append("").append(",");
                    stringBuffer.append(column.getLogicalDatatype().getName()).append(",");
                } else if (column.getUse() == 2) {
                    stringBuffer.append("").append(",");
                    stringBuffer.append(column.getDistinctType().getLogicalDataType().getName()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                if (column.getStructuredType() != null) {
                    stringBuffer.append(column.getStructuredType().getName()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                }
                if (column.getDistinctType() != null) {
                    stringBuffer.append(column.getDistinctType().getName()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                }
                if (column.getCollectionType() != null) {
                    stringBuffer.append(column.getCollectionType().getName()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(column.getUsesDefaultValue() ? "Y" : "N").append(",");
                stringBuffer.append(column.getShouldEngineer() ? "Y" : "N").append(",");
                stringBuffer.append(column.getContainer().getName()).append(",");
                if (column.isPKElement()) {
                    stringBuffer.append("P").append(",");
                } else {
                    stringBuffer.append("").append(",");
                }
                if (column.isFKColumn()) {
                    stringBuffer.append("F").append(",");
                } else {
                    stringBuffer.append("").append(",");
                }
                stringBuffer.append(column.getDataType().getName()).append(",");
                stringBuffer.append(column.getContainer().getIndexOf(column) + 1).append(",");
                stringBuffer.append(relationalDesign.getObjectID()).append(",");
                stringBuffer.append(relationalDesign.getNumID()).append(",");
                stringBuffer.append(relationalDesign.getName()).append(",");
                if (column.getUse() == 0) {
                    stringBuffer.append(column.getDomain().getSize()).append(",");
                    stringBuffer.append(column.getDomain().getPrecision()).append(",");
                    stringBuffer.append(column.getDomain().getScale()).append(",");
                } else if (column.getUse() == 1) {
                    stringBuffer.append(column.getSize()).append(",");
                    stringBuffer.append(column.getPrecision()).append(",");
                    stringBuffer.append(column.getScale()).append(",");
                } else {
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                    stringBuffer.append("").append(",");
                }
                arrayList.add(stringBuffer.toString());
                this.getCsvExporter().addNote(column.getObjectID(), column.getNumID(), "Column", column.getNotes());
                this.getCsvExporter().addComment(column.getObjectID(), column.getNumID(), "Column", column.getComment());
                this.getCsvExporter().addCommentRDBMS(column.getObjectID(), column.getNumID(), "Column", column.getCommentInRDBMS());
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Columns.csv";
    }
}

