/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSType;

public class EHCheckConstraint
extends ExportHandler {
    private List elements = new ArrayList();

    public EHCheckConstraint(CSVExporter cSVExporter) {
        super(cSVExporter);
    }

    @Override
    public void Export() {
        Object object;
        Iterator iterator;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DataElement_ID").append(",");
        stringBuffer.append("Num_DataElement_ID").append(",");
        stringBuffer.append("Type").append(",");
        stringBuffer.append("Sequence").append(",");
        stringBuffer.append("Constraint_Name").append(",");
        stringBuffer.append("Text").append(",");
        stringBuffer.append("Database_Type").append(",");
        stringBuffer.append("Container_Name").append(",");
        stringBuffer.append("DataElement_Name");
        arrayList.add(stringBuffer.toString());
        LogicalDesign logicalDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logicalDesign)) {
            iterator = logicalDesign.getAttributeSet().iterator();
            while (iterator.hasNext()) {
                this.elements.add(iterator.next());
            }
        }
        iterator = this.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            ModelIDObject modelIDObject = (RelationalDesign)iterator.next();
            if (!this.getCsvExporter().isModelSelected((DesignPart)modelIDObject)) continue;
            object = ((RelationalDesign)modelIDObject).getColumnSet().iterator();
            while (object.hasNext()) {
                this.elements.add(object.next());
            }
        }
        for (ModelIDObject modelIDObject : this.elements) {
            object = ((ContainedObject)modelIDObject).getCheck();
            int n = 0;
            if (object == null) continue;
            String string = ((CheckConstraint)object).getGenericConstraint();
            if (string != null && !"".equalsIgnoreCase(string)) {
                ++n;
                stringBuffer = new StringBuffer();
                stringBuffer.append(modelIDObject.getObjectID()).append(",");
                stringBuffer.append(modelIDObject.getNumID()).append(",");
                if (modelIDObject instanceof Attribute) {
                    stringBuffer.append("Attribute").append(",");
                } else {
                    stringBuffer.append("Column").append(",");
                }
                stringBuffer.append(n).append(",");
                stringBuffer.append(((ModelObject)object).getName()).append(",");
                stringBuffer.append(this.replaceAndQuoteString(string)).append(",");
                stringBuffer.append(((ModelObject)object).getSelectedRDBMSType().getName()).append(",");
                stringBuffer.append(((ContainedObject)modelIDObject).getContainer().getName()).append(",");
                stringBuffer.append(((ContainedObject)modelIDObject).getName()).append(",");
                arrayList.add(stringBuffer.toString());
            }
            Object[] objectArray = ((CheckConstraint)object).getTypes();
            for (int i = 0; i < objectArray.length; ++i) {
                RDBMSType rDBMSType = (RDBMSType)objectArray[i];
                String string2 = ((CheckConstraint)object).getImplementationFor(rDBMSType);
                if (string2 == null || "".equalsIgnoreCase(string2)) continue;
                ++n;
                stringBuffer = new StringBuffer();
                stringBuffer.append(modelIDObject.getObjectID()).append(",");
                stringBuffer.append(modelIDObject.getNumID()).append(",");
                if (modelIDObject instanceof Attribute) {
                    stringBuffer.append("Attribute").append(",");
                } else {
                    stringBuffer.append("Column").append(",");
                }
                stringBuffer.append(n).append(",");
                stringBuffer.append(((ModelObject)object).getName()).append(",");
                stringBuffer.append(this.replaceAndQuoteString(string2)).append(",");
                stringBuffer.append(rDBMSType.getName()).append(",");
                stringBuffer.append(((ContainedObject)modelIDObject).getContainer().getName()).append(",");
                stringBuffer.append(((ContainedObject)modelIDObject).getName()).append(",");
                arrayList.add(stringBuffer.toString());
            }
        }
        this.saveToFile(arrayList);
    }

    @Override
    public String getFileName() {
        return "DM_Check_Constraints.csv";
    }
}

