/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.controls.display.DisplayRegistry;
import oracle.dbtools.raptor.controls.display.IDisplayDetail;
import oracle.dbtools.raptor.export.pdf.PDFConfig;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.report.pdf.IPDFOptions;
import oracle.dbtools.raptor.report.pdf.PDFBlobPanel;
import oracle.dbtools.raptor.report.pdf.PDFCellLayoutPanel;
import oracle.dbtools.raptor.report.pdf.PDFColumnLayoutPanel;
import oracle.dbtools.raptor.report.pdf.PDFDocumentPropertiesPanel;
import oracle.dbtools.raptor.report.pdf.PDFHeaderFooterPanel;
import oracle.dbtools.raptor.report.pdf.PDFPageSetupPanel;
import oracle.dbtools.raptor.report.pdf.PDFSecurityPanel;
import oracle.dbtools.raptor.report.pdf.PDFTableLayoutPanel;
import oracle.dbtools.raptor.report.ui.AdvancedPanel;
import oracle.dbtools.raptor.report.ui.BindPanel;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.report.ui.ReportCellRenderer;
import oracle.dbtools.raptor.report.ui.ReportChildPanel;
import oracle.dbtools.raptor.report.ui.ReportConstants;
import oracle.dbtools.raptor.report.ui.ReportInfo;
import oracle.dbtools.raptor.report.ui.ReportNamePanel;
import oracle.dbtools.raptor.report.ui.ReportNodeInfo;
import oracle.dbtools.raptor.report.ui.ReportOptionsPanel;
import oracle.dbtools.raptor.report.ui.ReportSQLPanel;
import oracle.dbtools.raptor.report.ui.ReportUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class ReportTreePanel
extends JPanel
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private String _dbName;
    private DisplayModel _model;
    private String _path;
    private DefaultMutableTreeNode _rootNode;
    private static JTree _reportTree = null;
    private ReportOptionsPanel _reportOptions;
    private ReportNodeInfo _prevNodeInfo = null;
    private static ReportInfo _masterReportInfo = null;
    private static HashMap<String, ReportInfo> _childrenMapRptInfo = null;
    private static DefaultMutableTreeNode _childNode = null;

    public ReportTreePanel(DisplayModel displayModel) {
        this._model = displayModel;
        this.init();
        this.populateMaster();
        this.populateChildren();
        this.setupListeners();
    }

    public void setPath(String string) {
        this._path = string;
    }

    private void init() {
        _reportTree = null;
        String string = this._model != null ? this._model.getName() : "MasterReport";
        _masterReportInfo = new ReportInfo(string);
        Object object = this.createObject("MasterReport");
        this.assignValues(object, this._model);
        _masterReportInfo.addObject("MasterReport", object);
        Object object2 = this.createObject("Sql");
        this.assignValues(object2, this._model);
        _masterReportInfo.addObject("Sql", object2);
        Object object3 = this.createObject("DrillDown");
        this.assignValues(object3, this._model);
        _masterReportInfo.addObject("DrillDown", object3);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ReportConstants.ROOT_NODE_NAME).append(" - ").append(string);
        _childrenMapRptInfo = new HashMap();
        this.setPreferredSize(new Dimension(575, 425));
        JScrollPane jScrollPane = this.createReportTreePane();
        this._reportOptions = new ReportOptionsPanel(stringBuffer.toString(), this.getPanel(object));
        JScrollPane jScrollPane2 = new JScrollPane(this._reportOptions);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
        jSplitPane.setTopComponent(jScrollPane);
        jSplitPane.setBottomComponent(jScrollPane2);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setDividerSize(3);
        jSplitPane.setDividerLocation(150);
        this.add((Component)jSplitPane, "Center");
        this.repaint();
    }

    private JScrollPane createReportTreePane() {
        this._rootNode = new DefaultMutableTreeNode(new ReportNodeInfo(ReportConstants.ROOT_NODE_NAME, "MasterReport"));
        this._prevNodeInfo = (ReportNodeInfo)this._rootNode.getUserObject();
        this.createReportNodes();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this._rootNode);
        _reportTree = new JTree(defaultTreeModel);
        _reportTree.setCellRenderer(new ReportCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(_reportTree);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        _reportTree.setShowsRootHandles(true);
        _reportTree.setRootVisible(true);
        _reportTree.getSelectionModel().setSelectionMode(1);
        _reportTree.setSelectionPath(new TreePath(this._rootNode.getPath()));
        Color color = _reportTree.getBackground();
        jScrollPane.setBackground(color);
        jScrollPane.getViewport().setBackground(color);
        _reportTree.addTreeSelectionListener(this);
        this.setLayout(new BorderLayout());
        return jScrollPane;
    }

    private void createReportNodes() {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        for (ReportConstants.ROOT_CHILD_NODES rOOT_CHILD_NODES : ReportConstants.ROOT_CHILD_NODES.values()) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(new ReportNodeInfo(rOOT_CHILD_NODES.getName(), rOOT_CHILD_NODES.getType()));
            switch (rOOT_CHILD_NODES) {
                case CHILD_NODE: {
                    if (this._model == null || !this._model.hasChildren()) break;
                    DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                    String string = null;
                    if (_childrenMapRptInfo == null) {
                        _childrenMapRptInfo = new HashMap();
                    }
                    ReportInfo reportInfo = null;
                    for (DisplayModel displayModel : this._model.getChildren()) {
                        string = displayModel.getName();
                        defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ReportNodeInfo(string, "ChildReport"));
                        ReportUtils.createChildNodes(defaultMutableTreeNode2);
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                        reportInfo = new ReportInfo(string);
                        reportInfo.setIsChild(true);
                        _childrenMapRptInfo.put(string, reportInfo);
                    }
                    break;
                }
                case PDF_NODE: {
                    ReportUtils.createPDFNodes(defaultMutableTreeNode);
                }
            }
            this._rootNode.add(defaultMutableTreeNode);
        }
        _childNode = this._rootNode.getNextNode().getNextNode();
    }

    public void setupListeners() {
        ReportSQLPanel reportSQLPanel = this.getMasterReportSQLPanel();
        reportSQLPanel.getTestReportButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportTreePanel.this.displayTestReportDialog(1);
            }
        });
        reportSQLPanel.getLargeEditorTestReportButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportTreePanel.this.displayTestReportDialog(2);
            }
        });
    }

    private void populateMaster() {
        if (this._model == null) {
            return;
        }
        Object object = null;
        String string = null;
        for (ReportConstants.ROOT_CHILD_NODES rOOT_CHILD_NODES : ReportConstants.ROOT_CHILD_NODES.values()) {
            string = rOOT_CHILD_NODES.getType();
            object = this.createObject(string);
            this.assignValues(object, this._model);
            _masterReportInfo.addObject(string, object);
        }
        this.populateProperty(this._model, _masterReportInfo);
        this.populatePDF(this._model, _masterReportInfo);
    }

    private void populateChildren() {
        if (this._model.getChildren() == null) {
            return;
        }
        List list = this._model.getChildren();
        ReportInfo reportInfo = null;
        String string = null;
        String string2 = null;
        for (DisplayModel displayModel : list) {
            string2 = displayModel.getName();
            if (_childrenMapRptInfo.containsKey(string2)) {
                reportInfo = _childrenMapRptInfo.get(string2);
            }
            Object object = this.createObject("ChildReport", true);
            this.assignValues(object, displayModel, true, displayModel.getName(), "ChildReport", string2);
            reportInfo.addObject("ChildReport", object);
            for (ReportConstants.CHILD_CHILD_NODES cHILD_CHILD_NODES : ReportConstants.CHILD_CHILD_NODES.values()) {
                string = cHILD_CHILD_NODES.getType();
                object = this.createObject(string, true);
                this.assignValues(object, displayModel, true, cHILD_CHILD_NODES.getName(), string, string2);
                reportInfo.addObject(string, object);
            }
            this.populateProperty(displayModel, reportInfo);
            this.populatePDF(displayModel, reportInfo, string2);
        }
    }

    private void populateProperty(DisplayModel displayModel, ReportInfo reportInfo) {
        String string = displayModel.getStyle();
        if (string.equals("Table") || string.equals("Chart") || string.equals("Gauge")) {
            Object object = this.createObject(string);
            this.assignValues(object, displayModel, reportInfo.isChild(), null, string, null);
            reportInfo.addObject(string, object);
        }
    }

    private void populatePDF(DisplayModel displayModel, ReportInfo reportInfo) {
        this.populatePDF(displayModel, reportInfo, null);
    }

    private void populatePDF(DisplayModel displayModel, ReportInfo reportInfo, String string) {
        String string2 = null;
        for (ReportConstants.PDF_CHILD_NODES pDF_CHILD_NODES : ReportConstants.PDF_CHILD_NODES.values()) {
            string2 = pDF_CHILD_NODES.getType();
            Object object = this.createObject(string2);
            this.assignValues(object, displayModel, reportInfo.isChild(), null, string2, string);
            reportInfo.addObject(string2, object);
        }
    }

    public void displayTestReportDialog(int n) {
        String string = null;
        String string2 = string = n == 1 ? this.getMasterReportSQLPanel().getSql() : this.getMasterReportSQLPanel().getSqlFromLargeEditor();
        if (string != null && !string.isEmpty()) {
            this.showTest(this.getModel(string));
        } else {
            MessageDialog.error((Component)this, (Object)ReportArb.getString("TEST_REPORT_ERROR_SQL_MISSING"), (String)ReportArb.getString("TEST_REPORT_ERROR_TITLE"), null);
        }
    }

    public void showTest(DisplayModel displayModel) {
        if (this._dbName == null) {
            this._dbName = ReportUtils.getNewConnection();
        }
        try {
            Connections.getInstance().getConnection(this._dbName);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (this._dbName != null && Connections.getInstance().isConnectionOpen(this._dbName)) {
            displayModel.setConnName(this._dbName);
            DisplayPanel displayPanel = new DisplayPanel(displayModel);
            displayPanel.promptForBindsOnNextRun(true);
            displayPanel.refresh(true);
            Dimension dimension = new Dimension(400, 400);
            try {
                JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)displayPanel, null, (String)ReportArb.getString("TEST_REPORT_TITLE"), (int)16);
                jEWTDialog.setPreferredSize(dimension);
                jEWTDialog.setSize(dimension);
                jEWTDialog.setLocation(300, 20);
                jEWTDialog.runDialog();
            }
            catch (Exception exception) {
                // empty catch block
            }
            displayPanel.close();
        }
    }

    public DisplayModel getModel() {
        return this.getModel(null);
    }

    public DisplayModel getModel(String string) {
        DisplayModel displayModel = this.createDisplayModelFromReportInfo(_masterReportInfo, "MasterReport", string);
        ArrayList<DisplayModel> arrayList = new ArrayList<DisplayModel>();
        ArrayList<String> arrayList2 = ReportTreePanel.getChildNames();
        DisplayModel displayModel2 = null;
        ReportInfo reportInfo = null;
        for (String string2 : arrayList2) {
            reportInfo = _childrenMapRptInfo.get(string2);
            if (reportInfo == null) {
                System.out.println("getModel(), the childNameKey is null in _childrenMapRptInfo for child: " + string2);
            }
            displayModel2 = this.createDisplayModelFromReportInfo(reportInfo, "ChildReport", string);
            arrayList.add(displayModel2);
        }
        displayModel.setChildren(arrayList);
        return displayModel;
    }

    private DisplayModel createDisplayModelFromReportInfo(ReportInfo reportInfo, String string, String string2) {
        ReportNamePanel reportNamePanel = (ReportNamePanel)reportInfo.getObject(string);
        DisplayModel displayModel = new DisplayModel(reportNamePanel.getName(), reportNamePanel.getDesc(), "true", reportNamePanel.getTip());
        ReportSQLPanel reportSQLPanel = (ReportSQLPanel)reportInfo.getObject("Sql");
        displayModel.setStyle(reportSQLPanel.getStyle());
        Query query = new Query();
        String string3 = null;
        if (string.equalsIgnoreCase("MasterReport")) {
            string3 = string2 == null ? reportSQLPanel.getSql().replaceAll("\r\n", "\n") : string2.replaceAll("\r\n", "\n");
            query.setSql(string3);
            if (this.getBindPanel() != null) {
                query.setBinds(this.getBindPanel().getBinds());
            }
            if (this.getAdvPanel() != null) {
                displayModel.setID(this.getAdvPanel().getId());
                displayModel.setActions(this.getAdvPanel().getActions());
            }
            displayModel.setPath(this._path);
        } else {
            string3 = reportSQLPanel.getSql().replaceAll("\r\n", "\n");
            query.setSql(string3);
        }
        ArrayList<Query> arrayList = new ArrayList<Query>();
        arrayList.add(query);
        displayModel.setQueries(arrayList);
        IDisplayDetail iDisplayDetail = null;
        try {
            if (DisplayRegistry.hasDetails((String)reportSQLPanel.getStyle()).booleanValue()) {
                if (reportSQLPanel.getStyle().equals("Table")) {
                    iDisplayDetail = (IDisplayDetail)reportInfo.getObject("Table");
                } else if (reportSQLPanel.getStyle().equals("Chart")) {
                    iDisplayDetail = (IDisplayDetail)reportInfo.getObject("Chart");
                } else if (reportSQLPanel.getStyle().equals("Gauge")) {
                    iDisplayDetail = (IDisplayDetail)reportInfo.getObject("Gauge");
                }
                if (iDisplayDetail == null) {
                    iDisplayDetail = DisplayRegistry.getDetailPanel((String)reportSQLPanel.getStyle());
                }
                if (iDisplayDetail != null) {
                    displayModel.setExtValues(iDisplayDetail.getValues());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        PDFFormatOptions pDFFormatOptions = this.getAllPDFFormatOptions(reportInfo);
        displayModel.setPDFFormatOptions(pDFFormatOptions);
        return displayModel;
    }

    private PDFFormatOptions getAllPDFFormatOptions(ReportInfo reportInfo) {
        PDFFormatOptions pDFFormatOptions = null;
        String string = "Pdf";
        Object object = reportInfo.getObject(string);
        if (object != null) {
            pDFFormatOptions = ((IPDFOptions)object).getPDFFormatOptions();
        }
        for (ReportConstants.PDF_CHILD_NODES pDF_CHILD_NODES : ReportConstants.PDF_CHILD_NODES.values()) {
            string = pDF_CHILD_NODES.getType();
            object = reportInfo.getObject(string);
            if (object == null) continue;
            pDFFormatOptions = ((IPDFOptions)object).getPDFFormatOptions();
        }
        return pDFFormatOptions;
    }

    public AdvancedPanel getAdvPanel() {
        if (_masterReportInfo == null) {
            return null;
        }
        return (AdvancedPanel)_masterReportInfo.getObject("DrillDown");
    }

    public BindPanel getBindPanel() {
        if (_masterReportInfo == null) {
            return null;
        }
        return (BindPanel)_masterReportInfo.getObject("Bind");
    }

    public ReportSQLPanel getMasterReportSQLPanel() {
        if (_masterReportInfo == null) {
            return null;
        }
        return (ReportSQLPanel)_masterReportInfo.getObject("Sql");
    }

    public String validateSecurityPasswords() {
        StringBuffer stringBuffer = new StringBuffer();
        PDFSecurityPanel pDFSecurityPanel = (PDFSecurityPanel)_masterReportInfo.getObject("PdfSecurity");
        if (pDFSecurityPanel != null && !pDFSecurityPanel.validatePassword()) {
            stringBuffer.append(ReportArb.format("SECURITY_MASTER_REPORT", ReportTreePanel.getMasterReportName())).append("\n");
            stringBuffer.append(pDFSecurityPanel.getErrorMessage()).append("\n\n");
        }
        ArrayList<String> arrayList = ReportTreePanel.getChildNames();
        ReportInfo reportInfo = null;
        for (String string : arrayList) {
            reportInfo = _childrenMapRptInfo.get(string);
            if (reportInfo == null || (pDFSecurityPanel = (PDFSecurityPanel)reportInfo.getObject("PdfSecurity")) == null || pDFSecurityPanel.validatePassword()) continue;
            stringBuffer.append(ReportArb.format("SECURITY_CHILD_REPORT", reportInfo.getName())).append("\n");
            stringBuffer.append(pDFSecurityPanel.getErrorMessage()).append("\n\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)_reportTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        TreePath treePath = _reportTree.getSelectionPath();
        JPanel jPanel = null;
        ReportNodeInfo reportNodeInfo = (ReportNodeInfo)defaultMutableTreeNode.getUserObject();
        ReportNodeInfo reportNodeInfo2 = null;
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (this._prevNodeInfo.getType().equalsIgnoreCase("MasterReport") || this._prevNodeInfo.getType().equalsIgnoreCase("ChildReport")) {
            this.processNameChange(this._prevNodeInfo);
        }
        if (defaultMutableTreeNode.getParent() != null) {
            reportNodeInfo2 = (ReportNodeInfo)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
        }
        if (reportNodeInfo2 != null && defaultMutableTreeNode.getLevel() == 2 && reportNodeInfo2.getType().equals("Child") || defaultMutableTreeNode.getLevel() > 2) {
            ReportNodeInfo reportNodeInfo3 = (ReportNodeInfo)((DefaultMutableTreeNode)treePath.getPathComponent(2)).getUserObject();
            jPanel = this.getChildPanel(reportNodeInfo.getName(), reportNodeInfo.getType(), reportNodeInfo3.getName());
            string = reportNodeInfo3.getName();
            if (reportNodeInfo.getType().equals("ChildReport")) {
                stringBuffer.append(ReportArb.getString("CHILD_REPORT_NODE"));
            } else {
                stringBuffer.append(reportNodeInfo.getName());
            }
        } else {
            jPanel = this.getMasterPanel(reportNodeInfo.getName(), reportNodeInfo.getType());
            string = _masterReportInfo.getName();
            stringBuffer.append(reportNodeInfo.getName());
        }
        if (string != null && !string.isEmpty()) {
            stringBuffer.append(" - ").append(string);
        }
        this.displayReportOptions(stringBuffer.toString(), jPanel);
        this._prevNodeInfo = reportNodeInfo;
    }

    private Object createObject(String string) {
        return this.createObject(string, false);
    }

    private Object createObject(String string, boolean bl) {
        Object object = null;
        try {
            if (string.equalsIgnoreCase("MasterReport")) {
                object = new ReportNamePanel();
            } else if (string.equalsIgnoreCase("Sql")) {
                object = new ReportSQLPanel(bl);
            } else if (string.equalsIgnoreCase("Child")) {
                object = new ReportChildPanel();
            } else if (string.equalsIgnoreCase("ChildReport")) {
                object = new ReportNamePanel();
            } else if (string.equalsIgnoreCase("Bind")) {
                object = new BindPanel();
            } else if (string.equalsIgnoreCase("DrillDown")) {
                object = new AdvancedPanel();
            } else if (string.equalsIgnoreCase("ReportType")) {
                object = null;
            } else if (string.equalsIgnoreCase("Table")) {
                object = DisplayRegistry.getDetailPanel((String)"Table");
            } else if (string.equalsIgnoreCase("Chart")) {
                object = DisplayRegistry.getDetailPanel((String)"Chart");
            } else if (string.equalsIgnoreCase("Gauge")) {
                object = DisplayRegistry.getDetailPanel((String)"Gauge");
            } else if (string.equalsIgnoreCase("Pdf")) {
                object = new PDFDocumentPropertiesPanel();
            } else if (string.equalsIgnoreCase("PdfBlob")) {
                object = new PDFBlobPanel();
            } else if (string.equalsIgnoreCase("PdfCell")) {
                object = new PDFCellLayoutPanel();
            } else if (string.equalsIgnoreCase("PdfColumn")) {
                object = new PDFColumnLayoutPanel();
            } else if (string.equalsIgnoreCase("PdfColumnSize")) {
                object = null;
            } else if (string.equalsIgnoreCase("PdfColumnAlias")) {
                object = null;
            } else if (string.equalsIgnoreCase("PdfTable")) {
                object = new PDFTableLayoutPanel();
            } else if (string.equalsIgnoreCase("PdfHeaderFooter")) {
                object = new PDFHeaderFooterPanel();
            } else if (string.equalsIgnoreCase("PdfSecurity")) {
                object = new PDFSecurityPanel();
            } else if (string.equalsIgnoreCase("PdfPageSetup")) {
                object = new PDFPageSetupPanel();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    private JPanel getMasterPanel(String string, String string2) {
        JPanel jPanel = null;
        String string3 = string2;
        if (_masterReportInfo != null) {
            Object object;
            if (string3.equals("Property")) {
                string3 = ReportTreePanel.getMasterReportStyle();
            }
            if ((object = _masterReportInfo.getObject(string3)) == null) {
                Object object2 = this.createObject(string3);
                if (object2 != null) {
                    this.assignValues(object2, this._model, false, string, string3, null);
                }
                _masterReportInfo.addObject(string3, object2);
                jPanel = this.getPanel(object2);
            } else {
                jPanel = this.getPanel(object);
            }
        }
        return jPanel;
    }

    private JPanel getChildPanel(String string, String string2, String string3) {
        JPanel jPanel = null;
        String string4 = string2;
        if (_childrenMapRptInfo != null && _childrenMapRptInfo.containsKey(string3)) {
            Object object;
            ReportInfo reportInfo = _childrenMapRptInfo.get(string3);
            if (string4.equals("Property")) {
                object = (ReportSQLPanel)reportInfo.getObject("Sql");
                string4 = object == null ? "Table" : ((ReportSQLPanel)object).getStyle();
            }
            if ((object = reportInfo.getObject(string4)) == null) {
                Object object2 = this.createObject(string4, true);
                if (object2 != null) {
                    this.assignValues(object2, null, true, string, string4, string3);
                }
                reportInfo.addObject(string4, object2);
                jPanel = this.getPanel(object2);
            } else {
                jPanel = this.getPanel(object);
            }
        }
        return jPanel;
    }

    private void assignValues(Object object, DisplayModel displayModel) {
        this.assignValues(object, displayModel, false, null, null, null);
    }

    private void assignValues(Object object, DisplayModel displayModel, boolean bl, String string, String string2, String string3) {
        if (object instanceof ReportNamePanel) {
            if (displayModel != null) {
                ((ReportNamePanel)object).setInfo(displayModel.getName(), displayModel.getDescription(), displayModel.getToolTip());
            } else {
                ((ReportNamePanel)object).setInfo(string, "", "");
            }
        } else if (object instanceof ReportSQLPanel) {
            if (displayModel != null) {
                ((ReportSQLPanel)object).setInfo(displayModel.getName(), displayModel.getQuery().getSql(), displayModel.getStyle());
            }
        } else if (object instanceof ReportChildPanel) {
            ((ReportChildPanel)object).setChildNames(ReportTreePanel.getChildNames());
        } else if (object instanceof BindPanel) {
            if (displayModel != null) {
                ((BindPanel)object).setBinds(displayModel.getQuery().getReportBinds());
            }
        } else if (object instanceof AdvancedPanel) {
            if (displayModel != null) {
                ((AdvancedPanel)object).setModel(displayModel);
            }
        } else if (object instanceof IDisplayDetail) {
            if (displayModel != null && displayModel.getExtValues() != null && !displayModel.getExtValues().isEmpty()) {
                if (displayModel.getStyle().equals("Table") && string2.equals("Table")) {
                    ((IDisplayDetail)object).setValues(displayModel.getExtValues());
                } else if (displayModel.getStyle().equals("Chart") && string2.equals("Chart")) {
                    ((IDisplayDetail)object).setValues(displayModel.getExtValues());
                } else if (displayModel.getStyle().equals("Gauge") && string2.equals("Gauge")) {
                    ((IDisplayDetail)object).setValues(displayModel.getExtValues());
                }
            }
        } else if (object instanceof IPDFOptions) {
            ((IPDFOptions)object).assignPDFFormatValues(this.getPDFOptions(displayModel, bl, string3));
        }
    }

    private JPanel getPanel(Object object) {
        if (object == null) {
            return null;
        }
        JPanel jPanel = null;
        if (object instanceof IDisplayDetail) {
            jPanel = (JPanel)object;
        } else if (object instanceof IPDFOptions) {
            jPanel = ((IPDFOptions)object).getPanel();
        } else if (object instanceof ReportSQLPanel) {
            ((ReportSQLPanel)object).updateMasterInfo();
            jPanel = (JPanel)object;
        } else if (object instanceof JPanel) {
            jPanel = (JPanel)object;
        } else {
            System.out.println("Object is unknown...");
        }
        return jPanel;
    }

    private void processNameChange(ReportNodeInfo reportNodeInfo) {
        ReportInfo reportInfo;
        String string = null;
        if (reportNodeInfo.getType().equals("MasterReport")) {
            string = ((ReportNamePanel)_masterReportInfo.getObject("MasterReport")).getName();
            if (!string.equals(_masterReportInfo.getName())) {
                _masterReportInfo.setName(string);
            }
        } else if (reportNodeInfo.getType().equals("ChildReport") && !(string = ((ReportNamePanel)(reportInfo = _childrenMapRptInfo.get(reportNodeInfo.getName())).getObject("ChildReport")).getName()).equals(reportInfo.getName())) {
            reportInfo.setName(string);
            reportNodeInfo.setName(string);
            _childrenMapRptInfo.remove(reportInfo.getName());
            _childrenMapRptInfo.put(string, reportInfo);
        }
    }

    private PDFFormatOptions getPDFOptions(DisplayModel displayModel, boolean bl, String string) {
        PDFFormatOptions pDFFormatOptions = null;
        if (bl) {
            if (_childrenMapRptInfo.containsKey(string)) {
                ReportInfo reportInfo = _childrenMapRptInfo.get(string);
                if (reportInfo.getPDFOptions() == null) {
                    if (displayModel != null) {
                        pDFFormatOptions = displayModel.getPDFFormatOptions();
                    }
                    if (pDFFormatOptions == null) {
                        pDFFormatOptions = new PDFConfig().getPDFPreferences();
                    }
                    reportInfo.setPDFOptions(pDFFormatOptions);
                }
                pDFFormatOptions = reportInfo.getPDFOptions();
            }
        } else {
            if (_masterReportInfo.getPDFOptions() == null) {
                if (displayModel != null) {
                    pDFFormatOptions = displayModel.getPDFFormatOptions();
                }
                if (pDFFormatOptions == null) {
                    pDFFormatOptions = new PDFConfig().getPDFPreferences();
                }
                _masterReportInfo.setPDFOptions(pDFFormatOptions);
            }
            pDFFormatOptions = _masterReportInfo.getPDFOptions();
        }
        return pDFFormatOptions;
    }

    private void displayReportOptions(String string, JPanel jPanel) {
        if (jPanel == null) {
            System.out.println("displayReportOptions, title: <" + string + "> Report Panel is null.");
        }
        this._reportOptions.setTitle(string);
        this._reportOptions.setPanel(jPanel);
        this._reportOptions.revalidate();
        this._reportOptions.repaint();
    }

    public static ArrayList<String> getChildNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TreeNode treeNode = null;
        for (int i = 0; i < _childNode.getChildCount(); ++i) {
            treeNode = _childNode.getChildAt(i);
            arrayList.add(treeNode.toString());
        }
        return arrayList;
    }

    public static JTree getReportTree() {
        return _reportTree;
    }

    public static void addChildToReport(String string, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new ReportNodeInfo(string, "ChildReport"));
        ReportUtils.createChildNodes(defaultMutableTreeNode);
        ((DefaultTreeModel)ReportTreePanel.getReportTree().getModel()).insertNodeInto(defaultMutableTreeNode, _childNode, _childNode.getChildCount());
        _childrenMapRptInfo.put(string, new ReportInfo(string));
        ReportTreePanel.getReportTree().scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
        if (bl) {
            ReportChildPanel.addChildReportName(string);
        }
        ReportInfo reportInfo = _childrenMapRptInfo.get(string);
        JPanel jPanel = new ReportNamePanel();
        jPanel.setInfo(string, "", "");
        reportInfo.addObject("ChildReport", jPanel);
        jPanel = new ReportSQLPanel(true);
        reportInfo.addObject("Sql", jPanel);
    }

    public static void removeChildFromReport(String string, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        boolean bl2 = false;
        for (int i = 0; i < _childNode.getChildCount(); ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)_childNode.getChildAt(i);
            ReportNodeInfo reportNodeInfo = (ReportNodeInfo)defaultMutableTreeNode.getUserObject();
            if (!string.equals(reportNodeInfo.getName())) continue;
            ((DefaultTreeModel)ReportTreePanel.getReportTree().getModel()).removeNodeFromParent(defaultMutableTreeNode);
            bl2 = true;
            break;
        }
        if (bl2) {
            _childrenMapRptInfo.remove(string);
            ReportTreePanel.getReportTree().scrollPathToVisible(new TreePath(_childNode));
            if (bl) {
                ReportChildPanel.removeChildReportName(string);
            }
        }
    }

    public static String getMasterReportName() {
        ReportNamePanel reportNamePanel = (ReportNamePanel)_masterReportInfo.getObject("MasterReport");
        if (reportNamePanel != null) {
            return reportNamePanel.getName();
        }
        return null;
    }

    public static String getMasterReportStyle() {
        return ReportTreePanel.getMasterReportStyle(false);
    }

    public static String getMasterReportStyle(boolean bl) {
        ReportSQLPanel reportSQLPanel = (ReportSQLPanel)_masterReportInfo.getObject("Sql");
        if (reportSQLPanel != null) {
            if (bl) {
                return reportSQLPanel.getNLSStyle();
            }
            return reportSQLPanel.getStyle();
        }
        return null;
    }

    public static String getMasterReportSQL() {
        ReportSQLPanel reportSQLPanel = (ReportSQLPanel)_masterReportInfo.getObject("Sql");
        if (reportSQLPanel != null) {
            return reportSQLPanel.getSql();
        }
        return null;
    }

    public String getSQL() {
        return ReportTreePanel.getMasterReportSQL();
    }

    public void deallocate() {
        _reportTree = null;
        _masterReportInfo = null;
        _childrenMapRptInfo = null;
        _childNode = null;
    }
}

