/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.display.DisplayConstants;
import oracle.dbtools.raptor.controls.display.DisplayRegistry;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.report.ui.ReportConstants;
import oracle.dbtools.raptor.report.ui.ReportTreePanel;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;

public class ReportSQLPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JComboBox _style;
    private String _name;
    private BasicEditorPane _sql;
    private JButton _btnAddChild;
    private JButton _btnRemoveChild;
    private JButton _btnOpenFile;
    private JButton _btnClearAll;
    private JButton _btnLargeEditor;
    private JButton _btnTestReport;
    private Toolbar _toolbar;
    private BasicEditorPane _noneditableSQL;
    private JLabel nonEditSQLNameLabel;
    private JLabel nonEditSQLStyleLabel;
    private JTextArea _status;
    private JPanel _addChildPanel;
    private JTextField _childName;
    private JEWTDialog _childDlg;
    private boolean _isChild = false;
    private String _errMessage;
    private JEWTDialog _dlg;
    private BasicEditorPane _largeEditorPane;
    private Toolbar _toolbar2;
    private JButton _btnAddChild2;
    private JButton _btnOpenFile2;
    private JButton _btnClearAll2;
    private JButton _btnTestReport2;
    private static URL _lastUrl;

    public ReportSQLPanel() {
        this._isChild = false;
        this.init();
    }

    public ReportSQLPanel(boolean bl) {
        this._isChild = bl;
        this.init();
        if (!this._isChild) {
            this.checkStatus();
        }
    }

    private void init() {
        Object object2;
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._style, (String)ReportArb.getString("STYLE"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._sql, (String)ReportArb.getString("SQL"));
        this._btnTestReport2 = new JButton();
        this._btnOpenFile = new JButton();
        this._btnOpenFile.addActionListener(this);
        this._btnOpenFile.setIcon(OracleIcons.getIcon((String)"open.png"));
        this._btnOpenFile.setToolTipText(ReportArb.getString("OPEN_FILE"));
        this._btnClearAll = new JButton();
        this._btnClearAll.addActionListener(this);
        this._btnClearAll.setIcon(OracleIcons.getIcon((String)"clear.png"));
        this._btnClearAll.setToolTipText(ReportArb.getString("CLEAR_ALL"));
        this._btnLargeEditor = new JButton();
        this._btnLargeEditor.addActionListener(this);
        this._btnLargeEditor.setIcon(OracleIcons.getIcon((String)"zoom_to_selection.png"));
        this._btnLargeEditor.setToolTipText(ReportArb.getString("LARGER_VIEW"));
        this._btnTestReport = new JButton();
        this._btnTestReport.setIcon(ReportArb.getIcon("TEST_REPORT_ICON"));
        this._btnTestReport.setToolTipText(ReportArb.getString("TEST_REPORT"));
        if (!this.isChild()) {
            this._btnAddChild = new JButton();
            this._btnAddChild.addActionListener(this);
            this._btnAddChild.setIcon(ReportArb.getIcon("ADD_CHILD_ICON"));
            this._btnAddChild.setToolTipText(ReportArb.getString("ADD_CHILD"));
        } else {
            this._btnRemoveChild = new JButton();
            this._btnRemoveChild.addActionListener(this);
            this._btnRemoveChild.setIcon(OracleIcons.getIcon((String)"remove_file.png"));
            this._btnRemoveChild.setToolTipText(ReportArb.getString("REMOVE_CHILD"));
            ResourceUtils.resButton((AbstractButton)this._btnRemoveChild, (String)ReportArb.getString("REMOVE_CHILD"));
        }
        int n = 0;
        this._style = new JComboBox();
        ArrayList arrayList = DisplayRegistry.getNLSStyles();
        for (Object object2 : arrayList) {
            this._style.addItem(object2);
        }
        this._style.setSelectedItem(DisplayConstants.REPORT_STYLES.TABLE.getNLSName());
        this._style.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    if (!ReportSQLPanel.this.isChild()) {
                        ReportSQLPanel.this._btnAddChild.setEnabled(DisplayRegistry.allowChildren((String)ReportSQLPanel.this.getStyle()));
                        ReportSQLPanel.this.checkStatus();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._style, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 0, 0, 0), 0, 0));
        this._toolbar = new Toolbar();
        this._toolbar.setFloatable(false);
        this._toolbar.add((Component)this._btnOpenFile);
        this._toolbar.addSeparator();
        this._toolbar.add((Component)this._btnClearAll);
        this._toolbar.addSeparator();
        this._toolbar.add((Component)this._btnLargeEditor);
        if (!this.isChild()) {
            this._toolbar.addSeparator();
            this._toolbar.add((Component)this._btnAddChild);
            this._toolbar.addSeparator();
            this._toolbar.add((Component)this._btnTestReport);
        }
        object2 = new JPanel(new GridBagLayout());
        ((JComponent)object2).setBorder(BorderFactory.createEtchedBorder());
        ((Container)object2).add((Component)this._toolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        ((Container)object2).add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)object2, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 23, 2, new Insets(10, 0, 0, 8), 0, 0));
        this._sql = EditorFactory.createIdeEditorPane();
        this._sql.setDocument((Document)new BasicDocument("foo.plsql"));
        this._sql.setText("");
        this._sql.setEditable(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this._sql, 22, 32);
        jScrollPane.setPreferredSize(this._sql.getPreferredSize());
        jScrollPane.setSize(jScrollPane.getPreferredSize());
        this.add((Component)jScrollPane, new GridBagConstraints(0, ++n, 1, 4, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 8), 0, 150));
        if (this.isChild()) {
            this._noneditableSQL = EditorFactory.createIdeEditorPane();
            this.nonEditSQLNameLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)this.nonEditSQLNameLabel, (Component)this._noneditableSQL, (String)ReportArb.format("MASTER_REPORT_NAME", ReportTreePanel.getMasterReportName()));
            this.nonEditSQLStyleLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)this.nonEditSQLStyleLabel, (Component)this._noneditableSQL, (String)ReportArb.format("MASTER_STYLE", ReportTreePanel.getMasterReportStyle(true)));
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.add((Component)this.nonEditSQLNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
            jPanel2.add((Component)this.nonEditSQLStyleLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 24, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._noneditableSQL.setDocument((Document)new BasicDocument("foo.plsql"));
            JScrollPane jScrollPane2 = new JScrollPane((Component)this._noneditableSQL, 22, 32);
            jScrollPane2.setPreferredSize(this._noneditableSQL.getPreferredSize());
            jScrollPane2.setSize(jScrollPane2.getPreferredSize());
            jPanel2.add((Component)jScrollPane2, new GridBagConstraints(0, 1, 2, 3, 1.0, 1.0, 23, 1, new Insets(6, 0, 0, 0), 0, 50));
            n += 3;
            this.add((Component)jPanel2, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 23, 1, new Insets(10, 0, 0, 8), 0, 0));
            this._noneditableSQL.setText(ReportTreePanel.getMasterReportSQL());
            this._noneditableSQL.setEditable(false);
        } else {
            JLabel jLabel3 = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._status, (String)ReportArb.getString("STATUS"));
            this._status = new JTextArea();
            this._status.setEditable(false);
            this._status.setRows(4);
            JScrollPane jScrollPane3 = new JScrollPane(this._status, 22, 32);
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            jPanel3.add((Component)jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
            jPanel3.add((Component)jScrollPane3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(6, 0, 0, 0), 0, 0));
            this.add((Component)jPanel3, new GridBagConstraints(0, ++n + 3, 1, 1, 1.0, 1.0, 23, 2, new Insets(10, 0, 0, 8), 0, 0));
        }
    }

    private boolean displayAddChildDialog() {
        this._childDlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this.getAddChildPanel(), (Component)this._childName, (String)ReportArb.getString("ADD_CHILD"), (int)3);
        this._childDlg.setModal(true);
        this._childDlg.pack();
        this._childDlg.setMinimumSize(new Dimension(300, 200));
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._childDlg);
        boolean bl = this._childDlg.runDialog();
        if (bl) {
            if (this._childName.getText() != null) {
                this._childName.setText(this._childName.getText().trim());
            }
            if (!this.isValidReportName(this._childName.getText())) {
                this._childName.requestFocusInWindow();
                MessageDialog.error((Component)this._childDlg, (Object)this.getErrorMessage(), (String)ReportArb.getString("ADD_CHILD"), (String)"f1_dbPDFSecurityparam_html");
                return false;
            }
            ReportTreePanel.addChildToReport(this._childName.getText(), true);
        }
        return bl;
    }

    private JPanel getAddChildPanel() {
        if (this._addChildPanel != null) {
            this._childName.setText("");
            return this._addChildPanel;
        }
        this._addChildPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._childName, (String)ReportArb.getString("CHILD_NAME"));
        this._childName = new JTextField();
        this._addChildPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 6), 0, 0));
        this._addChildPanel.add((Component)this._childName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        return this._addChildPanel;
    }

    private boolean isValidReportName(String string) {
        this._errMessage = null;
        if (string == null || string.isEmpty()) {
            this._errMessage = ReportArb.getString("CHILD_RPT_NAME_MISSING");
        } else {
            ArrayList<String> arrayList = ReportTreePanel.getChildNames();
            for (String string2 : arrayList) {
                if (!string.equalsIgnoreCase(string2)) continue;
                this._errMessage = ReportArb.getString("CHILD_RPT_NAME_EXISTS");
                break;
            }
        }
        return this._errMessage == null;
    }

    private String getErrorMessage() {
        return this._errMessage;
    }

    private boolean displayLargerEditor(String string) {
        String string2 = this._sql.getText();
        JPanel jPanel = this.getLargeEditorPanel(string, string2);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_editheaderfooter_html");
        this._dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, (Component)this._largeEditorPane, (String)string, (int)7);
        this._dlg.setModal(true);
        this._dlg.pack();
        this._dlg.setMinimumSize(new Dimension(650, 390));
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._dlg);
        boolean bl = this._dlg.runDialog();
        if (bl) {
            this._sql.setText(this._largeEditorPane.getText());
        }
        return bl;
    }

    private JPanel getLargeEditorPanel(String string, String string2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        this._btnOpenFile2 = new JButton();
        this._btnOpenFile2.addActionListener(this);
        this._btnOpenFile2.setIcon(OracleIcons.getIcon((String)"open.png"));
        this._btnOpenFile2.setToolTipText(ReportArb.getString("OPEN_FILE"));
        this._btnClearAll2 = new JButton();
        this._btnClearAll2.addActionListener(this);
        this._btnClearAll2.setIcon(OracleIcons.getIcon((String)"clear.png"));
        this._btnClearAll2.setToolTipText(ReportArb.getString("CLEAR_ALL"));
        if (this._btnTestReport2 == null) {
            this._btnTestReport2 = new JButton();
        }
        this._btnTestReport2.setIcon(ReportArb.getIcon("TEST_REPORT_ICON"));
        this._btnTestReport2.setToolTipText(ReportArb.getString("TEST_REPORT"));
        if (!this.isChild()) {
            this._btnAddChild2 = new JButton();
            this._btnAddChild2.addActionListener(this);
            this._btnAddChild2.setIcon(ReportArb.getIcon("ADD_CHILD_ICON"));
            this._btnAddChild2.setToolTipText(ReportArb.getString("ADD_CHILD"));
        }
        this._toolbar2 = new Toolbar();
        this._toolbar2.setFloatable(false);
        this._toolbar2.add((Component)this._btnOpenFile2);
        this._toolbar2.addSeparator();
        this._toolbar2.add((Component)this._btnClearAll2);
        if (!this.isChild()) {
            this._toolbar2.addSeparator();
            this._toolbar2.add((Component)this._btnAddChild2);
            this._toolbar2.addSeparator();
            this._toolbar2.add((Component)this._btnTestReport2);
        }
        jPanel.add((Component)this._toolbar2, "First");
        this._largeEditorPane = EditorFactory.createIdeEditorPane();
        this._largeEditorPane.setDocument((Document)new BasicDocument("foo.plsql"));
        this._largeEditorPane.setText(string2);
        this._largeEditorPane.setEditable(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this._largeEditorPane, 22, 32);
        jScrollPane.setPreferredSize(this._largeEditorPane.getPreferredSize());
        jScrollPane.setSize(jScrollPane.getPreferredSize());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void checkStatus() {
        StringBuffer stringBuffer = null;
        try {
            ArrayList<String> arrayList = null;
            if (DisplayRegistry.allowChildren((String)this.getStyle()).booleanValue()) {
                if (this._status != null && !this._status.getText().isEmpty()) {
                    this._status.setText("");
                }
            } else {
                arrayList = ReportTreePanel.getChildNames();
                if (!arrayList.isEmpty()) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(ReportArb.format("STYLE_CHILD_UNVIEWABLE", this.getStyle()));
                    stringBuffer.append("\n");
                    for (String string : arrayList) {
                        stringBuffer.append(string).append("\n");
                    }
                    if (this._status != null) {
                        this._status.setText(stringBuffer.toString());
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setInfo(String string, String string2, String string3) {
        this._name = string;
        String string4 = string2 == null || string2.isEmpty() ? "" : string2;
        this._sql.setText(string4);
        if (string3 == null || string3.isEmpty()) {
            this._style.setSelectedItem(DisplayConstants.REPORT_STYLES.TABLE.getNLSName());
        } else {
            String string5 = DisplayRegistry.getNLSStyle((String)string3);
            this._style.setSelectedItem(string5);
        }
    }

    public String getReportName() {
        return this._name;
    }

    public String getSql() {
        String string = this._sql.getText().trim();
        if ((string.toLowerCase().indexOf("select") == 0 || string.toLowerCase().indexOf("with") == 0) && string.indexOf(";") == string.length() - 1) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getSqlFromLargeEditor() {
        String string = this._largeEditorPane.getText().trim();
        if ((string.toLowerCase().indexOf("select") == 0 || string.toLowerCase().indexOf("with") == 0) && string.indexOf(";") == string.length() - 1) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getStyle() {
        int n = this._style.getSelectedIndex();
        return DisplayRegistry.getStyleType((int)n);
    }

    public String getNLSStyle() {
        return (String)this._style.getSelectedItem();
    }

    public JButton getTestReportButton() {
        return this._btnTestReport;
    }

    public JButton getLargeEditorTestReportButton() {
        return this._btnTestReport2;
    }

    public void setChild(boolean bl) {
        this._isChild = bl;
    }

    public boolean isChild() {
        return this._isChild;
    }

    public void updateMasterInfo() {
        if (this.isChild()) {
            ResourceUtils.resLabel((JLabel)this.nonEditSQLNameLabel, (Component)this._noneditableSQL, (String)ReportArb.format("MASTER_REPORT_NAME", ReportTreePanel.getMasterReportName()));
            ResourceUtils.resLabel((JLabel)this.nonEditSQLStyleLabel, (Component)this._noneditableSQL, (String)ReportArb.format("MASTER_STYLE", ReportTreePanel.getMasterReportStyle(true)));
            this._noneditableSQL.setEditable(true);
            this._noneditableSQL.setText(ReportTreePanel.getMasterReportSQL());
            this._noneditableSQL.setEditable(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._btnLargeEditor) {
            this.displayLargerEditor(ReportConstants.ROOT_CHILD_NODES.SQL_NODE.getName());
        } else if (actionEvent.getSource() == this._btnAddChild || actionEvent.getSource() == this._btnAddChild2) {
            this.displayAddChildDialog();
        } else if (actionEvent.getSource() == this._btnOpenFile) {
            this.getFileName(this._sql);
        } else if (actionEvent.getSource() == this._btnOpenFile2) {
            this.getFileName(this._largeEditorPane);
        } else if (actionEvent.getSource() == this._btnClearAll) {
            this._sql.setText("");
        } else if (actionEvent.getSource() == this._btnClearAll2) {
            this._largeEditorPane.setText("");
        } else if (actionEvent.getSource() == this._btnRemoveChild) {
            ReportTreePanel.removeChildFromReport(this._name, true);
        }
    }

    private void getFileName(BasicEditorPane basicEditorPane) {
        Object object;
        Object object2;
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setDefaultTitle(ReportArb.getString("CHOOSE_FILE"));
        uRLFileChooser.clearChooseableURLFilters();
        DefaultURLFilter defaultURLFilter = new DefaultURLFilter(ReportArb.getString("FILE_FILTER_ALL"), "");
        uRLFileChooser.setURLFilter((URLFilter)defaultURLFilter);
        uRLFileChooser.setURLFilter((URLFilter)new DefaultURLFilter(ReportArb.getString("FILE_FILTER_TEXT_NAME"), ReportArb.getString("FILE_FILTER_TEXT_EXT")));
        uRLFileChooser.setURLFilter((URLFilter)new DefaultURLFilter(ReportArb.getString("FILE_FILTER_SQL_NAME"), ReportArb.getString("FILE_FILTER_SQL_EXT")));
        if (_lastUrl == null) {
            try {
                object2 = System.getProperty("user.home");
                object = new File((String)object2);
                uRLFileChooser.setSelectedURL(((File)object).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            uRLFileChooser.setSelectedURL(_lastUrl);
        }
        if (uRLFileChooser.showOpenDialog((Component)this) == 0 && ((File)(object2 = new File((_lastUrl = uRLFileChooser.getSelectedURL()).getFile()))).isFile()) {
            try {
                object = new FileInputStream((File)object2);
                int n = ((FileInputStream)object).available();
                byte[] byArray = new byte[n];
                ((FileInputStream)object).read(byArray);
                String string = new String(byArray);
                basicEditorPane.setText(string);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }
}

