/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.report.navigatorV2.Folder;
import oracle.dbtools.raptor.report.navigatorV2.FolderNode;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class ReportFolderDialog
implements ActionListener {
    private FolderNode _parentNode;
    private FolderNode _childNode;
    private String _existName;
    private JEWTDialog _folderDialog;
    private StringBuffer _errMsg = new StringBuffer();
    private JTextField _name;
    private JTextArea _desc;
    private JTextField _toolTip;

    public ReportFolderDialog(FolderNode folderNode, FolderNode folderNode2, String string) {
        this._parentNode = folderNode;
        this._childNode = folderNode2;
        this._existName = string;
        this.init();
    }

    private void init() {
        String string = this._childNode == null ? ReportArb.getString("CREATE_FOLDER_TITLE") : ReportArb.getString("EDIT_FOLDER_TITLE");
        JPanel jPanel = this.getFolderPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_userdefinedreport_html");
        this._folderDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
        this._folderDialog.setMinimumSize(jPanel.getPreferredSize());
        this._folderDialog.addActionListener((ActionListener)this);
        Dimension dimension = this._folderDialog.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 100;
        this._folderDialog.setSize(n2, n);
        this._folderDialog.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._folderDialog);
    }

    private JPanel getFolderPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._name, (String)ReportArb.getString("NAME"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._desc, (String)ReportArb.getString("DESCRIPTION"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._toolTip, (String)ReportArb.getString("TOOLTIP"));
        int n = 0;
        this._name = new JTextField();
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 6), 0, 0));
        jPanel.add((Component)this._name, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 23, 2, new Insets(10, 0, 0, 10), 0, 0));
        this._desc = new JTextArea();
        this._desc.setRows(3);
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 6), 0, 0));
        jPanel.add((Component)this._desc, new GridBagConstraints(1, n, 2, 1, 0.5, 0.5, 23, 1, new Insets(10, 0, 0, 10), 0, 0));
        this._toolTip = new JTextField();
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 10, 6), 0, 0));
        jPanel.add((Component)this._toolTip, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 23, 2, new Insets(10, 0, 10, 10), 0, 0));
        if (this._childNode != null) {
            this._name.setText(this._childNode.getFolder().getName());
            this._desc.setText(this._childNode.getFolder().getDescription());
            this._toolTip.setText(this._childNode.getToolTipText());
        }
        return jPanel;
    }

    public boolean runDialog() {
        return this._folderDialog.runDialog();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        if (this._name != null && !this._name.getText().isEmpty()) {
            this._name.setText(this._name.getText().trim());
        }
        if (bl = this.validateFolderInfo(this._name.getText())) {
            this.saveFolderInformation();
        } else {
            this.showError();
        }
    }

    private boolean validateFolderInfo(String string) {
        this._errMsg = new StringBuffer();
        if (string == null || string.isEmpty()) {
            this._errMsg.append(ReportArb.getString("FOLDER_NAME_MISSING")).append("\n");
        } else {
            Iterator iterator = this._parentNode.getChildren();
            while (iterator.hasNext()) {
                DefaultContainer defaultContainer = (DefaultContainer)iterator.next();
                if (this._existName.equalsIgnoreCase(defaultContainer.getShortLabel()) || !defaultContainer.getShortLabel().equalsIgnoreCase(string)) continue;
                this._errMsg.append(ReportArb.getString("FOLDER_NAME_EXISTS")).append("\n");
                break;
            }
        }
        return this._errMsg.length() <= 0;
    }

    private void saveFolderInformation() {
        try {
            Folder folder = new Folder(this._name.getText(), this._desc.getText());
            folder.settooltip(this._toolTip.getText());
            if (this._childNode == null) {
                FolderNode folderNode = new FolderNode(new URL(this._parentNode.getURL() + "/" + this._name.getText()), folder);
                this._parentNode.add((Element)folderNode);
                UpdateMessage.fireChildAdded((Subject)this._parentNode, (Element)folderNode);
            } else {
                this._childNode.setURL(new URL(this._parentNode.getURL() + "/" + this._name.getText()));
                this._childNode.setFolder(folder);
                UpdateMessage.fireStructureChanged((Subject)this._childNode);
                UpdateMessage.fireObjectRenamed((Subject)this._childNode);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        this._folderDialog.dispose();
    }

    private void showError() {
        MessageDialog.error((Component)this._folderDialog, (Object)this._errMsg.toString(), (String)"FOLDER_ERROR", null);
    }
}

