/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.controls.display.DisplayRegistry;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.report.navigatorV2.ReportNode;
import oracle.dbtools.raptor.report.ui.AdvancedPanel;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.report.ui.ReportNewPanel;
import oracle.dbtools.raptor.report.ui.ReportTreePanel;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.GuidGen;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class ReportDialog
implements ActionListener {
    private DefaultContainer _parentNode;
    private DefaultContainer _childNode;
    private String _existRptName;
    private String _sql;
    private JEWTDialog _rptDialog;
    private JPanel _panel = null;
    private StringBuffer _errMsg = new StringBuffer();

    public ReportDialog(DefaultContainer defaultContainer, DefaultContainer defaultContainer2, String string, String string2) {
        this._parentNode = defaultContainer;
        this._childNode = defaultContainer2;
        this._sql = string;
        this._existRptName = string2;
        this.init();
    }

    private void init() {
        String string = null;
        if (this._childNode == null) {
            string = ReportArb.getString("CREATE_REPORT_TITLE");
            this._panel = this.getNewReportPanel();
        } else {
            string = ReportArb.getString("EDIT_REPORT_TITLE");
            this._panel = this.getEditReportPanel();
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._panel, "f1_userdefinedreport_html");
        this._rptDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this._panel, null, (String)string, (int)14);
        this._rptDialog.setMinimumSize(this._panel.getPreferredSize());
        this._rptDialog.addActionListener((ActionListener)this);
        Dimension dimension = this._rptDialog.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 100;
        this._rptDialog.setSize(n2, n);
        this._rptDialog.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._rptDialog);
    }

    private JPanel getNewReportPanel() {
        ReportNewPanel reportNewPanel = new ReportNewPanel();
        reportNewPanel.getCreateReportPanel().setInfo("", this._sql, "");
        if (this._parentNode != null) {
            reportNewPanel.setPath(this._parentNode.getURL().getPath());
        }
        return reportNewPanel;
    }

    private JPanel getEditReportPanel() {
        ReportTreePanel reportTreePanel = new ReportTreePanel(((ReportNode)this._childNode).getReport());
        reportTreePanel.setPath(this._childNode.getURL().getPath());
        return reportTreePanel;
    }

    private boolean validateReportInfo(String string, String string2, AdvancedPanel advancedPanel, String string3) {
        Object object;
        this._errMsg = new StringBuffer();
        if (string == null || string.isEmpty()) {
            this._errMsg.append(ReportArb.getString("MASTER_RPT_NAME_MISSING")).append("\n\n");
        } else {
            object = this._parentNode.getChildren();
            while (object.hasNext()) {
                DefaultContainer defaultContainer = (DefaultContainer)object.next();
                if (this._existRptName.equalsIgnoreCase(defaultContainer.getShortLabel()) || !defaultContainer.getShortLabel().equalsIgnoreCase(string)) continue;
                this._errMsg.append(ReportArb.getString("MASTER_RPT_NAME_EXISTS")).append("\n\n");
                break;
            }
        }
        if (string2 == null || string2.isEmpty()) {
            this._errMsg.append(ReportArb.getString("MASTER_RPT_SQL_MISSING")).append("\n\n");
        }
        if (advancedPanel != null && advancedPanel.getActions() != null) {
            object = advancedPanel.getActions();
            boolean bl = false;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ObjectAction objectAction = (ObjectAction)iterator.next();
                if (objectAction.getTitle() == null || objectAction.getTitle().isEmpty()) {
                    this._errMsg.append(ReportArb.getString("DRILL_DOWN_NAME_MISSING")).append("\n\n");
                    bl = true;
                }
                if (objectAction.getClassArgs() == null || objectAction.getClassArgs().isEmpty()) {
                    this._errMsg.append(ReportArb.getString("DRILL_DOWN_REPORT_MISSING")).append("\n\n");
                    bl = true;
                }
                if (!bl) continue;
                break;
            }
        }
        if (string3 != null && !string3.isEmpty()) {
            this._errMsg.append(string3);
        }
        return this._errMsg.length() <= 0;
    }

    private void saveReportInformation(DisplayModel displayModel) {
        Object object;
        if (displayModel.getID() == null) {
            displayModel.setID(GuidGen.toString((byte[])GuidGen.uuidCreate()));
        }
        if (displayModel.getExtValues() == null) {
            object = null;
            try {
                object = DisplayRegistry.getDetailPanel((String)displayModel.getStyle());
            }
            catch (Exception exception) {
                // empty catch block
            }
            displayModel.setExtValues(object.getValues());
        }
        DisplayModelCache.putDisplayModel((DisplayModel)displayModel);
        try {
            if (this._childNode == null) {
                object = new ReportNode(new URL(this._parentNode.getURL() + "/" + displayModel.getName()), displayModel);
                ((ReportNode)object).setEditable(true);
                this._parentNode.add((Element)object);
                UpdateMessage.fireChildAdded((Subject)this._parentNode, (Element)object);
            } else {
                this._childNode.setURL(new URL(this._parentNode.getURL() + "/" + displayModel.getName()));
                ((ReportNode)this._childNode).setReport(displayModel);
                UpdateMessage.fireStructureChanged((Subject)this._childNode);
                UpdateMessage.fireObjectRenamed((Subject)this._childNode);
            }
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
        }
        this._rptDialog.dispose();
        this.cleanUp();
    }

    private void showError() {
        MessageDialog.error((Component)this._rptDialog, (Object)this._errMsg.toString(), (String)ReportArb.getString("REPORT_ERROR_TITLE"), null);
    }

    private void cleanUp() {
        if (this._panel != null && this._panel instanceof ReportTreePanel) {
            ((ReportTreePanel)this._panel).deallocate();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        if (this._panel instanceof ReportTreePanel) {
            if (((ReportTreePanel)this._panel).getAdvPanel() != null && ((ReportTreePanel)this._panel).getAdvPanel().getTable().getCellEditor() != null) {
                ((ReportTreePanel)this._panel).getAdvPanel().getTable().getCellEditor().stopCellEditing();
            }
            if (bl = this.validateReportInfo(ReportTreePanel.getMasterReportName(), ((ReportTreePanel)this._panel).getSQL(), ((ReportTreePanel)this._panel).getAdvPanel(), ((ReportTreePanel)this._panel).validateSecurityPasswords())) {
                this.saveReportInformation(((ReportTreePanel)this._panel).getModel());
            } else {
                this.showError();
            }
        } else {
            bl = this.validateReportInfo(((ReportNewPanel)this._panel).getMasterReportName(), ((ReportNewPanel)this._panel).getSQL(), null, null);
            if (bl) {
                this.saveReportInformation(((ReportNewPanel)this._panel).getModel());
            } else {
                this.showError();
            }
        }
    }

    public boolean runDialog() {
        return this._rptDialog.runDialog();
    }

    public DisplayModel getModel() {
        if (this._panel instanceof ReportTreePanel) {
            return ((ReportTreePanel)this._panel).getModel();
        }
        if (this._panel instanceof ReportNewPanel) {
            return ((ReportNewPanel)this._panel).getModel();
        }
        return null;
    }
}

