/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.pdf;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.export.pdf.PDFConfig;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.format.ReportAsianFonts;
import oracle.dbtools.raptor.format.ReportFormatOptions;
import oracle.dbtools.raptor.report.pdf.IPDFOptions;
import oracle.dbtools.raptor.report.pdf.PDFArb;
import oracle.dbtools.raptor.report.pdf.PDFConstants;
import oracle.dbtools.raptor.report.pdf.PDFFontPanel;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.util.ResourceUtils;

public class PDFTableLayoutPanel
implements IPDFOptions {
    private static final long serialVersionUID = 1L;
    private PDFFormatOptions _pdfFormat = null;
    private PDFFontPanel _fontPanel = null;
    private JCheckBox _showAllBorders = null;
    private JCheckBox _useRowShading = null;
    private JComboBox _horizontalAlignment = null;
    private JComboBox _spacingBeforeTable = null;
    private JComboBox _spacingAfterTable = null;
    private CustomColorChoice _borderColorChoice = null;
    private CustomColorChoice _oddRowColorChoice = null;
    private CustomColorChoice _evenRowColorChoice = null;
    private int _row = 0;

    public PDFTableLayoutPanel() {
        this.init();
    }

    private void init() {
        this._showAllBorders = new JCheckBox();
        this._useRowShading = new JCheckBox();
        this._horizontalAlignment = new JComboBox<String>(PDFConstants.HORIZONTAL_ALIGNMENT_LIST);
        this._spacingBeforeTable = new JComboBox<Integer>(this.getTableSpacingPointSizeList());
        this._spacingAfterTable = new JComboBox<Integer>(this.getTableSpacingPointSizeList());
        this._borderColorChoice = new CustomColorChoice();
        this._oddRowColorChoice = new CustomColorChoice();
        this._evenRowColorChoice = new CustomColorChoice();
    }

    @Override
    public JPanel getPanel() {
        if (this._pdfFormat == null) {
            this.assignPDFFormatValues(new PDFConfig().getPDFPreferences());
        }
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._useRowShading, (String)PDFArb.getString("USE_ROW_SHADING"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._oddRowColorChoice, (String)PDFArb.getString("ODD_ROW_SHADING"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._evenRowColorChoice, (String)PDFArb.getString("EVEN_ROW_SHADING"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this._showAllBorders, (String)PDFArb.getString("SHOW_BORDERS"));
        ResourceUtils.resLabel((JLabel)jLabel5, (Component)this._borderColorChoice, (String)PDFArb.getString("BORDER_COLOR"));
        ResourceUtils.resLabel((JLabel)jLabel6, (Component)this._horizontalAlignment, (String)PDFArb.getString("HORIZONTAL_ALIGNMENT"));
        ResourceUtils.resLabel((JLabel)jLabel7, (Component)this._spacingBeforeTable, (String)PDFArb.getString("SPACING_BEFORE"));
        ResourceUtils.resLabel((JLabel)jLabel8, (Component)this._spacingAfterTable, (String)PDFArb.getString("SPACING_AFTER"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._row = 0;
        JPanel jPanel2 = this._fontPanel.getPanel();
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.5, 21, 2, new Insets(6, 6, 0, 8), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel, (String)PDFArb.getString("FONT_TITLE"));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this._row = 0;
        jPanel3.add((Component)this._useRowShading, new GridBagConstraints(0, this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel3.add((Component)jLabel3, new GridBagConstraints(1, this._row, 2, 1, 0.0, 0.0, 21, 0, new Insets(6, 0, 0, 0), 0, 0));
        jPanel3.add((Component)jLabel, new GridBagConstraints(1, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 0, 0, 8), 0, 0));
        jPanel3.add((Component)this._oddRowColorChoice, new GridBagConstraints(2, this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 0, 6), 0, 0));
        jPanel3.add((Component)jLabel2, new GridBagConstraints(1, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 0, 0, 8), 0, 0));
        jPanel3.add((Component)this._evenRowColorChoice, new GridBagConstraints(2, this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 0, 6), 0, 0));
        jPanel3.add((Component)this._showAllBorders, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(16, 6, 0, 8), 0, 0));
        jPanel3.add((Component)jLabel4, new GridBagConstraints(1, this._row, 2, 1, 0.0, 0.0, 21, 0, new Insets(16, 0, 0, 6), 0, 0));
        jPanel3.add((Component)jLabel5, new GridBagConstraints(1, ++this._row, 2, 1, 0.0, 0.0, 21, 0, new Insets(6, 0, 6, 8), 0, 0));
        jPanel3.add((Component)this._borderColorChoice, new GridBagConstraints(2, this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 6, 6), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel3, (String)PDFArb.getString("SHADING_TITLE"));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        this._row = 0;
        jPanel4.add((Component)jLabel7, new GridBagConstraints(0, this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel4.add((Component)this._spacingBeforeTable, new GridBagConstraints(1, this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 0, 0), 0, 0));
        jPanel4.add((Component)jLabel8, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel4.add((Component)this._spacingAfterTable, new GridBagConstraints(1, this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 0, 0), 0, 0));
        jPanel4.add((Component)jLabel6, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(20, 6, 6, 6), 0, 0));
        jPanel4.add((Component)this._horizontalAlignment, new GridBagConstraints(1, this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(20, 0, 6, 6), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel4, (String)PDFArb.getString("SPACING_TITLE"));
        this._row = 0;
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.add((Component)jPanel, new GridBagConstraints(0, this._row, 3, 1, 0.0, 0.0, 23, 0, new Insets(10, 0, 6, 0), 0, 0));
        jPanel5.add(Box.createGlue(), new GridBagConstraints(0, ++this._row, 0, 0, 0.5, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add((Component)jPanel3, new GridBagConstraints(0, ++this._row, 1, 6, 0.0, 0.0, 23, 0, new Insets(10, 0, 0, 8), 0, 0));
        jPanel5.add((Component)jPanel4, new GridBagConstraints(1, this._row, 1, 6, 0.0, 0.0, 23, 0, new Insets(10, 0, 0, 0), 0, 0));
        jPanel5.add(Box.createHorizontalGlue(), new GridBagConstraints(2, this._row, 0, 0, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._useRowShading.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PDFTableLayoutPanel.this._oddRowColorChoice.setEnabled(PDFTableLayoutPanel.this._useRowShading.isSelected());
                PDFTableLayoutPanel.this._evenRowColorChoice.setEnabled(PDFTableLayoutPanel.this._useRowShading.isSelected());
            }
        });
        this._showAllBorders.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PDFTableLayoutPanel.this._borderColorChoice.setEnabled(PDFTableLayoutPanel.this._showAllBorders.isSelected());
            }
        });
        return jPanel5;
    }

    @Override
    public void assignPDFFormatValues(PDFFormatOptions pDFFormatOptions) {
        this._pdfFormat = pDFFormatOptions;
        this._fontPanel = new PDFFontPanel(this._pdfFormat.getFontName(), this._pdfFormat.getFontStyle(), this._pdfFormat.getFontSize(), this._pdfFormat.getFontColor(), this._pdfFormat.getFontLocations(), ReportAsianFonts.isVendorAsianJar((String)this._pdfFormat.getExternalLibrary()));
        this._useRowShading.setSelected(this._pdfFormat.isUseRowShading());
        this._showAllBorders.setSelected(this._pdfFormat.isShowAllBorders());
        Color color = new Color(this._pdfFormat.getOddRowShading());
        this._oddRowColorChoice.setSelectedColor(color);
        color = new Color(this._pdfFormat.getEvenRowShading());
        this._evenRowColorChoice.setSelectedColor(color);
        color = new Color(this._pdfFormat.getBorderColor());
        this._borderColorChoice.setSelectedColor(color);
        this._spacingBeforeTable.setSelectedItem(new Integer(this._pdfFormat.getSpacingBeforeTable()));
        this._spacingAfterTable.setSelectedItem(new Integer(this._pdfFormat.getSpacingAfterTable()));
        this._horizontalAlignment.setSelectedIndex(this._pdfFormat.getTableHorizontalAlignment().ordinal());
        this._oddRowColorChoice.setEnabled(this._useRowShading.isSelected());
        this._evenRowColorChoice.setEnabled(this._useRowShading.isSelected());
        this._borderColorChoice.setEnabled(this._showAllBorders.isSelected());
    }

    @Override
    public PDFFormatOptions getPDFFormatOptions() {
        if (this._pdfFormat != null) {
            this._pdfFormat.setFontName(this._fontPanel.getFontName());
            this._pdfFormat.setFontStyle(this._fontPanel.getFontStyle());
            this._pdfFormat.setFontSize(this._fontPanel.getFontSize());
            this._pdfFormat.setFontColor(this._fontPanel.getFontColor());
            this._pdfFormat.setUseRowShading(this._useRowShading.isSelected());
            this._pdfFormat.setOddRowShading(this._oddRowColorChoice.getSelectedColor().getRGB());
            this._pdfFormat.setEvenRowShading(this._evenRowColorChoice.getSelectedColor().getRGB());
            this._pdfFormat.setShowAllBorders(this._showAllBorders.isSelected());
            this._pdfFormat.setBorderColor(this._borderColorChoice.getSelectedColor().getRGB());
            this._pdfFormat.setSpacingBeforeTable(((Integer)this._spacingBeforeTable.getSelectedItem()).intValue());
            this._pdfFormat.setSpacingAfterTable(((Integer)this._spacingAfterTable.getSelectedItem()).intValue());
            ReportFormatOptions.HORIZONTAL_ALIGNMENT[] hORIZONTAL_ALIGNMENTArray = ReportFormatOptions.HORIZONTAL_ALIGNMENT.values();
            this._pdfFormat.setTableHorizontalAlignment(hORIZONTAL_ALIGNMENTArray[this._horizontalAlignment.getSelectedIndex()]);
        }
        return this._pdfFormat;
    }

    public boolean updateFontList(boolean bl) {
        boolean bl2 = this._fontPanel.setFontList(this._pdfFormat.getFontName(), this._pdfFormat.getFontLocations(), bl);
        return bl2;
    }

    private Integer[] getTableSpacingPointSizeList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(1));
        for (Integer n : PDFConstants.POINT_SIZE_LIST) {
            arrayList.add(n);
        }
        Integer[] integerArray = new Integer[arrayList.size()];
        arrayList.toArray(integerArray);
        return integerArray;
    }
}

