/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.pdf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.export.pdf.PDFConfig;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.format.ReportFormatOptions;
import oracle.dbtools.raptor.report.pdf.IPDFOptions;
import oracle.dbtools.raptor.report.pdf.PDFArb;
import oracle.dbtools.raptor.report.pdf.PDFConstants;
import oracle.ide.util.ResourceUtils;

public class PDFPageSetupPanel
implements IPDFOptions {
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 20;
    private PDFFormatOptions _pdfFormat = null;
    private NumericSpinBox _marginTop = null;
    private NumericSpinBox _marginBottom = null;
    private NumericSpinBox _marginLeft = null;
    private NumericSpinBox _marginRight = null;
    private JRadioButton _portrait = null;
    private JRadioButton _landscape = null;
    private JComboBox _paperSize = null;
    private JPanel _panel = null;

    public PDFPageSetupPanel() {
        this.init();
    }

    private void init() {
        this._marginTop = new NumericSpinBox(0, 20);
        this._marginBottom = new NumericSpinBox(0, 20);
        this._marginLeft = new NumericSpinBox(0, 20);
        this._marginRight = new NumericSpinBox(0, 20);
        this._marginTop.setDecimal(true);
        this._marginBottom.setDecimal(true);
        this._marginLeft.setDecimal(true);
        this._marginRight.setDecimal(true);
        this._portrait = new JRadioButton();
        this._landscape = new JRadioButton();
        this._paperSize = new JComboBox<String>(PDFConstants.PAPER_SIZE_LIST);
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._marginTop, (String)PDFArb.getString("MARGIN_TOP"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._marginBottom, (String)PDFArb.getString("MARGIN_BOTTOM"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._marginLeft, (String)PDFArb.getString("MARGIN_LEFT"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this._marginRight, (String)PDFArb.getString("MARGIN_RIGHT"));
        ResourceUtils.resLabel((JLabel)jLabel5, (Component)this._paperSize, (String)PDFArb.getString("PAPER_SIZE"));
        ResourceUtils.resButton((AbstractButton)this._portrait, (String)PDFArb.getString("PORTRAIT"));
        ResourceUtils.resButton((AbstractButton)this._landscape, (String)PDFArb.getString("LANDSCAPE"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(10, 8, 0, 8), 0, 0));
        jPanel.add((Component)this._marginTop, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 0, 0, 20), 30, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(10, 10, 0, 8), 0, 0));
        jPanel.add((Component)this._marginBottom, new GridBagConstraints(3, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 0, 0, 8), 30, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 8, 8), 0, 0));
        jPanel.add((Component)this._marginLeft, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 0, 8, 20), 30, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 10, 8, 8), 0, 0));
        jPanel.add((Component)this._marginRight, new GridBagConstraints(3, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 0, 8, 8), 30, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel, (String)PDFArb.getString("MARGIN_TITLE"));
        jPanel.add(Box.createGlue(), new GridBagConstraints(4, n, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._portrait);
        buttonGroup.add(this._landscape);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        n = 0;
        jPanel2.add((Component)this._portrait, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 15, 0, 6), 60, 0));
        jPanel2.add((Component)this._landscape, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 15, 10, 8), 60, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel2, (String)PDFArb.getString("ORIENTATION_TITLE"));
        n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jLabel5, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(10, 8, 10, 6), 0, 0));
        jPanel3.add((Component)this._paperSize, new GridBagConstraints(1, n, 2, 1, 0.0, 0.0, 23, 0, new Insets(10, 0, 10, 8), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel3, (String)PDFArb.getString("PAPER_SIZE_TITLE"));
        n = 0;
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 0.5, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)jPanel2, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 23, 0, new Insets(15, 0, 0, 6), 0, 0));
        jPanel4.add((Component)jPanel3, new GridBagConstraints(1, n, 2, 1, 0.0, 0.0, 23, 0, new Insets(15, 6, 0, 6), 0, 0));
        jPanel4.add(Box.createGlue(), new GridBagConstraints(2, n, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        n = 0;
        this._panel = new JPanel(new GridBagLayout());
        this._panel.add((Component)jPanel, new GridBagConstraints(0, n, 2, 2, 0.0, 0.0, 23, 0, new Insets(10, 0, 0, 0), 0, 0));
        this._panel.add(Box.createGlue(), new GridBagConstraints(0, ++n, 0, 0, 0.5, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._panel.add((Component)jPanel4, new GridBagConstraints(0, ++n, 2, 2, 0.0, 0.0, 23, 0, new Insets(10, 0, 0, 8), 0, 0));
    }

    @Override
    public JPanel getPanel() {
        if (this._pdfFormat == null) {
            this.assignPDFFormatValues(new PDFConfig().getPDFPreferences());
        }
        if (this._panel == null) {
            this.init();
        }
        return this._panel;
    }

    @Override
    public void assignPDFFormatValues(PDFFormatOptions pDFFormatOptions) {
        this._pdfFormat = pDFFormatOptions;
        this._marginTop.setValue((Number)Float.valueOf(this._pdfFormat.getTopMarginUI()));
        this._marginBottom.setValue((Number)Float.valueOf(this._pdfFormat.getBottomMarginUI()));
        this._marginLeft.setValue((Number)Float.valueOf(this._pdfFormat.getLeftMarginUI()));
        this._marginRight.setValue((Number)Float.valueOf(this._pdfFormat.getRightMarginUI()));
        int n = this._pdfFormat.getOrientation();
        switch (n) {
            case 0: {
                this._landscape.setSelected(true);
                break;
            }
            default: {
                this._portrait.setSelected(true);
            }
        }
        this._paperSize.setSelectedIndex(this._pdfFormat.getPaperSize().ordinal());
    }

    @Override
    public PDFFormatOptions getPDFFormatOptions() {
        if (this._pdfFormat != null) {
            this._pdfFormat.setTopMarginUI((float)this._marginTop.getIntValue());
            this._pdfFormat.setBottomMarginUI((float)this._marginBottom.getIntValue());
            this._pdfFormat.setLeftMarginUI((float)this._marginLeft.getIntValue());
            this._pdfFormat.setRightMarginUI((float)this._marginRight.getIntValue());
            int n = this._portrait.isSelected() ? 1 : (this._landscape.isSelected() ? 0 : 1);
            this._pdfFormat.setOrientation(n);
            ReportFormatOptions.PAPER_SIZE[] pAPER_SIZEArray = ReportFormatOptions.PAPER_SIZE.values();
            this._pdfFormat.setPaperSize(pAPER_SIZEArray[this._paperSize.getSelectedIndex()]);
        }
        return this._pdfFormat;
    }
}

