/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.pdf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.rtf.RTFEditorKit;
import oracle.dbtools.raptor.export.pdf.PDFConfig;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.format.ReportPatternInfo;
import oracle.dbtools.raptor.report.pdf.IPDFOptions;
import oracle.dbtools.raptor.report.pdf.PDFArb;
import oracle.dbtools.raptor.report.pdf.PDFEditDialog;
import oracle.ide.util.ResourceUtils;

public class PDFHeaderFooterPanel
implements IPDFOptions,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String RTF_PAR_KEYWORD = "\\par";
    private PDFFormatOptions _pdfFormat = null;
    private JButton _editHeaderBtn = null;
    private JButton _editFooterBtn = null;
    private JCheckBox _insertHeader = null;
    private JCheckBox _insertFooter = null;
    private JTextPane _headerTextPane = null;
    private JTextPane _footerTextPane = null;
    private JScrollPane _headerScrollPane = null;
    private JScrollPane _footerScrollPane = null;
    private int _row = 0;
    private RTFEditorKit _headerRTFKit;
    private RTFEditorKit _footerRTFKit;
    private ArrayList<ReportPatternInfo> _headerPatternList = null;
    private ArrayList<ReportPatternInfo> _footerPatternList = null;
    private ArrayList<ReportPatternInfo> _tmpPatternList = null;
    private String _headerRTFData = null;
    private String _footerRTFData = null;
    private boolean _autoUpdateDate = false;

    public PDFHeaderFooterPanel() {
        this.init();
    }

    private void init() {
        this._insertHeader = new JCheckBox();
        this._insertFooter = new JCheckBox();
        this._editHeaderBtn = new JButton();
        this._editFooterBtn = new JButton();
        this._headerTextPane = new JTextPane();
        this._headerTextPane.setEditable(false);
        this._footerTextPane = new JTextPane();
        this._footerTextPane.setEditable(false);
        this._editHeaderBtn.addActionListener(this);
        this._editFooterBtn.addActionListener(this);
        this._insertHeader.addActionListener(this);
        this._insertFooter.addActionListener(this);
        this._headerRTFKit = new RTFEditorKit();
        this._headerTextPane.setEditorKit(this._headerRTFKit);
        this._footerRTFKit = new RTFEditorKit();
        this._footerTextPane.setEditorKit(this._footerRTFKit);
        this._headerRTFData = null;
        this._footerRTFData = null;
    }

    @Override
    public JPanel getPanel() {
        if (this._pdfFormat == null) {
            this.assignPDFFormatValues(new PDFConfig().getPDFPreferences());
        }
        ResourceUtils.resButton((AbstractButton)this._insertHeader, (String)PDFArb.getString("INCLUDE_HEADER"));
        ResourceUtils.resButton((AbstractButton)this._insertFooter, (String)PDFArb.getString("INCLUDE_FOOTER"));
        ResourceUtils.resButton((AbstractButton)this._editHeaderBtn, (String)PDFArb.getString("EDIT_BUTTON"));
        ResourceUtils.resButton((AbstractButton)this._editFooterBtn, (String)PDFArb.getString("EDIT_BUTTON"));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this._headerTextPane);
        this._headerScrollPane = new JScrollPane(jPanel);
        this.displayTextTopOfPane(this._headerScrollPane);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this._insertHeader, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 8, 0, 0), 0, 0));
        jPanel2.add((Component)this._editHeaderBtn, new GridBagConstraints(1, this._row, 1, 1, 0.0, 0.0, 24, 0, new Insets(8, 0, 0, 8), 0, 0));
        jPanel2.add((Component)this._headerScrollPane, new GridBagConstraints(0, ++this._row, 2, 3, 1.0, 1.0, 23, 1, new Insets(8, 8, 0, 8), 0, 0));
        this._row = 0;
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add(this._footerTextPane);
        this._footerScrollPane = new JScrollPane(jPanel3);
        this.displayTextTopOfPane(this._footerScrollPane);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)this._insertFooter, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 8, 0, 0), 0, 0));
        jPanel4.add((Component)this._editFooterBtn, new GridBagConstraints(1, this._row, 1, 1, 0.0, 0.0, 24, 0, new Insets(8, 0, 0, 8), 0, 0));
        jPanel4.add((Component)this._footerScrollPane, new GridBagConstraints(0, ++this._row, 2, 3, 1.0, 1.0, 23, 1, new Insets(8, 8, 0, 8), 0, 0));
        this._row = 0;
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.add((Component)jPanel2, new GridBagConstraints(0, this._row, 5, 6, 1.0, 1.0, 23, 1, new Insets(10, 0, 0, 0), 0, 0));
        jPanel5.add(Box.createGlue(), new GridBagConstraints(0, ++this._row, 2, 1, 0.5, 0.5, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        jPanel5.add((Component)jPanel4, new GridBagConstraints(0, ++this._row, 5, 6, 1.0, 1.0, 25, 1, new Insets(30, 0, 0, 0), 0, 0));
        return jPanel5;
    }

    @Override
    public void assignPDFFormatValues(PDFFormatOptions pDFFormatOptions) {
        this._pdfFormat = pDFFormatOptions;
        try {
            this._insertHeader.setSelected(this._pdfFormat.isInsertHeader());
            this._insertFooter.setSelected(this._pdfFormat.isInsertFooter());
            this._headerTextPane.setEnabled(this._insertHeader.isSelected());
            this._footerTextPane.setEnabled(this._insertFooter.isSelected());
            this._tmpPatternList = this._pdfFormat.getHeaderPatternList();
            this._headerPatternList = new ArrayList();
            if (this._tmpPatternList != null && !this._tmpPatternList.isEmpty()) {
                this._headerPatternList.addAll(this._tmpPatternList);
            }
            this.loadRTF(this._pdfFormat.getHeader(), this._headerTextPane, this._headerRTFKit);
            this._tmpPatternList = this._pdfFormat.getFooterPatternList();
            this._footerPatternList = new ArrayList();
            if (this._tmpPatternList != null && !this._tmpPatternList.isEmpty()) {
                this._footerPatternList.addAll(this._tmpPatternList);
            }
            this._tmpPatternList = null;
            this.loadRTF(this._pdfFormat.getFooter(), this._footerTextPane, this._footerRTFKit);
            this._autoUpdateDate = this._pdfFormat.isAutoUpdateDate();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    @Override
    public PDFFormatOptions getPDFFormatOptions() {
        if (this._pdfFormat != null) {
            try {
                if (this._headerRTFData != null) {
                    this._pdfFormat.setHeader(this._headerRTFData);
                    this._pdfFormat.setHeaderPatternList(this._headerPatternList);
                }
                if (this._footerRTFData != null) {
                    this._pdfFormat.setFooter(this._footerRTFData);
                    this._pdfFormat.setFooterPatternList(this._footerPatternList);
                }
                this._pdfFormat.setInsertHeader(this._insertHeader.isSelected());
                this._pdfFormat.setInsertFooter(this._insertFooter.isSelected());
                this._pdfFormat.setAutoUpdateDate(this._autoUpdateDate);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return this._pdfFormat;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._editHeaderBtn) {
            this._headerRTFData = this.processEditRequest(PDFArb.getString("EDIT_HEADER_TITLE"), this._headerTextPane, this._headerRTFKit, this._headerPatternList);
            if (this._headerRTFData != null) {
                this._headerPatternList = new ArrayList();
                if (this._tmpPatternList != null && !this._tmpPatternList.isEmpty()) {
                    this._headerPatternList.addAll(this._tmpPatternList);
                    this._tmpPatternList = null;
                }
                this.displayTextTopOfPane(this._headerScrollPane);
            }
        } else if (actionEvent.getSource() == this._editFooterBtn) {
            this._footerRTFData = this.processEditRequest(PDFArb.getString("EDIT_FOOTER_TITLE"), this._footerTextPane, this._footerRTFKit, this._footerPatternList);
            if (this._footerRTFData != null) {
                this._footerPatternList = new ArrayList();
                if (this._tmpPatternList != null && !this._tmpPatternList.isEmpty()) {
                    this._footerPatternList.addAll(this._tmpPatternList);
                    this._tmpPatternList = null;
                }
                this.displayTextTopOfPane(this._footerScrollPane);
            }
        } else if (actionEvent.getSource() == this._insertHeader) {
            this._headerTextPane.setEnabled(this._insertHeader.isSelected());
        } else if (actionEvent.getSource() == this._insertFooter) {
            this._footerTextPane.setEnabled(this._insertFooter.isSelected());
        }
    }

    private String processEditRequest(String string, JTextPane jTextPane, RTFEditorKit rTFEditorKit, ArrayList<ReportPatternInfo> arrayList) {
        String string2 = null;
        PDFEditDialog pDFEditDialog = new PDFEditDialog(string, jTextPane.getStyledDocument(), this._pdfFormat.getFontLocations());
        pDFEditDialog.setReportPatternList(arrayList);
        pDFEditDialog.setAutoUpdateDate(this._autoUpdateDate);
        if (pDFEditDialog.runDialog()) {
            int n = jTextPane.getDocument().getLength();
            if (n > 0) {
                string2 = this.writeRTF(jTextPane, rTFEditorKit, string);
                this._tmpPatternList = pDFEditDialog.getReportPatternList();
            } else {
                string2 = "";
                if (this._tmpPatternList != null && !this._tmpPatternList.isEmpty()) {
                    this._tmpPatternList.clear();
                }
            }
            this._autoUpdateDate = pDFEditDialog.isAutoUpdateDate();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeRTF(JTextPane jTextPane, RTFEditorKit rTFEditorKit, String string) {
        String string2 = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            rTFEditorKit.write(byteArrayOutputStream, jTextPane.getDocument(), 0, jTextPane.getDocument().getLength());
            if (byteArrayOutputStream != null) {
                String string3 = byteArrayOutputStream.toString();
                int n = string3.lastIndexOf(RTF_PAR_KEYWORD);
                int n2 = RTF_PAR_KEYWORD.length();
                if (n >= 0) {
                    string2 = string3.substring(0, n) + string3.substring(n + n2);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRTF(String string, JTextPane jTextPane, RTFEditorKit rTFEditorKit) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            if (string != null) {
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                rTFEditorKit.read(byteArrayInputStream, jTextPane.getDocument(), 0);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void displayTextTopOfPane(final JScrollPane jScrollPane) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jScrollPane.getVerticalScrollBar().setValue(0);
            }
        });
    }
}

