/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.pdf;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.format.ReportAsianFonts;
import oracle.dbtools.raptor.format.ReportFonts;
import oracle.dbtools.raptor.format.ReportFormatOptions;
import oracle.dbtools.raptor.report.pdf.PDFArb;
import oracle.dbtools.raptor.report.pdf.PDFConstants;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.util.ResourceUtils;

public class PDFFontPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox _font = null;
    private JComboBox _style = null;
    private JComboBox _size = null;
    private CustomColorChoice _fontColorChoice = null;
    private int _row = 0;
    private int _col = 0;
    private boolean _isAsianVendorFonts = false;
    private boolean _init = true;

    public PDFFontPanel(String string, ReportFormatOptions.FONT_STYLE fONT_STYLE, int n, int n2, String string2, boolean bl) {
        this.assignValues(string, fONT_STYLE, n, n2, string2, bl);
        this._init = false;
    }

    public JPanel getPanel() {
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._font, (String)PDFArb.getString("FONT"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._size, (String)PDFArb.getString("SIZE"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._style, (String)PDFArb.getString("STYLE"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this._fontColorChoice, (String)PDFArb.getString("COLOR"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._row = 0;
        this._col = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(this._col, this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 6, 8), 0, 0));
        jPanel.add((Component)this._font, new GridBagConstraints(++this._col, this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 6, 16), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(++this._col, this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 6, 8), 0, 0));
        jPanel.add((Component)this._size, new GridBagConstraints(++this._col, this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 6, 0), 0, 0));
        this._col = 0;
        jPanel.add((Component)jLabel2, new GridBagConstraints(this._col, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 0, 6, 8), 0, 0));
        jPanel.add((Component)this._style, new GridBagConstraints(++this._col, this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 6, 16), 0, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(++this._col, this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 0, 6, 8), 0, 0));
        jPanel.add((Component)this._fontColorChoice, new GridBagConstraints(++this._col, this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 6, 0), 0, 0));
        this._row = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, this._row, 3, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel2;
    }

    public void assignValues(String string, ReportFormatOptions.FONT_STYLE fONT_STYLE, int n, int n2, String string2, boolean bl) {
        this._style = new JComboBox<String>(PDFConstants.FONT_STYLE_LIST);
        this._size = new JComboBox<Integer>(PDFConstants.POINT_SIZE_LIST);
        this._fontColorChoice = new CustomColorChoice();
        this.setFontList(string, string2, bl);
        this._style.setSelectedIndex(fONT_STYLE.ordinal());
        this._size.setSelectedItem(new Integer(n));
        Color color = new Color(n2);
        this._fontColorChoice.setSelectedColor(color);
    }

    public String getFontName() {
        String string = (String)this._font.getSelectedItem();
        if (this._isAsianVendorFonts) {
            string = ReportAsianFonts.getAsianFont((String)string);
        }
        return string;
    }

    public ReportFormatOptions.FONT_STYLE getFontStyle() {
        ReportFormatOptions.FONT_STYLE[] fONT_STYLEArray = ReportFormatOptions.FONT_STYLE.values();
        return fONT_STYLEArray[this._style.getSelectedIndex()];
    }

    public int getFontSize() {
        return (Integer)this._size.getSelectedItem();
    }

    public int getFontColor() {
        return this._fontColorChoice.getSelectedColor().getRGB();
    }

    public void setFontEnabled(boolean bl) {
        this._font.setEnabled(bl);
        this._style.setEnabled(bl);
        this._size.setEnabled(bl);
        this._fontColorChoice.setEnabled(bl);
    }

    public boolean setFontList(String string, String string2, boolean bl) {
        boolean bl2 = false;
        if (this._init || bl != this._isAsianVendorFonts) {
            String[] stringArray = null;
            String string3 = null;
            if (bl) {
                this._isAsianVendorFonts = true;
                stringArray = ReportAsianFonts.getVendorAsianFonts();
                this._font = new JComboBox<String>(stringArray);
                string3 = ReportAsianFonts.getAsianFontNLS((String)string);
                if (string3 == null) {
                    string3 = (String)this._font.getItemAt(0);
                }
            } else {
                this._isAsianVendorFonts = false;
                stringArray = ReportFonts.getAllFonts((String)string2);
                this._font = new JComboBox<String>(stringArray);
                string3 = string;
                if (string3 == null && (string3 = ReportFonts.getDefaultFontName((String)string2)) == null) {
                    string3 = (String)this._font.getItemAt(0);
                }
            }
            try {
                this._font.setSelectedItem(string3);
            }
            catch (Exception exception) {
                this._font.setSelectedIndex(0);
            }
            bl2 = true;
        }
        return bl2;
    }
}

