/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.pdf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.export.pdf.PDFConfig;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.format.ReportFormatOptions;
import oracle.dbtools.raptor.report.pdf.IPDFOptions;
import oracle.dbtools.raptor.report.pdf.PDFArb;
import oracle.ide.util.ResourceUtils;

public class PDFCellLayoutPanel
implements IPDFOptions {
    private static final long serialVersionUID = 1L;
    private static final int MIN_PADDING = 1;
    private static final int MAX_PADDING = 32;
    private PDFFormatOptions _pdfFormat = null;
    private NumericSpinBox _cellPadTop = null;
    private NumericSpinBox _cellPadBottom = null;
    private NumericSpinBox _cellPadLeft = null;
    private NumericSpinBox _cellPadRight = null;
    private JCheckBox _wrapText = null;
    private JRadioButton _topVerticalAlign = null;
    private JRadioButton _middleVerticalAlign = null;
    private JRadioButton _bottomVerticalAlign = null;
    private JRadioButton _leftHorizontalAlign = null;
    private JRadioButton _centerHorizontalAlign = null;
    private JRadioButton _rightHorizontalAlign = null;
    private int _row = 0;

    public PDFCellLayoutPanel() {
        this.init();
    }

    private void init() {
        this._cellPadTop = new NumericSpinBox(1, 32);
        this._cellPadBottom = new NumericSpinBox(1, 32);
        this._cellPadLeft = new NumericSpinBox(1, 32);
        this._cellPadRight = new NumericSpinBox(1, 32);
        this._topVerticalAlign = new JRadioButton();
        this._middleVerticalAlign = new JRadioButton();
        this._bottomVerticalAlign = new JRadioButton();
        this._leftHorizontalAlign = new JRadioButton();
        this._centerHorizontalAlign = new JRadioButton();
        this._rightHorizontalAlign = new JRadioButton();
        this._wrapText = new JCheckBox();
    }

    @Override
    public JPanel getPanel() {
        if (this._pdfFormat == null) {
            this.assignPDFFormatValues(new PDFConfig().getPDFPreferences());
        }
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._cellPadTop, (String)PDFArb.getString("PAD_TOP"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._cellPadBottom, (String)PDFArb.getString("PAD_BOTTOM"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._cellPadLeft, (String)PDFArb.getString("PAD_LEFT"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this._cellPadRight, (String)PDFArb.getString("PAD_RIGHT"));
        ResourceUtils.resButton((AbstractButton)this._leftHorizontalAlign, (String)PDFArb.getString("LEFT"));
        ResourceUtils.resButton((AbstractButton)this._centerHorizontalAlign, (String)PDFArb.getString("CENTER"));
        ResourceUtils.resButton((AbstractButton)this._rightHorizontalAlign, (String)PDFArb.getString("RIGHT"));
        ResourceUtils.resButton((AbstractButton)this._topVerticalAlign, (String)PDFArb.getString("TOP"));
        ResourceUtils.resButton((AbstractButton)this._middleVerticalAlign, (String)PDFArb.getString("MIDDLE"));
        ResourceUtils.resButton((AbstractButton)this._bottomVerticalAlign, (String)PDFArb.getString("BOTTOM"));
        ResourceUtils.resButton((AbstractButton)this._wrapText, (String)PDFArb.getString("WRAP_TEXT"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._row = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(10, 8, 0, 8), 0, 0));
        jPanel.add((Component)this._cellPadTop, new GridBagConstraints(1, this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 0, 0, 20), 30, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(10, 10, 0, 8), 0, 0));
        jPanel.add((Component)this._cellPadBottom, new GridBagConstraints(3, this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 0, 0, 8), 30, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, ++this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 8, 8), 0, 0));
        jPanel.add((Component)this._cellPadLeft, new GridBagConstraints(1, this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 0, 8, 20), 30, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(2, this._row, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 10, 8, 8), 0, 0));
        jPanel.add((Component)this._cellPadRight, new GridBagConstraints(3, this._row, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 0, 8, 8), 30, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel, (String)PDFArb.getString("CELL_PADDING_TITLE"));
        jPanel.add(Box.createGlue(), new GridBagConstraints(4, this._row, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._topVerticalAlign);
        buttonGroup.add(this._middleVerticalAlign);
        buttonGroup.add(this._bottomVerticalAlign);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this._leftHorizontalAlign);
        buttonGroup2.add(this._centerHorizontalAlign);
        buttonGroup2.add(this._rightHorizontalAlign);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this._row = 0;
        jPanel2.add((Component)this._leftHorizontalAlign, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 15, 0, 6), 60, 0));
        jPanel2.add((Component)this._centerHorizontalAlign, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 15, 0, 6), 60, 0));
        jPanel2.add((Component)this._rightHorizontalAlign, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 15, 8, 6), 60, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel2, (String)PDFArb.getString("HORIZONTAL_ALIGN_TITLE"));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this._row = 0;
        jPanel3.add((Component)this._topVerticalAlign, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 15, 0, 6), 60, 0));
        jPanel3.add((Component)this._middleVerticalAlign, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 15, 0, 6), 60, 0));
        jPanel3.add((Component)this._bottomVerticalAlign, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 15, 8, 6), 60, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel3, (String)PDFArb.getString("VERTICAL_ALIGN_TITLE"));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        this._row = 0;
        jPanel4.add(Box.createGlue(), new GridBagConstraints(0, ++this._row, 1, 1, 0.5, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)jPanel2, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(15, 0, 0, 6), 0, 0));
        jPanel4.add((Component)jPanel3, new GridBagConstraints(1, this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(15, 6, 0, 6), 0, 0));
        jPanel4.add(Box.createGlue(), new GridBagConstraints(2, this._row, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this._wrapText, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(15, 6, 0, 6), 0, 0));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        this._row = 0;
        jPanel5.add((Component)jPanel, new GridBagConstraints(0, this._row, 2, 2, 0.0, 0.0, 23, 0, new Insets(10, 0, 0, 0), 0, 0));
        jPanel5.add(Box.createGlue(), new GridBagConstraints(0, ++this._row, 0, 0, 0.5, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add((Component)jPanel4, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(10, 0, 0, 0), 0, 0));
        jPanel5.add(Box.createGlue(), new GridBagConstraints(0, ++this._row, 2, 3, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel5;
    }

    @Override
    public void assignPDFFormatValues(PDFFormatOptions pDFFormatOptions) {
        this._pdfFormat = pDFFormatOptions;
        this._cellPadTop.setIntValue(this._pdfFormat.getCellPaddingTop());
        this._cellPadBottom.setIntValue(this._pdfFormat.getCellPaddingBottom());
        this._cellPadLeft.setIntValue(this._pdfFormat.getCellPaddingLeft());
        this._cellPadRight.setIntValue(this._pdfFormat.getCellPaddingRight());
        ReportFormatOptions.HORIZONTAL_ALIGNMENT hORIZONTAL_ALIGNMENT = this._pdfFormat.getCellHorizontalAlignment();
        switch (hORIZONTAL_ALIGNMENT) {
            case CENTER: {
                this._centerHorizontalAlign.setSelected(true);
                break;
            }
            case RIGHT: {
                this._rightHorizontalAlign.setSelected(true);
                break;
            }
            default: {
                this._leftHorizontalAlign.setSelected(true);
            }
        }
        ReportFormatOptions.VERTICAL_ALIGNMENT vERTICAL_ALIGNMENT = this._pdfFormat.getCellVerticalAlignment();
        switch (vERTICAL_ALIGNMENT) {
            case TOP: {
                this._topVerticalAlign.setSelected(true);
                break;
            }
            case BOTTOM: {
                this._bottomVerticalAlign.setSelected(true);
                break;
            }
            default: {
                this._middleVerticalAlign.setSelected(true);
            }
        }
        this._wrapText.setSelected(this._pdfFormat.isWrapText());
    }

    @Override
    public PDFFormatOptions getPDFFormatOptions() {
        if (this._pdfFormat != null) {
            this._pdfFormat.setCellPaddingTop(this._cellPadTop.getIntValue());
            this._pdfFormat.setCellPaddingBottom(this._cellPadBottom.getIntValue());
            this._pdfFormat.setCellPaddingLeft(this._cellPadLeft.getIntValue());
            this._pdfFormat.setCellPaddingRight(this._cellPadRight.getIntValue());
            ReportFormatOptions.HORIZONTAL_ALIGNMENT hORIZONTAL_ALIGNMENT = null;
            hORIZONTAL_ALIGNMENT = this._centerHorizontalAlign.isSelected() ? ReportFormatOptions.HORIZONTAL_ALIGNMENT.CENTER : (this._rightHorizontalAlign.isSelected() ? ReportFormatOptions.HORIZONTAL_ALIGNMENT.RIGHT : ReportFormatOptions.HORIZONTAL_ALIGNMENT.LEFT);
            this._pdfFormat.setCellHorizontalAlignment(hORIZONTAL_ALIGNMENT);
            ReportFormatOptions.VERTICAL_ALIGNMENT vERTICAL_ALIGNMENT = null;
            vERTICAL_ALIGNMENT = this._topVerticalAlign.isSelected() ? ReportFormatOptions.VERTICAL_ALIGNMENT.TOP : (this._bottomVerticalAlign.isSelected() ? ReportFormatOptions.VERTICAL_ALIGNMENT.BOTTOM : ReportFormatOptions.VERTICAL_ALIGNMENT.MIDDLE);
            this._pdfFormat.setCellVerticalAlignment(vERTICAL_ALIGNMENT);
            this._pdfFormat.setWrapText(this._wrapText.isSelected());
        }
        return this._pdfFormat;
    }
}

