/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.pdf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.export.pdf.PDFConfig;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.report.pdf.IPDFOptions;
import oracle.dbtools.raptor.report.pdf.PDFArb;
import oracle.ide.util.ResourceUtils;

public class PDFBlobPanel
implements IPDFOptions,
ItemListener {
    private static final long serialVersionUID = 1L;
    private PDFFormatOptions _pdfFormat = null;
    private JRadioButton _embedBLOB = null;
    private JRadioButton _linkBLOB = null;
    private JRadioButton _excludeBLOB = null;
    private JCheckBox _createZipFile = null;
    private int _row = 0;

    public PDFBlobPanel() {
        this.init();
    }

    private void init() {
        this._embedBLOB = new JRadioButton();
        this._linkBLOB = new JRadioButton();
        this._excludeBLOB = new JRadioButton();
        this._createZipFile = new JCheckBox();
        this._linkBLOB.addItemListener(this);
    }

    @Override
    public JPanel getPanel() {
        if (this._pdfFormat == null) {
            this.assignPDFFormatValues(new PDFConfig().getPDFPreferences());
        }
        ResourceUtils.resButton((AbstractButton)this._embedBLOB, (String)PDFArb.getString("EMBED_BLOB"));
        ResourceUtils.resButton((AbstractButton)this._linkBLOB, (String)PDFArb.getString("LINK_BLOB"));
        ResourceUtils.resButton((AbstractButton)this._excludeBLOB, (String)PDFArb.getString("EXCLUDE_BLOB"));
        ResourceUtils.resButton((AbstractButton)this._createZipFile, (String)PDFArb.getString("CREATE_ZIP_ONLY"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._embedBLOB);
        buttonGroup.add(this._linkBLOB);
        buttonGroup.add(this._excludeBLOB);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._row = 0;
        JTextPane jTextPane = new JTextPane();
        jTextPane.setPreferredSize(new Dimension(400, 50));
        jPanel.add((Component)jTextPane, new GridBagConstraints(0, this._row, 1, 1, 1.0, 1.0, 23, 2, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)this._embedBLOB, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(2, 6, 0, 6), 0, 0));
        jPanel.add((Component)this._excludeBLOB, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(4, 6, 6, 6), 0, 0));
        jPanel.add((Component)this._linkBLOB, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(4, 6, 0, 6), 0, 0));
        jPanel.add((Component)this._createZipFile, new GridBagConstraints(0, ++this._row, 2, 1, 0.0, 0.0, 23, 0, new Insets(6, 25, 0, 6), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel, (String)PDFArb.getString("BLOB_TITLE"));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this._row = 0;
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, this._row, 1, 1, 0.0, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        String string = PDFArb.getString("BLOB_INSTRUCTIONS");
        jTextPane.setText(string);
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        jPanel2.add(Box.createGlue(), new GridBagConstraints(0, ++this._row, 2, 3, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel2;
    }

    @Override
    public void assignPDFFormatValues(PDFFormatOptions pDFFormatOptions) {
        this._pdfFormat = pDFFormatOptions;
        PDFFormatOptions.BLOB_ACTION bLOB_ACTION = this._pdfFormat.getBlobAction();
        switch (bLOB_ACTION) {
            case EMBED: {
                this._embedBLOB.setSelected(true);
                break;
            }
            case LINK: {
                this._linkBLOB.setSelected(true);
                break;
            }
            default: {
                this._excludeBLOB.setSelected(true);
            }
        }
        this._createZipFile.setSelected(this._pdfFormat.isCreateZipFile());
        if (this._linkBLOB.isSelected()) {
            this._createZipFile.setEnabled(true);
        } else {
            this._createZipFile.setEnabled(false);
        }
    }

    @Override
    public PDFFormatOptions getPDFFormatOptions() {
        if (this._pdfFormat != null) {
            PDFFormatOptions.BLOB_ACTION bLOB_ACTION = null;
            bLOB_ACTION = this._embedBLOB.isSelected() ? PDFFormatOptions.BLOB_ACTION.EMBED : (this._linkBLOB.isSelected() ? PDFFormatOptions.BLOB_ACTION.LINK : PDFFormatOptions.BLOB_ACTION.NONE);
            this._pdfFormat.setCreateZipFile(this._createZipFile.isSelected());
            this._pdfFormat.setBlobAction(bLOB_ACTION);
        }
        return this._pdfFormat;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this._linkBLOB) {
            if (this._linkBLOB.isSelected()) {
                this._createZipFile.setEnabled(true);
            } else {
                this._createZipFile.setEnabled(false);
            }
        }
    }
}

