/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.navigatorV2;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import oracle.dbtools.raptor.report.Messages;
import oracle.dbtools.raptor.report.addin.ReportAddin;
import oracle.dbtools.raptor.report.navigatorV2.ReportNavigatorContextMenu;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.util.PropertyAccess;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public class ReportNavigatorWindow
extends DefaultNavigatorWindow {
    private Component m_gui;

    ReportNavigatorWindow(Context context, String string) {
        super(context, string);
    }

    public Controller getController() {
        return new ReportNavigatorContextMenu();
    }

    private void init() {
        if (this.m_gui == null) {
            this.setToolbarVisible(false);
            this.m_gui = super.getGUI();
            ReportNavigatorContextMenu.getInstance().attachMouseListener(super.getTree());
            this.getTreeExplorer().getJTree().addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                    TNode tNode = (TNode)ReportNavigatorWindow.this.getTreeExplorer().getJTree().getModel().getRoot();
                    if (tNode == treeExpansionEvent.getPath().getLastPathComponent()) {
                        throw new ExpandVetoException(treeExpansionEvent);
                    }
                }

                @Override
                public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                }
            });
        }
    }

    public Component getGUI() {
        if (this.m_gui == null) {
            this.init();
        }
        return this.m_gui;
    }

    public String getTitleName() {
        return Messages.getString("ReportNavigatorWindow.0");
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public Icon getTabIcon() {
        return ReportAddin.navIcon;
    }

    public void loadLayout(PropertyAccess propertyAccess) {
        super.loadLayout(propertyAccess);
        final TreeExplorer treeExplorer = this.getTreeExplorer();
        if (treeExplorer != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TNode tNode = treeExplorer.getRoot();
                    treeExplorer.expand(tNode, false, false);
                }
            });
        }
    }

    public void saveLayout(PropertyAccess propertyAccess) {
        super.saveLayout(propertyAccess);
        propertyAccess.setProperty("ReportsDummy", "true");
    }
}

