/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.controls.TreeAutoExpander;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.model.Attributes;
import oracle.ideimpl.explorer.CustomTreeCellRenderer;
import oracle.ideimpl.explorer.CustomTreeSelectionModel;
import oracle.javatools.ui.ExpansionTreeTip;
import oracle.javatools.ui.themes.Themes;

public class CustomTree
extends JTree
implements Autoscroll {
    private KeyListener _preKeyListener;
    private KeyListener _postKeyListener;
    private MouseListener _preMouseListener;
    private CustomTreeCellRenderer _cellRenderer = new CustomTreeCellRenderer();
    private ExpansionTreeTip _expansionTip;
    private static final Insets DEFAULT_SCROLL_INSETS = new Insets(5, 5, 5, 5);
    private Insets m_autoscrollInsets = DEFAULT_SCROLL_INSETS;

    public CustomTree() {
        this((TreeModel)null);
    }

    public CustomTree(TreeModel model) {
        super(model);
        if (Themes.isThemed()) {
            this.setOpaque(false);
        }
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(this._cellRenderer);
        this.setSelectionModel(new CustomTreeSelectionModel());
        TreeAutoExpander.install((JTree)this);
        KeyStroke[] keyStrokes = new KeyStroke[]{KeyStroke.getKeyStroke(65, 2)};
        KeyUtil.removeKeyStrokesFromInputMap((JComponent)this, (KeyStroke[])keyStrokes, (int)0);
        this._expansionTip = new ExpansionTreeTip((JTree)this);
    }

    public ExpansionTreeTip getExpansionTip() {
        return this._expansionTip;
    }

    public void setPostKeyListener(KeyListener l) {
        this._postKeyListener = l;
    }

    public void setPreKeyListener(KeyListener l) {
        this._preKeyListener = l;
    }

    public void setPreMouseListener(MouseListener l) {
        this._preMouseListener = l;
    }

    protected Attributes getCellRendererAttributes() {
        return this._cellRenderer.getAttributes();
    }

    protected void setCellRendererAttributes(Attributes attributes) {
        this._cellRenderer.setAttributes(attributes);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (this._preKeyListener != null) {
            switch (e.getID()) {
                case 401: {
                    this._preKeyListener.keyPressed(e);
                    break;
                }
                case 400: {
                    this._preKeyListener.keyTyped(e);
                    break;
                }
                case 402: {
                    this._preKeyListener.keyReleased(e);
                }
            }
        }
        if (e.isConsumed()) {
            return;
        }
        super.processKeyEvent(e);
        if (e.isConsumed()) {
            return;
        }
        if (this._postKeyListener != null) {
            switch (e.getID()) {
                case 401: {
                    this._postKeyListener.keyPressed(e);
                    break;
                }
                case 400: {
                    this._postKeyListener.keyTyped(e);
                    break;
                }
                case 402: {
                    this._postKeyListener.keyReleased(e);
                }
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this._preMouseListener == null) {
            return;
        }
        switch (e.getID()) {
            case 502: {
                if (e.getClickCount() != 2) break;
                this._preMouseListener.mouseReleased(e);
            }
        }
        if (e.isConsumed()) {
            return;
        }
        super.processMouseEvent(e);
        if (e.isConsumed()) {
            return;
        }
        switch (e.getID()) {
            case 501: {
                this._preMouseListener.mousePressed(e);
                break;
            }
            case 502: {
                if (e.getClickCount() == 2) break;
                this._preMouseListener.mouseReleased(e);
                break;
            }
            case 500: {
                this._preMouseListener.mouseClicked(e);
                break;
            }
            case 505: {
                this._preMouseListener.mouseExited(e);
                break;
            }
            case 504: {
                this._preMouseListener.mouseEntered(e);
            }
        }
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String result = super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        return result != null ? result : "";
    }

    @Override
    public TreeSelectionModel getSelectionModel() {
        return super.getSelectionModel();
    }

    @Override
    public void setSelectionModel(TreeSelectionModel selectionModel) {
        super.setSelectionModel(selectionModel);
    }

    public void setAutoscrollInsets(Insets insets) {
        if (insets == null) {
            throw new NullPointerException("trying set insets to null");
        }
        this.m_autoscrollInsets = insets;
    }

    @Override
    public Insets getInsets() {
        return this.m_autoscrollInsets;
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle r = this.getVisibleRect();
        Dimension size = this.getSize();
        Insets i = new Insets(r.y + this.m_autoscrollInsets.top, r.x + this.m_autoscrollInsets.left, size.height - r.y - r.height + this.m_autoscrollInsets.bottom, size.width - r.x - r.width + this.m_autoscrollInsets.right);
        return i;
    }

    @Override
    public void autoscroll(Point location) {
        JScrollPane scroller = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (scroller != null) {
            JScrollBar hBar = scroller.getHorizontalScrollBar();
            JScrollBar vBar = scroller.getVerticalScrollBar();
            Rectangle r = this.getVisibleRect();
            if (location.x <= r.x + this.m_autoscrollInsets.left) {
                hBar.setValue(hBar.getValue() - hBar.getUnitIncrement(-1));
            }
            if (location.y <= r.y + this.m_autoscrollInsets.top) {
                vBar.setValue(vBar.getValue() - vBar.getUnitIncrement(-1));
            }
            if (location.x >= r.x + r.width - this.m_autoscrollInsets.right) {
                hBar.setValue(hBar.getValue() + hBar.getUnitIncrement(1));
            }
            if (location.y >= r.y + r.height - this.m_autoscrollInsets.bottom) {
                vBar.setValue(vBar.getValue() + vBar.getUnitIncrement(1));
            }
        }
    }
}

