/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.preferences;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.DataMinerPreferenceSettings;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.preferences.PreferencesLrb;
import oracle.ide.config.Preferences;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public class ColumnFilterPreferencesPanel
extends DefaultTraversablePanel {
    private JCheckBox jAttrImportanceCheckBox;
    private JCheckBox jAutoFilterCheckBox;
    private JCheckBox jAutoRemoveCheckBox;
    private JCheckBox jConstantPercentCheckBox;
    private JSpinner jConstantPercentSpinner;
    private JCheckBox jDataQualityCheckBox;
    private JCheckBox jImportanceCheckBox;
    private JSpinner jImportanceSpinner;
    private JCheckBox jNullPercentCheckBox;
    private JSpinner jNullPercentSpinner;
    private JLabel jSampleSizeLabel;
    private JSpinner jSampleSizeSpinner;
    private JCheckBox jSamplingCheckBox;
    private JCheckBox jTopNCheckBox;
    private JSpinner jTopNSpinner;
    private JCheckBox jUniquePercentCheckBox;
    private JSpinner jUniquePercentSpinner;

    public ColumnFilterPreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initRes() {
        this.setHelpID("data_miner_prefs");
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(PreferencesLrb.get("COLUMN_FILTER_DATA_QUALITY"), this.jDataQualityCheckBox);
        hashMap.put(PreferencesLrb.get("COLUMN_FILTER_NULLS"), this.jNullPercentCheckBox);
        hashMap.put(PreferencesLrb.get("COLUMN_FILTER_UNIQUE"), this.jUniquePercentCheckBox);
        hashMap.put(PreferencesLrb.get("COLUMN_FILTER_CONSTANT"), this.jConstantPercentCheckBox);
        hashMap.put(PreferencesLrb.get("COLUMN_FILTER_ATTRIBUTE_IMPORTANCE"), this.jAttrImportanceCheckBox);
        hashMap.put(PreferencesLrb.get("COLUMN_FILTER_IMPORTANCE_CUTOFF"), this.jImportanceCheckBox);
        hashMap.put(PreferencesLrb.get("COLUMN_FILTER_TOPN"), this.jTopNCheckBox);
        hashMap.put(PreferencesLrb.get("COLUMN_FILTER_SAMPLING"), this.jSamplingCheckBox);
        hashMap.put(PreferencesLrb.get("COLUMN_FILTER_SAMPLE_SIZE"), this.jSampleSizeLabel);
        UIResourceHelper.setComponentText(hashMap);
    }

    public void initUI() {
        this.jAutoFilterCheckBox.setVisible(false);
        this.jAutoRemoveCheckBox.setVisible(false);
    }

    private void initComponents() {
        this.jDataQualityCheckBox = new JCheckBox();
        this.jNullPercentCheckBox = new JCheckBox();
        this.jNullPercentSpinner = new JSpinner();
        this.jUniquePercentCheckBox = new JCheckBox();
        this.jUniquePercentSpinner = new JSpinner();
        this.jConstantPercentCheckBox = new JCheckBox();
        this.jConstantPercentSpinner = new JSpinner();
        this.jAttrImportanceCheckBox = new JCheckBox();
        this.jImportanceCheckBox = new JCheckBox();
        this.jImportanceSpinner = new JSpinner();
        this.jTopNCheckBox = new JCheckBox();
        this.jTopNSpinner = new JSpinner();
        this.jSamplingCheckBox = new JCheckBox();
        this.jSampleSizeLabel = new JLabel();
        this.jSampleSizeSpinner = new JSpinner();
        this.jAutoFilterCheckBox = new JCheckBox();
        this.jAutoRemoveCheckBox = new JCheckBox();
        this.jDataQualityCheckBox.setText("Data Quality");
        this.jDataQualityCheckBox.setName("jDataQualityCheckBox");
        this.jDataQualityCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jDataQualityCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jNullPercentCheckBox.setText("% Nulls less than or equal");
        this.jNullPercentCheckBox.setName("jNullPercentCheckBox");
        this.jNullPercentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jNullPercentCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jNullPercentSpinner.setModel(new SpinnerNumberModel(95.0, 0.0, 100.0, 5.0));
        this.jNullPercentSpinner.setName("jNullPercentSpinner");
        this.jUniquePercentCheckBox.setText("% Unique less than or equal");
        this.jUniquePercentCheckBox.setName("jUniquePercentCheckBox");
        this.jUniquePercentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jUniquePercentCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jUniquePercentSpinner.setModel(new SpinnerNumberModel(95.0, 0.0, 100.0, 5.0));
        this.jUniquePercentSpinner.setName("jUniquePercentSpinner");
        this.jConstantPercentCheckBox.setText("% Constant less than or equal");
        this.jConstantPercentCheckBox.setName("jConstantPercentCheckBox");
        this.jConstantPercentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jConstantPercentCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jConstantPercentSpinner.setModel(new SpinnerNumberModel(95.0, 0.0, 100.0, 5.0));
        this.jConstantPercentSpinner.setName("jConstantPercentSpinner");
        this.jAttrImportanceCheckBox.setText("Attribute Importance");
        this.jAttrImportanceCheckBox.setName("jAttrImportanceCheckBox");
        this.jAttrImportanceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jAttrImportanceCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jImportanceCheckBox.setText("Importance Cutoff");
        this.jImportanceCheckBox.setName("jImportanceCheckBox");
        this.jImportanceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jImportanceCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jImportanceSpinner.setModel(new SpinnerNumberModel(0.1, 0.0, 1.0, 0.1));
        this.jImportanceSpinner.setName("jImportanceSpinner");
        this.jTopNCheckBox.setText("Top N");
        this.jTopNCheckBox.setName("jTopNCheckBox");
        this.jTopNCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jTopNCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jTopNSpinner.setModel(new SpinnerNumberModel((Number)10, Integer.valueOf(1), null, (Number)1));
        this.jTopNSpinner.setName("jTopNSpinner");
        this.jSamplingCheckBox.setText("Sampling");
        this.jSamplingCheckBox.setName("jSamplingCheckBox");
        this.jSampleSizeLabel.setText("Sample Size");
        this.jSampleSizeLabel.setName("jSampleSizeLabel");
        this.jSampleSizeSpinner.setModel(new SpinnerNumberModel((Number)2000, Integer.valueOf(1), null, (Number)1000));
        this.jSampleSizeSpinner.setName("jSampleSizeSpinner");
        this.jAutoFilterCheckBox.setText("Automatic Filterings");
        this.jAutoFilterCheckBox.setName("jAutoFilterCheckBox");
        this.jAutoFilterCheckBox.setOpaque(false);
        this.jAutoFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jAutoFilterCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jAutoRemoveCheckBox.setText("Remove Missing Input Automatically");
        this.jAutoRemoveCheckBox.setName("jAutoRemoveCheckBox");
        this.jAutoRemoveCheckBox.setOpaque(false);
        this.jAutoRemoveCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColumnFilterPreferencesPanel.this.jAutoRemoveCheckBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(23, 23, 23).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jUniquePercentCheckBox, GroupLayout.Alignment.LEADING, -1, 290, Short.MAX_VALUE).addComponent(this.jNullPercentCheckBox, GroupLayout.Alignment.LEADING, -1, 290, Short.MAX_VALUE).addComponent(this.jConstantPercentCheckBox, GroupLayout.Alignment.LEADING, -2, 270, -2)).addGap(6, 6, 6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jNullPercentSpinner, -1, 172, Short.MAX_VALUE).addComponent(this.jUniquePercentSpinner, -1, 172, Short.MAX_VALUE).addComponent(this.jConstantPercentSpinner, -1, 172, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jImportanceCheckBox, -2, 196, -2).addComponent(this.jTopNCheckBox).addComponent(this.jSampleSizeLabel, -2, 194, -2)).addGap(6, 6, 6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSampleSizeSpinner, -1, 172, Short.MAX_VALUE).addComponent(this.jTopNSpinner, -1, 172, Short.MAX_VALUE).addComponent(this.jImportanceSpinner, -1, 172, Short.MAX_VALUE)))).addGap(10, 10, 10)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jAutoRemoveCheckBox, -2, 376, -2).addContainerGap(119, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.jAutoFilterCheckBox, -2, 364, -2).addContainerGap(129, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.jDataQualityCheckBox, -2, 309, -2).addContainerGap(184, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.jAttrImportanceCheckBox, -2, 309, -2).addContainerGap(184, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.jSamplingCheckBox, -2, 292, -2).addContainerGap(201, Short.MAX_VALUE)));
        groupLayout.linkSize(0, this.jConstantPercentCheckBox, this.jImportanceCheckBox, this.jNullPercentCheckBox, this.jSampleSizeLabel, this.jTopNCheckBox, this.jUniquePercentCheckBox);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jAutoFilterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAutoRemoveCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jDataQualityCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNullPercentSpinner, -2, -1, -2).addComponent(this.jNullPercentCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jUniquePercentSpinner, -2, -1, -2).addComponent(this.jUniquePercentCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jConstantPercentSpinner, -2, -1, -2).addComponent(this.jConstantPercentCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jAttrImportanceCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jImportanceSpinner, -2, -1, -2).addComponent(this.jImportanceCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTopNCheckBox).addComponent(this.jTopNSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSamplingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSampleSizeSpinner, -2, -1, -2).addComponent(this.jSampleSizeLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jAutoFilterCheckBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void jAutoRemoveCheckBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void jDataQualityCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.jNullPercentCheckBox.setSelected(this.jDataQualityCheckBox.isSelected());
        this.jUniquePercentCheckBox.setSelected(this.jDataQualityCheckBox.isSelected());
        this.jConstantPercentCheckBox.setSelected(this.jDataQualityCheckBox.isSelected());
        this.enableControls();
    }

    private void jAttrImportanceCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.jImportanceCheckBox.setSelected(this.jAttrImportanceCheckBox.isSelected());
        this.jTopNCheckBox.setSelected(this.jAttrImportanceCheckBox.isSelected());
        this.enableControls();
    }

    private void jNullPercentCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!(this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected())) {
            this.jDataQualityCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void jUniquePercentCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!(this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected())) {
            this.jDataQualityCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void jConstantPercentCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!(this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected())) {
            this.jDataQualityCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void jImportanceCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.jImportanceCheckBox.isSelected() && !this.jTopNCheckBox.isSelected()) {
            this.jAttrImportanceCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void jTopNCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.jImportanceCheckBox.isSelected() && !this.jTopNCheckBox.isSelected()) {
            this.jAttrImportanceCheckBox.setSelected(false);
        }
        this.enableControls();
    }

    private void enableControls() {
        this.jNullPercentCheckBox.setEnabled(this.jDataQualityCheckBox.isSelected());
        this.jUniquePercentCheckBox.setEnabled(this.jDataQualityCheckBox.isSelected());
        this.jConstantPercentCheckBox.setEnabled(this.jDataQualityCheckBox.isSelected());
        this.jNullPercentSpinner.setEnabled(this.jDataQualityCheckBox.isSelected() && this.jNullPercentCheckBox.isSelected());
        this.jUniquePercentSpinner.setEnabled(this.jDataQualityCheckBox.isSelected() && this.jUniquePercentCheckBox.isSelected());
        this.jConstantPercentSpinner.setEnabled(this.jDataQualityCheckBox.isSelected() && this.jConstantPercentCheckBox.isSelected());
        this.jImportanceCheckBox.setEnabled(this.jAttrImportanceCheckBox.isSelected());
        this.jTopNCheckBox.setEnabled(this.jAttrImportanceCheckBox.isSelected());
        this.jImportanceSpinner.setEnabled(this.jAttrImportanceCheckBox.isSelected() && this.jImportanceCheckBox.isSelected());
        this.jTopNSpinner.setEnabled(this.jAttrImportanceCheckBox.isSelected() && this.jTopNCheckBox.isSelected());
        this.jSampleSizeSpinner.setEnabled(this.jSamplingCheckBox.isSelected());
    }

    public void onEntry(TraversableContext traversableContext) {
        ColumnFilterPreferenceSettings columnFilterPreferenceSettings = ColumnFilterPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        this.jAutoFilterCheckBox.setSelected(columnFilterPreferenceSettings.getAutomaticFilter());
        this.jAutoRemoveCheckBox.setSelected(columnFilterPreferenceSettings.getAutomaticRemoveAttrs());
        this.jNullPercentCheckBox.setSelected(columnFilterPreferenceSettings.getUseNullsPercent());
        this.jNullPercentSpinner.setValue(new Double(columnFilterPreferenceSettings.getNullsPercentValue()));
        this.jUniquePercentCheckBox.setSelected(columnFilterPreferenceSettings.getUseUniquePercent());
        this.jUniquePercentSpinner.setValue(new Double(columnFilterPreferenceSettings.getUniquePercentValue()));
        this.jConstantPercentCheckBox.setSelected(columnFilterPreferenceSettings.getUseConstantPercent());
        this.jConstantPercentSpinner.setValue(new Double(columnFilterPreferenceSettings.getConstantPercentValue()));
        this.jImportanceCheckBox.setSelected(columnFilterPreferenceSettings.getUseCuttoff());
        this.jImportanceSpinner.setValue(new Double(columnFilterPreferenceSettings.getCutOffValue()));
        this.jTopNCheckBox.setSelected(columnFilterPreferenceSettings.getUseTopN());
        this.jTopNSpinner.setValue(new Integer(columnFilterPreferenceSettings.getTopNValue()));
        this.jSamplingCheckBox.setSelected(columnFilterPreferenceSettings.getUseSampling());
        this.jSampleSizeSpinner.setValue(new Integer(columnFilterPreferenceSettings.getSamplingNumberOfRows()));
        this.jDataQualityCheckBox.setSelected(columnFilterPreferenceSettings.getUseDataQuality());
        this.jAttrImportanceCheckBox.setSelected(columnFilterPreferenceSettings.getUseAttrImportance());
        this.enableControls();
    }

    public void onExit(TraversableContext traversableContext) {
        ColumnFilterPreferenceSettings columnFilterPreferenceSettings = ColumnFilterPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        columnFilterPreferenceSettings.setAutomaticFilter(this.jAutoFilterCheckBox.isSelected());
        columnFilterPreferenceSettings.setAutomaticRemoveAttrs(this.jAutoRemoveCheckBox.isSelected());
        columnFilterPreferenceSettings.setUseNullsPercent(this.jNullPercentCheckBox.isSelected());
        columnFilterPreferenceSettings.setNullsPercentValue((Double)this.jNullPercentSpinner.getValue());
        columnFilterPreferenceSettings.setUseUniquePercent(this.jUniquePercentCheckBox.isSelected());
        columnFilterPreferenceSettings.setUniquePercentValue((Double)this.jUniquePercentSpinner.getValue());
        columnFilterPreferenceSettings.setUseConstantPercent(this.jConstantPercentCheckBox.isSelected());
        columnFilterPreferenceSettings.setConstantPercentValue((Double)this.jConstantPercentSpinner.getValue());
        columnFilterPreferenceSettings.setUseCuttoff(this.jImportanceCheckBox.isSelected());
        columnFilterPreferenceSettings.setCutOffValue((Double)this.jImportanceSpinner.getValue());
        columnFilterPreferenceSettings.setUseTopN(this.jTopNCheckBox.isSelected());
        columnFilterPreferenceSettings.setTopNValue((Integer)this.jTopNSpinner.getValue());
        columnFilterPreferenceSettings.setUseSampling(this.jSamplingCheckBox.isSelected());
        columnFilterPreferenceSettings.setSamplingNumberOfRows((Integer)this.jSampleSizeSpinner.getValue());
        columnFilterPreferenceSettings.setUseDataQuality(this.jDataQualityCheckBox.isSelected());
        columnFilterPreferenceSettings.setUseAttrImportance(this.jAttrImportanceCheckBox.isSelected());
    }

    private static ColumnFilterPreferenceSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return ColumnFilterPreferenceSettings.getInstance(traversableContext.getPropertyStorage());
    }

    public static class ColumnFilterPreferenceSettings
    extends DataMinerPreferenceSettings {
        private static final String DATA_KEY = "oracle.dmt.dataminer.workflow.ColumnFilterPreferenceSettings";
        private static boolean _AUTO_FILTER = false;
        private static boolean _AUTO_REMOVE_ATTRS = true;
        private static boolean _USE_DATA_QUALITY = true;
        private static boolean _USE_ATTR_IMPORTANCE = false;
        private static boolean _USE_NULLS_PERCENT = true;
        private static boolean _USE_UNIQUE_PERCENT = true;
        private static boolean _USE_CONSTANT_PERCENT = true;
        private static boolean _USE_CUT_OFF = false;
        private static boolean _USE_TOP_N = false;
        private static boolean _USE_SAMPLING = true;
        private static double _NULLS_PERCENT = 95.0;
        private static double _UNIQUE_PERCENT = 95.0;
        private static double _CONSTANT_PERCENT = 95.0;
        private static double _CUT_OFF = 0.0;
        private static int _TOP_N = 100;
        private static int _NUMBER_OF_ROWS = 2000;

        public static ColumnFilterPreferenceSettings getInstance() {
            return ColumnFilterPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
        }

        private ColumnFilterPreferenceSettings(HashStructure hashStructure) {
            super(hashStructure);
        }

        public static ColumnFilterPreferenceSettings getInstance(PropertyStorage propertyStorage) {
            return new ColumnFilterPreferenceSettings(ColumnFilterPreferenceSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
        }

        public void setAutomaticFilter(boolean bl) {
            this._hash.putBoolean("AutomaticFilter", bl);
        }

        public boolean getAutomaticFilter() {
            return this._hash.getBoolean("AutomaticFilter", _AUTO_FILTER);
        }

        public void setAutomaticRemoveAttrs(boolean bl) {
            this._hash.putBoolean("AutomaticRemoveAttrs", bl);
        }

        public boolean getAutomaticRemoveAttrs() {
            return this._hash.getBoolean("AutomaticRemoveAttrs", _AUTO_REMOVE_ATTRS);
        }

        public boolean getUseDataQuality() {
            return this._hash.getBoolean("UseDataQuality", _USE_DATA_QUALITY);
        }

        public void setUseDataQuality(boolean bl) {
            this._hash.putBoolean("UseDataQuality", bl);
        }

        public boolean getUseAttrImportance() {
            return this._hash.getBoolean("UseAttrImportance", _USE_ATTR_IMPORTANCE);
        }

        public void setUseAttrImportance(boolean bl) {
            this._hash.putBoolean("UseAttrImportance", bl);
        }

        public boolean getUseNullsPercent() {
            return this._hash.getBoolean("UseNullsPercent", _USE_NULLS_PERCENT);
        }

        public void setUseNullsPercent(boolean bl) {
            this._hash.putBoolean("UseNullsPercent", bl);
        }

        public boolean getUseUniquePercent() {
            return this._hash.getBoolean("UseUniquePercent", _USE_UNIQUE_PERCENT);
        }

        public void setUseUniquePercent(boolean bl) {
            this._hash.putBoolean("UseUniquePercent", bl);
        }

        public boolean getUseConstantPercent() {
            return this._hash.getBoolean("UseConstantPercent", _USE_CONSTANT_PERCENT);
        }

        public void setUseConstantPercent(boolean bl) {
            this._hash.putBoolean("UseConstantPercent", bl);
        }

        public boolean getUseCuttoff() {
            return this._hash.getBoolean("UseCuttoff", _USE_CUT_OFF);
        }

        public void setUseCuttoff(boolean bl) {
            this._hash.putBoolean("UseCuttoff", bl);
        }

        public boolean getUseTopN() {
            return this._hash.getBoolean("UseTopN", _USE_TOP_N);
        }

        public void setUseTopN(boolean bl) {
            this._hash.putBoolean("UseTopN", bl);
        }

        public boolean getUseSampling() {
            return this._hash.getBoolean("UseSampling", _USE_SAMPLING);
        }

        public void setUseSampling(boolean bl) {
            this._hash.putBoolean("UseSampling", bl);
        }

        public int getSamplingNumberOfRows() {
            return this._hash.getInt("SamplingNumberOfRows", _NUMBER_OF_ROWS);
        }

        public void setSamplingNumberOfRows(int n) {
            this._hash.putInt("SamplingNumberOfRows", n);
        }

        public void removeSamplingNumberOfRows() {
            this._hash.remove("SamplingNumberOfRows");
        }

        public double getNullsPercentValue() {
            return this._hash.getDouble("NullsPercent", _NULLS_PERCENT);
        }

        public void setNullsPercentValue(double d) {
            this._hash.putDouble("NullsPercent", d);
        }

        public void removeNullsPercentValue() {
            this._hash.remove("NullsPercent");
        }

        public double getUniquePercentValue() {
            return this._hash.getDouble("UniquePercent", _UNIQUE_PERCENT);
        }

        public void setUniquePercentValue(double d) {
            this._hash.putDouble("UniquePercent", d);
        }

        public void removeUniquePercentValue() {
            this._hash.remove("UniquePercent");
        }

        public double getConstantPercentValue() {
            return this._hash.getDouble("ConstantPercent", _CONSTANT_PERCENT);
        }

        public void setConstantPercentValue(double d) {
            this._hash.putDouble("ConstantPercent", d);
        }

        public void removeConstantPercentValue() {
            this._hash.remove("ConstantPercent");
        }

        public double getCutOffValue() {
            return this._hash.getDouble("CutOff", _CUT_OFF);
        }

        public void setCutOffValue(double d) {
            this._hash.putDouble("CutOff", d);
        }

        public void removeCutOffValue() {
            this._hash.remove("CutOff");
        }

        public int getTopNValue() {
            return this._hash.getInt("TopN", _TOP_N);
        }

        public void setTopNValue(int n) {
            this._hash.putInt("TopN", n);
        }

        public void removeTopNValue() {
            this._hash.remove("TopN");
        }
    }
}

