/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dmt.dataminer.controls.OutputAttributeType;
import oracle.dmt.dataminer.server.model.MiningDetailsOutputType;
import oracle.dmt.dataminer.server.model.ModelDetailsExtract;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelDetailsPreferenceSettings;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.ModelConsumer;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.RowDiagnosticsProvider;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsOutputType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.MultiMap;

public final class ModelDetailsDataNode
extends AbstractTransformNode
implements ModelConsumer {
    public static final String MODEL_DETAILS_MODELS = "modelDetailsModels";
    public static final String MODEL_DETAILS_OUTPUT_COLUMNS = "modelDetailsOutputColumns";
    public final String INFORMATIONAL_KEY_AUTOMATIC_SETTING = this.getClass().getName();
    public static final String SQL_EXPRESSION = "SQL_EXPRESSION";
    public static final String SQL_EXPRESSION_GENERATE = "SQL_EXPRESSION_GENERATE";
    private static Preferences _p = Preferences.getPreferences();
    private ModelDetailsPreferenceSettings _modelDetailsPreferenceSettings = ModelDetailsPreferenceSettings.getInstance((PropertyStorage)_p);

    public ModelDetailsDataNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        ModelDetailsOutputType modelDetailsOutputType = new ModelDetailsOutputType();
        ModelDetailsOutputType.Models models = new ModelDetailsOutputType.Models();
        Attributes attributes = new Attributes();
        modelDetailsOutputType.setAttributes(attributes);
        modelDetailsOutputType.setModels(models);
        modelDetailsOutputType.setType(null);
        modelDetailsDataNodeType.setModelDetailsOutput(modelDetailsOutputType);
        if (this._modelDetailsPreferenceSettings.getAutomaticSetting()) {
            modelDetailsOutputType.setAutoSpec(AutoSpecType.fromValue((String)"Yes"));
        } else {
            modelDetailsOutputType.setAutoSpec(AutoSpecType.fromValue((String)"No"));
        }
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_MODEL_DETAILS_NODE_NAME");
    }

    public boolean areNodesCompatible(Node node) {
        ModelProvider modelProvider;
        ModelProvider modelProvider2;
        MiningFunctionType miningFunctionType;
        boolean bl = false;
        List<AbstractNode> list = this.findParentNodes();
        bl = list.size() == 0 ? true : (miningFunctionType = (modelProvider2 = (ModelProvider)((Object)list.get(0))).getMiningFunctionTypeSupported()).equals((Object)(modelProvider = (ModelProvider)((Object)node)).getMiningFunctionTypeSupported());
        return bl;
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = false;
        bl = node instanceof ModelProvider ? this.areNodesCompatible(node) : false;
        return bl;
    }

    @Override
    public String generateSQLExpression() {
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (modelDetailsDataNodeType.getModelDetailsOutput().getType().equals((Object)ModelDetailType.GLMC_ROW_DIAGNOSTICS) || modelDetailsDataNodeType.getModelDetailsOutput().getType().equals((Object)ModelDetailType.GLMR_ROW_DIAGNOSTICS)) {
            List<AbstractNode> list = this.findParentNodes();
            for (AbstractNode abstractNode : list) {
                if (!(abstractNode instanceof RowDiagnosticsProvider)) continue;
                hashMap.putAll(((RowDiagnosticsProvider)((Object)abstractNode)).getRowDiagnosticTables());
            }
        }
        return this.wrapExpressionInWithClause(ModelDetailsExtract.generateSQL(modelDetailsDataNodeType.getModelDetailsOutput().getType(), modelDetailsDataNodeType.getModelDetailsOutput().getModels().getModel(), modelDetailsDataNodeType.getModelDetailsOutput().getAttributes().getAttribute(), hashMap));
    }

    public ModelDetailsOutputType validateModelCompatibilityNotAuto(ModelDetailsOutputType modelDetailsOutputType) throws Exception {
        ModelDetailsOutputType.Models models = modelDetailsOutputType.getModels();
        List list = models.getModel();
        List<RefModelType> list2 = modelDetailsOutputType.getType() == ModelDetailType.SVMC_COEFFICIENTS || modelDetailsOutputType.getType() == ModelDetailType.SVMR_COEFFICIENTS ? this.getCompatibleModelsForSVMCoefficients() : (modelDetailsOutputType.getType() == ModelDetailType.GLMR_ROW_DIAGNOSTICS || modelDetailsOutputType.getType() == ModelDetailType.GLMC_ROW_DIAGNOSTICS ? this.getCompatibleModelsForRowDiagnostics() : this.getCompatibleModels(modelDetailsOutputType));
        for (RefModelType refModelType : list) {
            boolean bl = false;
            if (refModelType.getModelId() != null) {
                for (RefModelType refModelType2 : list2) {
                    if (refModelType.getModelId().compareTo(refModelType2.getModelId()) != 0 || refModelType.getNodeId().compareTo(refModelType2.getNodeId()) != 0) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                refModelType.setStatus(RefModelStatusType.VALID);
                continue;
            }
            refModelType.setStatus(RefModelStatusType.INVALID);
        }
        return modelDetailsOutputType;
    }

    public ModelDetailsOutputType addCompatibleModels(ModelDetailsOutputType modelDetailsOutputType) throws Exception {
        ModelDetailsOutputType.Models models = modelDetailsOutputType.getModels();
        List list = models.getModel();
        List<RefModelType> list2 = modelDetailsOutputType.getType() == ModelDetailType.SVMC_COEFFICIENTS || modelDetailsOutputType.getType() == ModelDetailType.SVMR_COEFFICIENTS ? this.getCompatibleModelsForSVMCoefficients() : (modelDetailsOutputType.getType() == ModelDetailType.GLMR_ROW_DIAGNOSTICS || modelDetailsOutputType.getType() == ModelDetailType.GLMC_ROW_DIAGNOSTICS ? this.getCompatibleModelsForRowDiagnostics() : this.getCompatibleModels(modelDetailsOutputType));
        list.clear();
        list.addAll(list2);
        if (list.isEmpty()) {
            modelDetailsOutputType.getAttributes().getAttribute().clear();
            modelDetailsOutputType.setMiningAlgorithm(null);
            modelDetailsOutputType.setMiningFunction(null);
            modelDetailsOutputType.setType(null);
        }
        return modelDetailsOutputType;
    }

    private List<RefModelType> getCompatibleModels(ModelDetailsOutputType modelDetailsOutputType) {
        MultiMap multiMap;
        List<AbstractNode> list = this.findParentNodes();
        ArrayList<MiningAlgorithmType> arrayList = new ArrayList<MiningAlgorithmType>();
        if (!modelDetailsOutputType.getMiningAlgorithm().equals((Object)MiningAlgorithmType.ALL) && modelDetailsOutputType.getType().equals((Object)ModelDetailType.MODEL_SIGNATURE)) {
            arrayList.add(modelDetailsOutputType.getMiningAlgorithm());
        } else if (modelDetailsOutputType.getMiningAlgorithm().equals((Object)MiningAlgorithmType.ALL)) {
            multiMap = MiningDetailsOutputType.getMiningAlgorithms(modelDetailsOutputType.getType());
            arrayList.addAll((Collection<MiningAlgorithmType>)multiMap);
        } else {
            arrayList.add(modelDetailsOutputType.getMiningAlgorithm());
        }
        multiMap = new MultiMap();
        for (AbstractNode abstractNode : list) {
            ModelProvider modelProvider = (ModelProvider)((Object)abstractNode);
            List<Object> list2 = new ArrayList();
            list2 = modelProvider.getOutputModels();
            for (RefModelType refModelType : list2) {
                String string = "MODEL_NAME:" + refModelType.getSchema() + ":" + refModelType.getName() + "FUNCTION:" + refModelType.getMiningFunction().value() + "ALGORITHM:" + refModelType.getMiningAlgorithm().value();
                multiMap.add((Object)string, (Object)refModelType);
            }
        }
        List<RefModelType> list3 = this.getModelsContains((MultiMap<String, RefModelType>)multiMap, arrayList);
        return list3;
    }

    private List<RefModelType> getCompatibleModelsForSVMCoefficientsFromNode(Node node) {
        ArrayList<RefModelType> arrayList = new ArrayList();
        try {
            arrayList = ((ModelProvider)((Object)node)).getSVMLinearModels();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private List<RefModelType> getCompatibleModelsForSVMCoefficients() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            ModelProvider modelProvider = (ModelProvider)((Object)abstractNode);
            List<Object> list2 = new ArrayList();
            list2 = modelProvider.getSVMLinearModels();
            if (list2 == null) continue;
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private List<RefModelType> getCompatibleModelsForRowDiagnostics() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            ModelProvider modelProvider = (ModelProvider)((Object)abstractNode);
            List<Object> list2 = new ArrayList();
            list2 = modelProvider.getGLMRowDiagnosticModels();
            if (list2 == null) continue;
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private ModelDetailsOutputType findIncompatibleModels() throws Exception {
        List<Object> list;
        Object object;
        ModelDetailsOutputType modelDetailsOutputType = this.createDuplicateOutputType();
        List<AbstractNode> list2 = this.findParentNodes();
        ModelDetailsOutputType.Models models = modelDetailsOutputType.getModels();
        List list3 = models.getModel();
        HashMap<String, RefModelType> hashMap = new HashMap<String, RefModelType>();
        HashMap<String, RefModelType> hashMap2 = new HashMap<String, RefModelType>();
        for (AbstractNode abstractNode : list2) {
            object = (ModelProvider)((Object)abstractNode);
            list = new ArrayList();
            list = object.getOutputModels();
            for (RefModelType refModelType : list) {
                String string = "NODE_ID:" + abstractNode.getMetadataId() + "MODEL_NAME:" + refModelType.getSchema() + ":" + refModelType.getName() + "FUNCTION:" + refModelType.getMiningFunction().value() + "ALGORITHM:" + refModelType.getMiningAlgorithm().value();
                hashMap.put(string, refModelType);
                String string2 = "MODEL_NAME:" + refModelType.getSchema() + ":" + refModelType.getName() + "FUNCTION:" + refModelType.getMiningFunction().value() + "ALGORITHM:" + refModelType.getMiningAlgorithm().value();
                hashMap2.put(string2, refModelType);
            }
        }
        for (AbstractNode abstractNode : list3) {
            object = "NODE_ID:" + abstractNode.getNodeId() + "MODEL_NAME:" + abstractNode.getSchema() + ":" + abstractNode.getName() + "FUNCTION:" + abstractNode.getMiningFunction().value() + "ALGORITHM:" + abstractNode.getMiningAlgorithm().value();
            list = (RefModelType)hashMap.get(object);
            if (list != null) {
                abstractNode.setStatus(RefModelStatusType.VALID);
                abstractNode.setModelId(list.getModelId());
            } else {
                abstractNode.setStatus(RefModelStatusType.INVALID);
                abstractNode.setNodeId(null);
                abstractNode.setModelId(null);
            }
            if (abstractNode.getNodeId() != null) continue;
            String string = "MODEL_NAME:" + abstractNode.getSchema() + ":" + abstractNode.getName() + "FUNCTION:" + abstractNode.getMiningFunction().value() + "ALGORITHM:" + abstractNode.getMiningAlgorithm().value();
            RefModelType refModelType = (RefModelType)hashMap2.get(string);
            if (refModelType != null) {
                abstractNode.setStatus(RefModelStatusType.VALID);
                abstractNode.setIsModelBuilt(refModelType.isIsModelBuilt());
                abstractNode.setNodeId(refModelType.getNodeId());
                abstractNode.setModelId(refModelType.getModelId());
                continue;
            }
            abstractNode.setStatus(RefModelStatusType.INVALID);
            abstractNode.setNodeId(null);
            abstractNode.setModelId(null);
        }
        return this.validateModelCompatibilityNotAuto(modelDetailsOutputType);
    }

    public boolean validateNodeRemoval(Node node, boolean bl) {
        Object object;
        Object object22;
        boolean bl2 = super.validate(bl);
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)MetaDataHelper.copyMetadataObject(this.getData());
        ModelDetailsOutputType.Models models = modelDetailsDataNodeType.getModelDetailsOutput().getModels();
        List list = models.getModel();
        Attributes attributes = modelDetailsDataNodeType.getModelDetailsOutput().getAttributes();
        List list2 = attributes.getAttribute();
        boolean bl3 = false;
        if (modelDetailsDataNodeType.getModelDetailsOutput().getAutoSpec().value().compareTo("No") == 0) {
            boolean bl4 = false;
            if (node != null) {
                for (Object object22 : list) {
                    if (object22.getNodeId() == null || node.getData().getId() == null || object22.getNodeId().compareTo(node.getData().getId()) != 0) continue;
                    object22.setStatus(RefModelStatusType.INVALID);
                    bl4 = true;
                }
            }
            if (bl4) {
                this.addMessage("MODEL_DETAIL_INVALID_MODELS", MessageEnumType.WARNING, new String[0]);
            }
        }
        List<AbstractNode> list3 = this.findParentNodes();
        if (node != null) {
            list3.remove(node);
        }
        if (list3.size() == 0) {
            this.addMessage("MODEL_DETAIL_NO_LINKS", MessageEnumType.WARNING, new String[0]);
            bl2 = false;
        } else {
            bl3 = true;
        }
        if (bl2 && list.size() == 0) {
            this.addMessage("MODEL_DETAIL_NO_MODELS", MessageEnumType.WARNING, new String[0]);
            bl2 = false;
        }
        for (Object object22 : list) {
            if (object22.getStatus() == RefModelStatusType.VALID) continue;
            this.addMessage("MODEL_DETAIL_INVALID_MODELS", MessageEnumType.WARNING, new String[0]);
            bl2 = false;
            break;
        }
        if (bl3 && list.size() > 0) {
            if (list2.size() == 0) {
                this.addMessage("MODEL_DETAIL_NO_OUTPUT_COLUMNS", MessageEnumType.WARNING, new String[0]);
                bl2 = false;
            } else {
                for (Object object22 : list2) {
                    if (!object22.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
                    this.addMessage("MODEL_DETAIL_INVALID_OUTPUT_COLUMNS", MessageEnumType.WARNING, new String[0]);
                    bl2 = false;
                    break;
                }
            }
        }
        Iterator iterator = this.findParentNodes();
        object22 = iterator.iterator();
        while (object22.hasNext()) {
            ModelProvider modelProvider;
            object = (AbstractNode)object22.next();
            if (!(object instanceof ModelProvider) || (modelProvider = (ModelProvider)object).getTargetAttribute() != null || !(modelProvider instanceof SupervisedBuildNode)) continue;
            this.addMessage("TEST_NO_TARGET", MessageEnumType.WARNING, new String[0]);
            bl2 = false;
            break;
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        object22 = (OdmrSDMUndoFilter)this.getUndoFilter();
        if (modelDetailsDataNodeType.getModelDetailsOutput() != null) {
            ((OdmrSDMUndoFilter)((Object)object22)).prepareUndo(this, this.getContext(), MODEL_DETAILS_MODELS, modelDetailsDataNodeType.getModelDetailsOutput());
        }
        object = "";
        if (bl2) {
            ((ModelDetailsDataNodeType)this.getData()).setSQLExpression(this.generateSQLExpression());
            object = this.getSQLExpression();
        } else {
            ((ModelDetailsDataNodeType)this.getData()).setSQLExpression((String)object);
        }
        ((OdmrSDMUndoFilter)((Object)object22)).prepareUndo(this, this.getContext(), SQL_EXPRESSION, object);
        return bl2;
    }

    @Override
    public void refactorModelReferences(Node node, Map<String, RefModelType> map, boolean bl) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        ModelDetailsOutputType modelDetailsOutputType = modelDetailsDataNodeType.getModelDetailsOutput();
        ModelDetailsOutputType modelDetailsOutputType2 = (ModelDetailsOutputType)MetaDataHelper.copyMetadataObject(modelDetailsOutputType);
        List list = modelDetailsOutputType2.getModels().getModel();
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RefModelType refModelType = (RefModelType)iterator.next();
            RefModelType refModelType2 = map.get(refModelType.getName());
            if (refModelType2 == null) continue;
            iterator.remove();
            arrayList.add(refModelType2);
        }
        list.addAll(arrayList);
        odmrSDMUndoFilter.prepareUndo(this, this.getContext(), MODEL_DETAILS_MODELS, modelDetailsOutputType2);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean validate(boolean var1_1) {
        var2_2 = (ModelDetailsDataNodeType)this.getData();
        var3_3 = null;
        var4_4 = this.isNodeUndefined();
        if (!var4_4) {
            var5_5 = (OdmrSDMUndoFilter)this.getUndoFilter();
            if (var2_2.getModelDetailsOutput().getAutoSpec().value().compareTo("Yes") == 0) {
                var6_7 = this.createDuplicateOutputType();
                try {
                    var3_3 = this.addCompatibleModels(var6_7);
                    if (!var3_3.getModels().getModel().isEmpty() || (var7_10 = this.autoProcessingUndefined()) == null) ** GOTO lbl22
                    var3_3 = var7_10;
                }
                catch (Exception var7_11) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)var7_11, (String)NodeMessagesLrb.get("ERROR_VALIDATING_TITLE"), (String)NodeMessagesLrb.get("ERROR_MODEL_DETAILS_UNEXPECTED"), null);
                    return false;
                }
            } else {
                try {
                    var3_3 = this.findIncompatibleModels();
                }
                catch (Exception var6_8) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)var6_8, (String)NodeMessagesLrb.get("ERROR_VALIDATING_TITLE"), (String)NodeMessagesLrb.get("ERROR_MODEL_DETAILS_UNEXPECTED"), null);
                    return false;
                }
            }
lbl22:
            // 3 sources

            if (var3_3 != null) {
                var5_5.prepareUndo(this, this.getContext(), "modelDetailsModels", var3_3);
            }
        } else if (var2_2.getModelDetailsOutput().getAutoSpec().value().compareTo("Yes") == 0) {
            var5_6 = (OdmrSDMUndoFilter)this.getUndoFilter();
            try {
                var3_3 = this.autoProcessingUndefined();
            }
            catch (Exception var6_9) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)var6_9, (String)NodeMessagesLrb.get("ERROR_VALIDATING_TITLE"), (String)NodeMessagesLrb.get("ERROR_MODEL_DETAILS_UNEXPECTED"), null);
                return false;
            }
            if (var3_3 != null) {
                var5_6.prepareUndo(this, this.getContext(), "modelDetailsModels", var3_3);
            }
        }
        return this.validateNodeRemoval(null, var1_1);
    }

    private ModelDetailsOutputType autoProcessingUndefined() throws Exception {
        List<AbstractNode> list = this.findParentNodes();
        ModelDetailsOutputType modelDetailsOutputType = null;
        for (AbstractNode abstractNode : list) {
            ModelProvider modelProvider = (ModelProvider)((Object)abstractNode);
            List<Object> list2 = new ArrayList();
            list2 = modelProvider.getOutputModels();
            if (list2.isEmpty()) continue;
            modelDetailsOutputType = this.getDefaultModelDetailOutputType(abstractNode);
            break;
        }
        if (modelDetailsOutputType != null) {
            modelDetailsOutputType = this.addCompatibleModels(modelDetailsOutputType);
        }
        return modelDetailsOutputType;
    }

    public boolean sourceModelsContains(List<RefModelType> list, MiningAlgorithmType miningAlgorithmType) {
        boolean bl = false;
        for (RefModelType refModelType : list) {
            if (refModelType.getMiningAlgorithm() != miningAlgorithmType) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public List<RefModelType> getModelsContains(List<RefModelType> list, MiningAlgorithmType miningAlgorithmType) {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        for (RefModelType refModelType : list) {
            if (refModelType.getMiningAlgorithm() != miningAlgorithmType) continue;
            arrayList.add(refModelType);
        }
        return arrayList;
    }

    public List<RefModelType> getModelsContains(List<RefModelType> list, MiningFunctionType miningFunctionType) {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        for (RefModelType refModelType : list) {
            if (refModelType.getMiningFunction() != miningFunctionType) continue;
            arrayList.add(refModelType);
        }
        return arrayList;
    }

    public List<RefModelType> getModelsContains(List<RefModelType> list, List<MiningAlgorithmType> list2) {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        for (RefModelType refModelType : list) {
            if (!list2.contains(refModelType.getMiningAlgorithm())) continue;
            arrayList.add(refModelType);
        }
        return arrayList;
    }

    public List<RefModelType> getModelsContains(MultiMap<String, RefModelType> multiMap, List<MiningAlgorithmType> list) {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        for (ArrayList arrayList2 : multiMap.values()) {
            for (RefModelType refModelType : arrayList2) {
                if (!list.contains(refModelType.getMiningAlgorithm())) continue;
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    private ModelDetailsOutputType createDuplicateOutputType() {
        ModelDetailsOutputType modelDetailsOutputType = new ModelDetailsOutputType();
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        ModelDetailsOutputType modelDetailsOutputType2 = modelDetailsDataNodeType.getModelDetailsOutput();
        modelDetailsOutputType.setType(modelDetailsOutputType2.getType());
        Attributes attributes = new Attributes();
        attributes.getAttribute().addAll(modelDetailsOutputType2.getAttributes().getAttribute());
        ModelDetailsOutputType.Models models = new ModelDetailsOutputType.Models();
        models.getModel().addAll(modelDetailsOutputType2.getModels().getModel());
        modelDetailsOutputType.setModels(models);
        modelDetailsOutputType.setAttributes(attributes);
        modelDetailsOutputType.setMiningAlgorithm(modelDetailsOutputType2.getMiningAlgorithm());
        modelDetailsOutputType.setMiningFunction(modelDetailsOutputType2.getMiningFunction());
        modelDetailsOutputType.setAutoSpec(modelDetailsOutputType2.getAutoSpec());
        return modelDetailsOutputType;
    }

    private ModelDetailsOutputType getDefaultModelDetailOutputType(Node node) {
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        ModelDetailsOutputType modelDetailsOutputType = new ModelDetailsOutputType();
        ModelDetailsOutputType.Models models = new ModelDetailsOutputType.Models();
        Attributes attributes = new Attributes();
        modelDetailsOutputType.setAttributes(attributes);
        ModelDetailType modelDetailType = null;
        MiningAlgorithmType miningAlgorithmType = null;
        ModelProvider modelProvider = (ModelProvider)((Object)node);
        MiningFunctionType miningFunctionType = modelProvider.getMiningFunctionTypeSupported();
        List<Object> list = new ArrayList();
        ArrayList<OutputAttributeType> arrayList = new ArrayList();
        list = modelProvider.getOutputModels();
        if (list.isEmpty()) {
            modelDetailType = null;
            miningAlgorithmType = null;
        } else if (this.sourceModelsContains(list, MiningAlgorithmType.DECISION_TREE)) {
            miningAlgorithmType = MiningAlgorithmType.DECISION_TREE;
            modelDetailType = ModelDetailType.DT_LEAF_NODES_ONLY;
        } else if (this.sourceModelsContains(list, MiningAlgorithmType.GENERALIZED_LINEAR_MODEL)) {
            miningAlgorithmType = MiningAlgorithmType.GENERALIZED_LINEAR_MODEL;
            modelDetailType = miningFunctionType == MiningFunctionType.CLASSIFICATION ? ModelDetailType.GLMC_COEFFICIENTS_AND_STATISTICS : ModelDetailType.GLMR_COEFFICIENTS_AND_STATISTICS;
        } else if (this.sourceModelsContains(list, MiningAlgorithmType.NAIVE_BAYES)) {
            miningAlgorithmType = MiningAlgorithmType.NAIVE_BAYES;
            modelDetailType = ModelDetailType.NB_PAIR_PROBABILITIES;
        } else if (this.sourceModelsContains(list, MiningAlgorithmType.SUPPORT_VECTOR_MACHINES)) {
            if (this.getCompatibleModelsForSVMCoefficientsFromNode(node).isEmpty()) {
                miningAlgorithmType = MiningAlgorithmType.ALL;
                modelDetailType = ModelDetailType.MODEL_SIGNATURE;
            } else {
                miningAlgorithmType = MiningAlgorithmType.SUPPORT_VECTOR_MACHINES;
                if (miningFunctionType == MiningFunctionType.CLASSIFICATION) {
                    modelDetailType = ModelDetailType.SVMC_COEFFICIENTS;
                } else if (miningFunctionType == MiningFunctionType.REGRESSION) {
                    modelDetailType = ModelDetailType.SVMR_COEFFICIENTS;
                } else if (miningFunctionType == MiningFunctionType.ANOMALY_DETECTION) {
                    modelDetailType = ModelDetailType.SVMC_COEFFICIENTS;
                }
            }
        } else if (this.sourceModelsContains(list, MiningAlgorithmType.APRIORI_ASSOCIATION_RULES)) {
            miningAlgorithmType = MiningAlgorithmType.APRIORI_ASSOCIATION_RULES;
            modelDetailType = ModelDetailType.AR_RULES_STRING_VERSION;
        } else if (this.sourceModelsContains(list, MiningAlgorithmType.KMEANS) || this.sourceModelsContains(list, MiningAlgorithmType.O_CLUSTER)) {
            miningAlgorithmType = MiningAlgorithmType.ALL;
            modelDetailType = ModelDetailType.CLUSTER_DETAILS;
        } else if (this.sourceModelsContains(list, MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR)) {
            miningAlgorithmType = MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR;
            modelDetailType = ModelDetailType.NMF_DETAILS_TRANSACTIONAL_VERSION;
        }
        if (miningFunctionType != null) {
            list = miningFunctionType == MiningFunctionType.CLUSTERING ? this.getModelsContains(list, MiningFunctionType.CLUSTERING) : this.getModelsContains(list, miningAlgorithmType);
            arrayList = ModelDetailsExtract.getOutputColumnList(modelDetailType);
            models.getModel().addAll(list);
            modelDetailsOutputType.setAttributes(OutputAttributeType.convertAttributes(arrayList));
        }
        modelDetailsOutputType.setModels(models);
        modelDetailsOutputType.setType(modelDetailType);
        modelDetailsOutputType.setMiningAlgorithm(miningAlgorithmType);
        modelDetailsOutputType.setMiningFunction(miningFunctionType);
        modelDetailsOutputType.setAutoSpec(modelDetailsDataNodeType.getModelDetailsOutput().getAutoSpec());
        return modelDetailsOutputType;
    }

    private ModelDetailsOutputType automaticHandleNewConnectionFrom(Node node, boolean bl) {
        ModelDetailsOutputType modelDetailsOutputType = null;
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        if (bl) {
            modelDetailsOutputType = this.getDefaultModelDetailOutputType(node);
        } else {
            modelDetailsOutputType = modelDetailsDataNodeType.getModelDetailsOutput();
            List<MiningAlgorithmType> list = MiningDetailsOutputType.getMiningAlgorithms(modelDetailsOutputType.getType());
            ModelProvider modelProvider = (ModelProvider)((Object)node);
            List<RefModelType> list2 = modelProvider.getOutputModels();
            modelDetailsOutputType.getModels().getModel().addAll(this.getModelsContains(list2, list));
        }
        return modelDetailsOutputType;
    }

    private boolean isNodeUndefined() {
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        ModelDetailsOutputType.Models models = modelDetailsDataNodeType.getModelDetailsOutput().getModels();
        List list = models.getModel();
        return list.isEmpty();
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        for (AttributeType attributeType : modelDetailsDataNodeType.getModelDetailsOutput().getAttributes().getAttribute()) {
            AttributeType attributeType2 = new AttributeType();
            String string = attributeType.getAlias() == null ? attributeType.getName() : attributeType.getAlias();
            attributeType2.setName(string);
            attributeType2.setDataType(attributeType.getDataType());
            attributeType2.setStatus(attributeType.getStatus());
            attributes.getAttribute().add(attributeType2);
        }
        return attributes;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    private ModelDetailsOutputType removeModels(Node node) {
        ModelDetailsOutputType modelDetailsOutputType = this.createDuplicateOutputType();
        List list = modelDetailsOutputType.getModels().getModel();
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        for (RefModelType refModelType : list) {
            if (refModelType.getNodeId().compareTo(node.getMetadataId()) != 0) continue;
            arrayList.add(refModelType);
        }
        list.removeAll(arrayList);
        return modelDetailsOutputType;
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ModelDetailsOutputType modelDetailsOutputType = null;
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)MetaDataHelper.copyMetadataObject(this.getData());
        if (modelDetailsDataNodeType.getModelDetailsOutput().getAutoSpec().value().compareTo("Yes") == 0 && (modelDetailsOutputType = this.removeModels(node)) != null) {
            if (modelDetailsOutputType.getModels().getModel().isEmpty()) {
                modelDetailsOutputType.setMiningAlgorithm(null);
                modelDetailsOutputType.setMiningFunction(null);
                modelDetailsOutputType.setType(null);
                modelDetailsOutputType.getAttributes().getAttribute().clear();
            }
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), MODEL_DETAILS_MODELS, modelDetailsOutputType);
        }
        this.validateNodeRemoval(node, false);
    }

    @Override
    public void setProperty(String string, Object object) {
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        if (string.equals(MODEL_DETAILS_MODELS)) {
            ModelDetailsOutputType modelDetailsOutputType = (ModelDetailsOutputType)object;
            modelDetailsDataNodeType.setModelDetailsOutput(modelDetailsOutputType);
        } else if (string.equals(MODEL_DETAILS_OUTPUT_COLUMNS)) {
            ModelDetailsOutputType modelDetailsOutputType = (ModelDetailsOutputType)object;
            modelDetailsDataNodeType.setModelDetailsOutput(modelDetailsOutputType);
        } else if (string.equals(SQL_EXPRESSION)) {
            if (object != null && object.equals(SQL_EXPRESSION_GENERATE)) {
                this.setSQLExpression(this.generateSQLExpression());
            } else {
                this.setSQLExpression((String)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(SQL_EXPRESSION)) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public Object getProperty(String string) {
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getData();
        if (string.equals(MODEL_DETAILS_MODELS)) {
            ModelDetailsOutputType modelDetailsOutputType = modelDetailsDataNodeType.getModelDetailsOutput();
            return modelDetailsOutputType;
        }
        if (string.equals(MODEL_DETAILS_OUTPUT_COLUMNS)) {
            ModelDetailsOutputType modelDetailsOutputType = modelDetailsDataNodeType.getModelDetailsOutput();
            return modelDetailsOutputType;
        }
        if (string.equals(SQL_EXPRESSION)) {
            String string2 = modelDetailsDataNodeType.getSQLExpression();
            return string2;
        }
        return super.getProperty(string);
    }

    @Override
    public String getHelpTopic() {
        return "modeldetails_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_MODEL_DETAILS_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_MODEL_DETAILS_ICON"));
    }
}

