/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.UnsupervisedBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.javatools.util.Pair;

public final class FeatureExtractionBuildNode
extends UnsupervisedBuildNode {
    public static final String SETTINGS = "Settings";
    public static final String FEAT_NUM_FEATURES = "FEAT_NUM_FEATURES";
    public static final String NMFS_CONV_TOLERANCE = "NMFS_CONV_TOLERANCE";
    public static final String NMFS_NUM_ITERATIONS = "NMFS_NUM_ITERATIONS";
    public static final String NMFS_RANDOM_SEED = "NMFS_RANDOM_SEED";

    public FeatureExtractionBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        FeatureExtractionBuildNodeType.Models models = new FeatureExtractionBuildNodeType.Models();
        featureExtractionBuildNodeType.setModels(models);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ALGO_NONNEGATIVE_MATRIX_FACTOR");
        List<String> list = WorkflowUtils.getNewModelNames(context, "FEATURE_EXTRACTION", arrayList);
        int n = 0;
        ModelType modelType = null;
        modelType = this.createNewNMFModel(list.get(n), "", (String)arrayList.get(n));
        modelType.setUseForOutput(true);
        this.addModel((NonNegativeMatrixFactorModelType)modelType);
        featureExtractionBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    public void addModel(NonNegativeMatrixFactorModelType nonNegativeMatrixFactorModelType) {
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        FeatureExtractionBuildNodeType.Models models = featureExtractionBuildNodeType.getModels();
        List list = models.getNonNegativeMatrixFactorModel();
        list.add(nonNegativeMatrixFactorModelType);
    }

    public ModelType createNewNMFModel(String string, String string2, String string3) {
        ModelType modelType = super.createNewModel(string, string2, "FEATURE_EXTRACTION", string3);
        return modelType;
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_FEAT_BUILD_NODE_NAME");
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        FeatureExtractionBuildNodeType.Models models = featureExtractionBuildNodeType.getModels();
        if (models.getNonNegativeMatrixFactorModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            if (bl2) {
                this.setNodeReady();
            }
            if (!this.validateModels(models.getNonNegativeMatrixFactorModel())) {
                bl3 = false;
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    public void setProperty(String string, Object object) {
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        if (string.equals(SETTINGS)) {
            FeatureExtractionBuildNodeType.Models models = featureExtractionBuildNodeType.getModels();
            List list = models.getNonNegativeMatrixFactorModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list2 = (List)object;
            if (list2.isEmpty()) {
                return;
            }
            String string2 = ((Property)list2.get(0)).getId();
            for (NonNegativeMatrixFactorModelType nonNegativeMatrixFactorModelType : list) {
                if (!nonNegativeMatrixFactorModelType.getId().equals(string2)) continue;
                for (Property property : list2) {
                    NonNegativeMatrixFactorAlgoType nonNegativeMatrixFactorAlgoType = nonNegativeMatrixFactorModelType.getNonNegativeMatrixFactorAlgo();
                    if (nonNegativeMatrixFactorAlgoType == null) continue;
                    if (property.getDescription().equals(FEAT_NUM_FEATURES)) {
                        nonNegativeMatrixFactorAlgoType.setFEATNUMFEATURES((BigInteger)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(NMFS_CONV_TOLERANCE)) {
                        nonNegativeMatrixFactorAlgoType.setNMFSCONVTOLERANCE(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals(NMFS_NUM_ITERATIONS)) {
                        nonNegativeMatrixFactorAlgoType.setNMFSNUMITERATIONS(((Integer)property.getValue()).intValue());
                        continue;
                    }
                    if (!property.getDescription().equals(NMFS_RANDOM_SEED)) continue;
                    nonNegativeMatrixFactorAlgoType.setNMFSRANDOMSEED((BigInteger)property.getValue());
                }
                break;
            }
        } else if (string.equals("modelAdded")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list3 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)featureExtractionBuildNodeType, modelType);
                if (list3.contains(modelType)) continue;
                MetaDataHelper.addModel((BuildNodeType)featureExtractionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelRemoved")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list4 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)featureExtractionBuildNodeType, modelType);
                if (!list4.contains(modelType)) continue;
                MetaDataHelper.removeModel((BuildNodeType)featureExtractionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelsRerun")) {
            Map map = (Map)object;
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            FeatureExtractionBuildNodeType featureExtractionBuildNodeType2 = (FeatureExtractionBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)featureExtractionBuildNodeType2, string3);
                modelType.setStatus((ModelStatusType)map.get(string3));
            }
        } else if (string.equals("modelUseForOutput")) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            FeatureExtractionBuildNodeType featureExtractionBuildNodeType3 = (FeatureExtractionBuildNodeType)this.getData();
            for (Pair pair : list) {
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)featureExtractionBuildNodeType3, (String)pair.getFirst());
                modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(SETTINGS)) {
            List list = (List)complexProperty.getData();
            ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
            for (Property property : list) {
                String string = property.getId();
                String string2 = property.getDescription();
                Object object = this.getOldPropertyValue(string, string2);
                Property property2 = new Property(string, null, object, string2, null);
                arrayList.add(property2);
            }
            return arrayList;
        }
        if (complexProperty.getPropertyName().equals("modelsRerun")) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)featureExtractionBuildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelUseForOutput")) {
            List list = (List)complexProperty.getData();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Pair pair : list) {
                String string = (String)pair.getFirst();
                FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)featureExtractionBuildNodeType, string);
                boolean bl = modelType.isUseForOutput();
                Pair pair2 = new Pair((Object)string, (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        return super.getProperty(complexProperty);
    }

    private Object getOldPropertyValue(String string, String string2) {
        FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this.getData();
        ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)featureExtractionBuildNodeType, string);
        if (modelType == null) {
            return null;
        }
        if (modelType instanceof NonNegativeMatrixFactorModelType) {
            NonNegativeMatrixFactorAlgoType nonNegativeMatrixFactorAlgoType = ((NonNegativeMatrixFactorModelType)modelType).getNonNegativeMatrixFactorAlgo();
            if (string2.equals(FEAT_NUM_FEATURES)) {
                return nonNegativeMatrixFactorAlgoType.getFEATNUMFEATURES();
            }
            if (string2.equals(NMFS_CONV_TOLERANCE)) {
                return nonNegativeMatrixFactorAlgoType.getNMFSCONVTOLERANCE();
            }
            if (string2.equals(NMFS_NUM_ITERATIONS)) {
                return nonNegativeMatrixFactorAlgoType.getNMFSNUMITERATIONS();
            }
            if (string2.equals(NMFS_RANDOM_SEED)) {
                return nonNegativeMatrixFactorAlgoType.getNMFSRANDOMSEED();
            }
        }
        return null;
    }

    @Override
    public Object getProperty(String string) {
        return super.getProperty(string);
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return MiningFunctionType.FEATURE_EXTRACTION;
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return MiningFunctionType.FEATURE_EXTRACTION;
    }

    @Override
    public AttributeType getTargetAttribute() {
        return null;
    }

    @Override
    public List<RefModelType> getSVMLinearModels() throws Exception {
        return null;
    }

    @Override
    public String getHelpTopic() {
        return "feature_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_FEATURE_EXTRACTION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_FEATURE_EXTRACTION_ICON"));
    }
}

