/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.UnsupervisedBuildNode;
import oracle.dmt.dataminer.workflow.preferences.ClusteringModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.KMeansAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.KMeansModelType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.OClusterAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.OClusterModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Pair;

public final class ClusteringBuildNode
extends UnsupervisedBuildNode {
    public static final String KMSETTINGS = "kmeansSettings";
    public static final String CLUS_NUM_CLUSTERS = "CLUS_NUM_CLUSTERS";
    public static final String KMNS_BLOCK_GROWTH = "KMNS_BLOCK_GROWTH";
    public static final String KMNS_CONV_TOLERANCE = "KMNS_BLOCK_GROWTH";
    public static final String KMNS_DISTANCE = "KMNS_BLOCK_GROWTH";
    public static final String KMNS_ITERATIONS = "KMNS_BLOCK_GROWTH";
    public static final String KMNS_MIN_PCT_ATTR_SUPPORT = "KMNS_BLOCK_GROWTH";
    public static final String KMNS_NUM_BINS = "KMNS_BLOCK_GROWTH";
    public static final String KMNS_SPLIT_CRITERION = "KMNS_BLOCK_GROWTH";
    public static final String OCSETTINGS = "oclusterSettings";
    public static final String OCLT_MAX_BUFFER = "OCLT_MAX_BUFFER";
    public static final String OCLT_SENSITIVITY = "OCLT_SENSITIVITY";
    private static Preferences _p = Preferences.getPreferences();
    private ClusteringModelBuildPreferencesPanelSettings clustBuildPref = ClusteringModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)_p);

    public ClusteringBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
        ClusteringBuildNodeType.Models models = new ClusteringBuildNodeType.Models();
        clusteringBuildNodeType.setModels(models);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.clustBuildPref.isOC()) {
            arrayList.add("ALGO_O_CLUSTER");
        }
        if (this.clustBuildPref.isKM()) {
            arrayList.add("ALGO_KMEANS");
        }
        List<String> list = WorkflowUtils.getNewModelNames(context, "CLUSTERING", arrayList);
        int n = 0;
        ModelType modelType = null;
        if (this.clustBuildPref.isOC()) {
            modelType = this.createNewClusteringModel(list.get(n), "", (String)arrayList.get(n++));
            modelType.setUseForOutput(true);
            this.addOCModel((OClusterModelType)modelType);
        }
        if (this.clustBuildPref.isKM()) {
            modelType = this.createNewClusteringModel(list.get(n), "", (String)arrayList.get(n));
            modelType.setUseForOutput(true);
            this.addKMModel((KMeansModelType)modelType);
        }
        clusteringBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    public void addKMModel(KMeansModelType kMeansModelType) {
        ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
        ClusteringBuildNodeType.Models models = clusteringBuildNodeType.getModels();
        List list = models.getKMeansModel();
        list.add(kMeansModelType);
    }

    public void addOCModel(OClusterModelType oClusterModelType) {
        ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
        ClusteringBuildNodeType.Models models = clusteringBuildNodeType.getModels();
        List list = models.getOClusterModel();
        list.add(oClusterModelType);
    }

    public ModelType createNewClusteringModel(String string, String string2, String string3) {
        ModelType modelType = super.createNewModel(string, string2, "CLUSTERING", string3);
        return modelType;
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_CLUS_BUILD_NODE_NAME");
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
        ClusteringBuildNodeType.Models models = clusteringBuildNodeType.getModels();
        if (models.getKMeansModel().isEmpty() && models.getOClusterModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            if (bl2) {
                this.setNodeReady();
            }
            if (!this.validateModels(models.getKMeansModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getOClusterModel())) {
                bl3 = false;
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    public void setProperty(String string, Object object) {
        ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
        if (string.equals(KMSETTINGS)) {
            ClusteringBuildNodeType.Models models = clusteringBuildNodeType.getModels();
            List list = models.getKMeansModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list2 = (List)object;
            if (list2.isEmpty()) {
                return;
            }
            String string2 = ((Property)list2.get(0)).getId();
            for (KMeansModelType kMeansModelType : list) {
                if (!kMeansModelType.getId().equals(string2)) continue;
                KMeansAlgoType kMeansAlgoType = kMeansModelType.getKMeansAlgo();
                for (Property property : list2) {
                    if (property.getDescription().equals(CLUS_NUM_CLUSTERS)) {
                        kMeansAlgoType.setCLUSNUMCLUSTERS((BigInteger)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals("KMNS_BLOCK_GROWTH")) {
                        kMeansAlgoType.setKMNSBLOCKGROWTH(((Integer)property.getValue()).intValue());
                        continue;
                    }
                    if (property.getDescription().equals("KMNS_BLOCK_GROWTH")) {
                        kMeansAlgoType.setKMNSCONVTOLERANCE(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals("KMNS_BLOCK_GROWTH")) {
                        kMeansAlgoType.setKMNSDISTANCE((String)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals("KMNS_BLOCK_GROWTH")) {
                        kMeansAlgoType.setKMNSITERATIONS(((Integer)property.getValue()).intValue());
                        continue;
                    }
                    if (property.getDescription().equals("KMNS_BLOCK_GROWTH")) {
                        kMeansAlgoType.setKMNSMINPCTATTRSUPPORT(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals("KMNS_BLOCK_GROWTH")) {
                        kMeansAlgoType.setKMNSNUMBINS((BigInteger)property.getValue());
                        continue;
                    }
                    if (!property.getDescription().equals("KMNS_BLOCK_GROWTH")) continue;
                    kMeansAlgoType.setKMNSSPLITCRITERION((String)property.getValue());
                }
                break;
            }
        } else if (string.equals(OCSETTINGS)) {
            ClusteringBuildNodeType.Models models = clusteringBuildNodeType.getModels();
            List list = models.getOClusterModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list3 = (List)object;
            if (list3.isEmpty()) {
                return;
            }
            String string3 = ((Property)list3.get(0)).getId();
            for (OClusterModelType oClusterModelType : list) {
                if (!oClusterModelType.getId().equals(string3)) continue;
                for (Property property : list3) {
                    OClusterAlgoType oClusterAlgoType = oClusterModelType.getOClusterAlgo();
                    if (oClusterAlgoType == null) continue;
                    if (property.getDescription().equals(CLUS_NUM_CLUSTERS)) {
                        oClusterAlgoType.setCLUSNUMCLUSTERS((BigInteger)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals(OCLT_MAX_BUFFER)) {
                        oClusterAlgoType.setOCLTMAXBUFFER(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (!property.getDescription().equals(OCLT_SENSITIVITY)) continue;
                    oClusterAlgoType.setOCLTSENSITIVITY(((Double)property.getValue()).doubleValue());
                }
                break;
            }
        } else if (string.equals("modelAdded")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list4 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)clusteringBuildNodeType, modelType);
                if (list4.contains(modelType)) continue;
                MetaDataHelper.addModel((BuildNodeType)clusteringBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelRemoved")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list5 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)clusteringBuildNodeType, modelType);
                if (!list5.contains(modelType)) continue;
                MetaDataHelper.removeModel((BuildNodeType)clusteringBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelsRerun")) {
            Map map = (Map)object;
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            ClusteringBuildNodeType clusteringBuildNodeType2 = (ClusteringBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)clusteringBuildNodeType2, string4);
                modelType.setStatus((ModelStatusType)map.get(string4));
            }
        } else if (string.equals("modelUseForOutput")) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            ClusteringBuildNodeType clusteringBuildNodeType3 = (ClusteringBuildNodeType)this.getData();
            for (Pair pair : list) {
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)clusteringBuildNodeType3, (String)pair.getFirst());
                modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(KMSETTINGS) || complexProperty.getPropertyName().equals(OCSETTINGS)) {
            List list = (List)complexProperty.getData();
            ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
            for (Property property : list) {
                String string = property.getId();
                String string2 = property.getDescription();
                Object object = this.getOldPropertyValue(string, string2);
                Property property2 = new Property(string, null, object, string2, null);
                arrayList.add(property2);
            }
            return arrayList;
        }
        if (complexProperty.getPropertyName().equals("modelsRerun")) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)clusteringBuildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelUseForOutput")) {
            List list = (List)complexProperty.getData();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Pair pair : list) {
                String string = (String)pair.getFirst();
                ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)clusteringBuildNodeType, string);
                boolean bl = modelType.isUseForOutput();
                Pair pair2 = new Pair((Object)string, (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        return super.getProperty(complexProperty);
    }

    private Object getOldPropertyValue(String string, String string2) {
        ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this.getData();
        ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)clusteringBuildNodeType, string);
        if (modelType == null) {
            return null;
        }
        if (modelType instanceof KMeansModelType) {
            KMeansAlgoType kMeansAlgoType = ((KMeansModelType)modelType).getKMeansAlgo();
            if (string2.equals(CLUS_NUM_CLUSTERS)) {
                return kMeansAlgoType.getCLUSNUMCLUSTERS();
            }
            if (string2.equals("KMNS_BLOCK_GROWTH")) {
                return kMeansAlgoType.getKMNSBLOCKGROWTH();
            }
            if (string2.equals("KMNS_CONV_TOLERANCE")) {
                return kMeansAlgoType.getKMNSCONVTOLERANCE();
            }
            if (string2.equals("KMNS_DISTANCE")) {
                return kMeansAlgoType.getKMNSDISTANCE();
            }
            if (string2.equals("KMNS_ITERATIONS")) {
                return kMeansAlgoType.getKMNSITERATIONS();
            }
            if (string2.equals("KMNS_MIN_PCT_ATTR_SUPPORT")) {
                return kMeansAlgoType.getKMNSMINPCTATTRSUPPORT();
            }
            if (string2.equals("KMNS_NUM_BINS")) {
                return kMeansAlgoType.getKMNSNUMBINS();
            }
            if (string2.equals("KMNS_SPLIT_CRITERION")) {
                return kMeansAlgoType.getKMNSSPLITCRITERION();
            }
        } else if (modelType instanceof OClusterModelType) {
            OClusterAlgoType oClusterAlgoType = ((OClusterModelType)modelType).getOClusterAlgo();
            if (string2.equals(CLUS_NUM_CLUSTERS)) {
                return oClusterAlgoType.getCLUSNUMCLUSTERS();
            }
            if (string2.equals(OCLT_MAX_BUFFER)) {
                return oClusterAlgoType.getOCLTMAXBUFFER();
            }
            if (string2.equals(OCLT_SENSITIVITY)) {
                return oClusterAlgoType.getOCLTSENSITIVITY();
            }
        }
        return null;
    }

    @Override
    public Object getProperty(String string) {
        return super.getProperty(string);
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return MiningFunctionType.CLUSTERING;
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return MiningFunctionType.CLUSTERING;
    }

    @Override
    public AttributeType getTargetAttribute() {
        return null;
    }

    @Override
    public List<RefModelType> getSVMLinearModels() throws Exception {
        return null;
    }

    @Override
    public String getHelpTopic() {
        return "clustering_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_CLUSTERING_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_CLUSTERING_ICON"));
    }
}

