/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import javax.swing.Icon;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeRefType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeReference;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.ide.Context;

public final class BuildTextNodeRef
extends AbstractTextNode {
    public static final String ADD_BUILD_TEXT_REFERENCE = "addBuildTextReference";
    public static final String NODE_REFERENCE = "nodeReference";
    public static final String ADD_ALL_STOPLISTS = "addAllStoplists";

    public BuildTextNodeRef(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public String getHelpTopic() {
        return "build_text_ref_node";
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_TEXT_NODE_NAME");
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_TEXT_SETTINGS_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_TEXT_SETTINGS_ICON"));
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        return false;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        throw new RuntimeException("This is not allowed");
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        throw new RuntimeException("This is not allowed");
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        BuildTextNodeRefType buildTextNodeRefType = (BuildTextNodeRefType)this.getData();
        NodeReference nodeReference = buildTextNodeRefType.getNodeReference();
        CaseAttributes caseAttributes = new CaseAttributes();
        buildTextNodeRefType.setCaseAttributes(caseAttributes);
        TextNodeType.Stoplists stoplists = new TextNodeType.Stoplists();
        buildTextNodeRefType.setStoplists(stoplists);
        TransformationSourceAttributes transformationSourceAttributes = new TransformationSourceAttributes();
        buildTextNodeRefType.setTransformationSourceAttributes(transformationSourceAttributes);
        TransformedAttributesType transformedAttributesType = new TransformedAttributesType();
        buildTextNodeRefType.setTransformedAttributes(transformedAttributesType);
        buildTextNodeRefType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public boolean validate(boolean bl) {
        boolean bl2 = super.validate(bl);
        if (bl2) {
            bl2 = this.validateNodeReference();
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    public boolean validateNodeReference() {
        boolean bl = false;
        BuildTextNodeRefType buildTextNodeRefType = (BuildTextNodeRefType)this.getData();
        NodeReference nodeReference = buildTextNodeRefType.getNodeReference();
        if (nodeReference != null && nodeReference.getNodeId() != null && nodeReference.getNodeId().intValue() > 0 && nodeReference.getNodeName() != null && nodeReference.getNodeName().length() > 0 && nodeReference.getProjectId() != null && nodeReference.getProjectId().intValue() > 0 && nodeReference.getProjectName() != null && nodeReference.getProjectName().length() > 0 && nodeReference.getWorkflowId() != null && nodeReference.getWorkflowId().intValue() > 0 && nodeReference.getWorkflowName() != null && nodeReference.getWorkflowName().length() > 0) {
            bl = true;
        }
        if (!bl) {
            this.addMessage("BUILD_TEXT_REF_NO_REFERENCE", MessageEnumType.INCOMPLETE, new String[0]);
        }
        return bl;
    }

    public static void copyNodeDetails(BuildTextNodeType buildTextNodeType, BuildTextNodeRefType buildTextNodeRefType) {
        AttributeType attributeType;
        int n;
        buildTextNodeRefType.getCaseAttributes().getAttribute().clear();
        for (n = 0; n < buildTextNodeType.getCaseAttributes().getAttribute().size(); ++n) {
            attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(buildTextNodeType.getCaseAttributes().getAttribute().get(n));
            buildTextNodeRefType.getCaseAttributes().getAttribute().add(attributeType);
        }
        buildTextNodeRefType.getStoplists().getStoplist().clear();
        for (n = 0; n < buildTextNodeType.getStoplists().getStoplist().size(); ++n) {
            attributeType = (StoplistType)MetaDataHelper.copyMetadataObject(buildTextNodeType.getStoplists().getStoplist().get(n));
            buildTextNodeRefType.getStoplists().getStoplist().add(attributeType);
        }
        buildTextNodeRefType.getTransformationSourceAttributes().getTransformationSourceAttributeType().clear();
        for (n = 0; n < buildTextNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType().size(); ++n) {
            attributeType = (TransformationSourceAttribute)buildTextNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType().get(n);
            TransformationSourceAttribute transformationSourceAttribute = (TransformationSourceAttribute)MetaDataHelper.copyMetadataObject(attributeType);
            buildTextNodeRefType.getTransformationSourceAttributes().getTransformationSourceAttributeType().add(transformationSourceAttribute);
        }
        buildTextNodeRefType.getTransformedAttributes().getMapTextTransformedSource().clear();
        TransformedAttributesType transformedAttributesType = (TransformedAttributesType)MetaDataHelper.copyMetadataObject(buildTextNodeType.getTransformedAttributes());
        buildTextNodeRefType.setTransformedAttributes(transformedAttributesType);
    }

    @Override
    public Object getProperty(String string) {
        BuildTextNodeRefType buildTextNodeRefType = (BuildTextNodeRefType)this.getData();
        Object object = null;
        if (string.equals(NODE_REFERENCE)) {
            NodeReference nodeReference;
            object = nodeReference = buildTextNodeRefType.getNodeReference();
        } else if (string.equals("allXfomNodeColumns")) {
            object = AttributeTypeHelper.getAllColumns((TextNodeType)buildTextNodeRefType);
        } else if (string.equals(ADD_ALL_STOPLISTS)) {
            object = buildTextNodeRefType.getStoplists();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(NODE_REFERENCE)) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string, Object object) {
        BuildTextNodeRefType buildTextNodeRefType = (BuildTextNodeRefType)this.getData();
        if (string.equals(NODE_REFERENCE)) {
            if (object instanceof NodeReference) {
                buildTextNodeRefType.setNodeReference((NodeReference)object);
            } else {
                buildTextNodeRefType.setNodeReference(null);
            }
        } else if (string.equals("allXfomNodeColumns")) {
            AttributeTypeHelper.TextTransformationNodeColumns textTransformationNodeColumns = (AttributeTypeHelper.TextTransformationNodeColumns)object;
            AttributeTypeHelper.copyTransformedAttributesType(buildTextNodeRefType.getTransformedAttributes(), textTransformationNodeColumns.getXformedAttributes());
            AttributeTypeHelper.copyTransformationSourceAttributes(buildTextNodeRefType.getTransformationSourceAttributes().getTransformationSourceAttributeType(), textTransformationNodeColumns.getXformSourceAttributes().getTransformationSourceAttributeType());
        } else if (string.equals(ADD_ALL_STOPLISTS)) {
            TextNodeType.Stoplists stoplists = (TextNodeType.Stoplists)object;
            buildTextNodeRefType.setStoplists((TextNodeType.Stoplists)object);
        } else {
            super.setProperty(string, object);
        }
    }
}

