/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.math.BigInteger;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.SampleSettingsProperties;
import oracle.dmt.dataminer.workflow.preferences.CacheSettingsPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleSettings;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public final class ApplyTextNode
extends AbstractTextNode
implements SampleSettingsProperties {
    public static final String SOURCE_COLUMNS = "sourceColumns";
    public static final String SAMPLE_SETTINGS = "sampleSize";

    @Override
    public void refactor(Node node, boolean bl) throws Exception {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        TransformedAttributesType transformedAttributesType = null;
        if (node instanceof AbstractTextNode) {
            TextNodeType textNodeType = (TextNodeType)node.getData();
            transformedAttributesType = (TransformedAttributesType)MetaDataHelper.copyMetadataObject(textNodeType.getTransformedAttributes());
            for (MapTextTransformedSourceType mapTextTransformedSourceType : transformedAttributesType.getMapTextTransformedSource()) {
                boolean bl2;
                boolean bl3 = bl2 = mapTextTransformedSourceType.getKey().getTransformationElement().getTheme() == null;
                if (bl2) {
                    mapTextTransformedSourceType.getKey().getTransformationElement().getToken().getToken().setFeatureTable(null);
                    continue;
                }
                mapTextTransformedSourceType.getKey().getTransformationElement().getTheme().getToken().setFeatureTable(null);
            }
        }
        if (transformedAttributesType != null) {
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "editColumns", transformedAttributesType);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        }
        super.refactor(node, bl);
    }

    public ApplyTextNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_APPLY_TEXT_NODE_NAME");
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_APPLY_TEXT_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_APPLY_TEXT_ICON"));
    }

    @Override
    public void initNewInstance(Context context) {
        Number number;
        super.initNewInstance(context);
        ApplyTextNodeType applyTextNodeType = (ApplyTextNodeType)this.getData();
        CaseAttributes caseAttributes = new CaseAttributes();
        applyTextNodeType.setCaseAttributes(caseAttributes);
        TextNodeType.Stoplists stoplists = new TextNodeType.Stoplists();
        applyTextNodeType.setStoplists(stoplists);
        TransformationSourceAttributes transformationSourceAttributes = new TransformationSourceAttributes();
        applyTextNodeType.setTransformationSourceAttributes(transformationSourceAttributes);
        TransformedAttributesType transformedAttributesType = new TransformedAttributesType();
        applyTextNodeType.setTransformedAttributes(transformedAttributesType);
        Preferences preferences = Preferences.getPreferences();
        CacheSettingsPanelSettings cacheSettingsPanelSettings = CacheSettingsPanelSettings.getInstance((PropertyStorage)preferences);
        SampleSettings sampleSettings = new SampleSettings();
        if (cacheSettingsPanelSettings.isPercent()) {
            number = cacheSettingsPanelSettings.getPercentValue();
            sampleSettings.setPercentOfTotal(number);
        } else {
            number = cacheSettingsPanelSettings.getNumberOfRows();
            sampleSettings.setNumberOfRows((Long)number);
        }
        number = new SampleSettings.Method();
        SampleSettings.Method.Random random = new SampleSettings.Method.Random();
        random.setSeed(BigInteger.valueOf(cacheSettingsPanelSettings.getSeed()));
        number.setRandom(random);
        sampleSettings.setMethod((SampleSettings.Method)number);
        sampleSettings.setUseFullData(false);
        sampleSettings.setGenerateCache(Boolean.valueOf(true));
        applyTextNodeType.setSampleSettings(sampleSettings);
        applyTextNodeType.getCacheSettings().setUseFullData(Boolean.valueOf(false));
        applyTextNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public String getHelpTopic() {
        return "apply_text_node";
    }

    @Override
    public boolean allowMoreThanOneInputNode() {
        return true;
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = super.isAllowedConnectionFrom(node);
        if (!bl) {
            return bl;
        }
        if (node instanceof DataProvider && !(node instanceof AbstractTextNode)) {
            List<AbstractNode> list = this.findParentNodes();
            for (AbstractNode abstractNode : list) {
                if (!(abstractNode instanceof DataProvider) || abstractNode instanceof AbstractTextNode) continue;
                bl = false;
                break;
            }
        } else if (node instanceof AbstractTextNode) {
            List<AbstractNode> list = this.findParentNodes();
            for (AbstractNode abstractNode : list) {
                if (!(abstractNode instanceof AbstractTextNode)) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private void syncTextNodeAttrs(AbstractTextNode abstractTextNode, boolean bl) {
        if (abstractTextNode != null) {
            Object object;
            Object object22;
            Object object32;
            CaseAttributes caseAttributes = new CaseAttributes();
            TextNodeType.Stoplists stoplists = new TextNodeType.Stoplists();
            TransformationSourceAttributes transformationSourceAttributes = new TransformationSourceAttributes();
            TransformedAttributesType transformedAttributesType = new TransformedAttributesType();
            ApplyTextNodeType applyTextNodeType = (ApplyTextNodeType)this.getData();
            TextNodeType textNodeType = (TextNodeType)abstractTextNode.getData();
            for (Object object32 : textNodeType.getCaseAttributes().getAttribute()) {
                object22 = (AttributeType)MetaDataHelper.copyMetadataObject(object32);
                caseAttributes.getAttribute().add(object22);
            }
            for (int i = 0; i < textNodeType.getStoplists().getStoplist().size(); ++i) {
                object32 = (StoplistType)MetaDataHelper.copyMetadataObject(textNodeType.getStoplists().getStoplist().get(i));
                stoplists.getStoplist().add(object32);
            }
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (Object object22 : applyTextNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType()) {
                hashMap.put(object22.getName(), object22.isIsOutput());
            }
            for (Object object22 : applyTextNodeType.getTransformedAttributes().getMapTextTransformedSource()) {
                hashMap.put(object22.getKey().getName(), object22.getKey().isIsOutput());
            }
            for (Object object22 : textNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType()) {
                object = (TransformationSourceAttribute)MetaDataHelper.copyMetadataObject(object22);
                if (hashMap.containsKey(object.getName())) {
                    object.setIsOutput(((Boolean)hashMap.get(object.getName())).booleanValue());
                }
                transformationSourceAttributes.getTransformationSourceAttributeType().add(object);
            }
            for (Object object22 : textNodeType.getTransformedAttributes().getMapTextTransformedSource()) {
                object = (MapTextTransformedSourceType)MetaDataHelper.copyMetadataObject(object22);
                if (hashMap.containsKey(object.getKey().getName())) {
                    object.getKey().setIsOutput(((Boolean)hashMap.get(object.getKey().getName())).booleanValue());
                }
                if (bl) {
                    boolean bl2;
                    boolean bl3 = bl2 = object.getKey().getTransformationElement().getTheme() == null;
                    if (bl2) {
                        object.getKey().getTransformationElement().getToken().getToken().setFeatureTable(null);
                    } else {
                        object.getKey().getTransformationElement().getTheme().getToken().setFeatureTable(null);
                    }
                }
                transformedAttributesType.getMapTextTransformedSource().add(object);
            }
            object32 = new ArrayList();
            object22 = (OdmrSDMUndoFilter)this.getUndoFilter();
            object = new ComplexProperty("editColumns", transformedAttributesType);
            ((ComplexProperty)object).setOldData(applyTextNodeType.getTransformedAttributes());
            object32.add(object);
            object = new ComplexProperty(SOURCE_COLUMNS, transformationSourceAttributes);
            ((ComplexProperty)object).setOldData(applyTextNodeType.getTransformationSourceAttributes());
            object32.add(object);
            object = new ComplexProperty("caseAttribute", caseAttributes);
            ((ComplexProperty)object).setOldData(applyTextNodeType.getCaseAttributes());
            object32.add(object);
            object = new ComplexProperty("editStoplists", stoplists);
            ((ComplexProperty)object).setOldData(applyTextNodeType.getStoplists());
            object32.add(object);
            ComplexProperty complexProperty = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
            complexProperty.setOldData(this.getSQLExpression());
            object32.add(complexProperty);
            ((OdmrSDMUndoFilter)((Object)object22)).prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object32);
        }
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        if (!(node instanceof DataProvider) && !(node instanceof AbstractTextNode)) {
            return;
        }
        super.handleNewConnectionFrom(node);
        this.validate(true, false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    public List<AttributeType> getCaseAttributes() {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider) || abstractNode instanceof AbstractTextNode) continue;
            DataProvider dataProvider = (DataProvider)((Object)abstractNode);
            for (AttributeType attributeType : dataProvider.getAttributes().getAttribute()) {
                if (!DatabaseMetadataUtils.isKeyDataTypeSupported(attributeType.getDataType())) continue;
                arrayList.add(attributeType);
            }
        }
        return arrayList;
    }

    @Override
    public void setNodeReady() {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ComplexProperty complexProperty = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty.setOldData(this.getSQLExpression());
        ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
        arrayList.add(complexProperty);
        ComplexProperty complexProperty2 = new ComplexProperty("status", NodeStatusType.READY);
        arrayList.add(complexProperty2);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
    }

    @Override
    public Object getProperty(String string) {
        ApplyTextNodeType applyTextNodeType = (ApplyTextNodeType)this.getData();
        TransformationSourceAttributes transformationSourceAttributes = null;
        if (string.equals(SOURCE_COLUMNS)) {
            transformationSourceAttributes = applyTextNodeType.getTransformationSourceAttributes();
        }
        if (!(string.equals(SAMPLE_SETTINGS_PERCENT) || string.equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || string.equals(SAMPLE_SETTINGS_SEED) || string.equals(SAMPLE_SETTINGS_TARGET) || string.equals(SAMPLE_SETTINGS_RANDOM) || string.equals(SAMPLE_SETTINGS_STRATIFIED) || string.equals(SAMPLE_SETTINGS_TOPN))) {
            return super.getProperty(string);
        }
        SampleSettings sampleSettings = applyTextNodeType.getSampleSettings();
        transformationSourceAttributes = sampleSettings;
        return transformationSourceAttributes;
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(SOURCE_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_PERCENT) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_SEED) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_TARGET) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_RANDOM) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_STRATIFIED) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_TOPN) || complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string, Object object) {
        ApplyTextNodeType applyTextNodeType = (ApplyTextNodeType)this.getData();
        if (string.equals(SOURCE_COLUMNS)) {
            TransformationSourceAttributes transformationSourceAttributes = (TransformationSourceAttributes)object;
            applyTextNodeType.setTransformationSourceAttributes(transformationSourceAttributes);
        }
        if (string.equals(SAMPLE_SETTINGS_PERCENT) || string.equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || string.equals(SAMPLE_SETTINGS_SEED) || string.equals(SAMPLE_SETTINGS_TARGET) || string.equals(SAMPLE_SETTINGS_RANDOM) || string.equals(SAMPLE_SETTINGS_STRATIFIED) || string.equals(SAMPLE_SETTINGS_TOPN)) {
            if (object instanceof SampleSettings) {
                applyTextNodeType.setSampleSettings((SampleSettings)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public String generateSQLExpression() {
        AbstractNode abstractNode;
        List list;
        Object object3;
        Object object2;
        List list2;
        TransformationSourceAttributes transformationSourceAttributes;
        ApplyTextNodeType applyTextNodeType = (ApplyTextNodeType)this.getData();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT " + (ApplyTextNode.generateSQLInlineHint() ? "/*+ inline */" : "") + "\n");
        AttributeType attributeType = null;
        boolean bl = false;
        if (applyTextNodeType.getCaseAttributes().getAttribute().size() > 0) {
            attributeType = (AttributeType)applyTextNodeType.getCaseAttributes().getAttribute().get(0);
        }
        if (attributeType != null) {
            stringBuilder.append("\"" + attributeType.getName() + "\"");
            bl = true;
        }
        if ((transformationSourceAttributes = applyTextNodeType.getTransformationSourceAttributes()) != null && (list2 = transformationSourceAttributes.getTransformationSourceAttributeType()) != null && list2.size() > 0) {
            for (int i = 0; i < list2.size(); ++i) {
                if (!((TransformationSourceAttribute)list2.get(i)).isIsOutput() || attributeType != null && ((TransformationSourceAttribute)list2.get(i)).getName().compareTo(attributeType.getName()) == 0) continue;
                if (bl) {
                    stringBuilder.append(",\n");
                }
                object2 = null;
                object2 = !StringUtils.isDoubleQuotedString(((TransformationSourceAttribute)list2.get(i)).getName()) ? "\"" + ((TransformationSourceAttribute)list2.get(i)).getName() + "\"" : ((TransformationSourceAttribute)list2.get(i)).getName();
                stringBuilder.append((String)object2);
                bl = true;
                object3 = ((TransformationSourceAttribute)list2.get(i)).getAlias();
                if (object3 == null || ((String)object3).isEmpty()) continue;
                if (!StringUtils.isDoubleQuotedString((String)object3)) {
                    object3 = "\"" + (String)object3 + "\"";
                }
                stringBuilder.append(" AS ");
                stringBuilder.append((String)object3);
            }
        }
        if ((list2 = applyTextNodeType.getTransformedAttributes()) != null && (list = list2.getMapTextTransformedSource()) != null && !list.isEmpty()) {
            for (Object object3 : list) {
                String string;
                String string2;
                abstractNode = object3.getKey();
                if (!abstractNode.isIsOutput()) continue;
                String string3 = null;
                String string4 = null;
                boolean bl2 = true;
                String string5 = null;
                TransformationTokenType transformationTokenType = abstractNode.getTransformationElement().getToken();
                if (transformationTokenType == null) {
                    bl2 = false;
                    transformationTokenType = abstractNode.getTransformationElement().getTheme();
                    string5 = ((TextTransformationType.Theme)transformationTokenType).getType().equals("Full") ? "1" : "0";
                }
                string4 = transformationTokenType.getToken().getPolicy();
                if (transformationTokenType.getToken().getStatisticTable() != null) {
                    string3 = transformationTokenType.getToken().getStatisticTable().getName();
                }
                String string6 = transformationTokenType.getToken().getMaxNumberPerDoc().toString();
                String string7 = transformationTokenType.getToken().getFrequency();
                if (string3 == null || string4 == "") continue;
                if (bl) {
                    stringBuilder.append(",\n");
                }
                if (!StringUtils.isDoubleQuotedString(string2 = abstractNode.getSource())) {
                    string2 = "\"" + string2 + "\"";
                }
                String string8 = string = (string = abstractNode.getAlias()) == null ? abstractNode.getName() : string;
                if (!StringUtils.isDoubleQuotedString(string)) {
                    string = "\"" + string + "\"";
                }
                String string9 = null;
                string9 = bl2 ? "ODMR_ENGINE_TEXT.dm_text_token_features('" + StringUtils.escapeSingleQuotesForSQL(string4) + "', " + string2 + ", '" + StringUtils.escapeSingleQuotesForSQL(string3) + "', '" + StringUtils.trimDoubleQuotes(StringUtils.escapeSingleQuotesForSQL(string2)) + "', " + string6 + ", '" + string7 + "') " + string : "ODMR_ENGINE_TEXT.dm_text_theme_features('" + StringUtils.escapeSingleQuotesForSQL(string4) + "', " + string2 + ", '" + StringUtils.escapeSingleQuotesForSQL(string3) + "', '" + StringUtils.trimDoubleQuotes(StringUtils.escapeSingleQuotesForSQL(string2)) + "', " + string5 + ", " + string6 + ", '" + string7 + "') " + string;
                stringBuilder.append(string9);
                bl = true;
            }
        }
        String string = null;
        object2 = this.findParentNodes();
        object3 = object2.iterator();
        while (object3.hasNext()) {
            abstractNode = object3.next();
            if (!(abstractNode instanceof DataProvider) || abstractNode instanceof AbstractTextNode) continue;
            string = abstractNode.getMetadataId();
            break;
        }
        stringBuilder.append(" FROM {INPUT_SOURCE:" + string + "}");
        return this.wrapExpressionInWithClause(stringBuilder.toString());
    }

    @Override
    protected void getInternalStackedSQL(AbstractDataNode abstractDataNode, StringBuffer stringBuffer) {
        boolean bl;
        boolean bl2 = bl = this.getState().equals((Object)NodeStatusType.COMPLETE) || this.getState().equals((Object)NodeStatusType.WARNING) || this.getState().equals((Object)NodeStatusType.READY) || !this.getState().equals((Object)NodeStatusType.FAILURE) || !this.getState().equals((Object)NodeStatusType.INVALID);
        if (!bl) {
            return;
        }
        List<AbstractNode> list = abstractDataNode.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof AbstractDataNode) || abstractNode instanceof BuildTextNode || abstractNode instanceof BuildTextNodeRef) continue;
            AbstractDataNode abstractDataNode2 = (AbstractDataNode)abstractNode;
            this.replaceSQLExpressionWithNodeName(abstractDataNode2, stringBuffer);
            stringBuffer.insert(0, "\n" + this.getSQLNodeComment(abstractDataNode2, true) + abstractDataNode2.getSQLExpression() + this.getSQLNodeComment(abstractDataNode2, false) + ",\n");
            abstractDataNode2.getInternalStackedSQL(abstractDataNode2, stringBuffer);
        }
    }

    public boolean validate(boolean bl, boolean bl2) {
        Object object;
        boolean bl3 = super.validate(bl2);
        if (bl3) {
            object = null;
            List<AbstractNode> list = this.findParentNodes();
            for (AbstractNode abstractNode : list) {
                if (!(abstractNode instanceof AbstractTextNode)) continue;
                object = (AbstractTextNode)abstractNode;
                break;
            }
            this.syncTextNodeAttrs((AbstractTextNode)object, bl);
        }
        if (bl3) {
            bl3 = this.validateInputAttributes();
        }
        object = (ApplyTextNodeType)this.getData();
        if (bl3 && (null == object.getTransformationSourceAttributes() || null == object.getTransformationSourceAttributes().getTransformationSourceAttributeType() || object.getTransformationSourceAttributes().getTransformationSourceAttributeType().isEmpty())) {
            bl3 = false;
            this.addMessage("TRANSFORM_NODE_SOURCE_COLUMNS_MISSING", MessageEnumType.INCOMPLETE, new String[0]);
        }
        if (bl3) {
            bl3 = this.validateNode();
        }
        this.setState(bl3);
        if (bl2) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validate(false, bl);
    }

    public List<AbstractNode> findDataNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider) || abstractNode instanceof AbstractTextNode) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    public boolean validateNode() {
        boolean bl = true;
        List<AbstractNode> list = this.findDataNodes();
        if (list.size() < 1) {
            this.addMessage("APPLY_TEXT_NO_DATA", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        List<AbstractNode> list2 = this.findParentNodes();
        for (AbstractNode abstractNode : list2) {
            if (abstractNode instanceof BuildTextNode) {
                bl2 = true;
                continue;
            }
            if (!(abstractNode instanceof BuildTextNodeRef)) continue;
            bl3 = true;
        }
        if (!bl2 && !bl3 || bl2 && bl3) {
            this.addMessage("APPLY_TEXT_ONE_BUILD_TEXT", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        return bl;
    }

    private boolean validateInputAttributes() {
        ComplexProperty complexProperty;
        Object object;
        Object object2;
        TransformedAttributesType transformedAttributesType;
        Object object3;
        AttributeType attributeType2;
        Object object42;
        AbstractNode abstractNode3;
        AbstractNode abstractNode2 = null;
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode3 : list) {
            if (!(abstractNode3 instanceof DataProvider) || abstractNode3 instanceof AbstractTextNode) continue;
            abstractNode2 = abstractNode3;
            break;
        }
        ApplyTextNodeType applyTextNodeType = (ApplyTextNodeType)this.getData();
        abstractNode3 = new CaseAttributes();
        if (!applyTextNodeType.getCaseAttributes().getAttribute().isEmpty()) {
            for (Object object42 : applyTextNodeType.getCaseAttributes().getAttribute()) {
                attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(object42);
                abstractNode3.getAttribute().add(attributeType2);
            }
        }
        TransformationSourceAttributes transformationSourceAttributes = new TransformationSourceAttributes();
        for (AttributeType attributeType2 : applyTextNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType()) {
            object3 = (TransformationSourceAttribute)MetaDataHelper.copyMetadataObject(attributeType2);
            transformationSourceAttributes.getTransformationSourceAttributeType().add(object3);
        }
        object42 = transformationSourceAttributes.getTransformationSourceAttributeType();
        attributeType2 = null;
        object3 = (DataProvider)((Object)abstractNode2);
        if (object3 != null) {
            attributeType2 = object3.getAttributes();
        }
        List list2 = attributeType2 != null ? attributeType2.getAttribute() : new ArrayList();
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType3 : list2) {
            String string = attributeType3.getAlias();
            String string2 = string != null && string.trim().length() > 0 ? string : attributeType3.getName();
            hashMap.put(string2, attributeType3);
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!applyTextNodeType.getCaseAttributes().getAttribute().isEmpty()) {
            AttributeType attributeType4 = (AttributeType)applyTextNodeType.getCaseAttributes().getAttribute().get(0);
            transformedAttributesType = (AttributeType)hashMap.get(attributeType4.getName());
            if (null == transformedAttributesType || !transformedAttributesType.getDataType().equals(attributeType4.getDataType())) {
                attributeType4.setStatus(AttributeStatus.INVALID);
                bl4 = true;
                bl = false;
            } else {
                attributeType4.setStatus(transformedAttributesType.getStatus());
                bl4 = true;
            }
        }
        if (!bl) {
            this.addMessage("SAMPLE_INVAL_CASEID", MessageEnumType.WARNING, new String[0]);
        }
        boolean bl5 = true;
        transformedAttributesType = (TransformedAttributesType)MetaDataHelper.copyMetadataObject(applyTextNodeType.getTransformedAttributes());
        ArrayList<TransformationSourceAttribute> arrayList = new ArrayList<TransformationSourceAttribute>();
        Object object5 = object42.iterator();
        while (object5.hasNext()) {
            object2 = (TransformationSourceAttribute)object5.next();
            if (object3 == null) {
                object2.setStatus(AttributeStatus.INVALID);
                bl3 = true;
                if (!this.isColumnUsedForTransformations(transformedAttributesType, (TransformationSourceAttribute)object2)) continue;
                bl2 = true;
                bl5 = false;
                continue;
            }
            object = (AttributeType)hashMap.get(object2.getName());
            if (null == object || !object.getDataType().equals(object2.getDataType())) {
                if (!this.isColumnUsedForTransformations(transformedAttributesType, (TransformationSourceAttribute)object2)) {
                    arrayList.add((TransformationSourceAttribute)object2);
                    continue;
                }
                object2.setStatus(AttributeStatus.INVALID);
                bl3 = true;
                if (this.isColumnUsedForTransformations(transformedAttributesType, (TransformationSourceAttribute)object2)) {
                    bl2 = true;
                }
                bl5 = false;
                continue;
            }
            object2.setStatus(object.getStatus());
            bl3 = true;
            if (this.isColumnUsedForTransformations(transformedAttributesType, (TransformationSourceAttribute)object2)) {
                bl2 = true;
            }
            hashMap.remove(object2.getName());
        }
        if (!bl5) {
            this.addMessage("TRANSFORM_NODE_INVALID_ATTR", MessageEnumType.WARNING, new String[0]);
        }
        if (!arrayList.isEmpty()) {
            this.removeMissingColumns(transformationSourceAttributes.getTransformationSourceAttributeType(), arrayList);
            bl3 = true;
        }
        if (!(object5 = new ArrayList(hashMap.values())).isEmpty()) {
            ApplyTextNode.copyAttributes(transformationSourceAttributes.getTransformationSourceAttributeType(), (List<AttributeType>)object5);
            bl3 = true;
        }
        object2 = new ArrayList();
        object = (OdmrSDMUndoFilter)this.getUndoFilter();
        if (bl3) {
            complexProperty = new ComplexProperty(SOURCE_COLUMNS, transformationSourceAttributes);
            complexProperty.setOldData(applyTextNodeType.getTransformationSourceAttributes());
            object2.add(complexProperty);
        }
        if (bl2) {
            complexProperty = new ComplexProperty("editColumns", transformedAttributesType);
            complexProperty.setOldData(applyTextNodeType.getTransformedAttributes());
            object2.add(complexProperty);
        }
        if (bl4) {
            complexProperty = new ComplexProperty("caseAttribute", abstractNode3);
            complexProperty.setOldData(applyTextNodeType.getCaseAttributes());
            object2.add(complexProperty);
        }
        complexProperty = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty.setOldData(this.getSQLExpression());
        object2.add(complexProperty);
        ((OdmrSDMUndoFilter)((Object)object)).prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object2);
        return bl && bl5;
    }

    private boolean isColumnUsedForTransformations(TransformedAttributesType transformedAttributesType, TransformationSourceAttribute transformationSourceAttribute) {
        boolean bl = false;
        for (MapTextTransformedSourceType mapTextTransformedSourceType : transformedAttributesType.getMapTextTransformedSource()) {
            String string = mapTextTransformedSourceType.getKey().getSource();
            if (!string.equals(transformationSourceAttribute.getName())) continue;
            bl = true;
            mapTextTransformedSourceType.getKey().setStatus(transformationSourceAttribute.getStatus());
        }
        return bl;
    }

    private void removeMissingColumns(List<TransformationSourceAttribute> list, List<TransformationSourceAttribute> list2) {
        HashMap<String, TransformationSourceAttribute> hashMap = new HashMap<String, TransformationSourceAttribute>(list.size());
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            hashMap.put(transformationSourceAttribute.getName(), transformationSourceAttribute);
        }
        for (TransformationSourceAttribute transformationSourceAttribute : list2) {
            TransformationSourceAttribute transformationSourceAttribute2 = (TransformationSourceAttribute)hashMap.get(transformationSourceAttribute.getName());
            list.remove(transformationSourceAttribute2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Features> loadFeatures(Context context, TextTransformationOutputAttributeType textTransformationOutputAttributeType) {
        ArrayList<Features> arrayList = new ArrayList<Features>();
        Connection connection = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            if (textTransformationOutputAttributeType != null) {
                ResultType resultType;
                TransformationTokenType transformationTokenType = textTransformationOutputAttributeType.getTransformationElement().getToken();
                if (transformationTokenType == null) {
                    transformationTokenType = textTransformationOutputAttributeType.getTransformationElement().getTheme();
                }
                if ((resultType = transformationTokenType.getToken().getFeatureTable()) != null) {
                    connection = Connections.getSharedConnection(context);
                    String string = resultType.getName();
                    if (string != null) {
                        ArrayList<AbstractTextNode.Statistics> arrayList2 = new ArrayList<AbstractTextNode.Statistics>();
                        String string2 = "select r.CASE_COLUMN, r.TEXT_COLUMN, s.ATTRIBUTE_NAME, s.VALUE from " + string + " r, TABLE(r.FEATURES) s";
                        sQLHelper.pstmt = connection.prepareStatement(string2);
                        sQLHelper.pstmt.setFetchSize(100);
                        sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                        Object object = null;
                        Object object2 = null;
                        Object object3 = null;
                        Object object4 = null;
                        String string3 = null;
                        Integer n = null;
                        while (sQLHelper.rs.next()) {
                            object = sQLHelper.rs.getObject("CASE_COLUMN");
                            object3 = sQLHelper.rs.getObject("TEXT_COLUMN");
                            string3 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                            n = sQLHelper.rs.getInt("VALUE");
                            if (object2 == null) {
                                object2 = object;
                                object4 = object3;
                            }
                            if (object2.toString().compareTo(object.toString()) != 0) {
                                arrayList.add(new Features(object2, object4.toString(), arrayList2));
                                object2 = object;
                                object4 = object3;
                                arrayList2 = new ArrayList();
                            }
                            arrayList2.add(new AbstractTextNode.Statistics(string3, n));
                        }
                        arrayList.add(new Features(object, object3.toString(), arrayList2));
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }

    public static class Features {
        Object _caseId;
        String _column;
        List<AbstractTextNode.Statistics> _features;

        public Features(Object object, String string, List<AbstractTextNode.Statistics> list) {
            this._caseId = object;
            this._column = string;
            this._features = list;
        }

        public Object getCaseId() {
            return this._caseId;
        }

        public String getColumn() {
            return this._column;
        }

        public List<AbstractTextNode.Statistics> getFeatures() {
            return this._features;
        }
    }
}

