/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.ide.Context;

public abstract class AbstractTextNode
extends AbstractTransformNode {
    public static final String CASE_ATTRIBUTES = "caseAttribute";
    public static final String ALL_TRANSFORMATION_NODE_COLUMNS = "allXfomNodeColumns";
    public static final String EDIT_STOPLISTS = "editStoplists";
    public static final String EDIT_COLUMNS = "editColumns";
    public static final String OUTPUT_STATE = "outputState";
    public static final String FREQUENCY_TERMS = "Terms";
    public static final String FREQUENCY_IDF = "IDF";
    public static final String THEME_SINGLE = "Single";
    public static final String THEME_FULL = "Full";
    public static final String SOURCE_TYPE_DEFAULT = "Default";
    public static final String SOURCE_TYPE_DB = "DB";
    public static final String SOURCE_TYPE_WF = "WF";

    public AbstractTextNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
    }

    @Override
    public boolean validate(boolean bl) {
        return super.validate(bl);
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
    }

    @Override
    public String generateSQLExpression() {
        return null;
    }

    @Override
    public Attributes getAttributes() {
        AttributeType attributeType;
        Object object2;
        Attributes attributes = new Attributes();
        TextNodeType textNodeType = (TextNodeType)this.getData();
        TransformationSourceAttributes transformationSourceAttributes = textNodeType.getTransformationSourceAttributes();
        for (Object object2 : transformationSourceAttributes.getTransformationSourceAttributeType()) {
            if (!object2.isIsOutput()) continue;
            attributeType = new AttributeType();
            AttributeTypeHelper.copyAttribute(attributeType, (AttributeType)object2);
            attributes.getAttribute().add(attributeType);
        }
        TransformedAttributesType transformedAttributesType = textNodeType.getTransformedAttributes();
        object2 = transformedAttributesType.getMapTextTransformedSource();
        attributeType = object2.iterator();
        while (attributeType.hasNext()) {
            MapTextTransformedSourceType mapTextTransformedSourceType = (MapTextTransformedSourceType)attributeType.next();
            TextTransformationOutputAttributeType textTransformationOutputAttributeType = mapTextTransformedSourceType.getKey();
            if (!textTransformationOutputAttributeType.isIsOutput()) continue;
            AttributeType attributeType2 = new AttributeType();
            AttributeTypeHelper.copyAttribute(attributeType2, (AttributeType)textTransformationOutputAttributeType);
            attributes.getAttribute().add(attributeType2);
        }
        return attributes;
    }

    @Override
    public Object getProperty(String string) {
        TextNodeType textNodeType = (TextNodeType)this.getData();
        Object object = null;
        if (string.equals(ALL_TRANSFORMATION_NODE_COLUMNS)) {
            object = AttributeTypeHelper.getAllColumns(textNodeType);
        } else if (string.equals(CASE_ATTRIBUTES)) {
            object = textNodeType.getCaseAttributes();
        } else if (string.equals(EDIT_COLUMNS)) {
            object = textNodeType.getTransformedAttributes();
        } else if (string.equals(EDIT_STOPLISTS)) {
            object = textNodeType.getStoplists();
        } else if (string.equals("SQL_EXPRESSION")) {
            object = this.getSQLExpression();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(CASE_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(EDIT_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(EDIT_STOPLISTS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(OUTPUT_STATE)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string, Object object) {
        TextNodeType textNodeType = (TextNodeType)this.getData();
        if (string.equals(ALL_TRANSFORMATION_NODE_COLUMNS)) {
            AttributeTypeHelper.TextTransformationNodeColumns textTransformationNodeColumns = (AttributeTypeHelper.TextTransformationNodeColumns)object;
            AttributeTypeHelper.copyTransformedAttributesType(textNodeType.getTransformedAttributes(), textTransformationNodeColumns.getXformedAttributes());
            AttributeTypeHelper.copyTransformationSourceAttributes(textNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType(), textTransformationNodeColumns.getXformSourceAttributes().getTransformationSourceAttributeType());
        } else if (string.equals(CASE_ATTRIBUTES)) {
            CaseAttributes caseAttributes = (CaseAttributes)object;
            textNodeType.setCaseAttributes(caseAttributes);
        } else if (string.equals(EDIT_COLUMNS)) {
            TransformedAttributesType transformedAttributesType = (TransformedAttributesType)object;
            textNodeType.setTransformedAttributes(transformedAttributesType);
        } else if (string.equals(EDIT_STOPLISTS)) {
            Object object22;
            TextNodeType.Stoplists stoplists = (TextNodeType.Stoplists)object;
            textNodeType.setStoplists(stoplists);
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (Object object22 : stoplists.getStoplist()) {
                hashMap.put(object22.getId(), Boolean.TRUE);
            }
            TransformedAttributesType transformedAttributesType = textNodeType.getTransformedAttributes();
            if (transformedAttributesType != null && (object22 = transformedAttributesType.getMapTextTransformedSource()) != null && !object22.isEmpty()) {
                Iterator iterator = object22.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    MapTextTransformedSourceType mapTextTransformedSourceType = (MapTextTransformedSourceType)iterator.next();
                    TransformationTokenType transformationTokenType = mapTextTransformedSourceType.getKey().getTransformationElement().getToken();
                    if (transformationTokenType == null) {
                        transformationTokenType = mapTextTransformedSourceType.getKey().getTransformationElement().getTheme();
                    }
                    if ((string2 = transformationTokenType.getToken().getStoplistId()) == null || hashMap.containsKey(string2)) continue;
                    transformationTokenType.getToken().setStoplistId(null);
                }
            }
        } else if (string.equals(OUTPUT_STATE)) {
            Object object3;
            Object object4;
            Map map = (Map)object;
            TransformedAttributesType transformedAttributesType = textNodeType.getTransformedAttributes();
            if (transformedAttributesType != null && (object4 = transformedAttributesType.getMapTextTransformedSource()) != null && !object4.isEmpty()) {
                TransformationSourceAttribute transformationSourceAttribute = object4.iterator();
                while (transformationSourceAttribute.hasNext()) {
                    object3 = (MapTextTransformedSourceType)transformationSourceAttribute.next();
                    Boolean bl = (Boolean)map.get(object3.getKey().getName());
                    if (null == bl) continue;
                    object3.getKey().setIsOutput(bl.booleanValue());
                }
            }
            for (TransformationSourceAttribute transformationSourceAttribute : textNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType()) {
                object3 = (Boolean)map.get(transformationSourceAttribute.getName());
                if (null == object3) continue;
                transformationSourceAttribute.setIsOutput(((Boolean)object3).booleanValue());
            }
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                this.setSQLExpression(this.generateSQLExpression());
            } else {
                this.setSQLExpression((String)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    public static void copyAttributes(List<TransformationSourceAttribute> list, List<AttributeType> list2) {
        for (AttributeType attributeType : list2) {
            TransformationSourceAttribute transformationSourceAttribute = new TransformationSourceAttribute();
            transformationSourceAttribute.setName(attributeType.getAlias() != null && !attributeType.getAlias().trim().isEmpty() ? attributeType.getAlias() : attributeType.getName());
            transformationSourceAttribute.setDataType(attributeType.getDataType());
            transformationSourceAttribute.setStatus(attributeType.getStatus());
            transformationSourceAttribute.setAnnotation(attributeType.getAnnotation());
            transformationSourceAttribute.setIsOutput(true);
            list.add(transformationSourceAttribute);
        }
    }

    public List<StoplistType> getStoplists(String string) {
        ArrayList<StoplistType> arrayList = new ArrayList<StoplistType>();
        TextNodeType textNodeType = (TextNodeType)this.getData();
        for (StoplistType stoplistType : textNodeType.getStoplists().getStoplist()) {
            String string2 = stoplistType.getType();
            if (stoplistType.getName().equals(SOURCE_TYPE_DEFAULT) && stoplistType.getType().equals("Basic")) continue;
            if (string != null) {
                if (string.equals("Basic") && string2.equals("Basic")) {
                    arrayList.add(stoplistType);
                }
                if (!string.equals("Multi") || !string2.equals("Multi")) continue;
                arrayList.add(stoplistType);
                continue;
            }
            arrayList.add(stoplistType);
        }
        return arrayList;
    }

    public String findStoplistId(String string) {
        StoplistType stoplistType = this.findStoplistWithName(string);
        return stoplistType != null ? stoplistType.getId() : null;
    }

    public StoplistType findStoplistWithId(String string) {
        StoplistType stoplistType = null;
        if (string != null) {
            TextNodeType textNodeType = (TextNodeType)this.getData();
            for (StoplistType stoplistType2 : textNodeType.getStoplists().getStoplist()) {
                if (!stoplistType2.getId().equals(string)) continue;
                stoplistType = stoplistType2;
            }
        }
        return stoplistType;
    }

    public static StoplistType findStoplistWithIdUsingInputType(String string, TextNodeType.Stoplists stoplists) {
        StoplistType stoplistType = null;
        if (string != null) {
            for (StoplistType stoplistType2 : stoplists.getStoplist()) {
                if (!stoplistType2.getId().equals(string)) continue;
                stoplistType = stoplistType2;
            }
        }
        return stoplistType;
    }

    public StoplistType findStoplistWithName(String string) {
        StoplistType stoplistType = null;
        if (string != null) {
            TextNodeType textNodeType = (TextNodeType)this.getData();
            for (StoplistType stoplistType2 : textNodeType.getStoplists().getStoplist()) {
                if (!stoplistType2.getName().equals(string)) continue;
                stoplistType = stoplistType2;
            }
        }
        return stoplistType;
    }

    public StoplistType findDefaultStoplist(String string) {
        StoplistType stoplistType = null;
        if (string != null) {
            TextNodeType textNodeType = (TextNodeType)this.getData();
            for (StoplistType stoplistType2 : textNodeType.getStoplists().getStoplist()) {
                if (!stoplistType2.getName().equals(SOURCE_TYPE_DEFAULT) || !stoplistType2.getType().equals("Basic") || !((StoplistType.StopTokens.Token)stoplistType2.getStopTokens().getToken().get(0)).getLanguage().equals(string)) continue;
                stoplistType = stoplistType2;
            }
        }
        return stoplistType;
    }

    public static int getStoplistNextId(TextNodeType.Stoplists stoplists) {
        int n = 0;
        for (StoplistType stoplistType : stoplists.getStoplist()) {
            int n2 = Integer.parseInt(stoplistType.getId());
            if (n >= n2) continue;
            n = n2;
        }
        return ++n;
    }

    public static StoplistType findDefaultStoplist(TextNodeType.Stoplists stoplists, String string) {
        StoplistType stoplistType = null;
        if (string != null) {
            for (StoplistType stoplistType2 : stoplists.getStoplist()) {
                if (!stoplistType2.getName().equals(SOURCE_TYPE_DEFAULT) || !stoplistType2.getType().equals("Basic") || !((StoplistType.StopTokens.Token)stoplistType2.getStopTokens().getToken().get(0)).getLanguage().equals(string)) continue;
                stoplistType = stoplistType2;
            }
        }
        return stoplistType;
    }

    public static String findStoplistId(TextNodeType.Stoplists stoplists, String string) {
        StoplistType stoplistType = AbstractTextNode.findStoplistWithName(stoplists, string);
        return stoplistType != null ? stoplistType.getId() : null;
    }

    public static StoplistType findStoplistWithName(TextNodeType.Stoplists stoplists, String string) {
        StoplistType stoplistType = null;
        if (string != null) {
            for (StoplistType stoplistType2 : stoplists.getStoplist()) {
                if (!stoplistType2.getName().equals(string)) continue;
                stoplistType = stoplistType2;
            }
        }
        return stoplistType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StoplistType generateDefaultStoplist(Context context, String string) {
        StoplistType stoplistType = null;
        Connection connection = null;
        SQLHelper sQLHelper = new SQLHelper();
        if (!AbstractTextNode.defaultStoplistExists(context, string)) {
            return stoplistType;
        }
        try {
            stoplistType = new StoplistType();
            stoplistType.setId(null);
            stoplistType.setName(SOURCE_TYPE_DEFAULT);
            stoplistType.setType("Basic");
            stoplistType.setLanguage(string);
            stoplistType.setDBName("");
            StoplistType.StopTokens stopTokens = new StoplistType.StopTokens();
            stoplistType.setStopTokens(stopTokens);
            connection = Connections.getSharedConnection(context);
            String string2 = "SELECT WORD FROM ODMR_USER_DEFAULT_STOPLISTS WHERE UPPER(LANGUAGE) = UPPER(?) ORDER BY WORD";
            sQLHelper.pstmt = connection.prepareStatement(string2);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            String string3 = null;
            while (sQLHelper.rs.next()) {
                string3 = sQLHelper.rs.getString(1);
                StoplistType.StopTokens.Token token = new StoplistType.StopTokens.Token();
                token.setItem(string3);
                token.setLanguage(string);
                token.setType("Word");
                stopTokens.getToken().add(token);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            sQLHelper.close();
        }
        return stoplistType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean defaultStoplistExists(Context context, String string) {
        boolean bl = false;
        Connection connection = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            connection = Connections.getSharedConnection(context);
            String string2 = "SELECT COUNT(*) FROM ODMR_USER_DEFAULT_STOPLISTS WHERE UPPER(LANGUAGE) = UPPER(?)";
            sQLHelper.pstmt = connection.prepareStatement(string2);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            Integer n = null;
            if (sQLHelper.rs.next()) {
                n = sQLHelper.rs.getInt(1);
                bl = n > 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            sQLHelper.close();
        }
        return bl;
    }

    public static List<Statistics> loadStatistics(Context context, TextTransformationOutputAttributeType textTransformationOutputAttributeType) throws Exception {
        ArrayList<Statistics> arrayList = new ArrayList<Statistics>();
        Connection connection = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            if (textTransformationOutputAttributeType != null) {
                ResultType resultType;
                TransformationTokenType transformationTokenType = textTransformationOutputAttributeType.getTransformationElement().getToken();
                if (transformationTokenType == null) {
                    transformationTokenType = textTransformationOutputAttributeType.getTransformationElement().getTheme();
                }
                if ((resultType = transformationTokenType.getToken().getStatisticTable()) != null) {
                    connection = Connections.getSharedConnection(context);
                    String string = resultType.getName();
                    if (string != null) {
                        String string2 = "SELECT TOKEN, COUNT FROM \"" + string + "\" ORDER BY TOKEN";
                        sQLHelper.pstmt = connection.prepareStatement(string2);
                        sQLHelper.pstmt.setFetchSize(100);
                        sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                        String string3 = null;
                        Integer n = null;
                        while (sQLHelper.rs.next()) {
                            string3 = sQLHelper.rs.getString("TOKEN");
                            n = sQLHelper.rs.getInt("COUNT");
                            arrayList.add(new Statistics(string3, n));
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }

    public static class Statistics {
        String _token;
        Integer _value;

        public Statistics(String string, Integer n) {
            this._token = string;
            this._value = n;
        }

        public String getToken() {
            return this._token;
        }

        public Integer getValue() {
            return this._value;
        }
    }
}

