/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.transformations;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformationPIPropertyLrb;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.javatools.ui.search.SearchMatcher;

public class TransformationSettingsTableModel
extends GenericBaseTableModel {
    public static final int FILTER_COLUMN_NAME = 0;
    public static final int FILTER_XFORM_NAME = 1;
    public static final int FILTER_SOURCE_COLUMN_NAME = 2;
    private static String[] _columnNames = new String[]{TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_COLUMN"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_TYPE"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_SOURCE_COLUMN"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_TRANSFORM"), TransformationPIPropertyLrb.get("PI_TRANSFORMATION_SETTINGS_GRID_OUTPUT")};
    private boolean _writable = true;
    protected static int _COL_INDEX = 0;
    public static final int COLUMN = _COL_INDEX++;
    public static final int TYPE = _COL_INDEX++;
    public static final int SOURCE_COLUMN = _COL_INDEX++;
    public static final int TRANSFORM = _COL_INDEX++;
    public static final int OUTPUT = _COL_INDEX++;
    public static final int HISTOGRAM = _COL_INDEX++;
    public static final int PERCENT_NULL = _COL_INDEX++;
    public static final int DISTINCT = _COL_INDEX++;
    public static final int MODE = _COL_INDEX++;
    public static final int AVG = _COL_INDEX++;
    public static final int MEDIAN = _COL_INDEX++;
    public static final int MIN = _COL_INDEX++;
    public static final int MAX = _COL_INDEX++;
    public static final int STD = _COL_INDEX++;
    public static final int VAR = _COL_INDEX++;
    public static final int SKEWNESS = _COL_INDEX++;
    public static final int KURTOSIS = _COL_INDEX++;
    protected Vector<TransformationSourceAttribute> _srcData;
    protected TransformedAttributes _transformedAttributes;
    protected HashMap<String, DataProfileStatisticsData> _dataMap = new HashMap();

    public String getColumnName(int n) {
        return _columnNames[n];
    }

    public void addDataItem(DataProfileStatisticsData dataProfileStatisticsData) {
        this._dataMap.put(dataProfileStatisticsData.getName(), dataProfileStatisticsData);
    }

    public void setWritable(boolean bl) {
        this._writable = bl;
    }

    private TransformationSettingsTableModel(TransformedAttributes transformedAttributes, Vector<TransformationSourceAttribute> vector, String string, int n) {
        this._transformedAttributes = transformedAttributes;
        this._srcData = new Vector();
        boolean bl = string == null || string.length() <= 0;
        boolean bl2 = false;
        String string2 = "";
        String string3 = "";
        SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
        for (TransformationSourceAttribute transformationSourceAttribute : vector) {
            Object object;
            String string4 = transformationSourceAttribute.getName();
            if (transformationSourceAttribute instanceof TransformationOutputAttribute) {
                object = (TransformationOutputAttribute)transformationSourceAttribute;
                string3 = TransformationTypes.xformToString(object.getTransformationElementType());
                MapTransformedSource mapTransformedSource = AttributeTypeHelper.findMapTransformedSource(transformedAttributes, string4);
                StringCollection stringCollection = mapTransformedSource.getStringCollectionNames();
                boolean bl3 = stringCollection.getValue().isEmpty();
                string2 = !bl3 ? (String)mapTransformedSource.getStringCollectionNames().getValue().get(0) : "";
            } else {
                string2 = "";
                string3 = "";
            }
            if (bl) {
                bl2 = true;
            } else {
                object = "";
                switch (n) {
                    case 0: {
                        object = string4;
                        break;
                    }
                    case 1: {
                        object = string3;
                        break;
                    }
                    case 2: {
                        object = string2;
                        break;
                    }
                    default: {
                        object = string4;
                    }
                }
                bl2 = object == null ? false : searchMatcher.matches((CharSequence)object);
            }
            if (!bl2) continue;
            this._srcData.add(transformationSourceAttribute);
        }
        this.setRowCount(this._srcData.size());
        this.setColumnIdentifiers(this.getColumnNames());
        this.setColumnCount(this.getColumnNames().length);
    }

    public TransformationSettingsTableModel(TransformedAttributes transformedAttributes, Vector<TransformationSourceAttribute> vector, List<DataProfileStatisticsData> list, String string, int n) {
        this(transformedAttributes, vector, string, n);
        if (list == null) {
            return;
        }
        for (DataProfileStatisticsData dataProfileStatisticsData : list) {
            this.addDataItem(dataProfileStatisticsData);
        }
    }

    public TransformationSettingsTableModel() {
    }

    protected String[] getColumnNames() {
        return _columnNames;
    }

    public String getMaxString(int n) {
        String string = "";
        for (int i = 0; i < this._srcData.size(); ++i) {
            Object object = this.getValueAt(i, n);
            if (object == null || object.toString().length() <= string.length()) continue;
            string = object.toString();
        }
        return string;
    }

    public int getRowCount() {
        return this._srcData != null ? this._srcData.size() : 0;
    }

    public Vector<TransformationSourceAttribute> getDataVector() {
        return this._srcData;
    }

    public int getRow(String string) {
        for (int i = 0; i < this._srcData.size(); ++i) {
            if (!this._srcData.get(i).getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void clearRows() {
        this._dataMap.clear();
        this._srcData.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public Object getValueAt(int n, int n2) {
        if (this._srcData.isEmpty()) {
            return "";
        }
        if (n >= this._srcData.size()) {
            return "";
        }
        TransformationSourceAttribute transformationSourceAttribute = this._srcData.get(n);
        TransformationOutputAttribute transformationOutputAttribute = null;
        if (transformationSourceAttribute instanceof TransformationOutputAttribute) {
            transformationOutputAttribute = (TransformationOutputAttribute)transformationSourceAttribute;
        }
        Object object = null;
        if (n2 == COLUMN) {
            object = transformationSourceAttribute.getName();
        } else if (n2 == TYPE) {
            List list;
            object = transformationSourceAttribute.getDataType();
            if (transformationOutputAttribute != null && this._transformedAttributes != null && (list = this._transformedAttributes.getMapTransformedSourceType()) != null && !list.isEmpty()) {
                for (MapTransformedSource mapTransformedSource : list) {
                    TransformationOutputAttribute transformationOutputAttribute2 = mapTransformedSource.getKey();
                    if (!transformationOutputAttribute2.getName().equals(transformationOutputAttribute.getName())) continue;
                    object = transformationOutputAttribute2.getDataType();
                }
            }
        } else if (n2 == TRANSFORM) {
            if (transformationOutputAttribute != null) {
                object = TransformationTypes.xformToString(transformationOutputAttribute.getTransformationElementType());
            }
        } else if (n2 == SOURCE_COLUMN) {
            List list;
            if (transformationOutputAttribute != null && this._transformedAttributes != null && (list = this._transformedAttributes.getMapTransformedSourceType()) != null && !list.isEmpty()) {
                for (MapTransformedSource mapTransformedSource : list) {
                    TransformationOutputAttribute transformationOutputAttribute3 = mapTransformedSource.getKey();
                    if (!transformationOutputAttribute3.getName().equals(transformationOutputAttribute.getName())) continue;
                    if (TransformationTypes.isCustomXform(transformationOutputAttribute3.getTransformationElementType())) {
                        object = TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM_EXPRESSION_SELECTION();
                    } else {
                        List list2;
                        StringCollection stringCollection = mapTransformedSource.getStringCollectionNames();
                        if (stringCollection != null && (list2 = stringCollection.getValue()) != null && !list2.isEmpty()) {
                            StringBuilder stringBuilder = new StringBuilder();
                            for (String string : list2) {
                                if (stringBuilder.length() > 0) {
                                    stringBuilder.append(",");
                                }
                                stringBuilder.append(string);
                            }
                            object = stringBuilder.toString();
                        }
                    }
                    break;
                }
            }
        } else if (n2 == OUTPUT) {
            object = transformationSourceAttribute.isIsOutput();
        } else assert (false) : "Out of bounds column when accessing items";
        return object != null ? object : "";
    }

    public Class getColumnClass(int n) {
        if (n == OUTPUT) {
            return ImageIcon.class;
        }
        return this.getValueAt(0, n).getClass();
    }

    public void removeSelectedRows(int[] nArray) {
        Vector<TransformationSourceAttribute> vector = new Vector<TransformationSourceAttribute>();
        TransformationSourceAttribute transformationSourceAttribute = null;
        for (int i = 0; i < nArray.length; ++i) {
            transformationSourceAttribute = this._srcData.elementAt(nArray[i]);
            vector.add(transformationSourceAttribute);
        }
        this._srcData.removeAll(vector);
        this.setRowCount(this._srcData.size());
        this.fireTableDataChanged();
    }

    public TableModel getModel() {
        return this;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == OUTPUT) {
            TransformationSourceAttribute transformationSourceAttribute = this._srcData.get(n);
            transformationSourceAttribute.setIsOutput(((Boolean)object).booleanValue());
        }
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == OUTPUT) {
            return this._writable;
        }
        return false;
    }

    public DataProfileStatisticsData getDataProfileStatisticsData(int n) {
        if (this._srcData.isEmpty()) {
            return null;
        }
        TransformationSourceAttribute transformationSourceAttribute = this._srcData.get(n);
        String string = transformationSourceAttribute.getName();
        return this.getDataProfileStatisticsData(string);
    }

    public DataProfileStatisticsData getDataProfileStatisticsData(String string) {
        DataProfileStatisticsData dataProfileStatisticsData = this._dataMap.get(TransformationStatisticsState.getQuotedName(string));
        return dataProfileStatisticsData;
    }

    public Object getMissingValuesReplacementValue(TransformationSourceAttribute transformationSourceAttribute) {
        DataProfileStatisticsData dataProfileStatisticsData = this._dataMap.get(TransformationStatisticsState.getQuotedName(transformationSourceAttribute.getName()));
        if (dataProfileStatisticsData != null) {
            if (dataProfileStatisticsData.getDataType().equals("VARCHAR2") || dataProfileStatisticsData.getDataType().equals("NVARCHAR2") || dataProfileStatisticsData.getDataType().equals("CHAR") || dataProfileStatisticsData.getDataType().equals("NCHAR")) {
                return dataProfileStatisticsData.getMode();
            }
            if (dataProfileStatisticsData.getDataType().equals("NUMBER") || dataProfileStatisticsData.getDataType().equals("BINARY_DOUBLE") || dataProfileStatisticsData.getDataType().equals("BINARY_FLOAT")) {
                return dataProfileStatisticsData.getAvg();
            }
            if (dataProfileStatisticsData.getDataType().equals("DATE") || DatabaseMetadataUtils.isTimestampDerived(dataProfileStatisticsData.getDataType())) {
                return dataProfileStatisticsData.getAvg();
            }
        }
        return null;
    }

    public Double getStd(TransformationSourceAttribute transformationSourceAttribute) {
        DataProfileStatisticsData dataProfileStatisticsData = this._dataMap.get(TransformationStatisticsState.getQuotedName(transformationSourceAttribute.getName()));
        if (dataProfileStatisticsData != null) {
            return dataProfileStatisticsData.getStd();
        }
        return null;
    }

    public Object getAvg(TransformationSourceAttribute transformationSourceAttribute) {
        DataProfileStatisticsData dataProfileStatisticsData = this._dataMap.get(TransformationStatisticsState.getQuotedName(transformationSourceAttribute.getName()));
        if (dataProfileStatisticsData != null) {
            return dataProfileStatisticsData.getAvg();
        }
        return null;
    }

    public Object getMedian(TransformationSourceAttribute transformationSourceAttribute) {
        DataProfileStatisticsData dataProfileStatisticsData = this._dataMap.get(TransformationStatisticsState.getQuotedName(transformationSourceAttribute.getName()));
        if (dataProfileStatisticsData != null) {
            return dataProfileStatisticsData.getMedian();
        }
        return null;
    }

    public Double getMin(String string) {
        Double d = null;
        DataProfileStatisticsData dataProfileStatisticsData = this._dataMap.get(TransformationStatisticsState.getQuotedName(string));
        if (dataProfileStatisticsData != null) {
            try {
                String string2 = dataProfileStatisticsData.getMin();
                d = Double.valueOf(string2);
            }
            catch (Exception exception) {
                d = null;
            }
        }
        return d;
    }

    public Double getMax(String string) {
        Double d = null;
        DataProfileStatisticsData dataProfileStatisticsData = this._dataMap.get(TransformationStatisticsState.getQuotedName(string));
        if (dataProfileStatisticsData != null) {
            try {
                String string2 = dataProfileStatisticsData.getMax();
                d = Double.valueOf(string2);
            }
            catch (Exception exception) {
                d = null;
            }
        }
        return d;
    }

    public void setFailedStatus() {
    }
}

