/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.regression;

import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.CustomPIPopupListener;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.dialog.build.CaseEditRecord;
import oracle.dmt.dataminer.workflow.dialog.build.TargetEditRecord;
import oracle.dmt.dataminer.workflow.inspect.AttributeTypeComparator;
import oracle.dmt.dataminer.workflow.inspect.GeneralBuildPIComponentGUI;
import oracle.dmt.dataminer.workflow.inspect.ModelBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.regression.RegressionBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.regression.RegressionBuildPIComponentHelper;
import oracle.dmt.dataminer.workflow.inspect.regression.WorkflowRegressionBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;

public class RegressionBuildPIComponentTargetPanel
extends JPanel
implements GeneralBuildPIComponentGUI {
    private JComboBox _jCmbTarget;
    private JLabel _jLblCaseIds;
    private JLabel _jLblTarget;
    private JComboBox jCaseCombo;
    private JLabel statusCaseIcon;
    private JLabel statusTargetIcon;
    private WorkflowRegressionBuildNodePropertyProxyModel _model;
    private boolean _bLoading = false;
    private TargetEditRecord targetEdits;
    private CaseEditRecord caseEdits;
    private List<ModelType> _models;
    private List<RegressionResultType> _classResults;
    private boolean _clearSearchState = true;

    public RegressionBuildPIComponentTargetPanel(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this._classResults = MetaDataHelper.getRegressResultsCollection(abstractBuildNode);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this._jLblTarget = new JLabel();
        this._jCmbTarget = new JComboBox();
        this._jLblCaseIds = new JLabel();
        this.jCaseCombo = new JComboBox();
        this.statusTargetIcon = new JLabel();
        this.statusCaseIcon = new JLabel();
        this._jLblTarget.setText("Target:");
        this._jLblTarget.setMinimumSize(new Dimension(75, 18));
        this._jLblTarget.setPreferredSize(new Dimension(75, 20));
        this._jCmbTarget.setModel(new DefaultComboBoxModel<String>(new String[]{"GENDER", "AFFINITY_CARD"}));
        this._jLblCaseIds.setText("Case IDs:");
        this.jCaseCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.statusTargetIcon.setText("warningIcon");
        this.statusCaseIcon.setText("warningIcon");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jLblCaseIds, -2, 55, -2).addComponent(this._jLblTarget, -2, 75, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCaseCombo, 0, 151, Short.MAX_VALUE).addComponent(this._jCmbTarget, 0, 151, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusTargetIcon).addComponent(this.statusCaseIcon)).addGap(97, 97, 97)));
        groupLayout.linkSize(0, this._jLblCaseIds, this._jLblTarget);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLblTarget, -2, -1, -2).addComponent(this._jCmbTarget, -2, -1, -2).addComponent(this.statusTargetIcon)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLblCaseIds, -2, 14, -2).addComponent(this.jCaseCombo, -2, -1, -2).addComponent(this.statusCaseIcon)).addContainerGap(14, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this._jLblCaseIds, this._jLblTarget);
    }

    @Override
    public boolean getClearState() {
        return this._clearSearchState;
    }

    @Override
    public void setClearState(boolean bl) {
        this._clearSearchState = bl;
    }

    @Override
    public JPanel getGUIComponent() {
        return this;
    }

    @Override
    public boolean isWritable() {
        return RegressionBuildPIComponentHelper.isWritable((PropertyModel)this._model);
    }

    @Override
    public AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        return RegressionBuildPIComponentHelper.getTargetNode(propertyModel);
    }

    @Override
    public Context getContext(PropertyModel propertyModel) {
        return RegressionBuildPIComponentHelper.getContext(propertyModel);
    }

    public void initRes() {
        this._jLblTarget.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET") + ":");
        this._jLblCaseIds.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_CASE_IDS"));
        this.initIconResources();
    }

    private void enableControls() {
        this._jCmbTarget.setEnabled(this.isWritable());
        this.jCaseCombo.setEnabled(this.isWritable());
    }

    public void initUI(PropertyModel propertyModel) {
        this._model = (WorkflowRegressionBuildNodePropertyProxyModel)propertyModel;
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._bLoading = true;
        BuildNodeType buildNodeType = (BuildNodeType)abstractBuildNode.getData();
        List list = buildNodeType.getMiningAttributes().getMiningAttribute();
        Collections.sort(list, new AttributeTypeComparator());
        if (buildNodeType instanceof SuperviseBuildNodeType) {
            this.initTargetAttrUI((SuperviseBuildNodeType)buildNodeType, list);
        } else {
            this.remove(this._jCmbTarget);
            this.remove(this._jLblTarget);
        }
        this.loadCaseIdUI(buildNodeType);
        this.jCaseCombo.addPopupMenuListener(new CustomPIPopupListener(){

            @Override
            public void updatePropertyModel(Object object) {
                if (object instanceof CaseIdItem) {
                    CaseIdItem caseIdItem = (CaseIdItem)object;
                    AttributeType attributeType = caseIdItem.item;
                    RegressionBuildPIComponentTargetPanel.this.caseEdits.getCaseAttributes().getAttribute().clear();
                    RegressionBuildPIComponentTargetPanel.this.caseEdits.getCaseAttributes().getAttribute().add(attributeType);
                    if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        RegressionBuildPIComponentTargetPanel.this.statusCaseIcon.setVisible(true);
                    } else {
                        RegressionBuildPIComponentTargetPanel.this.statusCaseIcon.setVisible(false);
                    }
                    RegressionBuildPIComponentTargetPanel.this.setValue(RegressionBuildPIComponentTargetPanel.this.caseEdits);
                } else {
                    RegressionBuildPIComponentTargetPanel.this.caseEdits.getCaseAttributes().getAttribute().clear();
                    RegressionBuildPIComponentTargetPanel.this.setValue(RegressionBuildPIComponentTargetPanel.this.caseEdits);
                }
            }
        });
        this.enableControls();
        this._bLoading = false;
    }

    public void reloadUI(PropertyModel propertyModel) {
        this._model = (WorkflowRegressionBuildNodePropertyProxyModel)propertyModel;
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._bLoading = true;
        BuildNodeType buildNodeType = (BuildNodeType)abstractBuildNode.getData();
        List list = buildNodeType.getMiningAttributes().getMiningAttribute();
        Collections.sort(list, new AttributeTypeComparator());
        if (buildNodeType instanceof SuperviseBuildNodeType) {
            this.reloadTargetAttrUI((SuperviseBuildNodeType)buildNodeType, list);
        }
        this.loadCaseIdUI(buildNodeType);
        this.enableControls();
        this._bLoading = false;
    }

    private void reloadTargetAttrUI(SuperviseBuildNodeType superviseBuildNodeType, List<MiningAttributeType> list) {
        this._jCmbTarget.removeAllItems();
        for (MiningAttributeType miningAttributeType : list) {
            try {
                if (!DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this.getContext((PropertyModel)this._model), miningAttributeType.getDataType())) continue;
                this._jCmbTarget.addItem(new TargetItem(miningAttributeType));
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                return;
            }
        }
        AttributeType attributeType = superviseBuildNodeType.getTargetAttribute();
        if (attributeType == null) {
            this._jCmbTarget.insertItemAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET_START_VALUE"), 0);
            this._jCmbTarget.setSelectedIndex(0);
            this.statusTargetIcon.setVisible(true);
        } else if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
            this._jCmbTarget.setEditable(true);
            this._jCmbTarget.setSelectedItem(new TargetItem(attributeType));
            this._jCmbTarget.setEditable(false);
            this.statusTargetIcon.setVisible(true);
        } else {
            this._jCmbTarget.setSelectedItem(new TargetItem(attributeType));
            this.statusTargetIcon.setVisible(false);
            this._jLblTarget.setIcon(null);
        }
    }

    private void initIconResources() {
        this.statusTargetIcon.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusTargetIcon.setText("");
        this.statusCaseIcon.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusCaseIcon.setText("");
    }

    private void loadCaseIdUI(BuildNodeType buildNodeType) {
        Object object;
        AttributeType attributeType3;
        AttributeType attributeType2;
        Object object2;
        List list = buildNodeType.getMiningAttributes().getMiningAttribute();
        if (this.caseEdits == null) {
            this.caseEdits = new CaseEditRecord(new CaseAttributes());
        } else {
            object2 = this.caseEdits.getCaseAttributes();
            if (object2 != null && (attributeType2 = this.caseEdits.getCaseAttributes().getAttribute()) != null) {
                attributeType2.clear();
            }
        }
        object2 = buildNodeType.getCaseAttributes().getAttribute();
        attributeType2 = object2.iterator();
        while (attributeType2.hasNext()) {
            attributeType3 = (AttributeType)attributeType2.next();
            object = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType3);
            this.caseEdits.getCaseAttributes().getAttribute().add(object);
        }
        this.jCaseCombo.removeAllItems();
        this.jCaseCombo.addItem("<None>");
        for (AttributeType attributeType3 : list) {
            if (!DatabaseMetadataUtils.isCaseIdDataTypeSupported(this.getContext((PropertyModel)this._model), attributeType3.getDataType())) continue;
            this.jCaseCombo.addItem(new CaseIdItem((MiningAttributeType)attributeType3));
        }
        attributeType2 = null;
        if (object2.size() != 0) {
            attributeType2 = (AttributeType)object2.get(0);
        } else {
            this.jCaseCombo.setSelectedIndex(0);
        }
        if (attributeType2 != null && attributeType2.getStatus().equals((Object)AttributeStatus.VALID)) {
            boolean bl = false;
            for (int i = 0; i < this.jCaseCombo.getItemCount(); ++i) {
                if (!(this.jCaseCombo.getItemAt(i) instanceof CaseIdItem)) continue;
                CaseIdItem caseIdItem = (CaseIdItem)this.jCaseCombo.getItemAt(i);
                if (!attributeType2.getName().equals(caseIdItem.item.getName()) || !attributeType2.getDataType().equals(caseIdItem.item.getDataType())) continue;
                this.jCaseCombo.setSelectedIndex(i);
                bl = true;
            }
            if (!bl) {
                new Exception("Could not find the case id value event though it is valid").printStackTrace();
            } else {
                this.statusCaseIcon.setVisible(false);
            }
        } else if (attributeType2 != null && attributeType2.getStatus().equals((Object)AttributeStatus.INVALID)) {
            attributeType3 = MetaDataHelper.createMiningAttributeFrom(attributeType2);
            object = new CaseIdItem((MiningAttributeType)attributeType3);
            this.jCaseCombo.setEditable(true);
            this.jCaseCombo.setSelectedItem(object);
            this.jCaseCombo.setEditable(false);
            this.statusCaseIcon.setVisible(true);
        } else if (attributeType2 == null) {
            this.statusCaseIcon.setVisible(false);
        }
    }

    private void initTargetAttrUI(SuperviseBuildNodeType superviseBuildNodeType, List<MiningAttributeType> list) {
        this._jCmbTarget.removeAllItems();
        for (MiningAttributeType miningAttributeType : list) {
            try {
                if (!DatabaseMetadataUtils.isTargetNumericalDataTypeSupported(this.getContext((PropertyModel)this._model), miningAttributeType.getDataType())) continue;
                this._jCmbTarget.addItem(new TargetItem(miningAttributeType));
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                return;
            }
        }
        AttributeType attributeType = superviseBuildNodeType.getTargetAttribute();
        if (attributeType == null) {
            this._jCmbTarget.insertItemAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET_START_VALUE"), 0);
            this._jCmbTarget.setSelectedIndex(0);
            this.statusTargetIcon.setVisible(true);
        } else if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
            this._jCmbTarget.setEditable(true);
            this._jCmbTarget.setSelectedItem(new TargetItem(attributeType));
            this._jCmbTarget.setEditable(false);
            this.statusTargetIcon.setVisible(true);
        } else {
            this._jCmbTarget.setSelectedItem(new TargetItem(attributeType));
            this.statusTargetIcon.setVisible(false);
        }
        this._jCmbTarget.addPopupMenuListener(new CustomPIPopupListener(){

            @Override
            public void updatePropertyModel(Object object) {
                if (!RegressionBuildPIComponentTargetPanel.this.isWritable()) {
                    return;
                }
                if (object instanceof TargetItem) {
                    TargetItem targetItem = (TargetItem)object;
                    AttributeType attributeType = targetItem.item;
                    if (RegressionBuildPIComponentTargetPanel.this.targetEdits == null) {
                        RegressionBuildPIComponentTargetPanel.this.targetEdits = new TargetEditRecord();
                    } else {
                        TargetItem targetItem2 = new TargetItem(RegressionBuildPIComponentTargetPanel.this.targetEdits.getTargetAttribute());
                        if (targetItem2.equals(targetItem)) {
                            return;
                        }
                    }
                    RegressionBuildPIComponentTargetPanel.this.targetEdits.setTargetAttribute((AttributeType)MetaDataHelper.copyMetadataObject(attributeType));
                    if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        RegressionBuildPIComponentTargetPanel.this.statusTargetIcon.setVisible(true);
                    } else {
                        RegressionBuildPIComponentTargetPanel.this.statusTargetIcon.setVisible(false);
                    }
                    if (RegressionBuildPIComponentTargetPanel.this._jCmbTarget.getItemAt(0) instanceof String) {
                        RegressionBuildPIComponentTargetPanel.this._jCmbTarget.removeItemAt(0);
                    }
                    RegressionBuildPIComponentTargetPanel.this.setValue(RegressionBuildPIComponentTargetPanel.this.targetEdits);
                }
            }
        });
    }

    private void setValue(TargetEditRecord targetEditRecord) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        if (targetEditRecord != null) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(RegressionBuildNodePropertyModel.RowIndex.TARGET), null, new ComplexProperty("targetAttribute", targetEditRecord.getTargetAttribute()), null, null));
            ArrayList<ModelType> arrayList2 = new ArrayList<ModelType>();
            arrayList2.addAll(this._models);
            arrayList.addAll(this.prepareStatusReady(arrayList2));
            ModelBuildNodePropertyModel.updateTargetModelAttributes((SuperviseBuildNodeType)abstractBuildNode.getData(), arrayList, RegressionBuildNodePropertyModel.RowIndex.MINING_ATTRIBUTE_SETTINGS, targetEditRecord.getTargetAttribute());
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setValue(CaseEditRecord caseEditRecord) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        RegressionBuildPIComponentHelper.getMaps((PropertyModel)this._model, hashMap, hashMap2);
        if (caseEditRecord != null && hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            CaseAttributes caseAttributes = new CaseAttributes();
            caseAttributes.getAttribute().addAll(caseEditRecord.getCaseAttributes().getAttribute());
            arrayList.add(new Property(String.valueOf(RegressionBuildNodePropertyModel.RowIndex.CASE_IDS), null, new ComplexProperty("caseAttributes", caseAttributes), null, null));
            arrayList.add(new Property(String.valueOf(RegressionBuildNodePropertyModel.RowIndex.MODELS_RERUN), null, new ComplexProperty("modelsRerun", hashMap), null, null));
            arrayList.add(new Property(String.valueOf(RegressionBuildNodePropertyModel.RowIndex.TESTS_RERUN), null, new ComplexProperty("testsRerun", hashMap2), null, null));
            BuildNodeType buildNodeType = (BuildNodeType)abstractBuildNode.getData();
            ModelBuildNodePropertyModel.updateCaseIdModelAttributes(buildNodeType, arrayList, RegressionBuildNodePropertyModel.RowIndex.MINING_ATTRIBUTE_SETTINGS, caseAttributes);
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void updateWorkFlow() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            WorkflowNode workflowNode = workflowEditor.getWorkflowNode();
            try {
                Node node = workflowEditor.getSelectedDiagramNode();
                if (node != null) {
                    workflowEditor.setSelected(workflowNode.getEngine(), node);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private List<Property> prepareStatusReady(List<ModelType> list) {
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        for (ModelType object2 : list) {
            hashMap.put(object2.getId(), ModelStatusType.READY);
        }
        HashMap hashMap2 = new HashMap();
        for (RegressionResultType regressionResultType : this._classResults) {
            if (null == hashMap.get(regressionResultType.getModelId())) continue;
            hashMap2.put(regressionResultType.getModelId(), ModelStatusType.READY);
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        if (list != null && !list.isEmpty()) {
            arrayList.add(new Property(String.valueOf(RegressionBuildNodePropertyModel.RowIndex.MODELS_RERUN), null, new ComplexProperty("modelsRerun", hashMap), null, null));
            arrayList.add(new Property(String.valueOf(RegressionBuildNodePropertyModel.RowIndex.TESTS_RERUN), null, new ComplexProperty("testsRerun", hashMap2), null, null));
        }
        return arrayList;
    }

    public void resetModelSettingsTable(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models.clear();
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this._classResults.clear();
        this._classResults = MetaDataHelper.getRegressResultsCollection(abstractBuildNode);
        this.reloadUI(propertyModel);
    }

    class TargetItem {
        AttributeType item = new AttributeType();

        TargetItem(MiningAttributeType miningAttributeType) {
            this.item.setAlias(miningAttributeType.getAlias());
            this.item.setDataType(miningAttributeType.getDataType());
            this.item.setName(miningAttributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)miningAttributeType.getStatus().value()));
        }

        TargetItem(AttributeType attributeType) {
            this.item.setAlias(attributeType.getAlias());
            this.item.setDataType(attributeType.getDataType());
            this.item.setName(attributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)attributeType.getStatus().value()));
        }

        public boolean equals(Object object) {
            if (!(object instanceof TargetItem)) {
                return false;
            }
            TargetItem targetItem = (TargetItem)object;
            if (!this.isEqual(targetItem.item.getAlias(), this.item.getAlias())) {
                return false;
            }
            if (!this.isEqual(targetItem.item.getName(), this.item.getName())) {
                return false;
            }
            if (!this.isEqual(targetItem.item.getDataType(), this.item.getDataType())) {
                return false;
            }
            return this.isEqual(targetItem.item.getStatus().value(), this.item.getStatus().value());
        }

        private boolean isEqual(String string, String string2) {
            if (string == null && string2 == null) {
                return true;
            }
            if (string != null && string2 != null) {
                return string.equals(string2);
            }
            return false;
        }

        public String toString() {
            return this.item.getName();
        }
    }

    class CaseIdItem {
        AttributeType item = new AttributeType();

        CaseIdItem(MiningAttributeType miningAttributeType) {
            this.item.setAlias(miningAttributeType.getAlias());
            this.item.setDataType(miningAttributeType.getDataType());
            this.item.setName(miningAttributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)miningAttributeType.getStatus().value()));
        }

        public String toString() {
            return this.item.getName();
        }
    }
}

