/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.association;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.CustomPIPopupListener;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.CaseEditRecord;
import oracle.dmt.dataminer.workflow.dialog.build.TargetEditRecord;
import oracle.dmt.dataminer.workflow.inspect.AttributeTypeComparator;
import oracle.dmt.dataminer.workflow.inspect.EditCaseAttributesDialog;
import oracle.dmt.dataminer.workflow.inspect.GeneralBuildPIComponentGUI;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.association.AssociationBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.association.AssociationBuildPIComponentHelper;
import oracle.dmt.dataminer.workflow.inspect.association.WorkflowAssociationBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;

public class AssociationBuildPIComponentItemPanel
extends JPanel
implements GeneralBuildPIComponentGUI {
    private JButton _jBtnCaseIds;
    private JLabel _jLblCaseIds;
    private JLabel _jLblItemID;
    private JLabel _jLblItemValue;
    private JTextField _jTextCaseIds;
    private JComboBox jItemIDCombo;
    private JComboBox jItemValueCombo;
    private JLabel statusItemId;
    private JLabel statusItemValue;
    private WorkflowAssociationBuildNodePropertyProxyModel _model;
    private boolean _bLoading = false;
    private CaseEditRecord caseEdits;
    private TargetEditRecord itemIDEdits;
    private TargetEditRecord itemValueEdits;
    private List<ModelType> _models;
    private boolean _clearSearchState = true;

    public AssociationBuildPIComponentItemPanel(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this._jLblCaseIds = new JLabel();
        this._jLblItemID = new JLabel();
        this.jItemIDCombo = new JComboBox();
        this._jLblItemValue = new JLabel();
        this.jItemValueCombo = new JComboBox();
        this._jBtnCaseIds = new JButton();
        this._jTextCaseIds = new JTextField();
        this.statusItemId = new JLabel();
        this.statusItemValue = new JLabel();
        this._jLblCaseIds.setText("Transaction IDs:");
        this._jLblItemID.setText("Item ID:");
        this.jItemIDCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._jLblItemValue.setText("Item Value:");
        this.jItemValueCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._jBtnCaseIds.setText("Edit");
        this._jBtnCaseIds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AssociationBuildPIComponentItemPanel.this._jBtnCaseIdsActionPerformed(actionEvent);
            }
        });
        this._jTextCaseIds.setEditable(false);
        this.statusItemId.setText("warningIcon");
        this.statusItemValue.setText("warningIcon");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jLblItemValue, -2, 73, -2).addComponent(this._jLblCaseIds, -2, 124, -2).addComponent(this._jLblItemID, -2, 109, -2)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jTextCaseIds, -2, 227, -2).addComponent(this.jItemIDCombo, -2, 227, -2).addComponent(this.jItemValueCombo, -2, 227, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jBtnCaseIds).addComponent(this.statusItemId).addComponent(this.statusItemValue)).addContainerGap(31, Short.MAX_VALUE)));
        groupLayout.linkSize(0, this._jLblCaseIds, this._jLblItemID, this._jLblItemValue);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLblCaseIds, -2, 14, -2).addComponent(this._jTextCaseIds, -2, -1, -2).addComponent(this._jBtnCaseIds)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLblItemID, -2, 14, -2).addComponent(this.jItemIDCombo, -2, -1, -2).addComponent(this.statusItemId)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jLblItemValue, -2, 14, -2).addComponent(this.jItemValueCombo, -2, -1, -2).addComponent(this.statusItemValue)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this._jLblCaseIds, this._jTextCaseIds);
        groupLayout.linkSize(1, this._jLblItemID, this.jItemIDCombo);
        groupLayout.linkSize(1, this._jLblItemValue, this.jItemValueCombo);
    }

    private void _jBtnCaseIdsActionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public boolean getClearState() {
        return this._clearSearchState;
    }

    @Override
    public void setClearState(boolean bl) {
        this._clearSearchState = bl;
    }

    @Override
    public JPanel getGUIComponent() {
        return this;
    }

    @Override
    public boolean isWritable() {
        return AssociationBuildPIComponentHelper.isWritable((PropertyModel)this._model);
    }

    @Override
    public AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        return AssociationBuildPIComponentHelper.getTargetNode(propertyModel);
    }

    @Override
    public Context getContext(PropertyModel propertyModel) {
        return AssociationBuildPIComponentHelper.getContext(propertyModel);
    }

    public void initRes() {
        this._jLblCaseIds.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_TXN_IDS"));
        this._jLblItemID.setText(PropertyLrb.get("PI_ASSOC_BUILD_GROUP_BUILD_ITEM_ID"));
        this._jLblItemValue.setText(PropertyLrb.get("PI_ASSOC_BUILD_GROUP_BUILD_ITEM_VALUE_LABEL"));
        this.initIconResources();
    }

    private void enableControls() {
        this._jBtnCaseIds.setEnabled(this.isWritable());
        this.jItemIDCombo.setEnabled(this.isWritable());
        this.jItemValueCombo.setEnabled(this.isWritable());
    }

    public void initUI(final PropertyModel propertyModel) {
        AbstractDataNode abstractDataNode;
        this._model = (WorkflowAssociationBuildNodePropertyProxyModel)propertyModel;
        final AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._bLoading = true;
        BuildNodeType buildNodeType = (BuildNodeType)abstractBuildNode.getData();
        WorkflowNode workflowNode = (WorkflowNode)this.getContext(propertyModel).getNode();
        WorkflowModel workflowModel = null;
        try {
            workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        AbstractDataNode abstractDataNode2 = abstractDataNode = abstractBuildNode.findBuildDataNode(workflowModel);
        ArrayList<AttributeType> arrayList = new ArrayList();
        if (abstractDataNode2 != null) {
            arrayList = abstractDataNode2.getAttributes().getAttribute();
        }
        Collections.sort(arrayList, new AttributeTypeComparator());
        this.loadCaseIdUI(buildNodeType);
        this.initItemIDUI((AssociationBuildNodeType)buildNodeType, arrayList);
        this.initItemValueUI((AssociationBuildNodeType)buildNodeType, arrayList);
        this._jBtnCaseIds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditCaseAttributesDialog editCaseAttributesDialog = new EditCaseAttributesDialog(AssociationBuildPIComponentItemPanel.this.caseEdits);
                Context context = AssociationBuildPIComponentItemPanel.this.getContext(propertyModel);
                WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                try {
                    WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
                    boolean bl = editCaseAttributesDialog.invoke(context, abstractBuildNode.findBuildDataNode(workflowModel));
                    if (bl) {
                        AssociationBuildPIComponentItemPanel.this.setValue(AssociationBuildPIComponentItemPanel.this.caseEdits);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.enableControls();
        this._bLoading = false;
    }

    public void reloadUI(PropertyModel propertyModel) {
        AbstractDataNode abstractDataNode;
        this._model = (WorkflowAssociationBuildNodePropertyProxyModel)propertyModel;
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._bLoading = true;
        BuildNodeType buildNodeType = (BuildNodeType)abstractBuildNode.getData();
        WorkflowNode workflowNode = (WorkflowNode)this.getContext(propertyModel).getNode();
        WorkflowModel workflowModel = null;
        try {
            workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        AbstractDataNode abstractDataNode2 = abstractDataNode = abstractBuildNode.findBuildDataNode(workflowModel);
        ArrayList<AttributeType> arrayList = new ArrayList();
        if (abstractDataNode2 != null) {
            arrayList = abstractDataNode2.getAttributes().getAttribute();
        }
        Collections.sort(arrayList, new AttributeTypeComparator());
        this.loadCaseIdUI(buildNodeType);
        this.initItemIDUI((AssociationBuildNodeType)buildNodeType, arrayList);
        this.initItemValueUI((AssociationBuildNodeType)buildNodeType, arrayList);
        this.enableControls();
        this._bLoading = false;
    }

    private void initIconResources() {
        this.statusItemId.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusItemId.setText("");
        this.statusItemValue.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.statusItemValue.setText("");
    }

    private void loadCaseIdUI(BuildNodeType buildNodeType) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.caseEdits == null) {
            this.caseEdits = new CaseEditRecord(new CaseAttributes());
        } else {
            object4 = this.caseEdits.getCaseAttributes();
            if (object4 != null && (object3 = this.caseEdits.getCaseAttributes().getAttribute()) != null) {
                object3.clear();
            }
        }
        object4 = buildNodeType.getCaseAttributes().getAttribute();
        object3 = object4.iterator();
        while (object3.hasNext()) {
            object2 = (AttributeType)object3.next();
            object = (AttributeType)MetaDataHelper.copyMetadataObject(object2);
            this.caseEdits.getCaseAttributes().getAttribute().add(object);
        }
        boolean bl = false;
        if (object4.size() != 0) {
            object2 = "";
            object = object4.iterator();
            while (object.hasNext()) {
                AttributeType attributeType = (AttributeType)object.next();
                object2 = (String)object2 + attributeType.getName() + ", ";
                if (!attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
                bl = true;
            }
            object2 = ((String)object2).substring(0, ((String)object2).length() - 2);
            this._jTextCaseIds.setText((String)object2);
        } else {
            this._jTextCaseIds.setText(BuildEditorLrb.get("BUILD_NODE_MULTICASEID_HINT"));
            bl = true;
        }
        if (bl) {
            this._jBtnCaseIds.setIcon(OracleIcons.getIcon((String)"warning.png"));
        } else {
            this._jBtnCaseIds.setIcon(null);
        }
    }

    private void initItemIDUI(AssociationBuildNodeType associationBuildNodeType, List<AttributeType> list) {
        this.jItemIDCombo.removeAllItems();
        for (AttributeType attributeType : list) {
            try {
                if (!DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this.getContext((PropertyModel)this._model), attributeType.getDataType())) continue;
                this.jItemIDCombo.addItem(new TargetItem(attributeType));
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                return;
            }
        }
        AttributeType attributeType = associationBuildNodeType.getItemID();
        if (attributeType == null) {
            this.jItemIDCombo.insertItemAt(BuildEditorLrb.get("BUILD_NODE_ITEMID_HINT"), 0);
            this.jItemIDCombo.setSelectedIndex(0);
            this.statusItemId.setVisible(true);
        } else if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
            this.jItemIDCombo.setEditable(true);
            this.jItemIDCombo.setSelectedItem(new TargetItem(attributeType));
            this.jItemIDCombo.setEditable(false);
            this.statusItemId.setVisible(true);
        } else {
            this.jItemIDCombo.setSelectedItem(new TargetItem(attributeType));
            this.statusItemId.setVisible(false);
        }
        this.jItemIDCombo.addPopupMenuListener(new CustomPIPopupListener(){

            @Override
            public void updatePropertyModel(Object object) {
                if (!AssociationBuildPIComponentItemPanel.this.isWritable()) {
                    return;
                }
                if (object instanceof TargetItem) {
                    TargetItem targetItem = (TargetItem)object;
                    AttributeType attributeType = targetItem.item;
                    if (AssociationBuildPIComponentItemPanel.this.itemIDEdits == null) {
                        AssociationBuildPIComponentItemPanel.this.itemIDEdits = new TargetEditRecord();
                    } else {
                        TargetItem targetItem2 = new TargetItem(AssociationBuildPIComponentItemPanel.this.itemIDEdits.getTargetAttribute());
                        if (targetItem2.equals(targetItem)) {
                            return;
                        }
                    }
                    AssociationBuildPIComponentItemPanel.this.itemIDEdits.setTargetAttribute((AttributeType)MetaDataHelper.copyMetadataObject(attributeType));
                    if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        AssociationBuildPIComponentItemPanel.this.statusItemId.setVisible(true);
                    } else {
                        AssociationBuildPIComponentItemPanel.this.statusItemId.setVisible(false);
                    }
                    if (AssociationBuildPIComponentItemPanel.this.jItemIDCombo.getItemAt(0) instanceof String) {
                        AssociationBuildPIComponentItemPanel.this.jItemIDCombo.removeItemAt(0);
                    }
                    AssociationBuildPIComponentItemPanel.this.setItemID(AssociationBuildPIComponentItemPanel.this.itemIDEdits);
                }
            }
        });
    }

    private void initItemValueUI(AssociationBuildNodeType associationBuildNodeType, List<AttributeType> list) {
        this.jItemValueCombo.removeAllItems();
        for (AttributeType attributeType : list) {
            try {
                if (!DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this.getContext((PropertyModel)this._model), attributeType.getDataType())) continue;
                this.jItemValueCombo.addItem(new TargetItem(attributeType));
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                return;
            }
        }
        AttributeType attributeType = associationBuildNodeType.getItemValue();
        if (attributeType == null) {
            this.jItemValueCombo.insertItemAt(BuildEditorLrb.get("BUILD_NODE_ITEMVALUE_EXISTENCE"), 0);
            this.jItemValueCombo.setSelectedIndex(0);
            this.statusItemValue.setVisible(false);
        } else if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
            this.jItemValueCombo.setEditable(true);
            this.jItemValueCombo.setSelectedItem(new TargetItem(attributeType));
            this.jItemValueCombo.setEditable(false);
            this.statusItemValue.setVisible(true);
        } else {
            this.jItemValueCombo.setSelectedItem(new TargetItem(attributeType));
            this.statusItemValue.setVisible(false);
        }
        this.jItemValueCombo.addPopupMenuListener(new CustomPIPopupListener(){

            @Override
            public void updatePropertyModel(Object object) {
                if (!AssociationBuildPIComponentItemPanel.this.isWritable()) {
                    return;
                }
                if (object instanceof TargetItem) {
                    TargetItem targetItem = (TargetItem)object;
                    AttributeType attributeType = targetItem.item;
                    if (AssociationBuildPIComponentItemPanel.this.itemValueEdits == null) {
                        AssociationBuildPIComponentItemPanel.this.itemValueEdits = new TargetEditRecord();
                    } else {
                        TargetItem targetItem2 = new TargetItem(AssociationBuildPIComponentItemPanel.this.itemValueEdits.getTargetAttribute());
                        if (targetItem2.equals(targetItem)) {
                            return;
                        }
                    }
                    AssociationBuildPIComponentItemPanel.this.itemValueEdits.setTargetAttribute((AttributeType)MetaDataHelper.copyMetadataObject(attributeType));
                    if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
                        AssociationBuildPIComponentItemPanel.this.statusItemValue.setVisible(true);
                    } else {
                        AssociationBuildPIComponentItemPanel.this.statusItemValue.setVisible(false);
                    }
                    AssociationBuildPIComponentItemPanel.this.setItemValue(AssociationBuildPIComponentItemPanel.this.itemValueEdits);
                } else {
                    AssociationBuildPIComponentItemPanel.this.itemValueEdits = new TargetEditRecord();
                    AssociationBuildPIComponentItemPanel.this.itemValueEdits.setTargetAttribute(null);
                    AssociationBuildPIComponentItemPanel.this.setItemValue(AssociationBuildPIComponentItemPanel.this.itemValueEdits);
                }
            }
        });
    }

    private void setValue(CaseEditRecord caseEditRecord) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        AssociationBuildPIComponentHelper.getMaps((PropertyModel)this._model, hashMap);
        if (caseEditRecord != null && hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            CaseAttributes caseAttributes = new CaseAttributes();
            caseAttributes.getAttribute().addAll(caseEditRecord.getCaseAttributes().getAttribute());
            arrayList.add(new Property(String.valueOf(AssociationBuildNodePropertyModel.RowIndex.CASE_IDS), null, new ComplexProperty("caseAttributes", caseAttributes), null, null));
            arrayList.add(new Property(String.valueOf(AssociationBuildNodePropertyModel.RowIndex.MODELS_RERUN), null, new ComplexProperty("modelsRerun", hashMap), null, null));
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setItemID(TargetEditRecord targetEditRecord) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        if (targetEditRecord != null) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(AssociationBuildNodePropertyModel.RowIndex.ITEM_ID), null, new ComplexProperty("ITEM_ID", targetEditRecord.getTargetAttribute()), null, null));
            ArrayList<ModelType> arrayList2 = new ArrayList<ModelType>();
            arrayList2.addAll(this._models);
            arrayList.addAll(this.prepareStatusReady(arrayList2));
            this._model.setValueAt(PropertyLrb.get("PI_ASSOC_BUILD_GROUP_BUILD_ITEM_ID"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setItemValue(TargetEditRecord targetEditRecord) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        if (targetEditRecord != null) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(AssociationBuildNodePropertyModel.RowIndex.ITEM_VALUE), null, new ComplexProperty("ITEM_VALUE", targetEditRecord.getTargetAttribute()), null, null));
            ArrayList<ModelType> arrayList2 = new ArrayList<ModelType>();
            arrayList2.addAll(this._models);
            arrayList.addAll(this.prepareStatusReady(arrayList2));
            this._model.setValueAt(PropertyLrb.get("PI_ASSOC_BUILD_GROUP_BUILD_ITEM_VALUE"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void updateWorkFlow() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            WorkflowNode workflowNode = workflowEditor.getWorkflowNode();
            try {
                Node node = workflowEditor.getSelectedDiagramNode();
                if (node != null) {
                    workflowEditor.setSelected(workflowNode.getEngine(), node);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private List<Property> prepareStatusReady(List<ModelType> list) {
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        for (ModelType modelType : list) {
            hashMap.put(modelType.getId(), ModelStatusType.READY);
        }
        ArrayList arrayList = new ArrayList();
        if (list != null && !list.isEmpty()) {
            arrayList.add(new Property(String.valueOf(AssociationBuildNodePropertyModel.RowIndex.MODELS_RERUN), null, new ComplexProperty("modelsRerun", hashMap), null, null));
        }
        return arrayList;
    }

    public void resetModelSettingsTable(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models.clear();
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this.reloadUI(propertyModel);
    }

    class TargetItem {
        AttributeType item = new AttributeType();

        TargetItem(MiningAttributeType miningAttributeType) {
            this.item.setAlias(miningAttributeType.getAlias());
            this.item.setDataType(miningAttributeType.getDataType());
            this.item.setName(miningAttributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)miningAttributeType.getStatus().value()));
        }

        TargetItem(AttributeType attributeType) {
            this.item.setAlias(attributeType.getAlias());
            this.item.setDataType(attributeType.getDataType());
            this.item.setName(attributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)attributeType.getStatus().value()));
        }

        public boolean equals(Object object) {
            if (!(object instanceof TargetItem)) {
                return false;
            }
            TargetItem targetItem = (TargetItem)object;
            if (!this.isEqual(targetItem.item.getAlias(), this.item.getAlias())) {
                return false;
            }
            if (!this.isEqual(targetItem.item.getName(), this.item.getName())) {
                return false;
            }
            if (!this.isEqual(targetItem.item.getDataType(), this.item.getDataType())) {
                return false;
            }
            return this.isEqual(targetItem.item.getStatus().value(), this.item.getStatus().value());
        }

        private boolean isEqual(String string, String string2) {
            if (string == null && string2 == null) {
                return true;
            }
            if (string != null && string2 != null) {
                return string.equals(string2);
            }
            return false;
        }

        public String toString() {
            return this.item.getName();
        }
    }

    class CaseIdItem {
        AttributeType item = new AttributeType();

        CaseIdItem(MiningAttributeType miningAttributeType) {
            this.item.setAlias(miningAttributeType.getAlias());
            this.item.setDataType(miningAttributeType.getDataType());
            this.item.setName(miningAttributeType.getName());
            this.item.setStatus(AttributeStatus.fromValue((String)miningAttributeType.getStatus().value()));
        }

        public String toString() {
            return this.item.getName();
        }
    }
}

