/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.inspect.ClassificationBuildPIComponentHelper;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationTestSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.util.SwingWorker;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class TestLiftProfitDialogPanel
extends JPanel
implements DataminerGUIPanel {
    private PropertyModel _model;
    List<String> _targetValues;
    private ButtonGroup buttonGroupAutoManual;
    private ButtonGroup buttonGroupHighLow;
    private GenericTable jAvailableAttrs;
    private JScrollPane jAvailableAttrsScrollPane;
    private JLabel jAvailableLabel;
    private JLabel jLabelTargetValueCount;
    private JLabel jLabelTitle;
    private JSlider jMaxCount;
    private JRadioButton jRadioAuto;
    private JRadioButton jRadioHighest;
    private JRadioButton jRadioLowest;
    private JRadioButton jRadioManual;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private JScrollPane jSelectedAttrsScrollPane;
    private JLabel jSelectedLabel;
    private GenericTable jSelectedlAttrs;
    private static Icon _select;
    private static Icon _selectAll;
    private static Icon _remove;
    private static Icon _removeAll;
    private static String _TARGET_VALUE;
    static String[] _columnNames;

    public TestLiftProfitDialogPanel(PropertyModel propertyModel) {
        this._model = propertyModel;
        this.initComponents();
        this.initUI();
        this.initRes();
    }

    private void initComponents() {
        this.buttonGroupAutoManual = new ButtonGroup();
        this.buttonGroupHighLow = new ButtonGroup();
        this.jRadioAuto = new JRadioButton();
        this.jLabelTitle = new JLabel();
        this.jLabelTargetValueCount = new JLabel();
        this.jRadioLowest = new JRadioButton();
        this.jRadioHighest = new JRadioButton();
        this.jRadioManual = new JRadioButton();
        this.jAvailableAttrsScrollPane = new JScrollPane();
        this.jAvailableAttrs = new GenericTable();
        this.jMaxCount = new JSlider();
        this.jSelectedAttrsScrollPane = new JScrollPane();
        this.jSelectedlAttrs = new GenericTable();
        this.jAvailableLabel = new JLabel();
        this.jSelectedLabel = new JLabel();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.jRadioAuto.setText("Auto");
        this.jRadioAuto.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioAuto.setMargin(new Insets(0, 0, 0, 0));
        this.jLabelTitle.setText("Lift / Profit Settings");
        this.jLabelTargetValueCount.setText("Target Values maximum count");
        this.jRadioLowest.setText("Use Lowest occuring");
        this.jRadioLowest.setActionCommand("Use Lowest Occuring");
        this.jRadioLowest.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioLowest.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioHighest.setText("Use Highest Occuring");
        this.jRadioHighest.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioHighest.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioManual.setText("Manual");
        this.jRadioManual.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioManual.setMargin(new Insets(0, 0, 0, 0));
        this.jAvailableAttrs.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jAvailableAttrsScrollPane.setViewportView((Component)this.jAvailableAttrs);
        this.jSelectedlAttrs.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jSelectedAttrsScrollPane.setViewportView((Component)this.jSelectedlAttrs);
        this.jAvailableLabel.setText("Available Attributes");
        this.jSelectedLabel.setText("Selected Attributes");
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jRadioManual, -2, 194, -2).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTitle, -1, 297, Short.MAX_VALUE).addComponent(this.jRadioAuto, -2, 157, -2)).addGap(144, 144, 144)).addGroup(groupLayout.createSequentialGroup().addGap(14, 14, 14).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelTargetValueCount, -2, 159, -2).addGap(13, 13, 13).addComponent(this.jMaxCount, -1, 231, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAvailableLabel, -2, 102, -2).addComponent(this.jAvailableAttrsScrollPane, -1, 169, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRemoveAllBtn, -1, 53, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, 53, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, GroupLayout.Alignment.TRAILING, -1, 53, Short.MAX_VALUE).addComponent(this.jSelectBtn, GroupLayout.Alignment.TRAILING, -1, 53, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jSelectedLabel, -2, 121, -2).addGap(44, 44, 44)).addComponent(this.jSelectedAttrsScrollPane, GroupLayout.Alignment.LEADING, -1, 169, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jRadioHighest, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jRadioLowest, GroupLayout.Alignment.LEADING, -2, 190, -2)))).addGap(24, 24, 24)))));
        groupLayout.linkSize(0, this.jRadioAuto, this.jRadioManual);
        groupLayout.linkSize(0, this.jRemoveAllBtn, this.jRemoveBtn, this.jSelectAllBtn, this.jSelectBtn);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jMaxCount, -2, -1, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelTitle).addGap(17, 17, 17).addComponent(this.jRadioAuto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelTargetValueCount))).addGap(9, 9, 9).addComponent(this.jRadioLowest).addGap(14, 14, 14).addComponent(this.jRadioHighest).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioManual).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAvailableLabel).addComponent(this.jSelectedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAvailableAttrsScrollPane, -1, 137, Short.MAX_VALUE).addComponent(this.jSelectedAttrsScrollPane, -1, 137, Short.MAX_VALUE)).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addGap(4, 4, 4).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn).addGap(28, 28, 28)))));
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_AUTO"), this.jRadioAuto);
        hashMap.put(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_CUSTOM"), this.jRadioManual);
        this.buttonGroupAutoManual.add(this.jRadioAuto);
        this.buttonGroupAutoManual.add(this.jRadioManual);
        hashMap.put(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LIFT_PROFIT_LABEL"), this.jLabelTitle);
        hashMap.put(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_TARGET_COUNT"), this.jLabelTargetValueCount);
        hashMap.put(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LOWEST"), this.jRadioLowest);
        hashMap.put(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_HIGHEST"), this.jRadioHighest);
        this.buttonGroupHighLow.add(this.jRadioLowest);
        this.buttonGroupHighLow.add(this.jRadioHighest);
        hashMap.put(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_AVAILABLE_TARGET_VALUES"), this.jAvailableLabel);
        hashMap.put(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SELECTED_TARGET_VALUES"), this.jSelectedLabel);
        UIResourceHelper.setComponentText(hashMap);
        this.initIcons();
    }

    private void initIcons() {
        if (_select == null) {
            Class<WorkflowEditor> clazz = WorkflowEditor.class;
            _select = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_RIGHT"));
            _selectAll = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_RIGHTALL"));
            _remove = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_LEFT"));
            _removeAll = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_LEFTALL"));
        }
        this.jSelectBtn.setIcon(_select);
        this.jSelectAllBtn.setIcon(_selectAll);
        this.jRemoveBtn.setIcon(_remove);
        this.jRemoveAllBtn.setIcon(_removeAll);
    }

    public Context getContext(PropertyModel propertyModel) {
        return ClassificationBuildPIComponentHelper.getContext(propertyModel);
    }

    private ClassificationTestSettingsType getTestSettingsType() {
        ClassificationTestSettingsType classificationTestSettingsType = null;
        Context context = this.getContext(this._model);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ClassificationBuildNodeType) {
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)nodeType;
            classificationTestSettingsType = classificationBuildNodeType.getTestSettings();
        }
        return classificationTestSettingsType;
    }

    @Override
    public void initUI() {
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        ClassificationTestSettingsType classificationTestSettingsType = this.getTestSettingsType();
        if (null != classificationTestSettingsType.getBottomNTargets()) {
            this.jRadioAuto.setSelected(true);
            this.jRadioLowest.setSelected(true);
            this.enableAuto(true);
            this.initSlider(classificationTestSettingsType.getBottomNTargets().getValue());
            this.jAvailableAttrs.setModel((TableModel)((Object)new EmptyTableAttributesModel()));
            this.jSelectedlAttrs.setModel((TableModel)((Object)new EmptyTableAttributesModel()));
        } else if (null != classificationTestSettingsType.getTopNTargets()) {
            this.jRadioAuto.setSelected(true);
            this.jRadioHighest.setSelected(true);
            this.enableAuto(true);
            this.initSlider(classificationTestSettingsType.getTopNTargets().getValue());
            this.jAvailableAttrs.setModel((TableModel)((Object)new EmptyTableAttributesModel()));
            this.jSelectedlAttrs.setModel((TableModel)((Object)new EmptyTableAttributesModel()));
        } else if (null != classificationTestSettingsType.getSpecificTargets()) {
            this.loadTargetValues();
            this.jRadioManual.setSelected(true);
            this.enableAuto(false);
            ClassificationTestSettingsType.SpecificTargets specificTargets = classificationTestSettingsType.getSpecificTargets();
            TableAttributesModel tableAttributesModel = new TableAttributesModel(specificTargets);
            this.jSelectedlAttrs.setModel((TableModel)((Object)tableAttributesModel));
            this.jSelectedlAttrs.setSorted(true);
        }
        this.jAvailableAttrs.setFillsViewportHeight(true);
        this.jSelectedlAttrs.setFillsViewportHeight(true);
        this.jRadioAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestLiftProfitDialogPanel.this.enableAuto(true);
            }
        });
        this.jRadioManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TestLiftProfitDialogPanel.this._targetValues == null) {
                    TestLiftProfitDialogPanel.this.loadTargetValues();
                }
                TestLiftProfitDialogPanel.this.enableAuto(false);
            }
        });
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestLiftProfitDialogPanel.this.moveItems(TestLiftProfitDialogPanel.this.jAvailableAttrs, TestLiftProfitDialogPanel.this.jSelectedlAttrs, false);
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestLiftProfitDialogPanel.this.moveItems(TestLiftProfitDialogPanel.this.jAvailableAttrs, TestLiftProfitDialogPanel.this.jSelectedlAttrs, true);
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestLiftProfitDialogPanel.this.moveItems(TestLiftProfitDialogPanel.this.jSelectedlAttrs, TestLiftProfitDialogPanel.this.jAvailableAttrs, false);
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestLiftProfitDialogPanel.this.moveItems(TestLiftProfitDialogPanel.this.jSelectedlAttrs, TestLiftProfitDialogPanel.this.jAvailableAttrs, true);
            }
        });
    }

    private void loadTargetValues() {
        LoadTargets loadTargets = new LoadTargets(this.getTargetNode(this._model));
        loadTargets.start();
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int n;
        int n2;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List<String> list = ((TableAttributesModel)((Object)genericTable.getModel())).getDataList();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!bl) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                String object2 = list.get(nArray[n2]);
                arrayList.add(object2);
            }
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                arrayList.add(list.get(n2));
            }
        }
        for (String string : arrayList) {
            n = list.indexOf(string);
            if (n == -1) continue;
            list.remove(n);
        }
        List<String> list2 = ((TableAttributesModel)((Object)genericTable2.getModel())).getDataList();
        list2.addAll(arrayList);
        ((TableAttributesModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((TableAttributesModel)((Object)genericTable.getModel())).setRowCount(list.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        int[] nArray2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            int n3 = list2.indexOf(arrayList.get(n));
            assert (n3 != -1) : "Unexpected state - added item should be present and must have an index";
            nArray2[n] = n3;
        }
        genericTable2.setSelectedRowsInModel(nArray2);
    }

    public ClassificationTestSettingsType collectData() {
        ClassificationTestSettingsType classificationTestSettingsType = this.getTestSettingsType();
        ClassificationTestSettingsType classificationTestSettingsType2 = new ClassificationTestSettingsType();
        if (this.jRadioAuto.isSelected()) {
            if (this.jRadioLowest.isSelected()) {
                ClassificationTestSettingsType.BottomNTargets bottomNTargets = new ClassificationTestSettingsType.BottomNTargets();
                bottomNTargets.setValue(new BigInteger(String.valueOf(this.jMaxCount.getValue())));
                classificationTestSettingsType2.setBottomNTargets(bottomNTargets);
            } else {
                ClassificationTestSettingsType.TopNTargets topNTargets = new ClassificationTestSettingsType.TopNTargets();
                topNTargets.setValue(new BigInteger(String.valueOf(this.jMaxCount.getValue())));
                classificationTestSettingsType2.setTopNTargets(topNTargets);
            }
        } else {
            List<String> list = ((TableAttributesModel)((Object)this.jSelectedlAttrs.getModel())).getDataList();
            ClassificationTestSettingsType.SpecificTargets specificTargets = new ClassificationTestSettingsType.SpecificTargets();
            List list2 = specificTargets.getTargetValue();
            for (String string : list) {
                ClassificationTestSettingsType.SpecificTargets.TargetValue targetValue = new ClassificationTestSettingsType.SpecificTargets.TargetValue();
                targetValue.setValue(string);
                list2.add(targetValue);
            }
            classificationTestSettingsType2.setSpecificTargets(specificTargets);
        }
        if (TestLiftProfitDialogPanel.areEqual(classificationTestSettingsType, classificationTestSettingsType2)) {
            return null;
        }
        return classificationTestSettingsType2;
    }

    private static boolean areEqual(ClassificationTestSettingsType classificationTestSettingsType, ClassificationTestSettingsType classificationTestSettingsType2) {
        if (classificationTestSettingsType == null && classificationTestSettingsType2 == null) {
            return true;
        }
        if (classificationTestSettingsType == null || classificationTestSettingsType2 == null) {
            return false;
        }
        if (null != classificationTestSettingsType.getBottomNTargets() && null != classificationTestSettingsType2.getBottomNTargets() && (null != classificationTestSettingsType.getBottomNTargets().getValue() && null != classificationTestSettingsType2.getBottomNTargets().getValue() ? classificationTestSettingsType.getBottomNTargets().getValue().equals(classificationTestSettingsType2.getBottomNTargets().getValue()) : null == classificationTestSettingsType.getBottomNTargets().getValue() && null == classificationTestSettingsType2.getBottomNTargets().getValue())) {
            return true;
        }
        if (null != classificationTestSettingsType.getTopNTargets() && null != classificationTestSettingsType2.getTopNTargets() && (null != classificationTestSettingsType.getTopNTargets().getValue() && null != classificationTestSettingsType2.getTopNTargets().getValue() ? classificationTestSettingsType.getTopNTargets().getValue().equals(classificationTestSettingsType2.getTopNTargets().getValue()) : null == classificationTestSettingsType.getTopNTargets().getValue() && null == classificationTestSettingsType2.getTopNTargets().getValue())) {
            return true;
        }
        if (null != classificationTestSettingsType.getSpecificTargets() && null != classificationTestSettingsType2.getSpecificTargets()) {
            List list = classificationTestSettingsType.getSpecificTargets().getTargetValue();
            List list2 = classificationTestSettingsType2.getSpecificTargets().getTargetValue();
            if (null != list && null != list2) {
                if (list.size() != list2.size()) {
                    return false;
                }
                boolean bl = true;
                for (int i = 0; i < list.size(); ++i) {
                    ClassificationTestSettingsType.SpecificTargets.TargetValue targetValue = (ClassificationTestSettingsType.SpecificTargets.TargetValue)list.get(i);
                    ClassificationTestSettingsType.SpecificTargets.TargetValue targetValue2 = (ClassificationTestSettingsType.SpecificTargets.TargetValue)list2.get(i);
                    if (null == targetValue || null == targetValue2 || null == targetValue.getValue() || null == targetValue2.getValue() || targetValue.getValue().equals(targetValue2.getValue())) continue;
                    bl = false;
                    break;
                }
                return bl;
            }
            if (null == list && null == list2) {
                return true;
            }
        }
        return false;
    }

    private void enableAuto(boolean bl) {
        this.jAvailableAttrs.setEnabled(!bl);
        ((AbstractTableModel)this.jAvailableAttrs.getModel()).fireTableDataChanged();
        ((AbstractTableModel)this.jSelectedlAttrs.getModel()).fireTableDataChanged();
        this.jSelectedlAttrs.setEnabled(!bl);
        this.jSelectedlAttrs.updateUI();
        this.jRadioLowest.setEnabled(bl);
        this.jRadioHighest.setEnabled(bl);
        this.jMaxCount.setEnabled(bl);
    }

    private void initSlider(BigInteger bigInteger) {
        this.jMaxCount.setMaximum(100);
        this.jMaxCount.setMinimum(0);
        this.jMaxCount.setPaintTicks(true);
        this.jMaxCount.setPaintLabels(true);
        this.jMaxCount.setMajorTickSpacing(10);
        this.jMaxCount.setMinorTickSpacing(1);
        this.jMaxCount.setValue(bigInteger.intValue());
    }

    public boolean doWork() {
        List<String> list;
        if (this.jRadioManual.isSelected() && (list = ((TableAttributesModel)((Object)this.jSelectedlAttrs.getModel())).getDataList()).isEmpty()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LIFT_PROFIT_DLG_TITLE_MSG"), (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LIFT_PROFIT_DLG_TITLE"), (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LIFT_PROFIT_DLG_TITLE"));
            return false;
        }
        return true;
    }

    public AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        return ClassificationBuildPIComponentHelper.getTargetNode(propertyModel);
    }

    static {
        _TARGET_VALUE = PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LIFT_PROFIT_SPECIFIC_TARGETS_COLUMN_NAME");
        _columnNames = new String[]{_TARGET_VALUE};
    }

    class TableAttributesModel
    extends GenericBaseTableModel {
        protected List<String> _data;
        protected final int COLUMN_COUNT = 1;
        public static final int VALUE = 0;

        protected TableAttributesModel(String string) {
            this.setColumnIdentifiers(_columnNames);
            this._data = new ArrayList<String>();
            if (string != null) {
                this._data.add(string);
            }
            this.setRowCount(this._data.size());
            this.setColumnCount(1);
        }

        protected TableAttributesModel() {
            this.setColumnIdentifiers(_columnNames);
            this._data = new ArrayList<String>();
            this.setRowCount(0);
            this.setColumnCount(1);
        }

        protected TableAttributesModel(List<String> list) {
            this.setColumnIdentifiers(_columnNames);
            this._data = new ArrayList<String>(list.size());
            this._data.addAll(list);
            this.setRowCount(this._data.size());
            this.setColumnCount(1);
        }

        protected TableAttributesModel(ClassificationTestSettingsType.SpecificTargets specificTargets) {
            this.setColumnIdentifiers(_columnNames);
            List list = specificTargets.getTargetValue();
            this._data = new ArrayList<String>(list.size());
            for (ClassificationTestSettingsType.SpecificTargets.TargetValue targetValue : list) {
                this._data.add(targetValue.getValue());
            }
            this.setRowCount(this._data.size());
            this.setColumnCount(1);
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            String string = null;
            switch (n2) {
                case 0: {
                    string = this._data.get(n);
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public List<String> getDataList() {
            return this._data;
        }
    }

    class ErrorTableAttributesModel
    extends TableAttributesModel {
        public ErrorTableAttributesModel() {
            super(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_FAILED_LOADING_TARGET_VALUES"));
        }
    }

    class LoadingTableAttributesModel
    extends TableAttributesModel {
        public LoadingTableAttributesModel() {
            super(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LOADING_TARGET_VALUES"));
        }
    }

    class EmptyTableAttributesModel
    extends TableAttributesModel {
    }

    private class LoadTargets
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        ClassificationBuildNode _buildNode;
        SuperviseBuildNodeType _nodeType;

        public LoadTargets(AbstractBuildNode abstractBuildNode) {
            assert (this._buildNode == null || !(this._buildNode instanceof ClassificationBuildNode));
            this._buildNode = (ClassificationBuildNode)abstractBuildNode;
            this._nodeType = (SuperviseBuildNodeType)this._buildNode.getData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> getDistinctTargetValues(TableType tableType) {
            Object object;
            StringBuffer stringBuffer = null;
            String string = tableType.getName();
            String string2 = tableType.getSchema();
            String string3 = "\"" + string2 + "\"" + "." + "\"" + string + "\"";
            String string4 = this._nodeType.getTargetAttribute().getName();
            StringBuffer stringBuffer2 = new StringBuffer();
            if (stringBuffer != null) {
                object = "SELECT * FROM " + string;
                int n = stringBuffer.lastIndexOf((String)object);
                stringBuffer2.append(stringBuffer.substring(0, n));
                stringBuffer2.append("select distinct \"" + string4 + "\" from " + string3 + " where \"" + string4 + "\" is not null");
            } else {
                stringBuffer2.append("select distinct \"" + string4 + "\" from " + string3 + " where \"" + string4 + "\" is not null");
            }
            object = new ArrayList();
            StringBuffer stringBuffer3 = new StringBuffer();
            stringBuffer3.append(stringBuffer2);
            Connection connection = null;
            SQLHelper sQLHelper = new SQLHelper();
            try {
                connection = Connections.getUniqueConnection(TestLiftProfitDialogPanel.this.getContext(TestLiftProfitDialogPanel.this._model));
                sQLHelper.stmt = connection.createStatement();
                sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer3.toString());
                while (sQLHelper.rs.next()) {
                    String string5 = sQLHelper.rs.getString(1);
                    object.add(string5);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                object.clear();
            }
            finally {
                try {
                    sQLHelper.close();
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {}
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object construct() {
            TestLiftProfitDialogPanel.this.jAvailableAttrs.setModel((TableModel)((Object)new LoadingTableAttributesModel()));
            try {
                Context context = TestLiftProfitDialogPanel.this.getContext(TestLiftProfitDialogPanel.this._model);
                WorkflowNode workflowNode = (WorkflowNode)context.getNode();
                WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
                AbstractDataNode abstractDataNode = this._buildNode.findBuildDataNode(workflowModel);
                if (abstractDataNode != null) {
                    DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)abstractDataNode.getData();
                    TableType tableType = dataSourceNodeType.getSourceTable();
                    TestLiftProfitDialogPanel.this._targetValues = this.getDistinctTargetValues(tableType);
                    if (TestLiftProfitDialogPanel.this._targetValues != null && !TestLiftProfitDialogPanel.this._targetValues.isEmpty()) {
                        this._success = true;
                    }
                }
            }
            catch (Exception exception) {
                this._ex = exception;
                exception.printStackTrace();
            }
            return this._buildNode;
        }

        private void loadTargetValuesExcludingExisting() {
            ArrayList<String> arrayList;
            ClassificationTestSettingsType classificationTestSettingsType = TestLiftProfitDialogPanel.this.getTestSettingsType();
            ClassificationTestSettingsType.SpecificTargets specificTargets = classificationTestSettingsType.getSpecificTargets();
            HashMap<String, ClassificationTestSettingsType.SpecificTargets.TargetValue> hashMap = new HashMap<String, ClassificationTestSettingsType.SpecificTargets.TargetValue>();
            if (specificTargets != null) {
                arrayList = specificTargets.getTargetValue();
                for (ClassificationTestSettingsType.SpecificTargets.TargetValue object : arrayList) {
                    hashMap.put(object.getValue(), object);
                }
            }
            arrayList = new ArrayList<String>();
            if (hashMap.isEmpty()) {
                arrayList.addAll(TestLiftProfitDialogPanel.this._targetValues);
            } else {
                for (String string : TestLiftProfitDialogPanel.this._targetValues) {
                    if (null != hashMap.get(string)) continue;
                    arrayList.add(string);
                }
            }
            Object object = new TableAttributesModel(arrayList);
            TestLiftProfitDialogPanel.this.jAvailableAttrs.setModel(object);
            TestLiftProfitDialogPanel.this.jAvailableAttrs.setSorted(true);
        }

        public void finished() {
            if (this._success && this._ex == null) {
                this.loadTargetValuesExcludingExisting();
            } else {
                TestLiftProfitDialogPanel.this.jAvailableAttrs.setModel((TableModel)((Object)new ErrorTableAttributesModel()));
                if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_ERROR_TITLE"), (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_ERROR_TITLE_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), null, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_ERROR_TITLE"), (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_ERROR_TITLE_MESG"));
                }
            }
        }
    }
}

