/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.math.BigInteger;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.inspect.CachePIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.applyText.WorkflowApplyTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.buildText.WorkflowBuildTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.profile.WorkflowDataProfileNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.transformations.WorkflowTransformNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.ApplyTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.model.SampleSettingsProperties;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.preferences.CacheSettingsPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleSettings;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.javatools.data.PropertyStorage;

public class SamplePIComponentPanel
extends CachePIComponentPanel {
    private CacheSettingsPanelSettings _samplePreffrences = CacheSettingsPanelSettings.getInstance((PropertyStorage)_p);
    private SampleSettings _sampleSettings;

    private SampleSettings getSampleSettings(AbstractDataNode abstractDataNode) {
        SampleSettings sampleSettings = null;
        if (abstractDataNode instanceof DataProfileNode) {
            DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)abstractDataNode.getData();
            sampleSettings = dataProfileNodeType.getSampleSettings();
        } else if (abstractDataNode instanceof TransformationNode) {
            TransformationNodeType transformationNodeType = (TransformationNodeType)abstractDataNode.getData();
            sampleSettings = transformationNodeType.getSampleSettings();
        } else if (abstractDataNode instanceof BuildTextNode) {
            BuildTextNodeType buildTextNodeType = (BuildTextNodeType)abstractDataNode.getData();
            sampleSettings = buildTextNodeType.getSampleSettings();
        } else if (abstractDataNode instanceof ApplyTextNode) {
            ApplyTextNodeType applyTextNodeType = (ApplyTextNodeType)abstractDataNode.getData();
            sampleSettings = applyTextNodeType.getSampleSettings();
        }
        return sampleSettings;
    }

    @Override
    public void setSettings(AbstractDataNode abstractDataNode) {
        this._sampleSettings = this.getSampleSettings(abstractDataNode);
    }

    @Override
    public Object getRandom() {
        if (this._sampleSettings == null) {
            return null;
        }
        return this._sampleSettings.getMethod().getRandom();
    }

    @Override
    public Object getStratified() {
        if (this._sampleSettings == null) {
            return null;
        }
        return this._sampleSettings.getMethod().getStratified();
    }

    @Override
    public Long getNumberOfRows() {
        if (this._sampleSettings == null) {
            return null;
        }
        return this._sampleSettings.getNumberOfRows();
    }

    @Override
    public Double getPercentOfTotal() {
        if (this._sampleSettings == null) {
            return null;
        }
        return this._sampleSettings.getPercentOfTotal();
    }

    @Override
    public void setNumberRows(Long l) {
        if (this._sampleSettings == null) {
            return;
        }
        this._sampleSettings.setNumberOfRows(l);
    }

    @Override
    public void setPercentOfTotal(Double d) {
        if (this._sampleSettings == null) {
            return;
        }
        this._sampleSettings.setPercentOfTotal(d);
    }

    @Override
    public boolean isUseFullData() {
        if (this._sampleSettings == null) {
            return false;
        }
        return this._sampleSettings.isUseFullData();
    }

    public SamplePIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
    }

    @Override
    protected void setCheckBoxText() {
        this.jCheckBoxAllData.setText(PropertyLrb.get("PI_ATTRIBUTES_SAMPLE_GROUP_USE_ALL_DATA"));
    }

    @Override
    protected Object copySettings() {
        SampleSettings sampleSettings = new SampleSettings();
        sampleSettings.setNumberOfRows(this.getNumberOfRows());
        sampleSettings.setPercentOfTotal(this.getPercentOfTotal());
        SampleSettings.Method method = this._sampleSettings.getMethod();
        SampleSettings.Method method2 = new SampleSettings.Method();
        if (null != method.getRandom()) {
            SampleSettings.Method.Random random = new SampleSettings.Method.Random();
            random.setSeed(method.getRandom().getSeed());
            method2.setRandom(random);
        } else if (null != method.getStratified()) {
            SampleSettings.Method.Stratified stratified = new SampleSettings.Method.Stratified();
            stratified.setTargetAttr(method.getStratified().getTargetAttr());
            method2.setStratified(stratified);
        } else if (null != method.getTopN()) {
            SampleSettings.Method.TopN topN = new SampleSettings.Method.TopN();
            method2.setTopN(topN);
        }
        sampleSettings.setMethod(method2);
        sampleSettings.setUseFullData(this.isUseFullData());
        sampleSettings.setGenerateCache(Boolean.valueOf(true));
        sampleSettings.setOutputTable(this._sampleSettings.getOutputTable());
        return sampleSettings;
    }

    @Override
    protected void updateSettings(Object object, String string) {
        ComplexProperty complexProperty = new ComplexProperty(string, object);
        complexProperty.setOldData(this._sampleSettings);
        if (this._model instanceof WorkflowDataProfileNodePropertyProxyModel) {
            WorkflowDataProfileNodePropertyProxyModel workflowDataProfileNodePropertyProxyModel = (WorkflowDataProfileNodePropertyProxyModel)this._model;
            workflowDataProfileNodePropertyProxyModel.setValueAt(string, (AbstractDataNode)this.getTargetNode(this._model), complexProperty, workflowDataProfileNodePropertyProxyModel.getRowMapping(WorkflowDataProfileNodePropertyProxyModel.SAMPLE_SETTINGS));
        } else if (this._model instanceof WorkflowTransformNodePropertyProxyModel) {
            WorkflowTransformNodePropertyProxyModel workflowTransformNodePropertyProxyModel = (WorkflowTransformNodePropertyProxyModel)this._model;
            workflowTransformNodePropertyProxyModel.setValueAt(string, (AbstractDataNode)this.getTargetNode(this._model), complexProperty, workflowTransformNodePropertyProxyModel.getRowMapping(WorkflowTransformNodePropertyProxyModel.SAMPLE_SETTINGS));
        } else if (this._model instanceof WorkflowBuildTextNodePropertyProxyModel) {
            WorkflowBuildTextNodePropertyProxyModel workflowBuildTextNodePropertyProxyModel = (WorkflowBuildTextNodePropertyProxyModel)this._model;
            workflowBuildTextNodePropertyProxyModel.setValueAt(string, (AbstractDataNode)this.getTargetNode(this._model), complexProperty, workflowBuildTextNodePropertyProxyModel.getRowMapping(WorkflowBuildTextNodePropertyProxyModel.SAMPLE_SETTINGS));
        } else if (this._model instanceof WorkflowApplyTextNodePropertyProxyModel) {
            WorkflowApplyTextNodePropertyProxyModel workflowApplyTextNodePropertyProxyModel = (WorkflowApplyTextNodePropertyProxyModel)this._model;
            workflowApplyTextNodePropertyProxyModel.setValueAt(string, (AbstractDataNode)this.getTargetNode(this._model), complexProperty, workflowApplyTextNodePropertyProxyModel.getRowMapping(WorkflowApplyTextNodePropertyProxyModel.SAMPLE_SETTINGS));
        }
    }

    @Override
    protected void setStratifiedSettings(String string) {
        SampleSettings sampleSettings = (SampleSettings)this.copySettings();
        SampleSettings.Method.Stratified stratified = new SampleSettings.Method.Stratified();
        stratified.setTargetAttr(string);
        sampleSettings.getMethod().setRandom(null);
        sampleSettings.getMethod().setStratified(stratified);
        sampleSettings.getMethod().setTopN(null);
        this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_STRATIFIED);
    }

    @Override
    protected void setRandomSettings() {
        SampleSettings sampleSettings = (SampleSettings)this.copySettings();
        SampleSettings.Method.Random random = new SampleSettings.Method.Random();
        random.setSeed(BigInteger.valueOf(this._samplePreffrences.getSeed()));
        sampleSettings.getMethod().setRandom(random);
        sampleSettings.getMethod().setStratified(null);
        sampleSettings.getMethod().setTopN(null);
        this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_RANDOM);
    }

    @Override
    protected void setTopNSettings() {
        SampleSettings sampleSettings = (SampleSettings)this.copySettings();
        SampleSettings.Method.TopN topN = new SampleSettings.Method.TopN();
        sampleSettings.getMethod().setRandom(null);
        sampleSettings.getMethod().setStratified(null);
        sampleSettings.getMethod().setTopN(topN);
        this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_TOPN);
    }

    @Override
    protected void setTargetAttribute(String string) {
        SampleSettings sampleSettings = (SampleSettings)this.copySettings();
        sampleSettings.getMethod().getStratified().setTargetAttr(string);
        this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_TARGET);
    }

    @Override
    protected void setUseFullData(boolean bl) {
        SampleSettings sampleSettings = (SampleSettings)this.copySettings();
        sampleSettings.setUseFullData(bl);
        this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_PERCENT);
    }

    @Override
    protected void setPercent(double d) {
        SampleSettings sampleSettings = (SampleSettings)this.copySettings();
        sampleSettings.setPercentOfTotal(Double.valueOf(d));
        sampleSettings.setNumberOfRows(null);
        this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_PERCENT);
    }

    @Override
    protected void setNumberOfRows(Integer n) {
        SampleSettings sampleSettings = (SampleSettings)this.copySettings();
        sampleSettings.setNumberOfRows(Long.valueOf(n.intValue()));
        sampleSettings.setPercentOfTotal(null);
        this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_NUMBER_OF_ROWS);
    }

    @Override
    protected void setSeed(Integer n) {
        SampleSettings sampleSettings = (SampleSettings)this.copySettings();
        sampleSettings.getMethod().getRandom().setSeed(BigInteger.valueOf(n.intValue()));
        this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_SEED);
    }

    @Override
    protected void selectAllData(boolean bl) {
        this._jCmbSize.setEnabled(!bl);
        this._jLblSize.setEnabled(!bl);
        this.jPanelSamplingSizeRows.setEnabled(!bl);
        this.jPanelSamplingSizePercent.setEnabled(!bl);
    }

    @Override
    protected void updateUIElements(boolean bl) {
        boolean bl2 = this.isWritable();
        this.jCheckBoxAllData.setEnabled(bl2);
        this._jCmbSize.setEnabled(bl2 && !bl);
        this.jPanelSamplingSizeRows.setEnabled(bl2 && !bl);
        this.getSamplingSizePanel().setEnabled(bl2 && !bl);
        this.jPanelSamplingSizePercent.setEnabled(bl2 && !bl);
    }
}

