/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.bali.inspector.ActionGroup;
import oracle.bali.inspector.CustomEditorAction;
import oracle.bali.inspector.InspectorPropertyEditor;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyGroupImpl;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public abstract class AbstractNodePropertyModel
extends PropertyModel {
    protected WorkflowNodeInspectorElement _workflowNodeInspectorElement = null;
    private static final int PROPERTY_START_INDEX = 0;
    private Context context;
    protected static final Object[] COLUMNS = new Object[]{PropertyModel.COLUMN_ID, PropertyModel.COLUMN_VALUE, PropertyModel.COLUMN_VALUE_CLASS, PropertyModel.COLUMN_GROUP, PropertyModel.COLUMN_DISPLAY_NAME, PropertyModel.COLUMN_NAME, PropertyModel.COLUMN_DESCRIPTION, PropertyModel.COLUMN_EDITOR_FACTORY, PropertyModel.COLUMN_EDITOR_FACTORY_2, PropertyModel.COLUMN_IS_READABLE, PropertyModel.COLUMN_IS_WRITABLE, PropertyModel.COLUMN_DISPLAY_VALUE, PropertyModel.COLUMN_ACTIONS, PropertyModel.COLUMN_IS_HIDDEN, IdePropertyModel.COLUMN_HELP};
    private final List<Property> ROWS = new ArrayList<Property>();

    protected static int getInitialIndex() {
        return 0;
    }

    protected abstract int getRowIndexforNAME();

    protected abstract int getRowIndexforCOMMENT();

    public AbstractNodePropertyModel(Context context) {
        this.context = context;
        this.setInspector();
    }

    public void setContext(Context context) {
        this.context = context;
        this.setInspector();
    }

    private void setInspector() {
        Element[] elementArray = this.getContext().getSelection();
        this._workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
    }

    protected void addCommonProperties(NodeType nodeType, List<Property> list) {
        Property property = new Property(this.propertyId("name"), PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME"), nodeType.getName(), PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_DESCRIPTION"), Groups.COMMON);
        list.add(this.getRowIndexforNAME(), property);
        Property property2 = new Property(this.propertyId("comment"), PropertyLrb.get("PI_COMMON_GROUP_NODE_COMMENT"), nodeType.getAnnotation(), PropertyLrb.get("PI_COMMON_GROUP_NODE_COMMENT_DESCRIPTION"), Groups.COMMON);
        list.add(this.getRowIndexforCOMMENT(), property2);
    }

    public boolean isCellEditable(int n, int n2) {
        WorkflowNode workflowNode = (WorkflowNode)EditorManager.getEditorManager().getCurrentEditor().getContext().getNode();
        boolean bl = !workflowNode.isReadOnly();
        return bl;
    }

    public void invalidateValueData() {
    }

    public Context getContext() {
        return this.context;
    }

    public Object[] getColumnMapping() {
        return COLUMNS;
    }

    public List<Property> getRows() {
        return this.ROWS;
    }

    public String getTargetDisplayName() {
        Element element = this.context.getElement();
        String string = element.getShortLabel();
        return string;
    }

    public int getRowCount() {
        return this.ROWS.size();
    }

    protected String propertyId(String string) {
        return ((Object)((Object)this)).getClass().getName() + "." + string;
    }

    public abstract Object getValueAt(int var1, int var2);

    public void setValueAt(Object object, int n, int n2) {
        Object[] objectArray = this.getColumnMapping();
        Object object2 = objectArray[n2];
        List<Property> list = this.getRows();
        if (object2 == PropertyModel.COLUMN_VALUE) {
            if (n == this.getRowIndexforNAME()) {
                list.get((int)n).value = object;
                this._workflowNodeInspectorElement.updateNode("name", object);
            } else if (n == this.getRowIndexforCOMMENT()) {
                list.get((int)n).value = object;
                this._workflowNodeInspectorElement.updateNode("comment", object);
            }
        }
    }

    public static class PropertyEditorFactory2
    extends InspectorPropertyEditor {
        private final Property property;
        private Object value;
        private Context context = null;

        public PropertyEditorFactory2(Property property, Context context) {
            this.property = property;
            this.context = context;
        }

        private boolean isNameProperty() {
            return this.property.id.lastIndexOf("name") == this.property.id.length() - "name".length();
        }

        private boolean isCommentProperty() {
            return this.property.id.lastIndexOf("comment") == this.property.id.length() - "comment".length();
        }

        private boolean isDuplicateName(String string) {
            boolean bl = false;
            String string2 = (String)this.value;
            if (string2.compareTo(string) == 0) {
                return bl;
            }
            Editor editor = EditorManager.getEditorManager().getCurrentEditor();
            if (editor instanceof WorkflowEditor) {
                WorkflowEditor workflowEditor = (WorkflowEditor)editor;
                bl = workflowEditor.doesNodeNameAlreadyExist(string);
            }
            return bl;
        }

        private boolean doesNotContainForwardSlash(String string) {
            return string.indexOf("/") == -1;
        }

        private boolean doesNotContainAmpersand(String string) {
            return string.indexOf("&") == -1;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public Object getValue() {
            return this.value;
        }

        public void setAsText(String string) throws IllegalArgumentException {
            block18: {
                if (this.isNameProperty()) {
                    String string2 = string;
                    if (string2.length() > 30) {
                        this.value = string2.substring(0, 30);
                        String string3 = MessageFormat.format(PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_TOO_LONG"), 30);
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)PropertyLrb.get("PI_COMMON_GROUP_NODE_SETTING_ERROR_TITLE"), null);
                    } else if (string2.trim().length() == 0) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_SPACES"), (String)PropertyLrb.get("PI_COMMON_GROUP_NODE_SETTING_ERROR_TITLE"), null);
                    } else if (this.isDuplicateName(string2)) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("NODE_NAME_NOT_UNIQUE_MSG"), (String)WorkflowEditorLrb.get("NODE_NAME_NOT_UNIQUE_TITLE"), null);
                    } else if (!this.doesNotContainForwardSlash(string2)) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_SLASH"), (String)PropertyLrb.get("PI_COMMON_GROUP_NODE_SETTING_ERROR_TITLE"), null);
                    } else if (!this.doesNotContainAmpersand(string2)) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_AMPERSAND"), (String)PropertyLrb.get("PI_COMMON_GROUP_NODE_SETTING_ERROR_TITLE"), null);
                    } else {
                        this.value = string2;
                    }
                } else if (this.isCommentProperty()) {
                    String string4 = string;
                    Connection connection = null;
                    try {
                        connection = Connections.getSharedConnection(this.context);
                        if (string4.length() > 4000) {
                            this.value = string4.substring(0, 4000);
                            String string5 = MessageFormat.format(PropertyLrb.get("PI_COMMON_GROUP_NODE_COMMENT_TOO_LONG"), 4000);
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string5, (String)PropertyLrb.get("PI_COMMON_GROUP_NODE_SETTING_ERROR_TITLE"), null);
                            break block18;
                        }
                        if (!StringUtils.checkStringDBLengthMaxLong(string4, connection, 4000)) {
                            String string6 = MessageFormat.format(PropertyLrb.get("PI_COMMON_GROUP_NODE_COMMENT_MAX_BYTES"), 4000);
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string6, (String)PropertyLrb.get("PI_COMMON_GROUP_NODE_SETTING_ERROR_TITLE"), null);
                            break block18;
                        }
                        this.value = string4;
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)"Workflow Document Edit Error", (String)"Unable update comment.", null);
                    }
                } else {
                    this.value = string;
                }
            }
        }

        public String getAsText() {
            if (this.value == null) {
                return "";
            }
            return this.value.toString();
        }

        public boolean isPaintable() {
            return false;
        }

        public void paintValue(Graphics graphics, Rectangle rectangle) {
        }

        public boolean hasInlineEditor() {
            return !this.property.id.equals("dataSourceTable");
        }

        public List<ActionGroup> getActionGroups() {
            return new ArrayList<ActionGroup>();
        }

        public boolean hasActionGroups() {
            return true;
        }

        public String[] getTags() {
            return new String[0];
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void applyValueFrom(Component component) {
        }

        public CustomEditorAction customEditorAction() {
            return null;
        }
    }

    protected static class Groups {
        public static final PropertyGroupImpl COMMON = new PropertyGroupImpl(PreferencesLrb.get("PI_ATTRUBUTES_NODE_DETAILS"));

        protected Groups() {
        }
    }
}

