/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddEditTransformsPanelNoStats;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.MissingValuesPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.NormalizationPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.OutlierPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class UseExistingColumnPanel
extends JPanel {
    private TransformationSourceAttribute selSourceColumn;
    private MapTransformedSource selectedTransformedColumn;
    private TransformationStatisticsState state;
    private int datatype = TransformationTypes.DATA_TYPE_UNDEFINED;
    private Vector<String> transformedColumns;
    private Map<String, MapTransformedSource> helperMap;
    private boolean wizard;
    private AddEditTransformsPanelNoStats parent;
    private static final String _CURRENT_PANEL = "_CURRENT_PANEL";
    private String _selectedTransformation;
    private JComboBox jCmbXformedColumn;
    private JLabel jLblXformedColumn;
    private JPanel jPanelHost;
    private BinningPanel binningPanel;
    private MissingValuesPanel missValuesPanel;
    private OutlierPanel outlierPanel;
    private NormalizationPanel normalizationPanel;

    public UseExistingColumnPanel(List<TransformationSourceAttribute> list, List<MapTransformedSource> list2, TransformationStatisticsState transformationStatisticsState) {
        this.state = transformationStatisticsState;
        this.wizard = true;
        HashMap<String, TransformationSourceAttribute> hashMap = new HashMap<String, TransformationSourceAttribute>();
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            hashMap.put(transformationSourceAttribute.getName(), transformationSourceAttribute);
        }
        this.helperMap = new HashMap<String, MapTransformedSource>(list2.size());
        this.transformedColumns = new Vector(list2.size());
        for (MapTransformedSource mapTransformedSource : list2) {
            if (null != hashMap.get(mapTransformedSource.getKey().getName())) continue;
            this.transformedColumns.add(mapTransformedSource.getKey().getName());
            this.helperMap.put(mapTransformedSource.getKey().getName(), mapTransformedSource);
        }
        this.selectedTransformedColumn = list2.get(0);
        if ("NUMBER".equals(this.selectedTransformedColumn.getKey().getDataType())) {
            this.datatype = TransformationTypes.DATA_TYPE_NUMERIC;
        } else if ("VARCHAR2".equals(this.selectedTransformedColumn.getKey().getDataType()) || "CHAR".equals(this.selectedTransformedColumn.getKey().getDataType())) {
            this.datatype = TransformationTypes.DATA_TYPE_CATEGORIC;
        } else if ("DATE".equals(this.selectedTransformedColumn.getKey().getDataType()) || DatabaseMetadataUtils.isTimestamp(this.selectedTransformedColumn.getKey().getDataType()) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(this.selectedTransformedColumn.getKey().getDataType())) {
            this.datatype = TransformationTypes.DATA_TYPE_DATE;
        } else if (DatabaseMetadataUtils.isTimestampWithTimeZone(this.selectedTransformedColumn.getKey().getDataType())) {
            this.datatype = TransformationTypes.DATA_TYPE_TIMESTAMP_WITH_TIME_ZONE;
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public UseExistingColumnPanel(TransformationSourceAttribute transformationSourceAttribute, TransformationStatisticsState transformationStatisticsState, List<MapTransformedSource> list, AddEditTransformsPanelNoStats addEditTransformsPanelNoStats) {
        this.state = transformationStatisticsState;
        this.selSourceColumn = transformationSourceAttribute;
        this.parent = addEditTransformsPanelNoStats;
        this.wizard = false;
        this.helperMap = new HashMap<String, MapTransformedSource>(list.size());
        this.transformedColumns = new Vector(list.size());
        for (MapTransformedSource mapTransformedSource : list) {
            if (transformationSourceAttribute.getName().equals(mapTransformedSource.getKey().getName())) continue;
            this.transformedColumns.add(mapTransformedSource.getKey().getName());
            this.helperMap.put(mapTransformedSource.getKey().getName(), mapTransformedSource);
        }
        this.selectedTransformedColumn = list.get(0);
        if ("NUMBER".equals(this.selectedTransformedColumn.getKey().getDataType())) {
            this.datatype = TransformationTypes.DATA_TYPE_NUMERIC;
        } else if ("VARCHAR2".equals(this.selectedTransformedColumn.getKey().getDataType()) || "CHAR".equals(this.selectedTransformedColumn.getKey().getDataType()) || "NVARCHAR2".equals(this.selectedTransformedColumn.getKey().getDataType()) || "NCHAR".equals(this.selectedTransformedColumn.getKey().getDataType())) {
            this.datatype = TransformationTypes.DATA_TYPE_CATEGORIC;
        } else if ("DATE".equals(this.selectedTransformedColumn.getKey().getDataType()) || DatabaseMetadataUtils.isTimestamp(this.selectedTransformedColumn.getKey().getDataType()) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(this.selectedTransformedColumn.getKey().getDataType())) {
            this.datatype = TransformationTypes.DATA_TYPE_DATE;
        } else if (DatabaseMetadataUtils.isTimestampWithTimeZone(this.selectedTransformedColumn.getKey().getDataType())) {
            this.datatype = TransformationTypes.DATA_TYPE_TIMESTAMP_WITH_TIME_ZONE;
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLblXformedColumn = new JLabel();
        this.jCmbXformedColumn = new JComboBox();
        this.jPanelHost = new JPanel();
        this.jLblXformedColumn.setText("Transformed Column:");
        this.jCmbXformedColumn.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jPanelHost.setLayout(new CardLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelHost, -1, 380, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblXformedColumn, -2, 135, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCmbXformedColumn, -2, 186, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblXformedColumn).addComponent(this.jCmbXformedColumn, -2, 22, -2)).addGap(18, 18, 18).addComponent(this.jPanelHost, -2, 214, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void initRes() {
        this.jLblXformedColumn.setText(XformDialogsLrb.get("EXISTING_COLUMN_TRANSFORMED_COLUMN"));
    }

    public void initUI() {
        this.jCmbXformedColumn.setModel(new DefaultComboBoxModel<String>(this.transformedColumns));
        if (this.transformedColumns.size() > 0) {
            this.jCmbXformedColumn.setSelectedIndex(0);
        }
        this.jCmbXformedColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)UseExistingColumnPanel.this.jCmbXformedColumn.getSelectedItem();
                UseExistingColumnPanel.this.selectedTransformedColumn = (MapTransformedSource)UseExistingColumnPanel.this.helperMap.get(string);
                UseExistingColumnPanel.this.showPanel();
                if (UseExistingColumnPanel.this.parent != null) {
                    UseExistingColumnPanel.this.parent.updateOutputName(UseExistingColumnPanel.this.selectedTransformedColumn);
                }
            }
        });
        this.showPanel();
    }

    private void showPanel() {
        TransformationType transformationType = this.selectedTransformedColumn.getKey().getTransformationElementType();
        this._selectedTransformation = TransformationTypes.transformationTypeToString(transformationType);
        if (TransformationTypes.isBinning(transformationType)) {
            this.binningPanel = !this.wizard ? new BinningPanel(this.selSourceColumn.getName(), this.selSourceColumn.getDataType(), this.state, TransformationTypes.binningToString(transformationType), TransformationTypes.getBinCount(transformationType), this.datatype, TransformationTypes.getBinGeneration(transformationType), TransformationTypes.getBinLabels(transformationType), TransformationTypes.getCustomBinningSpec(transformationType)) : new BinningPanel(this.state, this.datatype);
            this.jPanelHost.add(_CURRENT_PANEL, this.binningPanel);
            UseExistingColumnPanel.disableUI(this.binningPanel, false);
        } else if (TransformationTypes.isMissingValuesCategorical(transformationType) || TransformationTypes.isMissingValuesNumeric(transformationType) || TransformationTypes.isMissingValuesDate(transformationType)) {
            this.missValuesPanel = !this.wizard ? new MissingValuesPanel((TransformationSourceAttribute)this.selectedTransformedColumn.getKey(), this.state.getMissingValuesDefaultReplacementValue(this.selSourceColumn), null, null) : new MissingValuesPanel(this.datatype);
            this.jPanelHost.add(_CURRENT_PANEL, this.missValuesPanel);
            UseExistingColumnPanel.disableUI(this.missValuesPanel, false);
        } else if (TransformationTypes.isOutlier(transformationType)) {
            this.outlierPanel = !this.wizard ? new OutlierPanel((TransformationSourceAttribute)this.selectedTransformedColumn.getKey(), this.state.getStd(this.selSourceColumn), this.state.getAvg(this.selSourceColumn), null) : new OutlierPanel();
            this.jPanelHost.add(_CURRENT_PANEL, this.outlierPanel);
            UseExistingColumnPanel.disableUI(this.outlierPanel, false);
        } else if (TransformationTypes.isNormalization(transformationType)) {
            this.normalizationPanel = !this.wizard ? new NormalizationPanel((TransformationSourceAttribute)this.selectedTransformedColumn.getKey(), this.state.getMin(this.selSourceColumn.getName()), this.state.getMax(this.selSourceColumn.getName()), null) : new NormalizationPanel();
            this.jPanelHost.add(_CURRENT_PANEL, this.normalizationPanel);
            UseExistingColumnPanel.disableUI(this.normalizationPanel, false);
        }
        CardLayout cardLayout = (CardLayout)this.jPanelHost.getLayout();
        cardLayout.show(this.jPanelHost, _CURRENT_PANEL);
    }

    public MapTransformedSource getSelectedTransformedColumn() {
        return this.selectedTransformedColumn;
    }

    private static void disableUI(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Container) {
                if (componentArray[i] instanceof GenericTable) {
                    GenericTable genericTable = (GenericTable)componentArray[i];
                    genericTable.setCellSelectionEnabled(false);
                    genericTable.setColumnHeaderSelectionEnabled(false);
                    genericTable.setSorted(false);
                }
                UseExistingColumnPanel.disableUI((Container)componentArray[i], bl);
            }
            componentArray[i].setEnabled(bl);
        }
    }

    public TransformationType getResultTransformatonType() {
        TransformationType transformationType = null;
        if (TransformationTypes.isBinning(this._selectedTransformation)) {
            Integer n = this.binningPanel.getBincount();
            if (n == null || n == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_BIN_COUNT_INVALID"), (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                return null;
            }
            String string = this.binningPanel.getSelectedBinngType();
            transformationType = string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_CATEGORIC()) || string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_NUMERIC()) || string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP()) || string.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP_WITH_TIME_ZONE()) ? TransformationTypes.initCustomBinning(string, this.binningPanel.getCustomBinning()) : TransformationTypes.initBinning(string, this.binningPanel.getBincount(), this.binningPanel.isAuto(), this.binningPanel.isLabels());
        } else if (TransformationTypes.isMissingValues(this._selectedTransformation)) {
            Object object = null;
            String string = this.missValuesPanel.getMissigValueXformType();
            if (string.equals(TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS())) {
                object = this.missValuesPanel.getSelectedStats();
            } else {
                Object object2 = null;
                try {
                    object2 = this.missValuesPanel.getReplacementValue();
                }
                catch (Exception exception) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                    return null;
                }
                if (object2 == null || object2.toString().isEmpty()) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_MISS_VALUE_INVALID"), (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                    return null;
                }
                if (this.datatype == TransformationTypes.DATA_TYPE_NUMERIC) {
                    try {
                        object = Double.valueOf(object2.toString());
                    }
                    catch (Exception exception) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_MISS_VALUE_INVALID"), (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                        return null;
                    }
                } else {
                    object = object2;
                }
            }
            transformationType = TransformationTypes.initMissValues(this.datatype, this.missValuesPanel.getMissigValueXformType(), object);
        } else if (TransformationTypes.isNormalization(this._selectedTransformation)) {
            try {
                TransformationType.Normalization normalization = this.normalizationPanel.getResults();
                if (normalization != null) {
                    transformationType = new TransformationType();
                    transformationType.setNormalization(normalization);
                }
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
            }
        } else if (TransformationTypes.isOutlier(this._selectedTransformation)) {
            try {
                TransformationType.Outlier outlier = this.outlierPanel.getResults();
                if (outlier != null) {
                    transformationType = new TransformationType();
                    transformationType.setOutlier(outlier);
                }
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
            }
        }
        return transformationType;
    }
}

