/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.GenericTableTooltip;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.MessagePanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformSettingsEditorDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationNodeAttributesGrid;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.ComponentWithTitlebar;

public class TransformationNodeAttributesPanelPreRun
extends AbstractDialogPanel
implements DataConsumerPanel {
    private TransformSettingsEditorDialog parentDlg;
    private TransformationNodeAttributesGrid grid;
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JPanel jBottomPanel;
    private JSplitPane jSplitPane1;
    private JPanel jTopPanel;
    private GenericTable _jAttributesTable = new GenericTableTooltip();

    public TransformationNodeAttributesPanelPreRun(TransformSettingsEditorDialog transformSettingsEditorDialog, Context context, AbstractNode abstractNode) {
        super(context, abstractNode);
        this.parentDlg = transformSettingsEditorDialog;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jTopPanel = new JPanel();
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.jBottomPanel = new JPanel();
        this.jSplitPane1.setDividerLocation(150);
        this.jSplitPane1.setOrientation(0);
        GroupLayout groupLayout = new GroupLayout(this.jTopPanel);
        this.jTopPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 607, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAttributesComponent, -1, 587, Short.MAX_VALUE).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 149, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAttributesComponent, -1, 127, Short.MAX_VALUE).addContainerGap())));
        this.jSplitPane1.setTopComponent(this.jTopPanel);
        GroupLayout groupLayout2 = new GroupLayout(this.jBottomPanel);
        this.jBottomPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 607, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 196, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this.jBottomPanel);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING, -1, 609, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jSplitPane1, -1, 352, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        this.jSplitPane1.setDividerLocation(280);
        HelpUtils.setHelpID((JComponent)this, (String)"edit_transform_settings");
    }

    @Override
    public void initUI() {
        AbstractNode abstractNode = this.getData();
        NodeType nodeType = abstractNode.getData();
        TransformationNodeType transformationNodeType = (TransformationNodeType)nodeType;
        this.grid = new TransformationNodeAttributesGrid(abstractNode, this.parentDlg, transformationNodeType);
        this.grid.initUI(this.getContext(), this.jAttributesComponent, this._jAttributesTable);
        this.jBottomPanel.setLayout(new FlowLayout());
        this.createNoDataPanel(this.jBottomPanel);
    }

    private void createNoDataPanel(JPanel jPanel) {
        String string = XformDialogsLrb.get("ADD_TRANSFORMATION_PRE_RUN_1");
        String string2 = XformDialogsLrb.get("ADD_TRANSFORMATION_PRE_RUN_2");
        MessagePanel messagePanel = new MessagePanel(string, string2);
        jPanel.add(messagePanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doWork() {
        TransformationNode transformationNode = (TransformationNode)this.getData();
        CommandProcessor.getInstance().beginTrans(XformDialogsLrb.get("XFROM_NODE_PROPERTIES_TRANSACTION_NAME"));
        try {
            TransformationNodeType transformationNodeType = this.grid.getCachedTransformationNodeType();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property("allXfomNodeColumns", null, AttributeTypeHelper.getAllColumns(transformationNodeType), null, null));
            arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)transformationNode.getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(transformationNode, this._context, arrayList);
            transformationNode.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)XformDialogsLrb.get("XFROM_NODE_PROPERTIES_DIALOG_FAILURE_TITLE"), (String)XformDialogsLrb.get("XFROM_NODE_PROPERTIES_DIALOG_FAILURE_MSG"), null);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
        return true;
    }

    @Override
    public void cleanUp() {
        this.grid.cleanUp();
    }
}

