/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.dmt.dataminer.controls.MiniHistogramCellRenderer;
import oracle.dmt.dataminer.controls.OutputCellEditor;
import oracle.dmt.dataminer.controls.OutputCellRenderer;
import oracle.dmt.dataminer.dprofiler.DataProfilePanelSettings;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddCustomTransformsDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddEditTransformsDialogAbstract;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddTransformsDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.ApplyTransformWizard;
import oracle.dmt.dataminer.workflow.dialog.transformations.EditCustomTransformsDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.EditTransformationsAbtractDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.EditTransformsDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.ExtendedTransformationSettingsTableModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.FilterProcessor;
import oracle.dmt.dataminer.workflow.dialog.transformations.RefreshResult;
import oracle.dmt.dataminer.workflow.dialog.transformations.SearchHelper;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformSettingsEditorDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformationPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformationSettingsTableModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.dmt.javatools.ui.table.table.RolloverTableRenderer;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.util.SwingWorker;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class TransformationNodeAttributesGrid
implements TableModelListener,
FilterProcessor {
    private TransformSettingsEditorDialog parentDlg;
    private JButton removeBtn;
    private JButton editBtn;
    private JButton addBtn;
    private JButton addCustomBtn;
    private JButton _outputTrueBtn;
    private JButton _outputFalseBtn;
    private boolean loading;
    private boolean _showStats;
    private SearchHelper _searchHelper;
    private TransformationNode _node;
    private TransformationNodeType _cachedTransformationNodeType;
    private TransformationStatisticsState _state;
    private List<TransformationSourceAttribute> _combinedAttrList = new ArrayList<TransformationSourceAttribute>();
    private static Preferences _p = Preferences.getPreferences();
    private GraphicalPreferencesSettings graphPanelSettings = GraphicalPreferencesSettings.getInstance((PropertyStorage)_p);
    private DataProfilePanelSettings dataProfilePanelSettings = DataProfilePanelSettings.getInstance((PropertyStorage)_p);
    private GenericTable _jAttributesTable;
    private static String _CANCELLED = "_canceled";
    private static String _DATA_UP_TODATE = "_data_up_todate";
    private static String _SUCCESS = "_success";

    public GraphicalPreferencesSettings getGraphPanelSettings() {
        return this.graphPanelSettings;
    }

    public TransformationStatisticsState getState() {
        return this._state;
    }

    public void setLoading(boolean bl) {
        this.loading = bl;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public TransformationNode getNode() {
        return this._node;
    }

    public TransformationNodeAttributesGrid(AbstractNode abstractNode, TransformSettingsEditorDialog transformSettingsEditorDialog, TransformationNodeType transformationNodeType) {
        this._node = (TransformationNode)abstractNode;
        this._cachedTransformationNodeType = AttributeTypeHelper.cloneTransformationNodeType(transformationNodeType);
        this.parentDlg = transformSettingsEditorDialog;
    }

    void showStats(GenericTable genericTable, boolean bl) {
        this._showStats = bl;
        this._jAttributesTable = genericTable;
        int[] nArray = genericTable.getSelectedRowsInModel();
        TransformationSettingsTableModel transformationSettingsTableModel = (TransformationSettingsTableModel)((Object)genericTable.getModel());
        transformationSettingsTableModel = bl && null != this._cachedTransformationNodeType.getInputStatisticTable().getName() ? this.initialCreateExtendedTableModel(genericTable, nArray, true) : this.initialCreateTableModel(genericTable, nArray);
        if (transformationSettingsTableModel == null) {
            return;
        }
        this.setupItemsTable(transformationSettingsTableModel, genericTable);
    }

    void refreshStats(GenericTable genericTable, boolean bl) throws Exception {
        assert (null != this._cachedTransformationNodeType.getInputStatisticTable().getName());
        int[] nArray = genericTable.getSelectedRowsInModel();
        TransformationSettingsTableModel transformationSettingsTableModel = (TransformationSettingsTableModel)((Object)genericTable.getModel());
        Object object = this.refreshStatistics();
        if (object instanceof Exception) {
            throw (Exception)object;
        }
        if (object.equals(_DATA_UP_TODATE)) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_INFO"), (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_INFO_TITLE"), null);
            return;
        }
        if (object.equals(_CANCELLED)) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("REFRESHING_STATISTICS_ABORTED"), (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
            return;
        }
        transformationSettingsTableModel = bl ? this.refreshExtendedTableModel(genericTable, nArray, true) : this.refreshTableModel(genericTable);
        if (transformationSettingsTableModel == null) {
            return;
        }
        this.setupItemsTable(transformationSettingsTableModel, genericTable);
        if (nArray != null && nArray.length > 0 && !(transformationSettingsTableModel instanceof LoadingTransformationSettingsTableModel)) {
            genericTable.setRowSelectionInterval(nArray[0], nArray[0]);
        }
    }

    public Object refreshStatistics() throws Exception {
        class Loader
        extends ProgressRunnable {
            private boolean _canceled = false;
            private boolean _success = false;
            private Exception _exception;

            Loader() {
            }

            protected Object doWork() throws Exception {
                try {
                    this._success = TransformationNodeAttributesGrid.this._state.refreshAllStatistics();
                }
                catch (Exception exception) {
                    this._exception = exception;
                }
                return TransformationNodeAttributesGrid.this._state;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }
        }
        Loader loader = new Loader();
        loader.setTitle(XformDialogsLrb.get("REFRESHING_STATISTICS"));
        loader.setMessage(XformDialogsLrb.get("REFRESHING_STATISTICS_DETAILS"));
        loader.start(true);
        if (loader._canceled) {
            return _CANCELLED;
        }
        if (null != loader._exception) {
            return loader._exception;
        }
        return loader._success ? _SUCCESS : _DATA_UP_TODATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initUI(final Context context, ComponentWithTitlebar<JComponent> componentWithTitlebar, final GenericTable genericTable) {
        Connection connection;
        this._showStats = this.graphPanelSettings.isShowStatistics();
        this._jAttributesTable = genericTable;
        this.prepareCreateModel();
        this._state = new TransformationStatisticsState(context, this.graphPanelSettings, this._node, this._cachedTransformationNodeType.getTransformedAttributes(), AttributeTypeHelper.toVector(this._combinedAttrList));
        this.identifyModifiedColumn();
        boolean bl = false;
        TransformationSettingsTableModel transformationSettingsTableModel = null;
        String string = this._cachedTransformationNodeType.getInputStatisticTable().getName();
        if (this._showStats && null != string) {
            boolean bl2 = false;
            connection = null;
            try {
                connection = Connections.getUniqueConnection(context);
                ConnectionFolder.setConnectionAlterSessionFixes(connection);
                bl2 = DatabaseMetadataUtils.datasourceExists(connection, Connections.getUserAccountName(context), string);
            }
            catch (Exception exception) {
                bl2 = false;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            if (bl2) {
                transformationSettingsTableModel = this.initialCreateExtendedTableModel(genericTable, null, true);
            }
        }
        if (transformationSettingsTableModel == null) {
            transformationSettingsTableModel = this.initialCreateTableModel(genericTable, null);
            bl = true;
        }
        if (transformationSettingsTableModel == null) {
            return;
        }
        this.setupItemsTable(transformationSettingsTableModel, genericTable);
        JScrollPane jScrollPane = new JScrollPane((Component)genericTable);
        componentWithTitlebar.setComponent((JComponent)jScrollPane);
        componentWithTitlebar.setLabel(new JLabel(PreferencesLrb.get("PI_ATTRUBUTES_GROUP_TITLE")));
        connection = new ControlBar();
        this.installItemFilterActions(context, (ControlBar)connection, genericTable);
        this.editBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
        this.addBtn.setEnabled(false);
        this.addCustomBtn.setEnabled(false);
        this._outputTrueBtn.setEnabled(false);
        this._outputFalseBtn.setEnabled(false);
        componentWithTitlebar.setControlBar((ControlBar)connection);
        genericTable.setFillsViewportHeight(true);
        genericTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ListSelectionModel listSelectionModel;
                if (mouseEvent.getClickCount() == 2 && !(listSelectionModel = genericTable.getSelectionModel()).isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
                    int[] nArray = genericTable.getSelectedRowsInModel();
                    TransformationSettingsTableModel transformationSettingsTableModel = (TransformationSettingsTableModel)((Object)genericTable.getModel());
                    TransformationSourceAttribute transformationSourceAttribute = transformationSettingsTableModel.getDataVector().get(nArray[0]);
                    try {
                        if (!DatabaseMetadataUtils.isDataTypeSupported(transformationSourceAttribute.getDataType())) {
                            return;
                        }
                        if (DatabaseMetadataUtils.isACustomDataType(TransformationNodeAttributesGrid.this._node.getContext(), transformationSourceAttribute.getDataType())) {
                            return;
                        }
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                        return;
                    }
                    if (!transformationSourceAttribute.getStatus().equals((Object)AttributeStatus.VALID)) {
                        return;
                    }
                    if (transformationSourceAttribute instanceof TransformationOutputAttribute) {
                        TransformationOutputAttribute transformationOutputAttribute = (TransformationOutputAttribute)transformationSourceAttribute;
                        ArrayList<TransformationSourceAttribute> arrayList = new ArrayList<TransformationSourceAttribute>();
                        arrayList.add(transformationSourceAttribute);
                        EditTransformationsAbtractDialog editTransformationsAbtractDialog = TransformationTypes.isCustomXform(transformationOutputAttribute.getTransformationElementType()) ? new EditCustomTransformsDialog(TransformationNodeAttributesGrid.this._cachedTransformationNodeType, TransformationNodeAttributesGrid.this._state, transformationOutputAttribute, false) : new EditTransformsDialog(TransformationNodeAttributesGrid.this._cachedTransformationNodeType, TransformationNodeAttributesGrid.this._state, arrayList, false);
                        AbstractDataNode abstractDataNode = (AbstractDataNode)TransformationNodeAttributesGrid.this._node.findParentNode();
                        if (editTransformationsAbtractDialog.invoke(context, TransformationNodeAttributesGrid.this._node, abstractDataNode)) {
                            String string;
                            MapTransformedSource mapTransformedSource = editTransformationsAbtractDialog.getTransformedAttribute();
                            String string2 = mapTransformedSource.getKey().getName();
                            if (mapTransformedSource.getKey().isModified()) {
                                TransformationNodeAttributesGrid.this._state.removeAllData(string2);
                                TransformationNodeAttributesGrid.this.addToModifiedList(mapTransformedSource);
                                transformationSettingsTableModel = TransformationNodeAttributesGrid.this.createTableModel(genericTable);
                                if (transformationSettingsTableModel != null) {
                                    for (int i = 0; i < transformationSettingsTableModel.getDataVector().size(); ++i) {
                                        string = transformationSettingsTableModel.getDataVector().get(i);
                                        if (!string.getName().equals(string2)) continue;
                                        genericTable.setSelectedRowInModel(i);
                                        break;
                                    }
                                }
                                genericTable.scrollToSelection();
                            }
                            if (editTransformationsAbtractDialog.isUpdateWhenFinished()) {
                                if (!TransformationNodeAttributesGrid.this._state.isModified(string2)) {
                                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_INFO"), (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_INFO_TITLE"), null);
                                    return;
                                }
                                try {
                                    RefreshResult refreshResult = TransformationNodeAttributesGrid.this.updateWhenFinished(string2);
                                    if (refreshResult.isException()) {
                                        throw refreshResult.getException();
                                    }
                                    if (refreshResult == null) {
                                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("REFRESHING_STATISTICS_ABORTED"), (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                                        return;
                                    }
                                    TransformationNodeAttributesGrid.this._state.setDataProfileStatisticsData(refreshResult.getStatsData());
                                    TransformationNodeAttributesGrid.this.parentDlg.updateGraph(refreshResult.getGrafDataModel());
                                }
                                catch (Exception exception) {
                                    string = exception.getLocalizedMessage();
                                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                                }
                            }
                        }
                    } else {
                        ArrayList<TransformationSourceAttribute> arrayList = new ArrayList<TransformationSourceAttribute>();
                        arrayList.add(transformationSourceAttribute);
                        AddTransformsDialog addTransformsDialog = new AddTransformsDialog(TransformationNodeAttributesGrid.this._cachedTransformationNodeType, TransformationNodeAttributesGrid.this._state, arrayList);
                        AbstractDataNode abstractDataNode = (AbstractDataNode)TransformationNodeAttributesGrid.this._node.findParentNode();
                        if (addTransformsDialog.invoke(context, TransformationNodeAttributesGrid.this._node, abstractDataNode)) {
                            ((TransformationSourceAttribute)arrayList.get(0)).setIsOutput(false);
                            MapTransformedSource mapTransformedSource = addTransformsDialog.getTransformedAttribute();
                            List list = TransformationNodeAttributesGrid.this._cachedTransformationNodeType.getTransformedAttributes().getMapTransformedSourceType();
                            list.add(mapTransformedSource);
                            TransformationNodeAttributesGrid.this.addToModifiedList(mapTransformedSource);
                            transformationSettingsTableModel = TransformationNodeAttributesGrid.this.createTableModel(genericTable);
                            if (transformationSettingsTableModel != null) {
                                for (int i = 0; i < transformationSettingsTableModel.getDataVector().size(); ++i) {
                                    TransformationSourceAttribute transformationSourceAttribute2 = transformationSettingsTableModel.getDataVector().get(i);
                                    if (!transformationSourceAttribute2.getName().equals(mapTransformedSource.getKey().getName())) continue;
                                    genericTable.setSelectedRowInModel(i);
                                    break;
                                }
                            }
                            genericTable.scrollToSelection();
                        }
                    }
                }
            }
        });
        if (bl && genericTable.getModel().getRowCount() > 0) {
            genericTable.setRowSelectionInterval(0, 0);
        }
    }

    private void addCellRenderes(GenericTable genericTable) {
        genericTable.setRowHeight((int)MiniHistogramCellRenderer._DEFAULT_PREFFERRED_WIDTH.getHeight());
        genericTable.getColumnModel().getColumn(ExtendedTransformationSettingsTableModel.HISTOGRAM).setCellRenderer(new MiniHistogramCellRenderer(this._state));
        genericTable.getColumnModel().getColumn(ExtendedTransformationSettingsTableModel.PERCENT_NULL).setCellRenderer(new CustomRenderer(FormatType.PERCENTAGE));
        genericTable.getColumnModel().getColumn(ExtendedTransformationSettingsTableModel.DISTINCT).setCellRenderer(new CustomRenderer());
        genericTable.getColumnModel().getColumn(ExtendedTransformationSettingsTableModel.MODE).setCellRenderer(new CustomRenderer());
        genericTable.getColumnModel().getColumn(ExtendedTransformationSettingsTableModel.AVG).setCellRenderer(new CustomRenderer());
        genericTable.getColumnModel().getColumn(ExtendedTransformationSettingsTableModel.MEDIAN).setCellRenderer(new CustomRenderer());
        genericTable.getColumnModel().getColumn(ExtendedTransformationSettingsTableModel.MIN).setCellRenderer(new CustomRenderer());
        genericTable.getColumnModel().getColumn(ExtendedTransformationSettingsTableModel.MAX).setCellRenderer(new CustomRenderer());
        genericTable.getColumnModel().getColumn(ExtendedTransformationSettingsTableModel.STD).setCellRenderer(new CustomRenderer());
        genericTable.getColumnModel().getColumn(ExtendedTransformationSettingsTableModel.VAR).setCellRenderer(new CustomRenderer());
        genericTable.getColumnModel().getColumn(ExtendedTransformationSettingsTableModel.SKEWNESS).setCellRenderer(new CustomRenderer());
        genericTable.getColumnModel().getColumn(ExtendedTransformationSettingsTableModel.KURTOSIS).setCellRenderer(new CustomRenderer());
    }

    public RefreshResult updateWhenFinished(final String string) throws Exception {
        class Loader
        extends ProgressRunnable {
            private RefreshResult results = new RefreshResult();

            Loader() {
            }

            protected Object doWork() throws Exception {
                try {
                    TransformationNodeAttributesGrid.this._state.refreshSingleColumnStatistics(string);
                    HashMap<String, DataProfileStatisticsData> hashMap = new HashMap<String, DataProfileStatisticsData>();
                    HashMap<String, TransformationStatisticsState.AttributeHistogramArray> hashMap2 = new HashMap<String, TransformationStatisticsState.AttributeHistogramArray>();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string);
                    List<DataProfileStatisticsData> list = TransformationNodeAttributesGrid.this._state.loadColumnRefreshedStatistics(hashMap, hashMap2, arrayList);
                    this.results.statsData = list.get(0);
                    GraphDataModel graphDataModel = TransformationNodeAttributesGrid.this._state.createBriefRefreshedGraphModel(string, hashMap2.get(TransformationStatisticsState.getQuotedName(string)));
                    this.results.statsData.setGraphDataModel(graphDataModel);
                    this.results.grafDataModel = TransformationNodeAttributesGrid.this._state.createDetailedRefreshedGraphModel(string, hashMap2.get(TransformationStatisticsState.getQuotedName(string)));
                    ArrayList<TransformationStatisticsState.AttributeHistogramArray> arrayList2 = new ArrayList<TransformationStatisticsState.AttributeHistogramArray>(hashMap2.values());
                    TransformationNodeAttributesGrid.this._state.updateRefreshedData(string, (TransformationStatisticsState.AttributeHistogramArray)arrayList2.get(0), this.results.statsData);
                }
                catch (Exception exception) {
                    this.results.exception = exception;
                }
                return this.results;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this.results = null;
            }
        }
        Loader loader = new Loader();
        loader.setTitle(XformDialogsLrb.get("REFRESHING_STATISTICS"));
        loader.setMessage(XformDialogsLrb.get("REFRESHING_STATISTICS_DETAILS"));
        loader.start(true);
        return loader.results;
    }

    public WizardGenerateStatsResults generateStatsOnExit(final List<String> list) throws Exception {
        class Loader
        extends ProgressRunnable {
            private WizardGenerateStatsResults wizResults;

            Loader() {
                this.wizResults = new WizardGenerateStatsResults();
            }

            protected Object doWork() throws Exception {
                try {
                    TransformationNodeAttributesGrid.this._state.refreshSelectedColumnsStatistics(list);
                    HashMap<String, DataProfileStatisticsData> hashMap = new HashMap<String, DataProfileStatisticsData>();
                    HashMap<String, TransformationStatisticsState.AttributeHistogramArray> hashMap2 = new HashMap<String, TransformationStatisticsState.AttributeHistogramArray>();
                    List<DataProfileStatisticsData> list2 = TransformationNodeAttributesGrid.this._state.loadColumnRefreshedStatistics(hashMap, hashMap2, list);
                    HashMap<String, DataProfileStatisticsData> hashMap3 = new HashMap<String, DataProfileStatisticsData>();
                    for (DataProfileStatisticsData dataProfileStatisticsData : list2) {
                        RefreshResult refreshResult = new RefreshResult();
                        refreshResult.statsData = dataProfileStatisticsData;
                        GraphDataModel graphDataModel = TransformationNodeAttributesGrid.this._state.createBriefRefreshedGraphModel(dataProfileStatisticsData.getName(), hashMap2.get(TransformationStatisticsState.getQuotedName(dataProfileStatisticsData.getName())));
                        refreshResult.statsData.setGraphDataModel(graphDataModel);
                        refreshResult.grafDataModel = TransformationNodeAttributesGrid.this._state.createDetailedRefreshedGraphModel(dataProfileStatisticsData.getName(), hashMap2.get(TransformationStatisticsState.getQuotedName(dataProfileStatisticsData.getName())));
                        hashMap3.put(dataProfileStatisticsData.getName(), refreshResult.statsData);
                        this.wizResults.add(refreshResult);
                    }
                    TransformationNodeAttributesGrid.this._state.updateRefreshedDataWiz(list, hashMap2, hashMap3);
                }
                catch (Exception exception) {
                    this.wizResults.exception = exception;
                }
                return this.wizResults;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this.wizResults = null;
            }
        }
        Loader loader = new Loader();
        loader.setTitle(XformDialogsLrb.get("REFRESHING_STATISTICS"));
        loader.setMessage(XformDialogsLrb.get("REFRESHING_STATISTICS_DETAILS"));
        loader.start(true);
        return loader.wizResults;
    }

    private void setupItemsTable(TransformationSettingsTableModel transformationSettingsTableModel, GenericTable genericTable) {
        genericTable.setModel((TableModel)((Object)transformationSettingsTableModel));
        if (transformationSettingsTableModel instanceof LoadingTransformationSettingsTableModel) {
            return;
        }
        genericTable.setShowGrid(true);
        genericTable.setSorted(true);
        genericTable.setSortColumn(TransformationSettingsTableModel.COLUMN, true);
        genericTable.getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler(genericTable));
        TableColumn tableColumn = genericTable.getColumnModel().getColumn(TransformationSettingsTableModel.COLUMN);
        tableColumn.setCellRenderer(new CustomCellRenderer());
        tableColumn = genericTable.getColumnModel().getColumn(TransformationSettingsTableModel.OUTPUT);
        tableColumn.setCellEditor(new OutputCellEditor());
        tableColumn = genericTable.getColumnModel().getColumn(TransformationSettingsTableModel.OUTPUT);
        tableColumn.setCellRenderer(new OutputCellRenderer());
        if (transformationSettingsTableModel instanceof ExtendedTransformationSettingsTableModel) {
            this.addCellRenderes(genericTable);
        }
        this.setPreferredWidth(genericTable, transformationSettingsTableModel);
        transformationSettingsTableModel.addTableModelListener(this);
    }

    private void installItemFilterActions(final Context context, ControlBar controlBar, final GenericTable genericTable) {
        TransformationNodeAttributesGrid transformationNodeAttributesGrid = this;
        this.editBtn = new JButton(transformationNodeAttributesGrid.parentDlg.getEditIcon());
        this.editBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_EDIT_BIN_DEFINITION"));
        this.editBtn.getAccessibleContext().setAccessibleName(InspectorArb.getString((int)23));
        this.editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                int[] nArray = genericTable.getSelectedRowsInModel();
                ArrayList<TransformationSourceAttribute> arrayList = new ArrayList<TransformationSourceAttribute>();
                TransformationSettingsTableModel transformationSettingsTableModel = (TransformationSettingsTableModel)((Object)genericTable.getModel());
                String string = null;
                String string2 = null;
                for (int i = 0; i < nArray.length; ++i) {
                    object = (TransformationOutputAttribute)transformationSettingsTableModel.getDataVector().get(nArray[i]);
                    if (string == null) {
                        string = object.getDataType();
                    } else if (!TransformationTypes.isComparabelDataTypes(string, object.getDataType())) {
                        string2 = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_INCOMPATIBLE_COLUMNS");
                        break;
                    }
                    arrayList.add((TransformationSourceAttribute)object);
                }
                if (null != string2) {
                    MessageDialog.error((Component)Ide.getMainWindow(), string2, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                    return;
                }
                AbstractDataNode abstractDataNode = (AbstractDataNode)TransformationNodeAttributesGrid.this._node.findParentNode();
                if (arrayList.size() == 1) {
                    EditTransformationsAbtractDialog editTransformationsAbtractDialog;
                    object = (TransformationOutputAttribute)arrayList.get(0);
                    ArrayList<TransformationSourceAttribute> arrayList2 = new ArrayList<TransformationSourceAttribute>();
                    arrayList2.add((TransformationSourceAttribute)arrayList.get(0));
                    EditTransformationsAbtractDialog editTransformationsAbtractDialog2 = editTransformationsAbtractDialog = TransformationTypes.isCustomXform(object.getTransformationElementType()) ? new EditCustomTransformsDialog(TransformationNodeAttributesGrid.this._cachedTransformationNodeType, TransformationNodeAttributesGrid.this._state, (TransformationOutputAttribute)object, false) : new EditTransformsDialog(TransformationNodeAttributesGrid.this._cachedTransformationNodeType, TransformationNodeAttributesGrid.this._state, arrayList2, false);
                    if (editTransformationsAbtractDialog.invoke(context, TransformationNodeAttributesGrid.this._node, abstractDataNode)) {
                        String string3;
                        MapTransformedSource mapTransformedSource = editTransformationsAbtractDialog.getTransformedAttribute();
                        String string4 = mapTransformedSource.getKey().getName();
                        if (mapTransformedSource.getKey().isModified()) {
                            TransformationNodeAttributesGrid.this._state.removeAllData(string4);
                            TransformationNodeAttributesGrid.this.addToModifiedList(mapTransformedSource);
                            transformationSettingsTableModel = TransformationNodeAttributesGrid.this.createTableModel(genericTable);
                            if (transformationSettingsTableModel != null) {
                                for (int i = 0; i < transformationSettingsTableModel.getDataVector().size(); ++i) {
                                    string3 = transformationSettingsTableModel.getDataVector().get(i);
                                    if (!string3.getName().equals(string4)) continue;
                                    genericTable.setSelectedRowInModel(i);
                                    break;
                                }
                                genericTable.scrollToSelection();
                            }
                        }
                        if (editTransformationsAbtractDialog.isUpdateWhenFinished()) {
                            if (!TransformationNodeAttributesGrid.this._state.isModified(string4)) {
                                MessageDialog.information((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_INFO"), (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_INFO_TITLE"), null);
                                return;
                            }
                            try {
                                RefreshResult refreshResult = TransformationNodeAttributesGrid.this.updateWhenFinished(mapTransformedSource.getKey().getName());
                                if (refreshResult.isException()) {
                                    throw refreshResult.getException();
                                }
                                if (refreshResult == null) {
                                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("REFRESHING_STATISTICS_ABORTED"), (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                                    return;
                                }
                                TransformationNodeAttributesGrid.this._state.setDataProfileStatisticsData(refreshResult.getStatsData());
                                TransformationNodeAttributesGrid.this.parentDlg.updateGraph(refreshResult.getGrafDataModel());
                            }
                            catch (Exception exception) {
                                string3 = exception.getLocalizedMessage();
                                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                            }
                        }
                    }
                } else {
                    try {
                        object = new ApplyTransformWizard();
                        if (((ApplyTransformWizard)object).runWizard((Component)Ide.getMainWindow(), context, TransformationNodeAttributesGrid.this._node, abstractDataNode, TransformationNodeAttributesGrid.this._cachedTransformationNodeType, arrayList)) {
                            List<MapTransformedSource> list = ((ApplyTransformWizard)object).getAllXformedColumns();
                            List list2 = TransformationNodeAttributesGrid.this._cachedTransformationNodeType.getTransformedAttributes().getMapTransformedSourceType();
                            list2.clear();
                            list2.addAll(list);
                            ArrayList<String> arrayList3 = new ArrayList<String>();
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            for (Object object2 : ((ApplyTransformWizard)object).getEditedXformedColumns()) {
                                String string5 = object2.getKey().getName();
                                if (!object2.getKey().isModified()) continue;
                                TransformationNodeAttributesGrid.this._state.removeAllData(string5);
                                TransformationNodeAttributesGrid.this.addToModifiedList(object2);
                                hashMap.put(string5, string5);
                                arrayList3.add(object2.getKey().getName());
                            }
                            TransformationNodeAttributesGrid.this.createTableModel(genericTable);
                            if (((ApplyTransformWizard)object).isGeneratStats()) {
                                try {
                                    WizardGenerateStatsResults wizardGenerateStatsResults = TransformationNodeAttributesGrid.this.generateStatsOnExit(arrayList3);
                                    if (wizardGenerateStatsResults.isException()) {
                                        throw wizardGenerateStatsResults.getException();
                                    }
                                    if (wizardGenerateStatsResults == null) {
                                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("REFRESHING_STATISTICS_ABORTED"), (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                                        return;
                                    }
                                    TransformationNodeAttributesGrid.this._state.setDataProfileStatisticsData(wizardGenerateStatsResults.getStatsData());
                                    TransformationNodeAttributesGrid.this.parentDlg.updateGraph(wizardGenerateStatsResults.getGraphDataModelMap());
                                }
                                catch (Exception exception) {
                                    Object object2;
                                    object2 = exception.getLocalizedMessage();
                                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)object2, (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        controlBar.add((Component)this.editBtn);
        TransformationNodeAttributesGrid transformationNodeAttributesGrid2 = this;
        this.removeBtn = new JButton(transformationNodeAttributesGrid2.parentDlg.getRemoveIcon());
        this.removeBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_REMOVE_BIN_DEFINITION"));
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Object object2;
                Object object3;
                int[] nArray = genericTable.getSelectedRowsInModel();
                ArrayList<TransformationOutputAttribute> arrayList = new ArrayList<TransformationOutputAttribute>();
                TransformationSettingsTableModel transformationSettingsTableModel = (TransformationSettingsTableModel)((Object)genericTable.getModel());
                for (int i = 0; i < nArray.length; ++i) {
                    object3 = (TransformationOutputAttribute)transformationSettingsTableModel.getDataVector().get(nArray[i]);
                    arrayList.add((TransformationOutputAttribute)object3);
                }
                List list = TransformationNodeAttributesGrid.this._cachedTransformationNodeType.getTransformedAttributes().getMapTransformedSourceType();
                object3 = new HashMap();
                Map map = TransformationNodeAttributesGrid.this.getDecoupledInvalidSrcColumns(arrayList);
                for (MapTransformedSource object4 : list) {
                    object3.put(object4.getKey().getName(), object4);
                }
                for (TransformationOutputAttribute transformationOutputAttribute : arrayList) {
                    object2 = (MapTransformedSource)object3.get(transformationOutputAttribute.getName());
                    if (null == object2) continue;
                    list.remove(object2);
                }
                if (null != map && null != TransformationNodeAttributesGrid.this._cachedTransformationNodeType.getTransformationSourceAttributes()) {
                    object = TransformationNodeAttributesGrid.this._cachedTransformationNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType();
                    ArrayList<TransformationSourceAttribute> arrayList2 = new ArrayList<TransformationSourceAttribute>();
                    object2 = object.iterator();
                    while (object2.hasNext()) {
                        TransformationSourceAttribute transformationSourceAttribute = (TransformationSourceAttribute)object2.next();
                        if (null == map.get(transformationSourceAttribute.getName())) continue;
                        arrayList2.add(transformationSourceAttribute);
                    }
                    if (!arrayList2.isEmpty()) {
                        object.removeAll(arrayList2);
                    }
                }
                if (TransformationNodeAttributesGrid.this._showStats && null != TransformationNodeAttributesGrid.this._cachedTransformationNodeType.getInputStatisticTable().getName()) {
                    TransformationNodeAttributesGrid.this.prepareCreateModel();
                    TransformationNodeAttributesGrid.this._state.setTransformationSourceAttributes(AttributeTypeHelper.toVector(TransformationNodeAttributesGrid.this._combinedAttrList));
                    object = new LoadUI(genericTable, null, true);
                    object.start();
                } else {
                    TransformationNodeAttributesGrid.this.prepareCreateModel();
                    transformationSettingsTableModel = new TransformationSettingsTableModel(TransformationNodeAttributesGrid.this._cachedTransformationNodeType.getTransformedAttributes(), AttributeTypeHelper.toVector(TransformationNodeAttributesGrid.this._combinedAttrList), null, null, 0);
                    TransformationNodeAttributesGrid.this.setupItemsTable(transformationSettingsTableModel, genericTable);
                }
            }
        });
        controlBar.add((Component)this.removeBtn);
        TransformationNodeAttributesGrid transformationNodeAttributesGrid3 = this;
        this.addBtn = new JButton(transformationNodeAttributesGrid3.parentDlg.getAddIcon());
        this.addBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_ADD_BIN_DEFINITION"));
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object2;
                Object object3;
                int[] nArray = genericTable.getSelectedRowsInModel();
                ArrayList<TransformationSourceAttribute> arrayList = new ArrayList<TransformationSourceAttribute>();
                String string = null;
                if (nArray != null && nArray.length > 0) {
                    object3 = (TransformationSettingsTableModel)((Object)genericTable.getModel());
                    object2 = null;
                    for (int i = 0; i < nArray.length; ++i) {
                        TransformationSourceAttribute object5 = ((TransformationSettingsTableModel)((Object)object3)).getDataVector().get(nArray[i]);
                        if (object5 instanceof TransformationOutputAttribute) {
                            string = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ORIGINAL_SELECTED_COLUMNS");
                            break;
                        }
                        if (object2 == null) {
                            object2 = object5.getDataType();
                        } else if (!TransformationTypes.isComparabelDataTypes((String)object2, object5.getDataType())) {
                            string = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_INCOMPATIBLE_COLUMNS");
                            break;
                        }
                        arrayList.add(object5);
                    }
                }
                if (null != string) {
                    MessageDialog.error((Component)Ide.getMainWindow(), string, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                    return;
                }
                if (arrayList.size() <= 1) {
                    object3 = new AddTransformsDialog(TransformationNodeAttributesGrid.this._cachedTransformationNodeType, TransformationNodeAttributesGrid.this._state, arrayList);
                    object2 = (AbstractDataNode)TransformationNodeAttributesGrid.this._node.findParentNode();
                    if (((EditTransformationsAbtractDialog)object3).invoke(context, TransformationNodeAttributesGrid.this._node, (AbstractDataNode)object2)) {
                        MapTransformedSource mapTransformedSource = ((AddEditTransformsDialogAbstract)object3).getTransformedAttribute();
                        String string2 = (String)mapTransformedSource.getStringCollectionNames().getValue().get(0);
                        TransformationSettingsTableModel transformationSettingsTableModel = (TransformationSettingsTableModel)((Object)genericTable.getModel());
                        Vector<TransformationSourceAttribute> vector = transformationSettingsTableModel.getDataVector();
                        for (TransformationSourceAttribute transformationSourceAttribute : vector) {
                            if (!transformationSourceAttribute.getName().equals(string2)) continue;
                            transformationSourceAttribute.setIsOutput(false);
                            break;
                        }
                        List list = TransformationNodeAttributesGrid.this._cachedTransformationNodeType.getTransformedAttributes().getMapTransformedSourceType();
                        list.add(mapTransformedSource);
                        TransformationNodeAttributesGrid.this.addToModifiedList(mapTransformedSource);
                        TransformationSettingsTableModel transformationSettingsTableModel2 = TransformationNodeAttributesGrid.this.createTableModel(genericTable);
                        if (transformationSettingsTableModel2 != null) {
                            for (int i = 0; i < transformationSettingsTableModel2.getDataVector().size(); ++i) {
                                TransformationSourceAttribute transformationSourceAttribute = transformationSettingsTableModel2.getDataVector().get(i);
                                if (!transformationSourceAttribute.getName().equals(mapTransformedSource.getKey().getName())) continue;
                                genericTable.setSelectedRowInModel(i);
                                break;
                            }
                            genericTable.scrollToSelection();
                        }
                    }
                } else {
                    try {
                        object3 = new ApplyTransformWizard();
                        object2 = (AbstractDataNode)TransformationNodeAttributesGrid.this._node.findParentNode();
                        if (((ApplyTransformWizard)object3).runWizard((Component)Ide.getMainWindow(), context, TransformationNodeAttributesGrid.this._node, (AbstractDataNode)object2, TransformationNodeAttributesGrid.this._cachedTransformationNodeType, arrayList)) {
                            for (TransformationSourceAttribute transformationSourceAttribute : arrayList) {
                                transformationSourceAttribute.setIsOutput(false);
                            }
                            List<MapTransformedSource> list = ((ApplyTransformWizard)object3).getAllXformedColumns();
                            TransformationNodeAttributesGrid.this._cachedTransformationNodeType.getTransformedAttributes().getMapTransformedSourceType().addAll(list);
                            ArrayList<String> arrayList2 = new ArrayList<String>();
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            for (Object object : ((ApplyTransformWizard)object3).getEditedXformedColumns()) {
                                TransformationNodeAttributesGrid.this.addToModifiedList(object);
                                hashMap.put(object.getKey().getName(), object.getKey().getName());
                                arrayList2.add(object.getKey().getName());
                            }
                            TransformationNodeAttributesGrid.this.createTableModel(genericTable);
                            if (((ApplyTransformWizard)object3).isGeneratStats()) {
                                try {
                                    WizardGenerateStatsResults wizardGenerateStatsResults = TransformationNodeAttributesGrid.this.generateStatsOnExit(arrayList2);
                                    if (wizardGenerateStatsResults.isException()) {
                                        throw wizardGenerateStatsResults.getException();
                                    }
                                    if (wizardGenerateStatsResults == null) {
                                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("REFRESHING_STATISTICS_ABORTED"), (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                                        return;
                                    }
                                    TransformationNodeAttributesGrid.this._state.setDataProfileStatisticsData(wizardGenerateStatsResults.getStatsData());
                                }
                                catch (Exception exception) {
                                    Object object;
                                    object = exception.getLocalizedMessage();
                                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)object, (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        controlBar.add((Component)this.addBtn);
        TransformationNodeAttributesGrid transformationNodeAttributesGrid4 = this;
        this.addCustomBtn = new JButton(transformationNodeAttributesGrid4.parentDlg.getCustomTransformIcon());
        this.addCustomBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_ADD_CUSTOM_XFORM"));
        this.addCustomBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddCustomTransformsDialog addCustomTransformsDialog = new AddCustomTransformsDialog(TransformationNodeAttributesGrid.this._cachedTransformationNodeType, null, TransformationNodeAttributesGrid.this._state);
                AbstractDataNode abstractDataNode = (AbstractDataNode)TransformationNodeAttributesGrid.this._node.findParentNode();
                if (addCustomTransformsDialog.invoke(context, TransformationNodeAttributesGrid.this._node, abstractDataNode)) {
                    MapTransformedSource mapTransformedSource = addCustomTransformsDialog.getTransformedAttribute();
                    List list = TransformationNodeAttributesGrid.this._cachedTransformationNodeType.getTransformedAttributes().getMapTransformedSourceType();
                    list.add(mapTransformedSource);
                    TransformationNodeAttributesGrid.this.addToModifiedList(mapTransformedSource);
                    TransformationSettingsTableModel transformationSettingsTableModel = TransformationNodeAttributesGrid.this.createTableModel(genericTable);
                    if (transformationSettingsTableModel != null) {
                        for (int i = 0; i < transformationSettingsTableModel.getDataVector().size(); ++i) {
                            TransformationSourceAttribute transformationSourceAttribute = transformationSettingsTableModel.getDataVector().get(i);
                            if (!transformationSourceAttribute.getName().equals(mapTransformedSource.getKey().getName())) continue;
                            genericTable.setSelectedRowInModel(i);
                            break;
                        }
                        genericTable.scrollToSelection();
                    }
                }
            }
        });
        controlBar.add((Component)this.addCustomBtn);
        TransformationNodeAttributesGrid transformationNodeAttributesGrid5 = this;
        this._outputTrueBtn = new JButton(transformationNodeAttributesGrid5.parentDlg.getOutputTrueIcon());
        this._outputTrueBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_INCLUDE_BIN_DEFINITION"));
        this._outputTrueBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransformationNodeAttributesGrid.this.setOutputState(true);
            }
        });
        controlBar.add((Component)this._outputTrueBtn);
        TransformationNodeAttributesGrid transformationNodeAttributesGrid6 = this;
        this._outputFalseBtn = new JButton(transformationNodeAttributesGrid6.parentDlg.getOutputFalseIcon());
        this._outputFalseBtn.setToolTipText(XformDialogsLrb.get("TOOLTIP_EXCLUDE_BIN_DEFINITION"));
        this._outputFalseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransformationNodeAttributesGrid.this.setOutputState(false);
            }
        });
        controlBar.add((Component)this._outputFalseBtn);
        if (this._searchHelper == null) {
            this._searchHelper = new SearchHelper(this);
        }
        controlBar.addSeparator();
        Component component = this._searchHelper.createFindPane();
        controlBar.add(component);
    }

    private void setOutputState(boolean bl) {
        int[] nArray = this._jAttributesTable.getSelectedRowsInModel();
        if (nArray != null && nArray.length > 0) {
            TransformationSettingsTableModel transformationSettingsTableModel = (TransformationSettingsTableModel)((Object)this._jAttributesTable.getModel());
            for (int i = 0; i < nArray.length; ++i) {
                TransformationSourceAttribute transformationSourceAttribute = transformationSettingsTableModel.getDataVector().get(nArray[i]);
                transformationSourceAttribute.setIsOutput(bl);
            }
            transformationSettingsTableModel.fireTableDataChanged();
            this._jAttributesTable.setSelectedRowsInModel(nArray);
        }
    }

    private void setPreferredWidth(GenericTable genericTable, TransformationSettingsTableModel transformationSettingsTableModel) {
        TableColumnModel tableColumnModel = genericTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(TransformationSettingsTableModel.COLUMN);
        RolloverTableRenderer rolloverTableRenderer = (RolloverTableRenderer)tableColumn.getCellRenderer();
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)rolloverTableRenderer.getBaseRenderer();
        Font font = defaultTableCellRenderer.getFont();
        FontMetrics fontMetrics = defaultTableCellRenderer.getFontMetrics(font);
        String string = transformationSettingsTableModel.getMaxString(TransformationSettingsTableModel.COLUMN);
        int n = fontMetrics.stringWidth(string.toString()) + 5;
        TransformationNodeAttributesGrid transformationNodeAttributesGrid = this;
        tableColumn.setPreferredWidth(n += transformationNodeAttributesGrid.parentDlg.getValid_attribue_icon().getIconWidth());
        tableColumn = tableColumnModel.getColumn(TransformationSettingsTableModel.TYPE);
        string = transformationSettingsTableModel.getMaxString(TransformationSettingsTableModel.TYPE);
        n = fontMetrics.stringWidth(string.toString()) + 5;
        tableColumn.setPreferredWidth(n);
        tableColumn = tableColumnModel.getColumn(TransformationSettingsTableModel.SOURCE_COLUMN);
        string = transformationSettingsTableModel.getMaxString(TransformationSettingsTableModel.SOURCE_COLUMN);
        if (string.isEmpty()) {
            string = transformationSettingsTableModel.getColumnName(TransformationSettingsTableModel.SOURCE_COLUMN) + 10;
        }
        n = fontMetrics.stringWidth(string.toString()) + 5;
        tableColumn.setPreferredWidth(n);
        tableColumn = tableColumnModel.getColumn(TransformationSettingsTableModel.TRANSFORM);
        string = transformationSettingsTableModel.getMaxString(TransformationSettingsTableModel.TRANSFORM);
        if (string.isEmpty()) {
            string = transformationSettingsTableModel.getColumnName(TransformationSettingsTableModel.TRANSFORM) + 10;
        }
        n = fontMetrics.stringWidth(string.toString()) + 5;
        tableColumn.setPreferredWidth(n);
        if (null == this._cachedTransformationNodeType.getInputStatisticTable().getName() || !this._showStats) {
            genericTable.setAutoResizeMode(3);
        } else {
            genericTable.setAutoResizeMode(0);
        }
    }

    public TransformationNodeType getCachedTransformationNodeType() {
        return this._cachedTransformationNodeType;
    }

    private void identifyModifiedColumn() {
        List list;
        TransformedAttributes transformedAttributes = this._cachedTransformationNodeType.getTransformedAttributes();
        if (transformedAttributes != null && (list = transformedAttributes.getMapTransformedSourceType()) != null && !list.isEmpty()) {
            for (MapTransformedSource mapTransformedSource : list) {
                if (!mapTransformedSource.getKey().isModified()) continue;
                this.addToModifiedList(mapTransformedSource);
            }
        }
    }

    private void addToModifiedList(MapTransformedSource mapTransformedSource) {
        this._state.addToModifiedList(mapTransformedSource);
        this.parentDlg.updateResfresButtonState();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.parentDlg.updateResfresButtonState();
    }

    boolean isRefresheEnabled() {
        return !this._state.isUpToDate();
    }

    private Map<String, String> getDecoupledInvalidSrcColumns(List<TransformationOutputAttribute> list) {
        TransformationSourceAttribute transformationSourceAttribute;
        Object object;
        Object object22;
        HashMap<MapTransformedSource, MapTransformedSource> hashMap = null;
        TransformedAttributes transformedAttributes = this._cachedTransformationNodeType.getTransformedAttributes();
        if (transformedAttributes == null) {
            return hashMap;
        }
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (TransformationOutputAttribute object42 : list) {
            hashMap2.put(object42.getName(), object42.getName());
        }
        TransformationSourceAttributes transformationSourceAttributes = this._cachedTransformationNodeType.getTransformationSourceAttributes();
        List list2 = transformationSourceAttributes.getTransformationSourceAttributeType();
        HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
        for (Object object22 : list2) {
            hashMap3.put(object22.getName(), object22);
        }
        ArrayList arrayList = new ArrayList();
        for (TransformationOutputAttribute transformationOutputAttribute : list) {
            object = AttributeTypeHelper.findMapTransformedSource(transformedAttributes, (AttributeType)transformationOutputAttribute);
            List list3 = object.getStringCollectionNames().getValue();
            for (String string : list3) {
                transformationSourceAttribute = (TransformationSourceAttribute)hashMap3.get(string);
                if (transformationSourceAttribute == null || transformationSourceAttribute.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                arrayList.add(string);
            }
        }
        if (arrayList.isEmpty()) {
            return hashMap;
        }
        object22 = transformedAttributes.getMapTransformedSourceType();
        if (object22 == null || object22.isEmpty()) {
            return hashMap;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            boolean bl = false;
            Iterator iterator2 = object22.iterator();
            while (iterator2.hasNext()) {
                String string;
                string = (MapTransformedSource)iterator2.next();
                if (null != hashMap2.get(string.getKey().getName())) continue;
                transformationSourceAttribute = string.getStringCollectionNames();
                List list4 = transformationSourceAttribute.getValue();
                for (String string2 : list4) {
                    if (!string2.equals(object)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                break;
            }
            if (bl) continue;
            if (hashMap == null) {
                hashMap = new HashMap<MapTransformedSource, MapTransformedSource>();
            }
            hashMap.put((MapTransformedSource)object, (MapTransformedSource)object);
        }
        return hashMap;
    }

    private void prepareCreateModel() {
        List list;
        this._combinedAttrList.clear();
        TransformationSourceAttributes transformationSourceAttributes = this._cachedTransformationNodeType.getTransformationSourceAttributes();
        TransformedAttributes transformedAttributes = this._cachedTransformationNodeType.getTransformedAttributes();
        if (transformationSourceAttributes != null && (list = transformationSourceAttributes.getTransformationSourceAttributeType()) != null && !list.isEmpty()) {
            this._combinedAttrList.addAll(list);
        }
        if (transformedAttributes != null && (list = transformedAttributes.getMapTransformedSourceType()) != null && !list.isEmpty()) {
            for (MapTransformedSource mapTransformedSource : list) {
                this._combinedAttrList.add((TransformationSourceAttribute)mapTransformedSource.getKey());
            }
        }
    }

    @Override
    public void processFilter(String string) {
        try {
            TransformationSettingsTableModel transformationSettingsTableModel = null;
            String string2 = this._cachedTransformationNodeType.getInputStatisticTable().getName();
            transformationSettingsTableModel = string2 != null ? (this._showStats && null != this._cachedTransformationNodeType.getInputStatisticTable().getName() ? new ExtendedTransformationSettingsTableModel(this._cachedTransformationNodeType.getTransformedAttributes(), AttributeTypeHelper.toVector(this._combinedAttrList), this._state.loadAllStatistics(string2), string, this._searchHelper.getCurrentSearchCategory()) : new TransformationSettingsTableModel(this._cachedTransformationNodeType.getTransformedAttributes(), AttributeTypeHelper.toVector(this._combinedAttrList), this._state.loadAllStatistics(string2), string, this._searchHelper.getCurrentSearchCategory())) : new TransformationSettingsTableModel(this._cachedTransformationNodeType.getTransformedAttributes(), AttributeTypeHelper.toVector(this._combinedAttrList), null, string, this._searchHelper.getCurrentSearchCategory());
            this.setupItemsTable(transformationSettingsTableModel, this._jAttributesTable);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_FILTER_ERROR_TITLE"), (String)XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_FILTER_ERROR_MESSAGE"), null);
        }
    }

    private TransformationSettingsTableModel refreshExtendedTableModel(GenericTable genericTable, int[] nArray, boolean bl) throws Exception {
        this.prepareCreateModel();
        LoadingTransformationSettingsTableModel loadingTransformationSettingsTableModel = new LoadingTransformationSettingsTableModel();
        LoadUI loadUI = new LoadUI(genericTable, nArray, bl);
        loadUI.start();
        return loadingTransformationSettingsTableModel;
    }

    private TransformationSettingsTableModel initialCreateExtendedTableModel(GenericTable genericTable, int[] nArray, boolean bl) {
        LoadingTransformationSettingsTableModel loadingTransformationSettingsTableModel = new LoadingTransformationSettingsTableModel();
        LoadUI loadUI = new LoadUI(genericTable, nArray, bl);
        loadUI.start();
        return loadingTransformationSettingsTableModel;
    }

    private TransformationSettingsTableModel refreshTableModel(GenericTable genericTable) throws Exception {
        assert (null != this._cachedTransformationNodeType.getInputStatisticTable().getName());
        return this.refreshExtendedTableModel(genericTable, null, false);
    }

    private TransformationSettingsTableModel initialCreateTableModel(GenericTable genericTable, int[] nArray) {
        if (null != this._cachedTransformationNodeType.getInputStatisticTable().getName()) {
            return this.initialCreateExtendedTableModel(genericTable, nArray, false);
        }
        TransformationSettingsTableModel transformationSettingsTableModel = new TransformationSettingsTableModel(this._cachedTransformationNodeType.getTransformedAttributes(), AttributeTypeHelper.toVector(this._combinedAttrList), null, null, 0);
        this._state.setTableModel(transformationSettingsTableModel);
        return transformationSettingsTableModel;
    }

    void cleanUp() {
        this._state.cleanUp();
    }

    private TransformationSettingsTableModel createTableModel(GenericTable genericTable) {
        TransformationSettingsTableModel transformationSettingsTableModel = null;
        if (this._showStats && null != this._cachedTransformationNodeType.getInputStatisticTable().getName()) {
            int[] nArray = genericTable.getSelectedRowsInModel();
            this.prepareCreateModel();
            this._state.setTransformationSourceAttributes(AttributeTypeHelper.toVector(this._combinedAttrList));
            LoadUI loadUI = new LoadUI(genericTable, nArray, true);
            loadUI.start();
        } else {
            this.prepareCreateModel();
            transformationSettingsTableModel = new TransformationSettingsTableModel(this._cachedTransformationNodeType.getTransformedAttributes(), AttributeTypeHelper.toVector(this._combinedAttrList), null, null, 0);
            this.setupItemsTable(transformationSettingsTableModel, genericTable);
        }
        return transformationSettingsTableModel;
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        GenericTable jAttributesTable;
        int[] selectedRowsInModel;
        boolean extended = false;

        public LoadUI(GenericTable genericTable, int[] nArray, boolean bl) {
            this.jAttributesTable = genericTable;
            this.selectedRowsInModel = nArray;
            this.extended = bl;
        }

        public Object construct() {
            try {
                TransformationNodeAttributesGrid.this.setLoading(true);
                int n = 0;
                String string = null;
                try {
                    string = TransformationNodeAttributesGrid.this._searchHelper != null ? TransformationNodeAttributesGrid.this._searchHelper.getSearchText() : null;
                    n = TransformationNodeAttributesGrid.this._searchHelper != null ? TransformationNodeAttributesGrid.this._searchHelper.getCurrentSearchCategory() : 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.extended) {
                    TransformationNodeAttributesGrid.this._state.loadExtendedModel(string, n);
                } else {
                    TransformationNodeAttributesGrid.this._state.loadBaseModel(string, n);
                }
                this._success = TransformationNodeAttributesGrid.this._state.isLoaded();
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
                exception.printStackTrace();
            }
            return TransformationNodeAttributesGrid.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                if (this._success && this._ex == null) {
                    TransformationNodeAttributesGrid.this.setupItemsTable(TransformationNodeAttributesGrid.this._state.getTableModel(), this.jAttributesTable);
                    TransformationNodeAttributesGrid.this.setLoading(false);
                    if (null != this.selectedRowsInModel && this.selectedRowsInModel.length > 0) {
                        this.jAttributesTable.setSelectedRowsInModel(this.selectedRowsInModel);
                    } else if (!TransformationNodeAttributesGrid.this._state.getTableModel().getDataVector().isEmpty()) {
                        this.jAttributesTable.setRowSelectionInterval(0, 0);
                    } else {
                        TransformationNodeAttributesGrid.this.parentDlg.updateGraphNoData();
                    }
                } else {
                    if (TransformationNodeAttributesGrid.this._state.getTableModel() != null) {
                        TransformationNodeAttributesGrid.this._state.getTableModel().setFailedStatus();
                        TransformationNodeAttributesGrid.this.setupItemsTable(TransformationNodeAttributesGrid.this._state.getTableModel(), this.jAttributesTable);
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)XformDialogsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_TITLE"), (String)XformDialogsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), null, (String)XformDialogsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_TITLE"), (String)XformDialogsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_MESG"));
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)XformDialogsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_TITLE"), (String)XformDialogsLrb.get("TABLE_SUMMARY_EDITOR_FAILURE_MESG"), null);
            }
            finally {
                if (TransformationNodeAttributesGrid.this.isLoading()) {
                    TransformationNodeAttributesGrid.this.setLoading(false);
                }
            }
        }
    }

    private class LoadingTransformationSettingsTableModel
    extends TransformationSettingsTableModel {
        private String[] _columns;

        LoadingTransformationSettingsTableModel() {
            this._srcData = new Vector();
            TransformationSourceAttribute transformationSourceAttribute = new TransformationSourceAttribute();
            transformationSourceAttribute.setName(TransformationPIPropertyLrb.get("TRANSFORMATION_LOADING"));
            this._srcData.add(transformationSourceAttribute);
            this.setRowCount(this._srcData.size());
            this.setColumnIdentifiers(this.getColumnNames());
            this.setColumnCount(1);
        }

        @Override
        public String getColumnName(int n) {
            return this._columns[n];
        }

        @Override
        protected String[] getColumnNames() {
            this._columns = new String[]{TransformationPIPropertyLrb.get("TRANSFORMATION_LOADING_STATUS")};
            return this._columns;
        }
    }

    private class CustomRenderer
    extends DefaultTableCellRenderer {
        FormatType formatType;

        public CustomRenderer(FormatType formatType) {
            this.formatType = formatType;
        }

        public CustomRenderer() {
            this.formatType = FormatType.NUMERICAL;
        }

        @Override
        public void setValue(Object object) {
            if (object != null) {
                String string = null;
                if (object instanceof Double) {
                    string = this.formatType == FormatType.PERCENTAGE ? NumericFormat.format((Double)object, true, TransformationNodeAttributesGrid.this.dataProfilePanelSettings.getPercentagePrecisionLevel()) + "" : NumericFormat.format((Double)object, true, TransformationNodeAttributesGrid.this.dataProfilePanelSettings.getNumericalPrecisionLevel()) + "";
                } else if (object instanceof Integer) {
                    string = NumericFormat.format((Integer)object, true, 8) + "";
                } else if (object instanceof String) {
                    string = (String)object;
                }
                super.setValue(string);
            }
        }
    }

    class SelectedItemSelectionHandler
    implements ListSelectionListener {
        GenericTable jAttributesTable;

        SelectedItemSelectionHandler(GenericTable genericTable) {
            this.jAttributesTable = genericTable;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = true;
            if (listSelectionModel.isSelectionEmpty()) {
                bl = false;
            } else {
                int[] nArray = this.jAttributesTable.getSelectedRowsInModel();
                if (nArray != null && nArray.length > 0) {
                    bl4 = true;
                    TransformationSettingsTableModel transformationSettingsTableModel = (TransformationSettingsTableModel)((Object)this.jAttributesTable.getModel());
                    TransformationSourceAttribute transformationSourceAttribute = transformationSettingsTableModel.getDataVector().get(nArray[0]);
                    bl5 = transformationSourceAttribute.getStatus().equals((Object)AttributeStatus.VALID);
                    boolean bl6 = transformationSourceAttribute instanceof TransformationOutputAttribute;
                    String string = transformationSourceAttribute.getDataType();
                    boolean bl7 = false;
                    try {
                        bl7 = DatabaseMetadataUtils.isDataTypeSupported(string) && !DatabaseMetadataUtils.isACustomDataType(TransformationNodeAttributesGrid.this._node.getContext(), string) && !string.equals("CLOB") && !string.equals("NCLOB") && !string.equals("XMLTYPE");
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                    }
                    if (bl6) {
                        bl2 = bl7;
                        bl3 = false;
                        bl = bl7;
                    } else {
                        bl2 = false;
                        bl3 = bl7;
                    }
                    for (int i = 1; i < nArray.length; ++i) {
                        if (nArray[0] >= transformationSettingsTableModel.getDataVector().size()) continue;
                        TransformationSourceAttribute transformationSourceAttribute2 = transformationSettingsTableModel.getDataVector().get(nArray[i]);
                        boolean bl8 = transformationSourceAttribute2 instanceof TransformationOutputAttribute;
                        if (!bl8) {
                            bl = false;
                        }
                        if (bl8 == bl6) continue;
                        bl2 = false;
                        bl3 = false;
                        break;
                    }
                }
            }
            TransformationNodeAttributesGrid.this.removeBtn.setEnabled(bl);
            TransformationNodeAttributesGrid.this.editBtn.setEnabled(bl2 && bl5);
            TransformationNodeAttributesGrid.this.addBtn.setEnabled(bl3 && bl5);
            TransformationNodeAttributesGrid.this.addCustomBtn.setEnabled(true);
            TransformationNodeAttributesGrid.this._outputTrueBtn.setEnabled(bl4);
            TransformationNodeAttributesGrid.this._outputFalseBtn.setEnabled(bl4);
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Icon icon;
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = false;
            for (TransformationSourceAttribute transformationSourceAttribute : TransformationNodeAttributesGrid.this._combinedAttrList) {
                if (!transformationSourceAttribute.getName().equals(object.toString()) || 0 != transformationSourceAttribute.getStatus().compareTo((Enum)AttributeStatus.VALID)) continue;
                bl3 = true;
                break;
            }
            if (bl3) {
                TransformationNodeAttributesGrid.this.parentDlg;
                icon = TransformSettingsEditorDialog.getValid_attribue_icon();
            } else {
                TransformationNodeAttributesGrid.this.parentDlg;
                icon = TransformSettingsEditorDialog.getInvalid_attribue_icon();
            }
            this.setIcon(icon);
            return component;
        }
    }

    class WizardGenerateStatsResults {
        List<RefreshResult> results = new ArrayList<RefreshResult>();
        Exception exception;

        WizardGenerateStatsResults() {
        }

        void add(RefreshResult refreshResult) {
            this.results.add(refreshResult);
        }

        boolean isException() {
            return this.exception != null;
        }

        Exception getException() {
            return this.exception;
        }

        List<DataProfileStatisticsData> getStatsData() {
            ArrayList<DataProfileStatisticsData> arrayList = new ArrayList<DataProfileStatisticsData>();
            for (RefreshResult refreshResult : this.results) {
                arrayList.add(refreshResult.getStatsData());
            }
            return arrayList;
        }

        Map<String, GraphDataModel> getGraphDataModelMap() {
            HashMap<String, GraphDataModel> hashMap = null;
            if (this.results.isEmpty()) {
                return hashMap;
            }
            hashMap = new HashMap<String, GraphDataModel>();
            for (RefreshResult refreshResult : this.results) {
                hashMap.put(refreshResult.getStatsData().getName(), refreshResult.getGrafDataModel());
            }
            return hashMap;
        }
    }

    private static enum FormatType {
        PERCENTAGE,
        NUMERICAL;

    }
}

