/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Dimension;
import java.awt.Frame;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationNodeAttributesPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationNodeAttributesPanelPreRun;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.icons.OracleIcons;

public class TransformSettingsEditorDialog
extends DataConsumerAttributesDialog<TransformationNode> {
    AbstractDialogPanel content;
    private static Icon _valid_attribue_icon;
    private static Icon _invalid_attribue_icon;
    private static Icon _editIcon;
    private static Icon _addIcon;
    private static Icon _addCustomTransformIcon;
    private static Icon _outputTrueIcon;
    private static Icon _outputFalseIcon;

    @Override
    protected JEWTDialog buildDialog(Context context, TransformationNode transformationNode, AbstractDataNode abstractDataNode) {
        TransformationNodeType transformationNodeType = (TransformationNodeType)transformationNode.getData();
        ResultType resultType = transformationNodeType.getInputStatisticTable();
        boolean bl = null != resultType && null != resultType.getName();
        this.initRes();
        this.content = bl ? new TransformationNodeAttributesPanel(this, context, transformationNode) : new TransformationNodeAttributesPanelPreRun(this, context, transformationNode);
        JEWTDialog jEWTDialog = this.buildDialog(context, this.content);
        jEWTDialog.setMinimumSize(new Dimension(400, 380));
        jEWTDialog.setPreferredSize(new Dimension(800, 700));
        return jEWTDialog;
    }

    @Override
    protected JEWTDialog buildDialog(Context context, JPanel jPanel) {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        CustomJEWTDialog customJEWTDialog = new CustomJEWTDialog((Frame)ideMainWindow, this.wizName, n);
        customJEWTDialog.setContent(jPanel);
        customJEWTDialog.setTitle(this.getDialogTitle());
        return customJEWTDialog;
    }

    @Override
    protected void registerHelp(JEWTDialog jEWTDialog) {
    }

    public void initRes() {
        if (_valid_attribue_icon == null) {
            Class<PIComponentPanel> clazz = PIComponentPanel.class;
            Class<WorkflowEditor> clazz2 = WorkflowEditor.class;
            _invalid_attribue_icon = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("USAGE_ATTRIBUTE_INVALID"));
            _valid_attribue_icon = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("USAGE_ATTRIBUTE"));
            _editIcon = InspectorArb.getIcon((int)24);
            _addIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_VALUE_ADD_ICON"));
            _addCustomTransformIcon = UIResourceHelper.getImageIcon(clazz, PropertyLrb.get("PI_ATTRIBUTES_GROUP_VALUE_ADD_EXPRESSION_ICON"));
            _outputTrueIcon = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("FILTER_ATTR_OUTPUT_ICON"));
            _outputFalseIcon = UIResourceHelper.getImageIcon(clazz2, WorkflowEditorLrb.get("FILTER_ATTR_IGNORE_ICON"));
        }
    }

    @Override
    protected String getDialogTitle() {
        return XformDialogsLrb.get("DIALOG_TITLE");
    }

    public static Icon getValid_attribue_icon() {
        return _valid_attribue_icon;
    }

    public static Icon getInvalid_attribue_icon() {
        return _invalid_attribue_icon;
    }

    public static Icon getRemoveIcon() {
        return OracleIcons.getIcon((String)"delete.png");
    }

    public static Icon getEditIcon() {
        return _editIcon;
    }

    public static Icon getAddIcon() {
        return _addIcon;
    }

    public static Icon getCustomTransformIcon() {
        return _addCustomTransformIcon;
    }

    void updateResfresButtonState() {
        if (this.content instanceof TransformationNodeAttributesPanel) {
            ((TransformationNodeAttributesPanel)this.content).updateResfresButtonState();
        }
    }

    void updateGraph(GraphDataModel graphDataModel) {
        if (this.content instanceof TransformationNodeAttributesPanel) {
            ((TransformationNodeAttributesPanel)this.content).updateGraph(graphDataModel);
        }
    }

    void updateGraph(Map<String, GraphDataModel> map) {
        if (this.content instanceof TransformationNodeAttributesPanel) {
            ((TransformationNodeAttributesPanel)this.content).updateGraph(map);
        }
    }

    void updateGraphNoData() {
        if (this.content instanceof TransformationNodeAttributesPanel) {
            ((TransformationNodeAttributesPanel)this.content).updateGraphNoData();
        }
    }

    public static Icon getOutputTrueIcon() {
        return _outputTrueIcon;
    }

    public static Icon getOutputFalseIcon() {
        return _outputFalseIcon;
    }

    class CustomJEWTDialog
    extends JEWTDialog {
        CustomJEWTDialog(Frame frame, String string, int n) {
            super(frame, string, n);
        }

        public void dispose() {
            super.dispose();
            TransformSettingsEditorDialog.this.content.cleanUp();
        }
    }
}

