/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.CardLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.workflow.dialog.transformations.OutLierPanelPercent;
import oracle.dmt.dataminer.workflow.dialog.transformations.OutLierPanelStdDev;
import oracle.dmt.dataminer.workflow.dialog.transformations.OutLierPanelValue;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;

public class OutlierPanel
extends JPanel {
    private String selectedType;
    private TransformationType.Outlier outlier;
    private Double stdDev;
    private Object average;
    private boolean wizard;
    private JComboBox jCmbType;
    private JLabel jLblType;
    private JPanel jPanelMVDetails;
    protected OutLierPanelStdDev panelStDev;
    protected OutLierPanelPercent panelPercent;
    protected OutLierPanelValue panelValue;

    public OutlierPanel() {
        this.selectedType = TransformationTypes.getTRANSFORMATION_TYPE_OUTLIER_ST_DEV();
        this.wizard = true;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public OutlierPanel(TransformationSourceAttribute transformationSourceAttribute, Double d, Object object, String string) {
        this.wizard = false;
        this.selectedType = string;
        this.stdDev = d;
        this.average = object;
        if (transformationSourceAttribute instanceof TransformationOutputAttribute) {
            TransformationOutputAttribute transformationOutputAttribute = (TransformationOutputAttribute)transformationSourceAttribute;
            this.outlier = transformationOutputAttribute.getTransformationElementType().getOutlier();
            if (null != this.outlier) {
                if (null != this.outlier.getStandardDeviation()) {
                    this.selectedType = TransformationTypes.getTRANSFORMATION_TYPE_OUTLIER_ST_DEV();
                } else if (null != this.outlier.getPercent()) {
                    this.selectedType = TransformationTypes.getTRANSFORMATION_TYPE_OUTLIER_PERCENT();
                } else if (null != this.outlier.getValue()) {
                    this.selectedType = TransformationTypes.getTRANSFORMATION_TYPE_OUTLIER_VALUE();
                }
            }
        }
        if (this.selectedType == null) {
            this.selectedType = TransformationTypes.getTRANSFORMATION_TYPE_OUTLIER_ST_DEV();
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLblType = new JLabel();
        this.jCmbType = new JComboBox();
        this.jPanelMVDetails = new JPanel();
        this.jLblType.setText("Outlier Type:");
        this.jCmbType.setModel(new DefaultComboBoxModel<String>(new String[]{"Standard Deviation", "Percent", "Value", " "}));
        this.jPanelMVDetails.setLayout(new CardLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(23, 23, 23).addComponent(this.jLblType, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCmbType, -2, 152, -2).addGap(21, 21, 21)).addComponent(this.jPanelMVDetails, -1, 330, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblType).addComponent(this.jCmbType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelMVDetails, -1, 196, Short.MAX_VALUE).addContainerGap()));
    }

    public void initRes() {
        this.jLblType.setText(XformDialogsLrb.get("OUTLIER_MAIN_TYPE"));
        this.jLblType.setLabelFor(this.jCmbType);
    }

    public void initUI() {
        this.panelStDev = new OutLierPanelStdDev(this.outlier, this.stdDev, this.average, this.wizard);
        this.jPanelMVDetails.add(TransformationTypes.getTRANSFORMATION_TYPE_OUTLIER_ST_DEV(), this.panelStDev);
        this.panelPercent = new OutLierPanelPercent(this.outlier, this.wizard);
        this.jPanelMVDetails.add(TransformationTypes.getTRANSFORMATION_TYPE_OUTLIER_PERCENT(), this.panelPercent);
        this.panelValue = new OutLierPanelValue(this.outlier, this.stdDev, this.average, this.wizard);
        this.jPanelMVDetails.add(TransformationTypes.getTRANSFORMATION_TYPE_OUTLIER_VALUE(), this.panelValue);
        this.jCmbType.setModel(new DefaultComboBoxModel<String>(new String[]{XformDialogsLrb.get("TRANSFORMATION_TYPE_OUTLIER_ST_DEV"), XformDialogsLrb.get("TRANSFORMATION_TYPE_OUTLIER_PERCENT"), XformDialogsLrb.get("TRANSFORMATION_TYPE_OUTLIER_VALUE")}));
        this.jCmbType.setSelectedItem(this.selectedType);
        this.jCmbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutlierPanel.this.selectedType = (String)OutlierPanel.this.jCmbType.getSelectedItem();
                OutlierPanel.this.showPanel();
            }
        });
        this.showPanel();
    }

    private void showPanel() {
        CardLayout cardLayout = (CardLayout)this.jPanelMVDetails.getLayout();
        cardLayout.show(this.jPanelMVDetails, this.selectedType);
    }

    public String getSelectedOutlierType() {
        return this.selectedType;
    }

    public TransformationType.Outlier getResults() throws Exception {
        TransformationType.Outlier outlier = null;
        if (this.selectedType.equals(TransformationTypes.getTRANSFORMATION_TYPE_OUTLIER_ST_DEV())) {
            outlier = new TransformationType.Outlier();
            Double d = this.panelStDev.getSigmaMultiple();
            if (d > 20.0) {
                String string = XformDialogsLrb.get("OUTLIER_MULTIPLE_ERROR");
                throw new Exception(string);
            }
            String string = this.panelStDev.getReplaceWith();
            TransformationType.Outlier.StandardDeviation standardDeviation = new TransformationType.Outlier.StandardDeviation();
            standardDeviation.setMultiplesSigma(d);
            outlier.setReplaceWith(string);
            outlier.setStandardDeviation(standardDeviation);
        } else if (this.selectedType.equals(TransformationTypes.getTRANSFORMATION_TYPE_OUTLIER_PERCENT())) {
            outlier = new TransformationType.Outlier();
            String string = this.panelPercent.getReplaceWith();
            Double d = this.panelPercent.getLowerPercent();
            Double d2 = this.panelPercent.getUpperPercent();
            if (d == null || d2 == null) {
                String string2 = XformDialogsLrb.get("OUTLIER_PERCENT_MISSING_ERROR");
                throw new Exception(string2);
            }
            if (d > 100.0 || d2 > 100.0 || d + d2 > 100.0) {
                String string3 = XformDialogsLrb.get("OUTLIER_PERCENT_ERROR");
                throw new Exception(string3);
            }
            TransformationType.Outlier.Percent percent = new TransformationType.Outlier.Percent();
            percent.setLowerPercent(d);
            percent.setUpperPercent(d2);
            outlier.setReplaceWith(string);
            outlier.setPercent(percent);
        } else if (this.selectedType.equals(TransformationTypes.getTRANSFORMATION_TYPE_OUTLIER_VALUE())) {
            outlier = new TransformationType.Outlier();
            String string = this.panelValue.getReplaceWith();
            Double d = this.panelValue.getLowerValue();
            Double d3 = this.panelValue.getUpperValue();
            if (d == null || d3 == null) {
                String string4 = XformDialogsLrb.get("OUTLIER_VALUE_MISSING_ERROR");
                throw new Exception(string4);
            }
            if (d > d3) {
                String string5 = XformDialogsLrb.get("OUTLIER_VALUE_ERROR");
                throw new Exception(string5);
            }
            TransformationType.Outlier.Value value = new TransformationType.Outlier.Value();
            value.setLowerValue(d);
            value.setUpperValue(d3);
            outlier.setReplaceWith(string);
            outlier.setValue(value);
        }
        return outlier;
    }
}

