/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;

public class OutLierPanelValue
extends JPanel {
    private TransformationType.Outlier outlier;
    private Double stdDev;
    private Object average;
    private boolean wizard;
    private int _precisionLevel = 3;
    private ButtonGroup buttonGroup1;
    private JRadioButton jBtnEdge;
    private JRadioButton jBtnNulls;
    private JLabel jLblLowerTxt;
    private JLabel jLblReplaceWith;
    private JLabel jLblUpperTxt;
    private JTextField jTextLower;
    private JTextField jTextUpper;

    public OutLierPanelValue(TransformationType.Outlier outlier, Double d, Object object, boolean bl) {
        this.outlier = outlier;
        this.stdDev = d;
        this.average = object;
        this.wizard = bl;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLblLowerTxt = new JLabel();
        this.jLblUpperTxt = new JLabel();
        this.jLblReplaceWith = new JLabel();
        this.jBtnNulls = new JRadioButton();
        this.jBtnEdge = new JRadioButton();
        this.jTextLower = new NumberTextField();
        this.jTextUpper = new NumberTextField();
        this.jLblLowerTxt.setText("Lower Value:");
        this.jLblUpperTxt.setText("Upper Value:");
        this.jLblReplaceWith.setText("Replace With:");
        this.jBtnNulls.setText("Nulls");
        this.jBtnEdge.setText("Edge Values");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(35, 35, 35).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(37, 37, 37).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jBtnEdge).addComponent(this.jBtnNulls))).addGroup(groupLayout.createSequentialGroup().addGap(16, 16, 16).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblLowerTxt, -2, 118, -2).addComponent(this.jLblUpperTxt, -2, 125, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextUpper).addComponent(this.jTextLower, -1, 65, Short.MAX_VALUE))))).addGroup(groupLayout.createSequentialGroup().addGap(39, 39, 39).addComponent(this.jLblReplaceWith, -2, 124, -2))).addContainerGap(67, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblLowerTxt).addComponent(this.jTextLower, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblUpperTxt).addComponent(this.jTextUpper, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLblReplaceWith).addGap(9, 9, 9).addComponent(this.jBtnNulls).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jBtnEdge).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void initRes() {
        this.jLblLowerTxt.setText(XformDialogsLrb.get("OUTLIER_VALUE_LOWER"));
        this.jLblUpperTxt.setText(XformDialogsLrb.get("OUTLIER_VALUE_UPPER"));
        this.jLblReplaceWith.setText(XformDialogsLrb.get("OUTLIER_COMMON_REPLACE_WITH"));
        this.jBtnNulls.setText(XformDialogsLrb.get("OUTLIER_COMMON_NULLS"));
        this.jBtnEdge.setText(XformDialogsLrb.get("OUTLIER_COMMON_EDGE_VALUES"));
    }

    public void initUI() {
        boolean bl = true;
        Double d = null;
        Double d2 = null;
        if (!this.wizard && this.outlier != null && null != this.outlier.getValue()) {
            TransformationType.Outlier.Value value = this.outlier.getValue();
            d = value.getLowerValue();
            this.setValue(this.jTextLower, d);
            d2 = value.getUpperValue();
            this.setValue(this.jTextUpper, d2);
            bl = this.outlier.getReplaceWith().equals(TransformationStatisticsState.NULLS);
        }
        if (d == null || d2 == null) {
            if (this.stdDev != null && this.average != null && this.average instanceof Double) {
                double d3 = (Double)this.average - 3.0 * this.stdDev;
                String string = NumericFormat.format(d3, false, this._precisionLevel);
                try {
                    Number number = NumericFormat.getInstance().parse(string);
                    d = number.doubleValue();
                    d3 = (Double)this.average + 3.0 * this.stdDev;
                    string = NumericFormat.format(d3, false, this._precisionLevel);
                    number = NumericFormat.getInstance().parse(string);
                    d2 = number.doubleValue();
                }
                catch (Exception exception) {
                    d = 0.0;
                    d2 = 1.0;
                }
            } else {
                d = 0.0;
                d2 = 1.0;
            }
        }
        this.setValue(this.jTextLower, d);
        this.setValue(this.jTextUpper, d2);
        this.buttonGroup1.add(this.jBtnNulls);
        this.buttonGroup1.add(this.jBtnEdge);
        this.jBtnNulls.setSelected(bl);
        this.jBtnEdge.setSelected(!bl);
    }

    private void setValue(JTextField jTextField, double d) {
        ((NumberTextField)jTextField).setDataType(Double.class);
        ((NumberTextField)jTextField).setSigned(true);
        ((NumberTextField)jTextField).setLocale(Locale.getDefault());
        ((NumberTextField)jTextField).setNumber((Number)d);
    }

    public String getReplaceWith() {
        return this.jBtnNulls.isSelected() ? TransformationStatisticsState.NULLS : TransformationStatisticsState.EDGES;
    }

    public Double getLowerValue() {
        if (null == this.jTextLower.getText()) {
            return null;
        }
        Number number = ((NumberTextField)this.jTextLower).getNumber();
        return number != null ? Double.valueOf(number.doubleValue()) : null;
    }

    public Double getUpperValue() {
        if (null == this.jTextUpper.getText()) {
            return null;
        }
        Number number = ((NumberTextField)this.jTextUpper).getNumber();
        return number != null ? Double.valueOf(number.doubleValue()) : null;
    }
}

