/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.DateFormatter;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.workflow.dialog.transformations.DatePickerDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;

public class MissingValuesValuePanel
extends JPanel {
    private Object replacementValue;
    private boolean isDate = false;
    private Integer dataType = TransformationTypes.DATA_TYPE_UNDEFINED;
    private JButton jCalendarButton;
    private JLabel jLabelValue;
    private JTextField jTextFieldValue;

    public MissingValuesValuePanel(Object object, Integer n) {
        this.dataType = n;
        if (object != null) {
            if (object instanceof XMLGregorianCalendar) {
                this.isDate = true;
                GregorianCalendar gregorianCalendar = ((XMLGregorianCalendar)object).toGregorianCalendar();
                this.replacementValue = gregorianCalendar;
            } else if (object instanceof GregorianCalendar) {
                this.isDate = true;
                this.replacementValue = object;
            } else if (object instanceof Date) {
                this.isDate = true;
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTimeInMillis(((Date)object).getTime());
                this.replacementValue = gregorianCalendar;
            } else {
                this.replacementValue = object;
            }
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLabelValue = new JLabel();
        if (this.replacementValue != null) {
            this.jTextFieldValue = this.replacementValue instanceof String ? new JTextField() : (this.replacementValue instanceof Number ? new NumberTextField() : new JFormattedTextField());
        } else if (this.dataType == TransformationTypes.DATA_TYPE_NUMERIC) {
            this.jTextFieldValue = new NumberTextField();
        } else if (this.dataType == TransformationTypes.DATA_TYPE_CATEGORIC) {
            this.jTextFieldValue = new JTextField();
        } else if (this.dataType == TransformationTypes.DATA_TYPE_DATE) {
            this.jTextFieldValue = new JFormattedTextField();
        } else if (this.dataType == TransformationTypes.DATA_TYPE_TIMESTAMP_WITH_TIME_ZONE) {
            this.jTextFieldValue = new JFormattedTextField();
        }
        this.jCalendarButton = new JButton();
        this.jLabelValue.setText("Value:");
        this.jTextFieldValue.setColumns(20);
        this.jTextFieldValue.setEditable(false);
        this.jCalendarButton.setText("...");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(33, 33, 33).addComponent(this.jLabelValue, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldValue, -2, 192, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCalendarButton, -2, 32, -2).addContainerGap(31, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelValue).addComponent(this.jTextFieldValue, -2, -1, -2).addComponent(this.jCalendarButton)).addContainerGap(185, Short.MAX_VALUE)));
    }

    public void initRes() {
        this.jLabelValue.setText(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_MISSING_VALUES_VALUE"));
        this.jLabelValue.setLabelFor(this.jTextFieldValue);
    }

    private void setDateFormatter() {
        SimpleDateFormat simpleDateFormat = null;
        if (this.dataType == TransformationTypes.DATA_TYPE_TIMESTAMP_WITH_TIME_ZONE) {
            simpleDateFormat = TimeUtils.getShortSimpleDateFormatZone();
            if (this.replacementValue instanceof GregorianCalendar) {
                simpleDateFormat.setTimeZone(((GregorianCalendar)this.replacementValue).getTimeZone());
            }
        } else {
            simpleDateFormat = TimeUtils.getShortSimpleDateFormat();
        }
        final DateFormatter dateFormatter = new DateFormatter(simpleDateFormat);
        ((JFormattedTextField)this.jTextFieldValue).setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

            @Override
            public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
                return dateFormatter;
            }
        });
    }

    public void initUI() {
        if (this.isDate) {
            this.setDateFormatter();
            this.jCalendarButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl;
                    DatePickerDialog datePickerDialog = new DatePickerDialog();
                    boolean bl2 = bl = MissingValuesValuePanel.this.dataType == TransformationTypes.DATA_TYPE_TIMESTAMP_WITH_TIME_ZONE;
                    if (datePickerDialog.invoke((GregorianCalendar)MissingValuesValuePanel.this.replacementValue, bl)) {
                        Calendar calendar = datePickerDialog.getCalendar();
                        MissingValuesValuePanel.this.replacementValue = calendar;
                        MissingValuesValuePanel.this.setDateFormatter();
                        ((JFormattedTextField)MissingValuesValuePanel.this.jTextFieldValue).setValue(MissingValuesValuePanel.this.replacementValue != null ? ((GregorianCalendar)MissingValuesValuePanel.this.replacementValue).getTime() : "");
                    }
                }
            });
            ((JFormattedTextField)this.jTextFieldValue).setValue(this.replacementValue != null ? ((GregorianCalendar)this.replacementValue).getTime() : "");
        } else {
            this.jCalendarButton.setVisible(false);
            this.jTextFieldValue.setEditable(true);
            if (this.replacementValue instanceof String) {
                this.jTextFieldValue.setText(this.replacementValue != null ? this.replacementValue.toString() : "");
            } else if (this.replacementValue instanceof Number) {
                ((NumberTextField)this.jTextFieldValue).setDataType(this.replacementValue.getClass());
                ((NumberTextField)this.jTextFieldValue).setNumber((Number)this.replacementValue);
            }
        }
    }

    Object getReplacementValue() throws Exception {
        if (!this.isDate) {
            this.replacementValue = this.jTextFieldValue instanceof NumberTextField ? ((NumberTextField)this.jTextFieldValue).getNumber() : this.jTextFieldValue.getText().trim();
        }
        return this.replacementValue != null ? this.replacementValue : "";
    }
}

