/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.dialog.WorkflowDialogLrb;
import oracle.dmt.dataminer.workflow.dialog.transformations.ApplyTransformWizardModel;
import oracle.dmt.dataminer.workflow.dialog.transformations.ApplyTransformWizardStepOne;
import oracle.dmt.dataminer.workflow.dialog.transformations.ApplyTransformWizardStepTwo;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.javatools.dialogs.ExceptionDialog;

public class ApplyTransformWizard {
    private final ImageIcon WIZARD_IMAGE = UIResourceHelper.getImageIcon(this.getClass(), WorkflowDialogLrb.get("WIZARD_IMAGE"));
    protected static final String STATE_TRANSFORM = "transforms";
    protected static final String STATE_COLUMNS = "columns";
    protected static final String KEY_TABLE_PAGE_DIRTY = "tableDirty";
    public static final String KEY_COLUMNS_PAGE_DIRTY = "columnsDirty";
    protected Context _context;
    protected ApplyTransformWizardModel _wizModel;
    protected Component _parent;
    protected TransformationNode _node;
    protected AbstractDataNode _parentNode;
    protected TransformationNodeType _nodeType;
    private ProgressBar progressBar;
    private Editor _editor;
    private List<TransformationSourceAttribute> _selectedSourceColumns;
    private boolean isPI = false;

    public ApplyTransformWizard() {
    }

    public ApplyTransformWizard(boolean bl) {
        this.isPI = bl;
    }

    ApplyTransformWizardModel getModel() {
        return this._wizModel;
    }

    public List<MapTransformedSource> getEditedXformedColumns() {
        return this._wizModel.getEditedXformedColumns();
    }

    public List<MapTransformedSource> getNonEditedXformedColumns() {
        return this._wizModel.getNonEditedXformedColumns();
    }

    public List<MapTransformedSource> getAllXformedColumns() {
        return this._wizModel.getAllXformedColumns();
    }

    public boolean isGeneratStats() {
        if (this.isPI) {
            return false;
        }
        if (!this._wizModel.isCheckBoxVisible()) {
            return false;
        }
        return this._wizModel.isGenerateStatsOnFinish();
    }

    protected String getWizardTitle() {
        return XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_NAME");
    }

    protected void initWizardModel() {
        assert (this._nodeType instanceof TransformationNodeType);
        this._wizModel = new ApplyTransformWizardModel(this._parent, this._context, this._node, this._nodeType, this._parentNode, this._selectedSourceColumns, this.isPI);
    }

    public boolean runWizard(final Component component, final Context context, final TransformationNode transformationNode, final AbstractDataNode abstractDataNode, final TransformationNodeType transformationNodeType, final List<TransformationSourceAttribute> list) {
        try {
            class CreateWizardTask
            implements Runnable {
                private WizardDialog wd;
                private FSMWizard wizard;

                CreateWizardTask() {
                }

                public FSMWizard getWizard() {
                    return this.wizard;
                }

                public WizardDialog getWizardDialog() {
                    return this.wd;
                }

                @Override
                public void run() {
                    ApplyTransformWizard.this._context = context;
                    ApplyTransformWizard.this._parent = component;
                    ApplyTransformWizard.this._node = transformationNode;
                    ApplyTransformWizard.this._parentNode = abstractDataNode;
                    ApplyTransformWizard.this._nodeType = transformationNodeType;
                    ApplyTransformWizard.this._selectedSourceColumns = list;
                    ApplyTransformWizard.this.initWizardModel();
                    FSMBuilder fSMBuilder = new FSMBuilder();
                    Step step = new Step(XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_STEP_ONE"), ApplyTransformWizardStepOne.class, "dm_apply_transform_choose_transfrom_step_html");
                    fSMBuilder.newStartState(step, (Object)ApplyTransformWizard.STATE_COLUMNS);
                    fSMBuilder.newState((Object)ApplyTransformWizard.STATE_TRANSFORM, step, (Object)ApplyTransformWizard.STATE_COLUMNS);
                    step = new Step(XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_STEP_TWO"), ApplyTransformWizardStepTwo.class, "dm_apply_transform_choose_columns_step_html");
                    fSMBuilder.newFinalState((Object)ApplyTransformWizard.STATE_COLUMNS, step);
                    try {
                        FSM fSM = fSMBuilder.getFSM();
                        Namespace namespace = new Namespace();
                        namespace.put("wizardModel", (Object)ApplyTransformWizard.this._wizModel);
                        this.wizard = new FSMWizard(fSM, namespace);
                        ApplyTransformWizard.this._wizModel.setWizard(this.wizard);
                        this.wizard.setWelcomePageAdded(false);
                        this.wizard.setFinishPageAdded(false);
                        this.wizard.setWizardTitle(ApplyTransformWizard.this.getWizardTitle());
                        this.wizard.setShowStepNumber(true);
                        this.wizard.updateImage(ApplyTransformWizard.this.WIZARD_IMAGE.getImage());
                        this.wizard.setDefaultWizardSize(1);
                        Dialog dialog = DialogUtil.getAncestorDialog((Component)component);
                        if (dialog != null) {
                            this.wd = this.wizard.getDialog(dialog);
                        } else {
                            Frame frame = DialogUtil.getAncestorFrame((Component)component);
                            this.wd = this.wizard.getDialog(frame);
                        }
                        this.wd.setMinimumSize(new Dimension(800, 800));
                    }
                    catch (FSMInvalidException fSMInvalidException) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)fSMInvalidException), (String)XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_FAILURE_TITLE"), (String)XformDialogsLrb.get("APPLY_TRANSFORMATION_WIZARD_FAILURE_MSG"));
                    }
                    ApplyTransformWizard.this.progressBar.setDoneStatus();
                }
            }
            CreateWizardTask createWizardTask = new CreateWizardTask();
            this.progressBar = new ProgressBar((Component)Ide.getMainWindow(), "", (Runnable)createWizardTask, true);
            this.progressBar.setCancelable(true);
            this.progressBar.start(XformDialogsLrb.get("INIT_WIZARD_MSG"), "");
            this.progressBar.waitUntilDone();
            if (this.progressBar.hasUserCancelled()) {
                return false;
            }
            WizardDialog wizardDialog = createWizardTask.getWizardDialog();
            FSMWizard fSMWizard = createWizardTask.getWizard();
            fSMWizard.addCommitListener(new CommitListener(){

                public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
                }

                public void commit(ApplyEvent applyEvent) throws TraversalException {
                    ApplyTransformWizard.this.getModel().close();
                    ApplyTransformWizard.this.commit();
                }

                public void rollback(ApplyEvent applyEvent) {
                }

                public void cancel(ApplyEvent applyEvent) {
                    ApplyTransformWizard.this.getModel().setWizardCancelled(true);
                    ApplyTransformWizard.this.getModel().close();
                }
            });
            this._editor = EditorManager.getEditorManager().getCurrentEditor();
            return WizardLauncher.runDialog((JDialog)wizardDialog);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    protected void commit() {
        if (this._wizModel.getAllXformedColumns().isEmpty()) {
            this._wizModel.prepareResultColumnsList(null);
        }
    }
}

