/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.test;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogState;
import oracle.dmt.dataminer.workflow.dialog.test.CostBenefitTabPanel;
import oracle.dmt.dataminer.workflow.dialog.test.CostMatrixTabPanel;
import oracle.dmt.dataminer.workflow.dialog.test.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.test.LiftTabPanel;
import oracle.dmt.dataminer.workflow.dialog.test.ProfitTabPanel;
import oracle.dmt.dataminer.workflow.dialog.test.ROCTabPanel;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.ide.panels.TraversableContext;

public class TunePanel
extends AbstractPropertiesDialogPanel {
    private JPanel jBenefitPanel;
    private JPanel jCostPanel;
    private JPanel jLiftPanel;
    private JPanel jProfitPanel;
    private JPanel jROCPanel;
    private JTabbedPane jTabbedPane;
    private static String[] _TABS = new String[]{DialogsLrb.get("TUNE_TAB_COST"), DialogsLrb.get("TUNE_TAB_BENEFIT"), DialogsLrb.get("TUNE_TAB_ROC"), DialogsLrb.get("TUNE_TAB_LIFT"), DialogsLrb.get("TUNE_TAB_PROFIT")};
    private String _cardLoading = "Loading";
    private String _cardReady = "Ready";
    private CardLayout _costlayout = new CardLayout();
    private CardLayout _benefitlayout = new CardLayout();
    private CardLayout _ROClayout = new CardLayout();
    private CardLayout _liftLayout = new CardLayout();
    private CardLayout _profitLayout = new CardLayout();
    private Hashtable<JPanel, AbstractPropertiesDialogPanel> _childPanels = new Hashtable();

    public TunePanel(TraversableContext traversableContext) {
        super(traversableContext);
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.jCostPanel = new JPanel();
        this.jBenefitPanel = new JPanel();
        this.jROCPanel = new JPanel();
        this.jLiftPanel = new JPanel();
        this.jProfitPanel = new JPanel();
        this.setPreferredSize(new Dimension(800, 700));
        this.jTabbedPane.setName("jTabbedPane");
        this.jCostPanel.setName("jCostPanel");
        GroupLayout groupLayout = new GroupLayout(this.jCostPanel);
        this.jCostPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 795, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 672, Short.MAX_VALUE));
        this.jTabbedPane.addTab("Cost", this.jCostPanel);
        this.jBenefitPanel.setName("jBenefitPanel");
        GroupLayout groupLayout2 = new GroupLayout(this.jBenefitPanel);
        this.jBenefitPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 795, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 672, Short.MAX_VALUE));
        this.jTabbedPane.addTab("Benefit", this.jBenefitPanel);
        this.jROCPanel.setName("jROCPanel");
        GroupLayout groupLayout3 = new GroupLayout(this.jROCPanel);
        this.jROCPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 795, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 672, Short.MAX_VALUE));
        this.jTabbedPane.addTab("ROC", this.jROCPanel);
        this.jLiftPanel.setName("jLiftPanel");
        GroupLayout groupLayout4 = new GroupLayout(this.jLiftPanel);
        this.jLiftPanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 795, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 672, Short.MAX_VALUE));
        this.jTabbedPane.addTab("Lift", this.jLiftPanel);
        this.jProfitPanel.setName("jProfitPanel");
        GroupLayout groupLayout5 = new GroupLayout(this.jProfitPanel);
        this.jProfitPanel.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 795, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 672, Short.MAX_VALUE));
        this.jTabbedPane.addTab("Profit", this.jProfitPanel);
        GroupLayout groupLayout6 = new GroupLayout(this);
        this.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane, -1, 800, Short.MAX_VALUE));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane, -1, 700, Short.MAX_VALUE));
    }

    private void initUI() {
        TuneState tuneState = (TuneState)this.getState();
        boolean bl = tuneState.getTestCompareNode().isShowROC();
        for (int i = 0; i < _TABS.length; ++i) {
            this.jTabbedPane.setTitleAt(i, _TABS[i]);
        }
        this.showLoadingPanel(this.jCostPanel, this._costlayout);
        this.showLoadingPanel(this.jBenefitPanel, this._benefitlayout);
        if (bl) {
            this.showLoadingPanel(this.jROCPanel, this._ROClayout);
        } else {
            this.jTabbedPane.removeTabAt(2);
        }
        this.showLoadingPanel(this.jLiftPanel, this._liftLayout);
        this.showLoadingPanel(this.jProfitPanel, this._profitLayout);
        HelpUtils.setHelpID((JComponent)this, (String)"class_tune_select");
        AbstractPropertiesDialogPanel.LoadUI loadUI = new AbstractPropertiesDialogPanel.LoadUI(DialogsLrb.get("TUNE_FAILURE_TITLE"), DialogsLrb.get("TUNE_FAILURE_MESG"));
        loadUI.start();
    }

    private void showLoadingPanel(JPanel jPanel, CardLayout cardLayout) {
        AbstractPropertiesDialogPanel.LoadingStatusPanel loadingStatusPanel = this.createLoadingStatusPanel();
        jPanel.setLayout(cardLayout);
        jPanel.add((Component)loadingStatusPanel, this._cardLoading);
        cardLayout.show(jPanel, this._cardLoading);
    }

    private void addPanel(JPanel jPanel, AbstractPropertiesDialogPanel abstractPropertiesDialogPanel) {
        this._childPanels.put(jPanel, abstractPropertiesDialogPanel);
    }

    @Override
    public void processInput() {
        Vector<AbstractPropertiesDialogPanel> vector = new Vector<AbstractPropertiesDialogPanel>(this._childPanels.values());
        for (int i = 0; i < vector.size(); ++i) {
            vector.elementAt(i).processInput();
        }
    }

    @Override
    public void initializeFromState(AbstractPropertiesDialogState abstractPropertiesDialogState) {
        AbstractPropertiesDialogPanel abstractPropertiesDialogPanel = null;
        TuneState tuneState = (TuneState)this.getState();
        boolean bl = tuneState.getTestCompareNode().isShowROC();
        abstractPropertiesDialogPanel = new CostMatrixTabPanel(this.getTraversableContext());
        this.jCostPanel.setLayout(this._costlayout);
        this.jCostPanel.add((Component)abstractPropertiesDialogPanel, this._cardReady);
        this._costlayout.show(this.jCostPanel, this._cardReady);
        this.addPanel(this.jCostPanel, abstractPropertiesDialogPanel);
        abstractPropertiesDialogPanel = new CostBenefitTabPanel(this.getTraversableContext());
        this.jBenefitPanel.setLayout(this._benefitlayout);
        this.jBenefitPanel.add((Component)abstractPropertiesDialogPanel, this._cardReady);
        this._benefitlayout.show(this.jBenefitPanel, this._cardReady);
        this.addPanel(this.jBenefitPanel, abstractPropertiesDialogPanel);
        if (bl) {
            abstractPropertiesDialogPanel = new ROCTabPanel(this.getTraversableContext());
            this.jROCPanel.setLayout(this._ROClayout);
            this.jROCPanel.add((Component)abstractPropertiesDialogPanel, this._cardReady);
            this._ROClayout.show(this.jROCPanel, this._cardReady);
            this.addPanel(this.jROCPanel, abstractPropertiesDialogPanel);
        }
        abstractPropertiesDialogPanel = new LiftTabPanel(this.getTraversableContext());
        this.jLiftPanel.setLayout(this._liftLayout);
        this.jLiftPanel.add((Component)abstractPropertiesDialogPanel, this._cardReady);
        this._liftLayout.show(this.jLiftPanel, this._cardReady);
        this.addPanel(this.jLiftPanel, abstractPropertiesDialogPanel);
        abstractPropertiesDialogPanel = new ProfitTabPanel(this.getTraversableContext());
        this.jProfitPanel.setLayout(this._profitLayout);
        this.jProfitPanel.add((Component)abstractPropertiesDialogPanel, this._cardReady);
        this._profitLayout.show(this.jProfitPanel, this._cardReady);
        this.addPanel(this.jProfitPanel, abstractPropertiesDialogPanel);
        this.jTabbedPane.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                Object object = propertyChangeEvent.getOldValue();
                System.out.println(object.toString());
            }
        });
        this.jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Component component;
                if (changeEvent.getSource() instanceof JTabbedPane && (component = TunePanel.this.jTabbedPane.getSelectedComponent()) instanceof JPanel) {
                    JPanel jPanel = (JPanel)component;
                    AbstractPropertiesDialogPanel abstractPropertiesDialogPanel = (AbstractPropertiesDialogPanel)TunePanel.this._childPanels.get(jPanel);
                    if (abstractPropertiesDialogPanel != null) {
                        abstractPropertiesDialogPanel.tabSelected();
                    }
                }
            }
        });
    }
}

