/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.test;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dmt.dataminer.controls.BaseCostMatrixDataProvider;
import oracle.dmt.dataminer.controls.BaseCostMatrixTable;
import oracle.dmt.dataminer.controls.BaseCostMatrixTableModel;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.controls.DateCellRenderer2;
import oracle.dmt.dataminer.controls.GenericTableFixedColumns;
import oracle.dmt.dataminer.controls.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.model.ModelPropertiesState;
import oracle.dmt.dataminer.workflow.dialog.test.CostBenefitDetailDialog;
import oracle.dmt.dataminer.workflow.dialog.test.CostBenefitTabState;
import oracle.dmt.dataminer.workflow.dialog.test.CostMatrixDetailDialog;
import oracle.dmt.dataminer.workflow.dialog.test.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.dmt.dataminer.workflow.xmlschema.CostMatrixType;
import oracle.dmt.dataminer.workflow.xmlschema.ROCAccuracyType;
import oracle.dmt.dataminer.workflow.xmlschema.TuningType;
import oracle.dmt.dataminer.workflow.xmlschema.WeightsType;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.ColorIcon;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;

public class CostBenefitTabPanel
extends AbstractPropertiesDialogPanel {
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private JButton jBtnApply;
    private JButton jClearButton;
    private JComboBox jCmbBoxTarget;
    private JButton jCostMatrixBtn;
    private JPanel jCostMatrixPanel;
    private JLabel jLabel7;
    private JLabel jLabelTitle;
    private JLabel jLblTable;
    private JLabel jLblTarget;
    private JLabel jLblWeight;
    private TransparentPanel jLiftTablePanel;
    private ComponentWithTitlebar<JComponent> jLiftToolbar;
    private JLabel jMatrixLbl1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPaneDescription;
    private JScrollPane jScrollPaneTable;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JButton jTuneBtn;
    private JLabel jTuneCriteriaLabel;
    private JLabel jTuneCriteriaValue;
    private GenericTable jTuneMatrixTable;
    private JLabel jTuneMethodLabel;
    private JLabel jTuneMethodValue;
    private JLabel jTuneSettingsLabel;
    private JLabel jTuneTargetLabel;
    private JLabel jTuneTargetValue;
    private JLabel jTuneThresholdLabel;
    private JLabel jTuneThresholdValue;
    private JTextField jTxtFldWeight;
    private GenericTable niceTableCosts;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();
    private CustomGenericTable jResultTable;
    private JScrollPane tscroller;

    public CostBenefitTabPanel(TraversableContext traversableContext) {
        super(traversableContext);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initRes() {
        this.jLabelTitle.setText(oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb.get("COST_BENEFIT_DIALOG_DETAILED_DESCRIPTION"));
        this._jDescription.setText(oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb.get("COST_BENEFIT_WEIGHTING_DESCRIPTION"));
        this.jScrollPaneDescription.getViewport().add((Component)this._jDescription);
        this.jLblTable.setText(oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb.get("COST_BENEFIT_MATRIX_TARGET_TABLE_TITLE"));
        this.jLblTarget.setText(oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb.get("COST_MATRIX_MATRIX_TARGET"));
        this.jLblTarget.setLabelFor(this.jCmbBoxTarget);
        this.jLblWeight.setText(oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb.get("COST_BENEFIT_DIALOG_BENEFIT_LBL"));
        this.jLblWeight.setLabelFor(this.jTxtFldWeight);
        this.setDataType(this.jTxtFldWeight, Double.class);
        this.setSigned(this.jTxtFldWeight, true);
        this.setNumber(this.jTxtFldWeight, ModelPropertiesState.DEFAULT_BENEFIT);
        this.jBtnApply.setText(oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb.get("COST_MATRIX_WEIGHT_APPLY"));
        ResourceUtils.resButton((AbstractButton)this.jTuneBtn, (String)DialogsLrb.get("TUNE_COMMON_TUNE"));
        this.jTuneBtn.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE")));
        this.jTuneBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_TUNE_ADA"));
        this.jTuneSettingsLabel.setText(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE_SETTINGS")));
        this.jTuneSettingsLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE_SETTINGS")));
        ResourceUtils.resButton((AbstractButton)this.jClearButton, (String)DialogsLrb.get("TUNE_COMMON_CLEAR"));
        this.jClearButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_CLEAR")));
        this.jClearButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_CLEAR_ADA"));
        this.jTuneMethodLabel.setText(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_METHOD")));
        this.jTuneMethodLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_METHOD")));
        this.jTuneMethodLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_METHOD_ADA"));
        this.jTuneMethodLabel.setLabelFor(this.jTuneMethodValue);
        this.jTuneTargetLabel.setText(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TARGET")));
        this.jTuneTargetLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TARGET")));
        this.jTuneTargetLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_TARGET_ADA"));
        this.jTuneTargetLabel.setLabelFor(this.jTuneTargetValue);
        this.jTuneCriteriaLabel.setText(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_CRITERIA")));
        this.jTuneCriteriaLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_CRITERIA")));
        this.jTuneCriteriaLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_CRITERIA_ADA"));
        this.jTuneCriteriaLabel.setLabelFor(this.jTuneCriteriaValue);
        this.jTuneThresholdLabel.setText(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_THRESHOLD")));
        this.jTuneThresholdLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_THRESHOLD")));
        this.jTuneThresholdLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_THRESHOLD_ADA"));
        this.jTuneThresholdLabel.setLabelFor(this.jTuneThresholdValue);
        this.jMatrixLbl1.setText(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX")));
        this.jMatrixLbl1.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX")));
        this.jMatrixLbl1.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX")));
        this.jMatrixLbl1.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX_ADA"));
        this.jMatrixLbl1.setLabelFor((Component)this.jTuneMatrixTable);
    }

    public void initUI() {
        this.jResultTable = new CustomGenericTable();
        this.tscroller = new JScrollPane((Component)((Object)this.jResultTable));
        this.jLiftToolbar.setComponent((JComponent)this.tscroller);
        ControlBar controlBar = new ControlBar();
        this.installLiftResultsActions(controlBar);
        this.jLiftToolbar.setControlBar(controlBar);
        this.initializeControls();
        LoadUI loadUI = new LoadUI();
        loadUI.start();
    }

    private void enableControls(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.jResultTable.getSelectedRowCount() > 0) {
            String string = this.getState().getShareState().getSelectTestResult();
            bl2 = this.getState().isTuningCustom(string);
            bl4 = this.getState().isTuningBenefit(string);
            bl3 = this.getState().isTuningCost(string);
        }
        this.jTuneTargetLabel.setVisible(bl && bl2);
        this.jTuneTargetValue.setVisible(bl && bl2);
        this.jTuneThresholdLabel.setVisible(bl && bl2);
        this.jTuneThresholdValue.setVisible(bl && bl2);
        this.jTuneCriteriaLabel.setVisible(bl && bl2);
        this.jTuneCriteriaValue.setVisible(bl && bl2);
        this.jMatrixLbl1.setVisible(bl && (bl2 || bl3 || bl4));
        this.jCostMatrixBtn.setVisible(bl && (bl3 || bl4));
        this.jScrollPane2.setVisible(bl && bl2);
        this.jTuneMatrixTable.setVisible(bl && bl2);
        this.jLabel7.setVisible(bl && bl2);
    }

    private void initializeControls() {
        this.jResultTable.setModel((TableModel)((Object)this.getState().getBenefitState().getLoadingBenefitTableModel()));
        this.jResultTable.setSelectionMode(0);
        this.jCmbBoxTarget.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
        ListSelectionModel listSelectionModel = this.jResultTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CostBenefitTabPanel.this.jResultTableValueChanged(listSelectionEvent);
            }
        });
        this.enableControls(false);
    }

    public void jResultTableValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int[] nArray = this.jResultTable.getSelectedRowsInModel();
            String string = (String)this.getState().getBenefitState().getBenefitTuneTableModel().getValueAt(nArray[0], 0);
            this.getState().getShareState().setSelectTestResult(string);
            this.loadTuneMatrix();
            this.enableControls(true);
        }
    }

    @Override
    protected final TuneState getState() {
        return (TuneState)super.getState();
    }

    @Override
    public void tabSelected() {
        if (this.getState().getBenefitState().getBenefitTuneTableModel() == null) {
            return;
        }
        String string = this.getState().getShareState().getSelectTestResult();
        int n = 0;
        for (int i = 0; i < this.jResultTable.getRowCount(); ++i) {
            Object object = this.getState().getBenefitState().getBenefitTuneTableModel().getValueAt(i, 0);
            if (!string.equals(object)) continue;
            n = i;
            break;
        }
        this.jResultTable.setRowSelectionInterval(n, n);
        this.loadTuneMatrix();
        this.enableControls(true);
    }

    @Override
    public void processInput() {
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabelTitle = new JLabel();
        this.jLblTarget = new JLabel();
        this.jCmbBoxTarget = new JComboBox();
        this.jScrollPaneDescription = new JScrollPane();
        this.jLblTable = new JLabel();
        this.jScrollPaneTable = new JScrollPane();
        this.niceTableCosts = new BaseCostMatrixTable();
        this.jLblWeight = new JLabel();
        this.jTxtFldWeight = new NumberTextField();
        this.jBtnApply = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jCostMatrixPanel = new JPanel();
        this.jTuneBtn = new JButton();
        this.jTuneSettingsLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jClearButton = new JButton();
        this.jTuneMethodLabel = new JLabel();
        this.jTuneMethodValue = new JLabel();
        this.jTuneTargetLabel = new JLabel();
        this.jTuneTargetValue = new JLabel();
        this.jTuneCriteriaLabel = new JLabel();
        this.jTuneCriteriaValue = new JLabel();
        this.jTuneThresholdLabel = new JLabel();
        this.jTuneThresholdValue = new JLabel();
        this.jMatrixLbl1 = new JLabel();
        this.jCostMatrixBtn = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTuneMatrixTable = new BaseCostMatrixTable();
        this.jLabel7 = new JLabel();
        this.jLiftTablePanel = new TransparentPanel();
        this.jLiftToolbar = new ComponentWithTitlebar();
        this.setMinimumSize(new Dimension(750, 490));
        this.setPreferredSize(new Dimension(750, 490));
        this.jSplitPane1.setDividerLocation(360);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setName("jSplitPane1");
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane2.setDividerLocation(450);
        this.jSplitPane2.setName("jSplitPane2");
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jPanel1.setName("jPanel1");
        this.jLabelTitle.setText("Use this screen to define costs for your target values for scoring purposes.");
        this.jLabelTitle.setName("jLabelTitle");
        this.jLblTarget.setText("Target:");
        this.jLblTarget.setName("jLblTarget");
        this.jCmbBoxTarget.setName("jCmbBoxTarget");
        this.jCmbBoxTarget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CostBenefitTabPanel.this.jCmbBoxTargetActionPerformed(actionEvent);
            }
        });
        this.jScrollPaneDescription.setBorder(null);
        this.jScrollPaneDescription.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneDescription.setVerticalScrollBarPolicy(21);
        this.jScrollPaneDescription.setName("jScrollPaneDescription");
        this.jLblTable.setText("Cost Benefit  Weights:");
        this.jLblTable.setName("jLblTable");
        this.jScrollPaneTable.setName("jScrollPaneTable");
        this.niceTableCosts.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[0]));
        this.niceTableCosts.setName("niceTableCosts");
        this.jScrollPaneTable.setViewportView((Component)this.niceTableCosts);
        this.jLblWeight.setText("Weight:");
        this.jLblWeight.setName("jLblWeight");
        this.jTxtFldWeight.setName("jTxtFldWeight");
        this.jBtnApply.setText("Apply");
        this.jBtnApply.setName("jBtnApply");
        this.jBtnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CostBenefitTabPanel.this.jBtnApplyActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneDescription, -1, 429, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblTable, -2, 123, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblWeight).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTxtFldWeight, -2, 82, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnApply)).addComponent(this.jLabelTitle, -1, 429, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblTarget).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCmbBoxTarget, 0, 389, Short.MAX_VALUE)))).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneTable, -1, 429, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelTitle).addGap(9, 9, 9).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblTarget).addComponent(this.jCmbBoxTarget, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneDescription, -2, 42, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblWeight).addComponent(this.jTxtFldWeight, -2, -1, -2).addComponent(this.jBtnApply)).addGap(20, 20, 20).addComponent(this.jLblTable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneTable, -1, 170, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane2.setLeftComponent(this.jPanel1);
        this.jScrollPane1.setName("jScrollPane1");
        this.jCostMatrixPanel.setName("jCostMatrixPanel");
        this.jTuneBtn.setText("Tune");
        this.jTuneBtn.setName("jTuneBtn");
        this.jTuneBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CostBenefitTabPanel.this.jTuneBtnActionPerformed(actionEvent);
            }
        });
        this.jTuneSettingsLabel.setText("Tune Settings");
        this.jTuneSettingsLabel.setName("jTuneSettingsLabel");
        this.jSeparator1.setName("jSeparator1");
        this.jClearButton.setText("Clear");
        this.jClearButton.setName("jClearButton");
        this.jClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CostBenefitTabPanel.this.jClearButtonActionPerformed(actionEvent);
            }
        });
        this.jTuneMethodLabel.setText("Method:");
        this.jTuneMethodLabel.setName("jTuneMethodLabel");
        this.jTuneMethodValue.setText("ROC");
        this.jTuneMethodValue.setName("jTuneMethodValue");
        this.jTuneTargetLabel.setText("Target Value:");
        this.jTuneTargetLabel.setName("jTuneTargetLabel");
        this.jTuneTargetValue.setText("1");
        this.jTuneTargetValue.setName("jTuneTargetValue");
        this.jTuneCriteriaLabel.setText("Criteria:");
        this.jTuneCriteriaLabel.setName("jTuneCriteriaLabel");
        this.jTuneCriteriaValue.setText("Average Accuracy");
        this.jTuneCriteriaValue.setName("jTuneCriteriaValue");
        this.jTuneThresholdLabel.setText("Threshold:");
        this.jTuneThresholdLabel.setName("jTuneThresholdLabel");
        this.jTuneThresholdValue.setText("0.56789");
        this.jTuneThresholdValue.setName("jTuneThresholdValue");
        this.jMatrixLbl1.setText("Derived Cost Matrix:");
        this.jMatrixLbl1.setName("jMatrixLbl1");
        this.jCostMatrixBtn.setText("View...");
        this.jCostMatrixBtn.setName("jCostMatrixBtn");
        this.jCostMatrixBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CostBenefitTabPanel.this.jCostMatrixBtnActionPerformed(actionEvent);
            }
        });
        this.jScrollPane2.setName("jScrollPane2");
        this.jTuneMatrixTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTuneMatrixTable.setName("jTuneMatrixTable");
        this.jTuneMatrixTable.setRowSelectionAllowed(false);
        this.jScrollPane2.setViewportView((Component)this.jTuneMatrixTable);
        this.jLabel7.setText("Rows: Actual; Columns: Predicted");
        this.jLabel7.setName("jLabel7");
        GroupLayout groupLayout2 = new GroupLayout(this.jCostMatrixPanel);
        this.jCostMatrixPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.jTuneSettingsLabel, GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING, -1, 235, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jClearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTuneBtn)).addComponent(this.jTuneMethodLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout2.createSequentialGroup().addGap(71, 71, 71).addComponent(this.jTuneMethodValue).addGap(66, 66, 66)).addGroup(GroupLayout.Alignment.LEADING, groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTuneThresholdLabel).addComponent(this.jTuneTargetLabel).addComponent(this.jTuneCriteriaLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTuneTargetValue).addComponent(this.jTuneCriteriaValue).addComponent(this.jTuneThresholdValue))).addComponent(this.jLabel7, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout2.createSequentialGroup().addComponent(this.jMatrixLbl1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCostMatrixBtn))).addContainerGap(45, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(43, 43, 43).addComponent(this.jTuneSettingsLabel)).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneBtn).addComponent(this.jClearButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneMethodLabel).addComponent(this.jTuneMethodValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneTargetLabel).addComponent(this.jTuneTargetValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneCriteriaLabel).addComponent(this.jTuneCriteriaValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneThresholdLabel).addComponent(this.jTuneThresholdValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMatrixLbl1).addComponent(this.jCostMatrixBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addContainerGap(82, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jCostMatrixPanel);
        this.jSplitPane2.setRightComponent(this.jScrollPane1);
        this.jSplitPane1.setTopComponent(this.jSplitPane2);
        this.jLiftTablePanel.setName("jLiftTablePanel");
        this.jLiftToolbar.setName("jLiftToolbar");
        GroupLayout groupLayout3 = new GroupLayout((Container)this.jLiftTablePanel);
        this.jLiftTablePanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jLiftToolbar, -1, 748, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jLiftToolbar, -1, 124, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent((Component)this.jLiftTablePanel);
        GroupLayout groupLayout4 = new GroupLayout(this);
        this.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 750, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 490, Short.MAX_VALUE));
    }

    private void jTuneBtnActionPerformed(ActionEvent actionEvent) {
        String string = this.getState().getShareState().getSelectTestResult();
        WeightsType weightsType = this.getState().getBenefitState().setTuneBenefitWeight(string);
        this.getState().setTuningBenefit(string, weightsType);
        int n = this.jResultTable.getSelectedRow();
        this.jResultTable.tableChanged(new TableModelEvent(this.jResultTable.getModel()));
        this.jResultTable.setRowSelectionInterval(n, n);
        this.loadTuneMatrix();
        this.enableControls(true);
    }

    private void jClearButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.getState().getShareState().getSelectTestResult();
        this.getState().setTuningNone(string);
        int n = this.jResultTable.getSelectedRow();
        this.jResultTable.tableChanged(new TableModelEvent(this.jResultTable.getModel()));
        this.jResultTable.setRowSelectionInterval(n, n);
        this.loadTuneMatrix();
        this.enableControls(true);
    }

    private void installLiftResultsActions(ControlBar controlBar) {
    }

    private void jCmbBoxTargetActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.jCmbBoxTarget.getSelectedItem();
        this.getState().getBenefitState().setSelectedTargetValue(string);
    }

    private void jBtnApplyActionPerformed(ActionEvent actionEvent) {
        String string = this.getState().getBenefitState().getSelectedTargetValue();
        this.getState().getBenefitState().setBenefitWeight(string, Double.parseDouble(this.getNumber(this.jTxtFldWeight).toString()));
        this.niceTableCosts.tableChanged(new TableModelEvent(this.niceTableCosts.getModel()));
    }

    private void jCostMatrixBtnActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        String string = this.getState().getShareState().getSelectTestResult();
        boolean bl2 = this.getState().getBenefitState().getTuneBenefitWeight(string) != null;
        boolean bl3 = bl = this.getState().getCostState().getTuneCostMatrix(string) != null;
        if (bl2) {
            WeightsType weightsType = this.getState().getBenefitState().getTuneBenefitWeight(string);
            CostBenefitDetailDialog costBenefitDetailDialog = new CostBenefitDetailDialog(weightsType);
            costBenefitDetailDialog.invoke();
        } else if (bl) {
            CostMatrixInfo costMatrixInfo = this.getState().getCostState().getTuneCostMatrixInfo(string);
            CostMatrixDetailDialog costMatrixDetailDialog = new CostMatrixDetailDialog(costMatrixInfo);
            costMatrixDetailDialog.invoke();
        }
    }

    private void loadTuneMatrix() {
        String string = this.getState().getShareState().getSelectTestResult();
        if (this.getState().isTuningNone(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_OPTION_NONE);
        } else if (this.getState().isTuningBenefit(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_BENEFIT);
        } else if (this.getState().isTuningCost(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_COST);
        } else if (this.getState().isTuningCustom(string)) {
            String string2 = null;
            TuneState.TuningCustomData tuningCustomData = this.getState().getTuningCustomData(string);
            String string3 = tuningCustomData.getTargetValue();
            Vector<Object> vector = this.getState().getModelTargetValues();
            this.jTuneTargetValue.setText(string3);
            Object object = tuningCustomData.getTuneType();
            CostMatrixType costMatrixType = tuningCustomData.getCostMatrix();
            if (object instanceof TuningType.Custom.Settings.ROC) {
                TuningType.Custom.Settings.ROC rOC = (TuningType.Custom.Settings.ROC)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_ROC);
                ROCAccuracyType rOCAccuracyType = rOC.getAccuracy();
                if (rOCAccuracyType == ROCAccuracyType.CUSTOM_ACCURACY) {
                    TuningType.Custom.Settings.ROC.CustomThreshold customThreshold = rOC.getCustomThreshold();
                    String string4 = customThreshold.getType().value();
                    this.jTuneCriteriaValue.setText(rOCAccuracyType.value() + ", " + string4 + ": " + this._percentageFormat.format(customThreshold.getValue()));
                } else {
                    this.jTuneCriteriaValue.setText(rOCAccuracyType.value());
                }
                this.jTuneThresholdValue.setText(this._percentageFormat.format(rOC.getThreshold()));
            } else if (object instanceof TuningType.Custom.Settings.Lift) {
                TuningType.Custom.Settings.Lift lift = (TuningType.Custom.Settings.Lift)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_LIFT);
                String string5 = lift.getType().value();
                this.jTuneCriteriaValue.setText("Quantile: " + lift.getQuantile() + " (" + string5 + ")");
                this.jTuneThresholdValue.setText(this._percentageFormat.format(lift.getThreshold()));
            } else if (object instanceof TuningType.Custom.Settings.Profit) {
                TuningType.Custom.Settings.Profit profit = (TuningType.Custom.Settings.Profit)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_PROFIT);
                this.jTuneCriteriaValue.setText("Population: " + this._percentageFormat.format(profit.getPopulation()) + "%, ROI: " + this._percentageFormat.format(profit.getROI()) + "%");
                this.jTuneThresholdValue.setText(this._percentageFormat.format(profit.getProfit()));
            }
            string2 = vector.size() == 2 ? (string3.compareTo(vector.firstElement().toString()) == 0 ? vector.lastElement().toString() : vector.firstElement().toString()) : TestViewerLrb.get("OTHER_TARGETS");
            ((BaseCostMatrixTable)this.jTuneMatrixTable).setModel(new TuneState.MatrixModel(new TuneState.TuneMatrixDataProvider(string3, string2, costMatrixType, this._percentageFormat)));
        }
    }

    class CustomGenericTable
    extends GenericTableFixedColumns {
        private DateFormat _df = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        private Preferences _p = Preferences.getPreferences();
        private ModelViewerPreferenceSettings _prefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)this._p);
        private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._prefenceSettings.getPercentagePrecisionLevel(), 0, 0);
        private NumberFormat _numericalFormat = NumericFormat.getInstance(true, this._prefenceSettings.getNumericalPrecisionLevel(), 0, 0);

        CustomGenericTable() {
            this._percentageFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
            this._percentageFormat.setMinimumIntegerDigits(1);
            this._numericalFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
            this._numericalFormat.setMinimumIntegerDigits(1);
        }

        @Override
        public void addDynamicCellRenderers() {
            this.addCellRenderer(CostBenefitTabPanel.this.getState().getBenefitState().getBenefitTuneTableModel().getColumnName(0), new CustomCellRenderer());
            this.addCellRenderer(CostBenefitTabPanel.this.getState().getBenefitState().getBenefitTuneTableModel().getColumnName(3), new DateCellRenderer2());
        }

        private String formatCellValue(Object object) {
            String string = null;
            if (object != null) {
                string = object instanceof Double ? this._percentageFormat.format((Double)object) : (object instanceof Integer ? this._numericalFormat.format(((Integer)object).intValue()) : (object instanceof BigDecimal ? this._numericalFormat.format(((BigDecimal)object).doubleValue()) : (object instanceof Date ? this._df.format(object) : object.toString())));
            }
            return string;
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            string = this.formatCellValue(object);
            return string;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = "";
            Object object = null;
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            if (n == -1 || n2 == -1) {
                return null;
            }
            object = this.getValueAt(n, n2);
            string = this.formatCellValue(object);
            return string;
        }
    }

    class MatrixModel
    extends BaseCostMatrixTableModel {
        public MatrixModel(BaseCostMatrixDataProvider baseCostMatrixDataProvider) {
            super(baseCostMatrixDataProvider);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return super.getValueAt(n, n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    private class TuneMatrixDataProvider
    implements BaseCostMatrixDataProvider {
        private String _positiveTarget;
        private String _otherTarget;
        private double _truePositiveCost = 0.0;
        private double _falseNegativeCost;
        private double _falsePositiveCost = 1.0;
        private double _trueNegativeCost = 0.0;

        TuneMatrixDataProvider(String string, String string2, CostMatrixType costMatrixType) {
            this._positiveTarget = string;
            this._otherTarget = string2;
            List list = costMatrixType.getItem();
            for (CostMatrixType.Item item : list) {
                String string3 = item.getActual();
                String string4 = item.getPredict();
                double d = item.getCost();
                if (string3.compareTo(string) != 0 || string4.compareTo(string) == 0) continue;
                this._falseNegativeCost = d;
                break;
            }
        }

        @Override
        public Object[] getTargetValues() {
            return new Object[]{this._positiveTarget, this._otherTarget};
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n == 0 && n2 == 0) {
                return CostBenefitTabPanel.this._percentageFormat.format(this._truePositiveCost);
            }
            if (n == 0 && n2 == 1) {
                return CostBenefitTabPanel.this._percentageFormat.format(this._falseNegativeCost);
            }
            if (n == 1 && n2 == 0) {
                return CostBenefitTabPanel.this._percentageFormat.format(this._falsePositiveCost);
            }
            if (n == 1 && n2 == 1) {
                return CostBenefitTabPanel.this._percentageFormat.format(this._trueNegativeCost);
            }
            return "Undefined";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!(object instanceof String)) assert (false);
            String string = (String)object;
            Color color = CostBenefitTabPanel.this.getState().getBenefitState().getParentTestViewerState().getTestResultGraphColor(string);
            this.setIcon((Icon)new ColorIcon(color));
            return component;
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        public Object construct() {
            try {
                CostBenefitTabPanel.this.getState().getBenefitState().load();
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return CostBenefitTabPanel.this.getState().getBenefitState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            int n = 1;
            try {
                if (this._success && this._ex == null) {
                    String string = CostBenefitTabPanel.this.getState().getShareState().getSelectTestResult();
                    CostBenefitTabPanel.this.niceTableCosts.setModel((TableModel)((Object)new CostBenefitTabState.WeightSettingsModel(CostBenefitTabPanel.this.getState().getBenefitState().getBenefitWeight())));
                    CostBenefitTabPanel.this.niceTableCosts.setShowToolTips(true);
                    CostBenefitTabPanel.this.niceTableCosts.setSorted(true);
                    CostBenefitTabPanel.this.niceTableCosts.setUpdateSelectionOnSort(true);
                    CostBenefitTabPanel.this.niceTableCosts.setRowSelectionAllowed(true);
                    CostBenefitTabPanel.this.niceTableCosts.setColumnSelectionAllowed(false);
                    CostBenefitTabPanel.this.niceTableCosts.setAutoResizeMode(0);
                    CostBenefitTabPanel.this.niceTableCosts.autoSizeColumnsToFit();
                    NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
                    TableColumn tableColumn = CostBenefitTabPanel.this.niceTableCosts.getColumnModel().getColumn(1);
                    tableColumn.setCellRenderer(numberCellRenderer);
                    CostBenefitTabPanel.this.jResultTable.setFixedColumnCount(n);
                    CostBenefitTabPanel.this.jResultTable.setModel((TableModel)((Object)CostBenefitTabPanel.this.getState().getBenefitState().getBenefitTuneTableModel()));
                    String string2 = CostBenefitTabPanel.this.getState().getBenefitState().getBenefitTuneTableModel().getColumnName(0);
                    CostBenefitTabPanel.this.jResultTable.setFixedColumnPreferredWidth(string2, 175);
                    CostBenefitTabPanel.this.jResultTable.findOrCreateTableRowHeader(CostBenefitTabPanel.this.tscroller);
                    CostBenefitTabPanel.this.jResultTable.setSorted(true);
                    CostBenefitTabPanel.this.jResultTable.setAutoResizeMode(0);
                    CostBenefitTabPanel.this.jResultTable.addDynamicCellRenderers();
                    TableColumnModel tableColumnModel = CostBenefitTabPanel.this.jResultTable.getColumnModel();
                    tableColumnModel.getColumn(1 - n).setPreferredWidth(90);
                    tableColumnModel.getColumn(2 - n).setPreferredWidth(150);
                    tableColumnModel.getColumn(3 - n).setPreferredWidth(200);
                    CostBenefitTabPanel.this.jResultTable.setSelectionMode(0);
                    CostBenefitTabPanel.this.jResultTable.setColumnSelectorAvailable(true);
                    CostBenefitTabPanel.this.jResultTable.setShowToolTips(true);
                    CostBenefitTabPanel.this.jResultTable.setSortRetainsSelection(true);
                    CostBenefitTabPanel.this.jResultTable.setRowSelectionAllowed(true);
                    CostBenefitTabPanel.this.jResultTable.setCellRenderers();
                    CostBenefitTabPanel.this.jResultTable.setRowHeaderCellRenderers();
                    int n2 = 0;
                    if (string != null) {
                        for (int i = 0; i < CostBenefitTabPanel.this.jResultTable.getRowCount(); ++i) {
                            Object object = CostBenefitTabPanel.this.getState().getBenefitState().getBenefitTuneTableModel().getValueAt(i, 0);
                            if (!string.equals(object)) continue;
                            n2 = i;
                            break;
                        }
                    }
                    CostBenefitTabPanel.this.jResultTable.setRowSelectionInterval(n2, n2);
                    CostBenefitTabPanel.this.jCmbBoxTarget.setModel(new DefaultComboBoxModel<String>(CostBenefitTabPanel.this.getState().getBenefitState().getTargetValues()));
                } else if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), null, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
                }
                CostBenefitTabPanel.this.enableControls(true);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
            }
        }
    }
}

