/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.modeldetails;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.OutputAttributeType;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.MiningAlgorithmOptions;
import oracle.dmt.dataminer.server.model.MiningDetailsOutputType;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.server.model.ModelDetailsExtract;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.AvailableRefModelType;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelDetailsLrb;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelOutputColumnsListPanel;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelsTableModel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowModelDetailsNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.ModelDetailsDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsOutputType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.model.Element;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class EditModelDetailsPanel
extends AbstractDialogPanel {
    private Connection _dbConn;
    private String _ownerName;
    private boolean _dirty = false;
    private final String UNDEFINED = ModelDetailsLrb.get("UNDEFINED_SELECTION");
    private ModelDetailsOutputType _modelOutputType;
    private ModelDetailsOutputType _updatedModelOutputType = null;
    private List<RefModelType> _models;
    private ModelDetailsDataNode _node;
    private ModelsTableModel _selectedModelsTableModel;
    private ModelsTableModel _availableModelsTableModel;
    private GenericTable _selectedModelsGenericTable = new GenericTable();
    private GenericTable _availableModelsGenericTable = new GenericTable();
    private Component _findPane;
    private SearchField _searchField;
    private int _currentSearchCategory = 1;
    private SearchCategory _defaultSearchCategory = new SearchCategory(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_MODEL"));
    private MiningFunctions _currentMiningFunction;
    private MiningAlgorithmOptions _currentAlgorithmOption;
    private MiningDetailsOutputType _currentMiningDetailOutputType;
    private List<OutputAttributeType> _currentOutputColumns;
    private ModelDetailType _modelDetailType;
    private static Icon _select;
    private static Icon _selectAll;
    private static Icon _remove;
    private static Icon _removeAll;
    private static Icon _invalid_icon;
    private static Icon _built_icon;
    private static NullIcon _nullIcon;
    private JButton _jDisplayColumnsButton;
    private JLabel _jMiningAlgorithmSelectedLabel;
    private JLabel _jMiningAlgorithmValue;
    private JLabel _jMiningFunctionLabel;
    private JLabel _jMiningFunctionSelectedLabel;
    private JLabel _jMiningFunctionSelectedValue;
    private JLabel _jMiningFunctionValue;
    private JComboBox _jModelAlgorithmCombo;
    private JLabel _jModelAlgorithmLabel;
    private JComboBox _jOutputTypeCombo;
    private JLabel _jOutputTypeLabel;
    private JLabel _jOutputTypeSelectedLabel;
    private JLabel _jOutputTypeSelectedValue;
    private ComponentWithTitlebar<JComponent> componentWithTitlebar1;
    private ComponentWithTitlebar<JComponent> componentWithTitlebar2;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;

    public EditModelDetailsPanel(JEWTDialog jEWTDialog, Context context, ModelDetailsDataNode modelDetailsDataNode, ModelDetailsOutputType modelDetailsOutputType) {
        super(context, modelDetailsDataNode);
        assert (context != null) : "Context must not be null.";
        assert (modelDetailsDataNode != null) : "Model details data node must not be null.";
        assert (modelDetailsDataNode instanceof ModelDetailsDataNode) : "Must be an instance of model details data node.";
        this._context = context;
        this._node = modelDetailsDataNode;
        this._modelOutputType = modelDetailsOutputType;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jModelAlgorithmLabel = new JLabel();
        this._jModelAlgorithmCombo = new JComboBox();
        this._jOutputTypeLabel = new JLabel();
        this._jOutputTypeCombo = new JComboBox();
        this.componentWithTitlebar1 = new ComponentWithTitlebar();
        this._jMiningFunctionLabel = new JLabel();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.componentWithTitlebar2 = new ComponentWithTitlebar();
        this._jMiningFunctionSelectedLabel = new JLabel();
        this._jMiningFunctionSelectedValue = new JLabel();
        this._jMiningAlgorithmSelectedLabel = new JLabel();
        this._jMiningAlgorithmValue = new JLabel();
        this._jOutputTypeSelectedLabel = new JLabel();
        this._jOutputTypeSelectedValue = new JLabel();
        this._jMiningFunctionValue = new JLabel();
        this._jDisplayColumnsButton = new JButton();
        this._jModelAlgorithmLabel.setText("Model Type:");
        this._jModelAlgorithmCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Decision Tree", "Clustering", "Scoring Model", "Associatin Rules"}));
        this._jOutputTypeLabel.setText("Output Type:");
        this._jOutputTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Full Tree", "Item 2", "Item 3", "Item 4"}));
        this._jMiningFunctionLabel.setText("Model Function:");
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        this._jMiningFunctionSelectedLabel.setText("Function:");
        this._jMiningFunctionSelectedValue.setText("Classification");
        this._jMiningAlgorithmSelectedLabel.setText("Algorithm:");
        this._jMiningAlgorithmValue.setText("Decision Tree");
        this._jOutputTypeSelectedLabel.setText("Output:");
        this._jOutputTypeSelectedValue.setText("Full Tree");
        this._jMiningFunctionValue.setText("Classification");
        this._jDisplayColumnsButton.setText("Columns...");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this._jMiningFunctionLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this._jOutputTypeLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this._jModelAlgorithmLabel, GroupLayout.Alignment.LEADING, -1, 81, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jMiningFunctionValue, -1, -1, Short.MAX_VALUE).addComponent(this._jModelAlgorithmCombo, 0, 164, Short.MAX_VALUE).addComponent(this._jOutputTypeCombo, -2, 279, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jDisplayColumnsButton, -2, 101, -2).addGap(28, 28, 28).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this._jMiningFunctionSelectedLabel, -1, 78, Short.MAX_VALUE).addComponent(this._jMiningAlgorithmSelectedLabel, -1, 78, Short.MAX_VALUE).addComponent(this._jOutputTypeSelectedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jMiningFunctionSelectedValue, -1, -1, Short.MAX_VALUE).addComponent(this._jMiningAlgorithmValue, -1, -1, Short.MAX_VALUE).addComponent(this._jOutputTypeSelectedValue, -1, 144, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.componentWithTitlebar1, -1, 352, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -2, 49, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.componentWithTitlebar2, -1, 352, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(0, this._jMiningAlgorithmSelectedLabel, this._jMiningFunctionSelectedLabel, this._jOutputTypeSelectedLabel);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jMiningFunctionLabel).addComponent(this._jMiningFunctionValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jModelAlgorithmLabel).addComponent(this._jModelAlgorithmCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jOutputTypeCombo, -2, -1, -2).addComponent(this._jOutputTypeLabel).addComponent(this._jDisplayColumnsButton, GroupLayout.Alignment.TRAILING))).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jMiningFunctionSelectedLabel).addComponent(this._jMiningFunctionSelectedValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jMiningAlgorithmSelectedLabel).addComponent(this._jMiningAlgorithmValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jOutputTypeSelectedLabel).addComponent(this._jOutputTypeSelectedValue)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.componentWithTitlebar2, -1, 245, Short.MAX_VALUE).addComponent((Component)this.componentWithTitlebar1, -1, 245, Short.MAX_VALUE)).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGap(122, 122, 122).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn).addGap(99, 99, 99)))));
        groupLayout.linkSize(1, this._jMiningFunctionLabel, this._jMiningFunctionSelectedLabel, this._jMiningFunctionSelectedValue, this._jMiningFunctionValue);
        groupLayout.linkSize(1, this._jMiningAlgorithmSelectedLabel, this._jMiningAlgorithmValue, this._jModelAlgorithmCombo, this._jModelAlgorithmLabel);
        groupLayout.linkSize(1, this._jOutputTypeCombo, this._jOutputTypeLabel, this._jOutputTypeSelectedLabel, this._jOutputTypeSelectedValue);
    }

    @Override
    public void initRes() {
        this.initIcons();
        this._jMiningFunctionLabel.setText(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_FUNCTION"));
        this._jMiningFunctionLabel.setText(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_FUNCTION"));
        this._jMiningFunctionLabel.setLabelFor(this._jMiningFunctionValue);
        ResourceUtils.resLabel((JLabel)this._jModelAlgorithmLabel, (Component)this._jModelAlgorithmCombo, (String)PropertyLrb.get("PI_MODEL_DETAILS_GROUP_MODEL_TYPE"));
        this._jModelAlgorithmCombo.getAccessibleContext().setAccessibleDescription(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_MODEL_TYPE_ADA"));
        this._jModelAlgorithmCombo.setToolTipText(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_MODEL_TYPE_ADA"));
        ResourceUtils.resLabel((JLabel)this._jOutputTypeLabel, (Component)this._jOutputTypeCombo, (String)PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE"));
        this._jOutputTypeCombo.getAccessibleContext().setAccessibleDescription(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE_ADA"));
        this._jOutputTypeCombo.setToolTipText(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE_ADA"));
        this._jMiningFunctionSelectedLabel.setText(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_FUNCTION"));
        this._jMiningFunctionSelectedLabel.setLabelFor(this._jMiningFunctionSelectedValue);
        this._jMiningFunctionSelectedValue.setText(this.UNDEFINED);
        ResourceUtils.resLabel((JLabel)this._jMiningAlgorithmSelectedLabel, (Component)this._jMiningAlgorithmValue, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_ALGORITHM"));
        this._jMiningAlgorithmValue.setText(this.UNDEFINED);
        ResourceUtils.resLabel((JLabel)this._jOutputTypeSelectedLabel, (Component)this._jOutputTypeSelectedValue, (String)PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE"));
        this._jOutputTypeSelectedValue.setText(this.UNDEFINED);
        this._jMiningAlgorithmSelectedLabel.setVisible(false);
        this._jMiningAlgorithmValue.setVisible(false);
        this._jMiningFunctionSelectedLabel.setVisible(false);
        this._jMiningFunctionSelectedValue.setVisible(false);
        this._jOutputTypeSelectedLabel.setVisible(false);
        this._jOutputTypeSelectedValue.setVisible(false);
        ResourceUtils.resButton((AbstractButton)this._jDisplayColumnsButton, (String)ModelDetailsLrb.get("COLUMNS_DISPLAY_BUTTON"));
        this._jDisplayColumnsButton.getAccessibleContext().setAccessibleDescription(ModelDetailsLrb.get("COLUMNS_DISPLAY_BUTTON_ADA"));
        this._jDisplayColumnsButton.setToolTipText(ModelDetailsLrb.get("COLUMNS_DISPLAY_BUTTON_ADA"));
        HelpUtils.setHelpID((JComponent)this, (String)"edit_selection_details");
    }

    public boolean doWork() {
        boolean bl = true;
        if (!this._dirty) {
            return true;
        }
        ModelDetailsOutputType modelDetailsOutputType = this.generateModelOutputType();
        try {
            this._updatedModelOutputType = bl ? modelDetailsOutputType : null;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
        }
        return bl;
    }

    private ModelDetailsOutputType generateModelOutputType() {
        ModelDetailsOutputType modelDetailsOutputType = new ModelDetailsOutputType();
        Attributes attributes = new Attributes();
        ModelDetailsOutputType.Models models = this._selectedModelsTableModel.getRowCount() == 0 ? new ModelDetailsOutputType.Models() : this._selectedModelsTableModel.generateModelsCollection();
        modelDetailsOutputType.setModels(models);
        modelDetailsOutputType.setAttributes(attributes);
        MiningDetailsOutputType miningDetailsOutputType = MiningDetailsOutputType.fromString(this._currentMiningDetailOutputType.toString());
        MiningAlgorithmOptions miningAlgorithmOptions = MiningAlgorithmOptions.fromString(this._currentAlgorithmOption.toString());
        MiningFunctions miningFunctions = MiningFunctions.fromString(this._currentMiningFunction.toString());
        modelDetailsOutputType.setMiningAlgorithm(MiningAlgorithmOptions.getMiningAlgorithmType(miningAlgorithmOptions));
        modelDetailsOutputType.setMiningFunction(MiningFunctions.getMiningFunctionType(miningFunctions));
        modelDetailsOutputType.setMiningFunction(MiningFunctions.getMiningFunctionType(miningFunctions));
        modelDetailsOutputType.setMiningAlgorithm(MiningAlgorithmOptions.getMiningAlgorithmType(miningAlgorithmOptions));
        modelDetailsOutputType.setType(MiningDetailsOutputType.getMiningDetailType(miningDetailsOutputType, miningAlgorithmOptions, miningFunctions));
        modelDetailsOutputType.setAutoSpec(AutoSpecType.fromValue((String)"No"));
        modelDetailsOutputType.setAttributes(OutputAttributeType.convertAttributes(this._currentOutputColumns));
        return modelDetailsOutputType;
    }

    private void initIcons() {
        if (_select == null) {
            Class<WorkflowEditor> clazz = WorkflowEditor.class;
            _select = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_RIGHT"));
            _selectAll = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_RIGHTALL"));
            _remove = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_LEFT"));
            _removeAll = UIResourceHelper.getImageIcon(clazz, WorkflowEditorLrb.get("SHUTTLE_LEFTALL"));
            Class<PropertyLrb> clazz2 = PropertyLrb.class;
            _built_icon = UIResourceHelper.getImageIcon(clazz2, PropertyLrb.get("PI_BUILD_GROUP_MODEL_BUILT_ICON"));
            _invalid_icon = UIResourceHelper.getImageIcon(clazz2, PropertyLrb.get("PI_BUILD_GROUP_MODEL_INVALID_ICON"));
            _nullIcon = new NullIcon(_built_icon.getIconWidth(), _built_icon.getIconHeight());
        }
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        this.jSelectBtn.setIcon(_select);
        this.jSelectAllBtn.setIcon(_selectAll);
        this.jRemoveBtn.setIcon(_remove);
        this.jRemoveAllBtn.setIcon(_removeAll);
    }

    @Override
    public void initUI() {
        ModelDetailsDataNode modelDetailsDataNode = this._node;
        if (modelDetailsDataNode == null) {
            return;
        }
        try {
            this._dbConn = Connections.getSharedConnection(this._context);
            this._ownerName = Connections.getUserAccountName(this._context);
            this._ownerName = StringUtils.isDoubleQuotedString(this._ownerName) ? StringUtils.trimDoubleQuotes(this._ownerName) : this._ownerName.toUpperCase();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_PI_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_PI_CONNECTION_ERROR_MESG"), null);
            return;
        }
        this.loadData();
        this.loadTables();
        JScrollPane jScrollPane = new JScrollPane((Component)this._availableModelsGenericTable);
        this.componentWithTitlebar1.setComponent((JComponent)jScrollPane);
        this.componentWithTitlebar1.setLabel(new JLabel(ModelDetailsLrb.get("AVAILABLE_MODELS")));
        ControlBar controlBar = new ControlBar();
        this._findPane = this.createFindPane();
        controlBar.add(this._findPane);
        this.componentWithTitlebar1.setControlBar(controlBar);
        JScrollPane jScrollPane2 = new JScrollPane((Component)this._selectedModelsGenericTable);
        this.componentWithTitlebar2.setComponent((JComponent)jScrollPane2);
        this.componentWithTitlebar2.setLabel(new JLabel(ModelDetailsLrb.get("SELECTED_MODELS")));
        this.initComboBoxes();
        this.initOutputColumns();
        this._jDisplayColumnsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelOutputColumnsListPanel modelOutputColumnsListPanel = new ModelOutputColumnsListPanel(EditModelDetailsPanel.this.getContext(), EditModelDetailsPanel.this._currentOutputColumns, (ModelDetailsDataNode)EditModelDetailsPanel.this.getData());
                modelOutputColumnsListPanel.invokeDialog(null);
            }
        });
        this._jModelAlgorithmCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this.processAlgorithmComboAction();
            }
        });
        this._jOutputTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this.processOutputTypeComboAction();
            }
        });
        this.jSelectBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ADA"));
        this.jSelectAllBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ALL_ADA"));
        this.jRemoveBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE_ADA"));
        this.jRemoveAllBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE.ALL_ADA"));
        this.jSelectBtn.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ADA"));
        this.jSelectAllBtn.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ALL_ADA"));
        this.jRemoveBtn.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE_ADA"));
        this.jRemoveAllBtn.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE.ALL_ADA"));
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this._dirty = true;
                EditModelDetailsPanel.this.moveAvailableRows(actionEvent);
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this._dirty = true;
                EditModelDetailsPanel.this._availableModelsGenericTable.selectAll();
                EditModelDetailsPanel.this.moveAvailableRows(actionEvent);
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this._dirty = true;
                EditModelDetailsPanel.this.moveSelectedRows();
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsPanel.this._dirty = true;
                EditModelDetailsPanel.this._selectedModelsGenericTable.selectAll();
                EditModelDetailsPanel.this.moveSelectedRows();
            }
        });
    }

    private void moveSelectedRows() {
        int[] nArray = this._selectedModelsGenericTable.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        this.moveItems(this._selectedModelsGenericTable, this._availableModelsGenericTable);
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._selectedModelsGenericTable.getModel());
        modelsTableModel.setOwnerOnly(!modelsTableModel.isModelsFromOtherSchemas());
        this.filterAvailableBasedOnSelected();
    }

    private void moveAvailableRows(ActionEvent actionEvent) {
        int[] nArray = this._availableModelsGenericTable.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = this._availableModelsGenericTable.getSelectedRowsInModel();
        this.moveItems(this._availableModelsGenericTable, this._selectedModelsGenericTable);
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._selectedModelsGenericTable.getModel());
        modelsTableModel.setOwnerOnly(!modelsTableModel.isModelsFromOtherSchemas());
        this.setSelectionOnInsertedRows(this._selectedModelsGenericTable, nArray2.length);
        this.filterAvailableBasedOnSelected();
    }

    private void filterAvailableBasedOnSelected() {
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._selectedModelsGenericTable.getModel());
        if (modelsTableModel.getRowCount() > 0) {
            this._jMiningFunctionSelectedValue.setText(this._currentMiningFunction.toString());
            this._jMiningAlgorithmValue.setText(this._currentAlgorithmOption.toString());
            this._jModelAlgorithmCombo.setEnabled(false);
            this._jOutputTypeSelectedValue.setText(this._currentMiningDetailOutputType.toString());
        } else {
            this._jMiningFunctionSelectedValue.setText(this.UNDEFINED);
            this._jMiningAlgorithmValue.setText(this.UNDEFINED);
            this._jModelAlgorithmCombo.setEnabled(true);
            this._jOutputTypeSelectedValue.setText(this.UNDEFINED);
        }
    }

    private void setSelectionOnInsertedRows(GenericTable genericTable, int n) {
        genericTable.setRowSelectionInterval(genericTable.getModel().getRowCount() - n, genericTable.getModel().getRowCount() - 1);
        genericTable.scrollToSelection();
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2) {
        int[] nArray = genericTable.getSelectedRowsInModel();
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)genericTable.getModel());
        ModelsTableModel modelsTableModel2 = (ModelsTableModel)((Object)genericTable2.getModel());
        modelsTableModel2.addSelection(modelsTableModel, nArray);
        if (modelsTableModel2.isFilteredTableModel()) {
            this._availableModelsTableModel.addSelection(modelsTableModel, nArray);
        }
        if (genericTable2.equals(this._selectedModelsGenericTable)) {
            this.setSelectionOnInsertedRows(genericTable2, nArray.length);
        }
        if (modelsTableModel.isFilteredTableModel()) {
            this._availableModelsTableModel.removeDuplicateRows(modelsTableModel.getDataVector(), nArray);
        }
        modelsTableModel.removeSelectedRows(nArray);
    }

    private void processOutputTypeComboAction() {
        MiningDetailsOutputType miningDetailsOutputType = (MiningDetailsOutputType)((Object)this._jOutputTypeCombo.getSelectedItem());
        if (this._currentMiningDetailOutputType != miningDetailsOutputType) {
            this._currentMiningDetailOutputType = miningDetailsOutputType;
            this._jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
            if (this._selectedModelsGenericTable.getRowCount() > 0) {
                this._jOutputTypeSelectedValue.setText(this._currentMiningDetailOutputType.toString());
            }
            this.initOutputColumns();
            this.processFilter(this._searchField.getText());
        }
    }

    private void processAlgorithmComboAction() {
        MiningAlgorithmOptions miningAlgorithmOptions = (MiningAlgorithmOptions)((Object)this._jModelAlgorithmCombo.getSelectedItem());
        if (this._currentAlgorithmOption != miningAlgorithmOptions) {
            this._currentAlgorithmOption = miningAlgorithmOptions;
            this.setupOutputTypeCombo(this._currentMiningFunction, this._currentAlgorithmOption);
            this.processFilter(this._searchField.getText());
        }
    }

    private void setupOutputTypeCombo(MiningFunctions miningFunctions, MiningAlgorithmOptions miningAlgorithmOptions) {
        this._jOutputTypeCombo.setModel(new DefaultComboBoxModel<MiningDetailsOutputType>(MiningDetailsOutputType.getMiningDetailsOutputType(miningFunctions, miningAlgorithmOptions)));
        this._currentMiningDetailOutputType = MiningDetailsOutputType.getPreferredOutputTypeForModelDetailsNode(miningFunctions, miningAlgorithmOptions);
        this._jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
        this.initOutputColumns();
    }

    private void loadTables() {
        try {
            this._selectedModelsTableModel = new ModelsTableModel(this._models, this._ownerName, this._node);
            this.setupModelsTable(this._selectedModelsGenericTable, this._selectedModelsTableModel);
            this._availableModelsTableModel = new ModelsTableModel(this._ownerName, this._node);
            Vector<AvailableRefModelType> vector = this._availableModelsTableModel.createMissingRowsBasedOnMatch(this._selectedModelsTableModel.getDataVector());
            this._availableModelsTableModel.removeDuplicateRowsBasedOnMatch(this._selectedModelsTableModel.getDataVector());
            this.processFilter("");
            this.setupModelsTable(this._selectedModelsGenericTable, this._selectedModelsTableModel);
            if (this._availableModelsGenericTable.getRowCount() > 0) {
                this._availableModelsGenericTable.setSelectedRowsInModel(new int[]{0});
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("ERROR_TITLE"), (String)ModelDetailsLrb.get("ERROR_MODEL_LOADING_UNEXPECTED"), null);
            exception.printStackTrace();
        }
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = -1;
        if (searchCategory.getLabel().equals(PropertyLrb.get("PI_MODEL_GROUP_FILTER_MODEL_NAME"))) {
            this._currentSearchCategory = 1;
        } else if (searchCategory.getLabel().equals(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_ALGORITHM"))) {
            this._currentSearchCategory = 3;
        } else if (searchCategory.getLabel().equals(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_NODE"))) {
            this._currentSearchCategory = 2;
        } else assert (false) : "Invalid Search Category Code";
        return n;
    }

    private SearchField searchField() {
        final SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                EditModelDetailsPanel.this.translateSearchCategoryToConstant(searchField.getSelectedCategory());
                EditModelDetailsPanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                EditModelDetailsPanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                EditModelDetailsPanel.this.processFilter(string);
            }
        });
        return searchField;
    }

    private void setupModelsTable(GenericTable genericTable, ModelsTableModel modelsTableModel) {
        genericTable.setModel((TableModel)((Object)modelsTableModel));
        if (genericTable.equals(this._availableModelsGenericTable)) {
            genericTable.setSorted(true);
            genericTable.setSortColumn(0, true);
            genericTable.setUpdateSelectionOnSort(true);
        }
        genericTable.getTableHeader().setReorderingAllowed(false);
        TableColumn tableColumn = genericTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new CustomCellRenderer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFilter(String string) {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        try {
            ideMainWindow.setCursor(new Cursor(3));
            ModelsTableModel modelsTableModel = this._availableModelsTableModel.getfilteredCopy(string, this._currentSearchCategory, this._currentMiningFunction, this._currentAlgorithmOption, this._currentMiningDetailOutputType);
            this.setupModelsTable(this._availableModelsGenericTable, modelsTableModel);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_PI_ERROR_TITLE"), (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_PI_NODE_LOAD_ERROR_MESG"), null);
        }
        finally {
            ideMainWindow.setCursor(new Cursor(0));
        }
    }

    private void setupFilterCtl() {
        this._currentSearchCategory = 1;
        this._searchField.addCategory(this._defaultSearchCategory);
        this._searchField.addCategory(new SearchCategory(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_NODE")));
        this._searchField.addCategory(new SearchCategory(PropertyLrb.get("PI_MODEL_DETAILS_MODEL_COLUMN_ALGORITHM")));
        this._searchField.setSelectedCategory(this._defaultSearchCategory);
    }

    protected Component createFindPane() {
        Box box = new Box(2);
        this._searchField = this.searchField();
        this.setupFilterCtl();
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._searchField);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 200);
        Dimension dimension3 = this.derive(dimension, 120);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private void initOutputColumns() {
        if (this._currentMiningDetailOutputType != null && this._currentAlgorithmOption != null && this._currentMiningFunction != null) {
            this._currentOutputColumns = ModelDetailsExtract.getOutputColumnList(MiningDetailsOutputType.getMiningDetailType(this._currentMiningDetailOutputType, this._currentAlgorithmOption, this._currentMiningFunction));
        }
    }

    private void initComboBoxes() {
        this._jMiningFunctionValue.setText(this._currentMiningFunction.toString());
        this._jMiningFunctionSelectedValue.setText(this._currentMiningFunction.toString());
        this._jModelAlgorithmCombo.setModel(new DefaultComboBoxModel<MiningAlgorithmOptions>(MiningAlgorithmOptions.getMiningAlgorithmOptions(this._currentMiningFunction)));
        if (this._models.size() > 0) {
            this._jModelAlgorithmCombo.setEnabled(false);
        } else {
            this._jModelAlgorithmCombo.setEnabled(true);
        }
        this._jModelAlgorithmCombo.setSelectedItem((Object)this._currentAlgorithmOption);
        this._jMiningAlgorithmValue.setText(this._currentAlgorithmOption.toString());
        this._jOutputTypeCombo.setModel(new DefaultComboBoxModel<MiningDetailsOutputType>(MiningDetailsOutputType.getMiningDetailsOutputType(this._currentMiningFunction, this._currentAlgorithmOption)));
        this._jOutputTypeCombo.setEnabled(true);
        this._jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
        this._jOutputTypeSelectedValue.setText(this._currentMiningDetailOutputType.toString());
    }

    private void loadData() {
        if (this._modelOutputType != null) {
            this._models = this._modelOutputType.getModels().getModel();
            this._modelDetailType = this._modelOutputType.getType();
            this._currentMiningDetailOutputType = MiningDetailsOutputType.getMiningDetailsOutputType(this._modelDetailType);
            this._currentMiningFunction = MiningFunctions.getMiningFunctionsFromType(this._modelOutputType.getMiningFunction());
            this._currentAlgorithmOption = MiningAlgorithmOptions.getMiningAlgorithmType(this._modelOutputType.getMiningAlgorithm());
            this._currentOutputColumns = OutputAttributeType.convertAttributes(this._modelOutputType.getAttributes());
        } else {
            this._models = null;
            this._currentMiningDetailOutputType = null;
            this._currentMiningFunction = null;
            this._currentAlgorithmOption = null;
            this._currentOutputColumns = null;
        }
    }

    protected ModelDetailsDataNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowModelDetailsNodePropertyProxyModel)) {
            return null;
        }
        WorkflowModelDetailsNodePropertyProxyModel workflowModelDetailsNodePropertyProxyModel = (WorkflowModelDetailsNodePropertyProxyModel)propertyModel;
        Context context = workflowModelDetailsNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ModelDetailsDataNodeType) {
            return (ModelDetailsDataNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    public void setUpdatedModelOutputType(ModelDetailsOutputType modelDetailsOutputType) {
        this._updatedModelOutputType = modelDetailsOutputType;
    }

    public ModelDetailsOutputType getUpdatedModelOutputType() {
        return this._updatedModelOutputType;
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            GenericTable genericTable = (GenericTable)jTable;
            int n3 = genericTable.convertRowIndexToModel(n);
            ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)genericTable.getModel());
            AvailableRefModelType availableRefModelType = modelsTableModel.getDataVector().get(n3);
            if (availableRefModelType.getStatus() == RefModelStatusType.VALID && modelsTableModel.isModelBuilt(n3)) {
                this.setIcon(_built_icon);
            } else if (availableRefModelType.getStatus() == RefModelStatusType.VALID && !modelsTableModel.isModelBuilt(n3)) {
                this.setIcon((Icon)_nullIcon);
            } else {
                this.setIcon(_invalid_icon);
            }
            return component;
        }
    }
}

